/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.px;

import com.tridium.agent.BILoadablePxView;
import com.tridium.file.util.PxFileUtil;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.security.UrlWhitelist;
import com.tridium.ui.Binder;
import com.tridium.ui.px.PxUtil;
import com.tridium.util.CompUtil;
import com.tridium.util.PxUtil;
import com.tridium.workbench.px.BWbPxMedia;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserOptions;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.WebWidgetUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.naming.BRootContainer;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.XmlParser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"file:PxFile", "bajaui:PxInclude"}, requiredPermissions="r")})
public class BWbPxView
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BWbPxView.class);
    static boolean useCache = AccessController.doPrivileged(() -> Boolean.getBoolean("wbPxView.useCache"));
    static HashMap<BOrd, CacheItem> cache = new HashMap();
    static Logger log = Logger.getLogger("wbPxView");
    protected PxProperty[] pxProperties = null;
    protected PxLayer[] pxLayers = null;
    private final UiLexicon lex = UiLexicon.bajaui();
    private final String errTitle = this.lex.getText("pxview.error.title");
    private final String errNull = this.lex.getText("pxview.error.null");
    private final String errUnresolved = this.lex.getText("pxview.error.unresolved");
    private final String errXml = this.lex.getText("pxview.error.xml");
    private final String errCast = this.lex.getText("pxview.error.cast");
    private final String loadingTitle = Lexicon.make((String)"js").getText("dialogs.loading");
    private final BAbstractPxView agent;
    private BPxMedia media = BWbPxMedia.INSTANCE;
    private BWidget widget = null;
    private boolean fileBased = false;
    private boolean dynamic = false;
    private BIFile pxFile = null;
    private BOrd pxOrd = BOrd.NULL;
    private String pxSource = null;
    private final Command cmdViewSource = new ViewSource(this);
    private final Command cmdGotoSource = new GotoSource(this);
    private final ToggleCommand cmdToggleMode = new ToggleMode(this);
    private final ToggleCommand cmdTogglePreviewMode = new TogglePreviewMedia(this);
    private NavListener navListener;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWbPxView(BAbstractPxView agent) {
        this.agent = agent;
    }

    public BWbPxView() {
        this(null);
    }

    public boolean isEditor() {
        return false;
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(this.lex.getText("menu.px.label"));
        menu.add(null, (Command)this.cmdToggleMode);
        menu.add(null, (Command)this.cmdTogglePreviewMode);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, this.cmdViewSource);
        menu.add(null, this.cmdGotoSource);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        bar.add(null, (Command)this.cmdToggleMode);
        bar.add(null, (Command)this.cmdTogglePreviewMode);
        return bar;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        boolean isPreviewMediaMode = this.isPreviewMediaMode();
        this.cmdTogglePreviewMode.setSelected(isPreviewMediaMode);
        if (isPreviewMediaMode) {
            this.loadPreviewMediaMode(value, cx);
        } else {
            this.setContent((BWidget)new BRootContainer(this.loadPx(value, cx)));
        }
    }

    private void validateProfile(Context cx) throws Exception {
        Type profileType = WbUtil.getWebProfileFromContext(this, cx);
        Type hxProfile = BTypeSpec.make((String)"hx:HxProfile").getResolvedType();
        if (profileType == null) {
            throw new LocalizableException(Lexicon.make((String)"workbench", (Context)cx), "previewModeRequiresHxProfile");
        }
        if (!profileType.is(hxProfile)) {
            throw new LocalizableException("workbench", "previewModeRequiresHxProfileCurrentKnown", new Object[]{profileType.toString()});
        }
    }

    private void loadPreviewMediaMode(BObject value, Context cx) throws Exception {
        BFoxSession foxSession;
        FoxSession sess;
        if (this.isUxMedia(value)) {
            this.setContent(WebWidgetUtil.getUxPxWidget(this));
            return;
        }
        this.validateProfile(cx);
        BWebBrowser browser = new BWebBrowser();
        this.setContent(browser);
        BISession session = WbUtil.findSession(this);
        String ord = "/ord/" + this.getWbShell().getActiveOrdTarget().getOrd().relativizeToSession().toString();
        if (ord.endsWith(";")) {
            ord = ord.substring(0, ord.length() - 1);
        }
        ord = value instanceof BIFile ? ord + "|view:hx:HxPxView?fullScreen=true;previewMode=true" : ord + "|view:?fullScreen=true;previewMode=true";
        URI uri = BWebWidget.makeUri(this, browser, session, ord, null);
        String uriToWhitelist = "regex:^" + uri.getScheme() + "://" + uri.getHost();
        browser.setWhitelist(UrlWhitelist.getDefaultInstance((String[])new String[]{uriToWhitelist}));
        if (session instanceof BFoxSession && (sess = (foxSession = (BFoxSession)session).getConnection().session()) != null) {
            this.navListener = new BWebWidget.FoxSessionRemoveListener(foxSession, browser, uri);
            BNavRoot.INSTANCE.addNavListener(this.navListener);
        }
        browser.load((BObject)BOrd.make((String)uri.toASCIIString()), cx);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BWidget loadPx(BObject value, Context cx) {
        String errMsg = "";
        TypeInfo pxViewMedia = null;
        try {
            PxDecoder decoder;
            if (value instanceof BPxInclude) {
                value = ((BPxInclude)value).getOrd().resolve(value).get();
            }
            if (this.agent != null) {
                if (this.agent instanceof BPxView) {
                    errMsg = this.errNull;
                    BPxView view = (BPxView)this.agent;
                    this.pxOrd = view.getPxFile();
                    if (this.pxOrd.isNull()) {
                        throw new Exception();
                    }
                    pxViewMedia = view.getResolvableMediaType().getTypeInfo();
                    errMsg = this.errUnresolved;
                    this.pxFile = (BIFile)this.pxOrd.get(this.getCurrentValue());
                    decoder = this.loadPxFile(cx);
                } else {
                    boolean bl;
                    if (!(this.agent instanceof BDynamicPxView)) throw new IllegalStateException("Don't know how to load from agent " + this.agent.getType());
                    this.dynamic = true;
                    BWebWidget[] target = (BWebWidget[])value;
                    BDynamicPxView view = (BDynamicPxView)this.agent;
                    Property p = view.getPropertyInParent();
                    boolean bl2 = false;
                    try {
                        if (view instanceof BILoadablePxView) {
                            BILoadablePxView loadablePx = (BILoadablePxView)view;
                            bl = loadablePx.isPxViewModified(BAbsTime.END_OF_TIME) || loadablePx.isPxViewLoading();
                        }
                    }
                    catch (Throwable loadablePx) {
                        // empty catch block
                    }
                    try {
                        Optional xml;
                        if (bl) {
                            xml = BProgressDialog.openIndeterminate((BWidget)this, (String)this.loadingTitle, arg_0 -> BWbPxView.lambda$loadPx$1((BComponent)target, p, arg_0));
                            this.pxSource = xml.orElse(BString.DEFAULT).toString();
                        } else {
                            xml = (BString)FoxRpcUtil.doRpcProperty((BComponent)target, (Property)p, (String)"generateXml", (Object[])new Object[0]).orElseThrow(() -> new BajaRuntimeException("RPC call to generateXml failed"));
                            this.pxSource = xml.toString();
                        }
                    }
                    catch (RuntimeException err) {
                        void var11_23;
                        RuntimeException runtimeException = err;
                        while (var11_23 != null) {
                            if (var11_23 instanceof BSysChannel.NiagaraRpcServerException) {
                                errMsg = Objects.toString(var11_23.getMessage(), "");
                                throw (BSysChannel.NiagaraRpcServerException)var11_23;
                            }
                            Throwable throwable = var11_23.getCause();
                        }
                        throw err;
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(this.pxSource.getBytes());
                    decoder = new PxDecoder(target.getNavOrd(), (InputStream)in, cx);
                }
            } else {
                if (!(value instanceof BIFile)) throw new IllegalStateException("Don't know how to load from " + value.getType());
                this.fileBased = true;
                this.pxFile = (BIFile)value;
                this.pxOrd = this.pxFile.getNavOrd();
                decoder = this.loadPxFile(cx);
            }
            if (this.widget != null) return this.widget;
            errMsg = this.errXml;
            this.widget = decoder.decodeDocument();
            this.pxProperties = decoder.getPxProperties();
            this.pxLayers = decoder.getPxLayers();
            for (BWebWidget bWebWidget : (BWebWidget[])CompUtil.getDescendants((BComponent)this.widget, BWebWidget.class)) {
                WebWidgetUtil.replaceWithCacheableWebWidget(this, bWebWidget);
            }
            for (BWebWidget bWebWidget : this.pxProperties) {
                bWebWidget.apply((BComponent)this.widget);
            }
            if (pxViewMedia != null) {
                this.media = (BPxMedia)pxViewMedia.getInstance();
            } else {
                BWbPxMedia bWbPxMedia = this.media = decoder.getMedia() != null ? (BPxMedia)decoder.getMedia().getInstance() : BWbPxMedia.INSTANCE;
            }
            if (!useCache) return this.widget;
            cache.put(this.pxOrd, new CacheItem(this.widget, this.media, this.pxProperties, this.pxLayers));
            return this.widget;
        }
        catch (Exception e) {
            this.widget = null;
            BOrd ord = this.pxOrd;
            if (!ord.isNull() || !(value instanceof BComponent) || !(this.agent instanceof BDynamicPxView)) return new BErrorPanel(this.getWbShell(), this.errTitle, errMsg, ord, e);
            BOrd navOrd = ((BComponent)value).getNavOrd();
            String string = this.agent.getName();
            if (navOrd == null || navOrd.isNull() || string == null) return new BErrorPanel(this.getWbShell(), this.errTitle, errMsg, ord, e);
            ord = BOrd.make((BOrd)navOrd, (String)("view:" + string));
            return new BErrorPanel(this.getWbShell(), this.errTitle, errMsg, ord, e);
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        Binder binder = (Binder)this.fw(302);
        BBinding[] bindings = binder.getAllBindings();
        for (int i = 0; i < bindings.length; ++i) {
            bindings[i].save(cx);
        }
        return value;
    }

    PxDecoder loadPxFile(Context cx) throws Exception {
        PxProperty p;
        int i;
        CacheItem item = cache.get(this.pxOrd);
        if (item == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("not cached: " + this.pxOrd);
            }
            return new PxDecoder(this.pxFile, cx);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("cached: " + this.pxOrd);
        }
        this.widget = (BWidget)item.widget.newCopy(true);
        this.media = item.media;
        this.pxProperties = new PxProperty[item.props.length];
        for (i = 0; i < this.pxProperties.length; ++i) {
            p = item.props[i];
            this.pxProperties[i] = new PxProperty(p.getName(), p.getTypeSpec(), p.getValue(), p.getTargets());
        }
        this.pxLayers = new PxLayer[item.layers.length];
        for (i = 0; i < this.pxLayers.length; ++i) {
            p = item.layers[i];
            this.pxLayers[i] = new PxLayer(p.getName());
        }
        this.setBaseOrd(item.widget, this.widget, cx);
        return null;
    }

    void setBaseOrd(BWidget master, BWidget copy, Context cx) {
        if (master instanceof BPxInclude) {
            BOrd ord = ((BPxInclude)master).getBaseOrd();
            BPxInclude copyInclude = (BPxInclude)copy;
            copyInclude.fw(205, (Object)ord, (Object)cx, null, null);
            copyInclude.remove("root");
            return;
        }
        BWidget[] masterKids = master.getChildWidgets();
        BWidget[] copyKids = copy.getChildWidgets();
        for (int i = 0; i < masterKids.length; ++i) {
            this.setBaseOrd(masterKids[i], copyKids[i], cx);
        }
    }

    protected boolean isUxMedia(BObject value) {
        Type mediaType = null;
        if (this.agent != null) {
            mediaType = this.agent.getResolvableMediaType();
        } else if (value instanceof BPxFile) {
            BPxFile file = (BPxFile)value;
            String media = PxFileUtil.getMediaFromFile((BPxFile)file);
            mediaType = PxUtil.getResolvableMediaType((String)media).getTypeSpec().getResolvedType();
        }
        if (mediaType != null) {
            return PxUtil.IUxMedia.class.isAssignableFrom(mediaType.getTypeClass());
        }
        return false;
    }

    protected boolean isPreviewMediaMode() {
        OrdTarget target;
        ViewQuery viewQuery;
        String previewMedia = "false";
        if (this.agent != null && PxUtil.IUxMedia.class.isAssignableFrom(this.agent.getResolvableMediaType().getTypeClass()) && BWebBrowserOptions.get().getUxMediaPrefersBrowserPreviewMode()) {
            previewMedia = "true";
        }
        if (this.getWbShell() != null && (viewQuery = (target = this.getWbShell().getActiveOrdTarget()).getViewQuery()) != null) {
            previewMedia = viewQuery.getParameter("previewMedia", previewMedia);
        }
        return "true".equals(previewMedia);
    }

    @Override
    public void deactivated() {
        if (this.navListener != null) {
            BNavRoot.INSTANCE.removeNavListener(this.navListener);
        }
        this.deactivate((BComponent)this.getContent());
    }

    private void deactivate(BComponent c) {
        if (c == null) {
            return;
        }
        if (c instanceof BWbView) {
            ((BWbView)c).deactivated();
        }
        for (BComponent kid : c.getChildComponents()) {
            this.deactivate(kid);
        }
    }

    public boolean isEditable() {
        return !this.isDynamic() && this.getPxFile() != null && !this.getPxFile().isReadonly();
    }

    public BWidget getWidget() {
        return this.widget;
    }

    public PxProperty[] getPxProperties() {
        return this.pxProperties;
    }

    public PxLayer[] getPxLayers() {
        return this.pxLayers;
    }

    public BPxMedia getMedia() {
        return this.media;
    }

    public BAbstractPxView getPxAgent() {
        return this.agent;
    }

    public void setWidget(BWidget widget) {
        this.widget = widget;
    }

    public void setMedia(BPxMedia media) {
        if (this.agent != null) {
            this.agent.setMedia(media.getType().getTypeSpec());
        }
        this.media = media;
    }

    public BIFile getPxFile() {
        return this.pxFile;
    }

    public boolean isFileBased() {
        return this.fileBased;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Command getViewSource() {
        return this.cmdViewSource;
    }

    public Command getGotoSource() {
        return this.cmdGotoSource;
    }

    public ToggleCommand getToggleMode() {
        return this.cmdToggleMode;
    }

    private static /* synthetic */ BString lambda$loadPx$1(BComponent target, Property p, BProgressDialog dlg) {
        try {
            return (BString)FoxRpcUtil.doRpcProperty((BComponent)target, (Property)p, (String)"generateXml", (Object[])new Object[0]).orElseThrow(() -> new BajaRuntimeException("RPC call to generateXml failed"));
        }
        catch (RuntimeException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new BajaRuntimeException("Error during RPC call to generateXml", err);
        }
    }

    static class CacheItem {
        BWidget widget;
        BPxMedia media;
        PxProperty[] props;
        PxLayer[] layers;

        public CacheItem(BWidget widget, BPxMedia media, PxProperty[] props, PxLayer[] layers) {
            this.widget = widget;
            this.media = media;
            this.props = props;
            this.layers = layers;
        }
    }

    public class TogglePreviewMedia
    extends ToggleCommand {
        public TogglePreviewMedia(BWbPxView owner) {
            super((BWidget)owner, (Lexicon)BWbPxView.this.lex, "commands.px.previewMedia");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbPxView owner = (BWbPxView)this.getOwner();
            BNiagaraWbShell shell = (BNiagaraWbShell)this.getShell();
            if (owner == null || shell == null) {
                return null;
            }
            boolean previewMediaMode = BWbPxView.this.isPreviewMediaMode();
            BOrd ord = shell.getActiveOrd();
            shell.hyperlink(BOrd.make((BOrd)ord, (String)("view:?previewMedia=" + !previewMediaMode)));
            return null;
        }
    }

    public class ToggleMode
    extends ToggleCommand {
        public ToggleMode(BWbPxView owner) {
            super((BWidget)owner, (Lexicon)BWbPxView.this.lex, "commands.px.editMode");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbPxView owner = (BWbPxView)this.getOwner();
            BNiagaraWbShell shell = (BNiagaraWbShell)this.getShell();
            if (owner == null || shell == null) {
                return null;
            }
            String from = shell.tab().getViewAgent().getAgentId();
            if (owner.isEditor() && shell.getSaveCommand().isEnabled()) {
                shell.getSaveCommand().invoke();
            }
            String to = from.equals("workbench:WbPxView") ? "pxEditor:PxEditor" : (from.equals("pxEditor:PxEditor") ? "workbench:WbPxView" : (from.indexOf(47) > 0 ? from.substring(0, from.indexOf(47)) : from + "/editor"));
            BOrd ord = shell.getActiveOrd();
            shell.hyperlink(BOrd.make((BOrd)ord, (String)("view:" + to)));
            return null;
        }
    }

    public class GotoSource
    extends Command {
        public GotoSource(BWbPxView owner) {
            super((BWidget)owner, (Lexicon)BWbPxView.this.lex, "commands.px.gotoSource");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbShell shell = (BWbShell)this.getShell();
            shell.hyperlink(BOrd.make((String)(BWbPxView.this.pxOrd.toString() + "|view:workbench:TextFileEditor")));
            return null;
        }
    }

    public class ViewSource
    extends Command {
        public ViewSource(BWbPxView owner) {
            super((BWidget)owner, (Lexicon)BWbPxView.this.lex, "commands.px.viewSource");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BWbPxView.this.pxSource == null) {
                BWbPxView.this.pxSource = BajaFileUtil.readString((BIFile)BWbPxView.this.pxFile);
            }
            BTextEditor editor = new BTextEditor();
            editor.setEditable(false);
            editor.setParser((TextParser)new XmlParser());
            editor.setText(BWbPxView.this.pxSource);
            BTextEditorPane pane = new BTextEditorPane(editor, 40, 100);
            BDialog.open((BWidget)this.getOwner(), (String)this.getLabel(), (Object)pane, (int)1);
            return null;
        }
    }
}

