/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.util.WbViewUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.BISession;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BISpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BObject;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.util.Version;
import javax.baja.web.BIFormFactorMax;
import javax.baja.web.BIOffline;
import javax.baja.workbench.BWbProfile;

public final class WbSys {
    private static final Logger logger = Logger.getLogger("wb.sys");
    private static final String validRemoteTypesKey = "validRemoteTypes";
    private static final String invalidRemoteTypesKey = "invalidRemoteTypes";
    private static final String isSameVersion = "isSameVersion";
    private static final Version filterAgentVersion = new Version("4.0.0");

    public static AgentFilter getBaseViewsFilter() {
        return IS_LICENSED_WB_VIEW_FILTER_HOLDER.INSTANCE;
    }

    public static AgentList getFilteredViewList(BWidget owner, BObject object, Predicate<AgentInfo> predicate) {
        BWbProfile profile = WbUtil.getProfileFromWidget(owner);
        Predicate<AgentInfo> agentPredicate = WbSys.getBaseViewsFilter().toPredicate().and(agent -> WbViewUtil.isAcceptableViewForProfile(profile, object, agent));
        if (predicate != null) {
            agentPredicate = agentPredicate.and(predicate);
        }
        return WbSys.remoteFilter(object, profile.getAgents(object).filter(agentPredicate));
    }

    private static AgentList remoteFilter(BObject target, AgentList list) {
        Collection typeInfos = Arrays.stream(list.list()).map(AgentInfo::getAgentType).filter(info -> info.is(BIFormFactorMax.TYPE)).collect(Collectors.toList());
        if (!typeInfos.isEmpty() && (target instanceof BISpaceNode || target instanceof BISpace)) {
            BISession session;
            BISession bISession = session = target instanceof BISpaceNode ? ((BISpaceNode)target).getSession() : ((BISpace)target).getSession();
            if (session instanceof BFoxSession) {
                BFoxSession foxSession = (BFoxSession)session;
                BFoxClientConnection connection = foxSession.getConnection();
                if (connection != null && connection.isConnected()) {
                    Map<String, Version> filteredTypeInfos;
                    if (connection.getRemoteVersion().compareTo(filterAgentVersion) >= 0 && (filteredTypeInfos = WbSys.populateCaches(connection, typeInfos)) != null) {
                        FoxSession fsession = connection.session();
                        Map validCache = (Map)fsession.getFromCache(validRemoteTypesKey, key -> new HashMap());
                        list = list.filter(info -> WbSys.removeAllOnlineWebWidgets(info) || validCache.containsKey(info.getAgentType().toString()));
                    }
                } else {
                    list = list.filter(WbSys::removeAllOnlineWebWidgets);
                }
            } else {
                list = list.filter(WbSys::removeAllOnlineWebWidgets);
            }
        }
        return list;
    }

    private static boolean removeAllOnlineWebWidgets(AgentInfo info) {
        return !info.getAgentType().is(BIFormFactorMax.TYPE) || info.getAgentType().is(BIOffline.TYPE);
    }

    @Deprecated
    public static boolean isRemoteVersionTheSame(FoxSession foxSession, String typeSpec) {
        return WbSys.isRemoteVersionTheSame(foxSession);
    }

    public static boolean isRemoteVersionTheSame(FoxSession foxSession) {
        try {
            BFoxClientConnection connection = (BFoxClientConnection)foxSession.conn();
            if (connection != null && connection.isConnected()) {
                BBrokerChannel brokerChannel = (BBrokerChannel)connection.getChannels().get("station");
                FoxSession fsession = connection.session();
                if (brokerChannel != null && fsession != null) {
                    return (Boolean)fsession.getFromCache(isSameVersion, key -> (Boolean)DiagnosticUtil.diagnoseIfLoggable((String)"wb.isSameVersion", () -> {
                        try {
                            ArrayList<ModuleInfo> moduleInfos = new ArrayList<ModuleInfo>();
                            moduleInfos.add(Sys.getRegistry().getModule("workbench", RuntimeProfile.wb));
                            moduleInfos.add(Sys.getRegistry().getModule("hx", RuntimeProfile.wb));
                            return WbSys.isVersionTheSame(brokerChannel.getRemoteModuleVersion(Collections.singleton(RuntimeProfile.ux), moduleInfos).orElse(null), String.valueOf(connection.getRemoteHost()));
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "BrokerChannel -> getRemoteModuleVersion", e);
                            return false;
                        }
                    }));
                }
            }
            return false;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Cannot determine if remote and local versions match", e);
            return false;
        }
    }

    public static boolean isVersionTheSame(Map<String, Version> remoteModuleVersions, String hostName) {
        if (remoteModuleVersions == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Not the same version, version unknown for host " + hostName);
            }
            return false;
        }
        for (Map.Entry<String, Version> tuple : remoteModuleVersions.entrySet()) {
            String moduleName = tuple.getKey();
            String moduleDisplayName = moduleName.replace(' ', '-');
            String[] split = moduleName.split(" ");
            Version version = tuple.getValue();
            ModuleInfo info = null;
            try {
                info = Sys.getRegistry().getModule(split[0], RuntimeProfile.valueOf((String)split[1]));
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                // empty catch block
            }
            if (info == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Not the same version for host " + hostName + ", client is missing module: " + moduleDisplayName);
                }
                return false;
            }
            if (info.getVendorVersion().equals((Object)version)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Not the same version for host " + hostName + ", client has a different version for module: " + info.getModulePartName() + " " + info.getVendorVersion() + " != " + version);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Version is the same for host " + hostName + ", checked " + remoteModuleVersions.size() + " modules");
        }
        return true;
    }

    private static Map<String, Version> populateCaches(BFoxClientConnection connection, Collection<TypeInfo> typeInfos) {
        if (connection != null && connection.isConnected()) {
            BBrokerChannel brokerChannel = (BBrokerChannel)connection.getChannels().get("station");
            FoxSession fsession = connection.session();
            if (brokerChannel != null && fsession != null) {
                Map validCache = (Map)fsession.getFromCache(validRemoteTypesKey, key -> new HashMap());
                Collection invalidCache = (Collection)fsession.getFromCache(invalidRemoteTypesKey, key -> new HashSet());
                try {
                    Map filteredTypeInfos = brokerChannel.checkTypes((Collection)typeInfos.stream().filter(type -> !validCache.containsKey(type.toString()) && !invalidCache.contains(type.toString())).collect(Collectors.toList()));
                    filteredTypeInfos.forEach((type, version) -> validCache.merge(type, version, (t, v) -> v));
                    invalidCache.addAll(typeInfos.stream().filter(type -> !filteredTypeInfos.containsKey(type.toString())).map(TypeInfo::toString).collect(Collectors.toList()));
                    return filteredTypeInfos;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "BrokerChannel -> Check Types", e);
                }
            }
        }
        return null;
    }

    private static interface IS_LICENSED_WB_VIEW_FILTER_HOLDER {
        public static final AgentFilter INSTANCE = AgentFilter.and((AgentFilter)WbViewUtil.isWorkbenchViewFilter(), (AgentFilter)WbMain.licenseFilter);
    }
}

