/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.ui.Binder;
import com.tridium.ui.PxIncludeManager;
import com.tridium.ui.theme.Theme;
import com.tridium.web.RequireJsUtil;
import com.tridium.web.rpc.BLexiconRpc;
import com.tridium.workbench.shell.BNiagaraWbDialog;
import com.tridium.workbench.shell.BWbPopupProfile;
import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.BrowserUtil;
import com.tridium.workbench.web.browser.IJs;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BExporter;
import javax.baja.gx.BPoint;
import javax.baja.gx.BSize;
import javax.baja.gx.Point;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.WebProperty;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.JsInfo;
import javax.baja.workbench.BWbShell;

public class WebWidgetInterop {
    public static final BComponent[] EMPTY_COMPONENT_ARRAY = new BComponent[0];
    private static final Logger LOG = BWebWidget.log;
    private static final Logger PROFILE_LOG = BWebBrowser.profileLog;
    private static final Level LIFECYCLE_LEVEL = Level.FINE;
    private static final Level INTEROP_LEVEL = Level.FINER;
    private static final Level NOISE_LEVEL = Level.FINEST;
    private static final Level PROFILE_LEVEL = Level.FINE;
    private static final Level CONSOLE_LEVEL = Level.FINE;
    private final WeakReference<BWebWidget> webWidgetRef;
    private final Env env = new Env();
    private final WbContainer wbContainer = new WbContainer();
    private final UxWidget uxWidget = new UxWidget();
    private final WebSocket webSocket = new WebSocket();
    private final Browser browser = new Browser();
    private final long startTicks;
    private volatile long initTicks;
    private volatile long loadTicks;
    private volatile long destroyTicks;
    private static final boolean BOX_OVER_FOX = "true".equals(AccessController.doPrivileged(() -> System.getProperty("niagara.webwidget.boxfox", "true")));

    private WebWidgetInterop(BWebWidget w) {
        this.webWidgetRef = new WeakReference<BWebWidget>(w);
        this.startTicks = Clock.ticks();
    }

    public static WebWidgetInterop start(BWebWidget w) {
        if (LOG.isLoggable(LIFECYCLE_LEVEL)) {
            w.log(LIFECYCLE_LEVEL, "Starting browser interop");
        }
        return new WebWidgetInterop(w);
    }

    public void registerFunctions(BWebBrowser browser) {
        this.registerConsumer(browser, "niagara_env_hyperlink", x$0 -> this.env.browserCalledHyperlink(x$0), INTEROP_LEVEL);
        this.registerRunnable(browser, "niagara_env_reload", () -> this.env.browserCalledReload(), INTEROP_LEVEL);
        this.registerSupplier(browser, "niagara_env_getSessionOrd", () -> this.env.browserCalledGetSessionOrd(), INTEROP_LEVEL);
        this.registerSupplier(browser, "niagara_env_getBaseOrd", () -> this.env.browserCalledGetBaseOrd(), INTEROP_LEVEL);
        this.registerFunction(browser, "niagara_env_listViews", x$0 -> this.env.browserCalledListViews(x$0), NOISE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_initializing", () -> this.wbContainer.browserCalledInitializing(), LIFECYCLE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_initialized", () -> this.wbContainer.browserCalledInitialized(), LIFECYCLE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_loaded", () -> this.wbContainer.browserCalledLoaded(), LIFECYCLE_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_error", x$0 -> this.wbContainer.browserCalledError(x$0), LIFECYCLE_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_hyperlink", x$0 -> this.wbContainer.browserCalledHyperlink(x$0), INTEROP_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_buildCommands", x$0 -> this.wbContainer.browserCalledBuildCommands(x$0), NOISE_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_updateCommand", x$0 -> this.wbContainer.browserCalledUpdateCommand(x$0), NOISE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_setModified", () -> this.wbContainer.browserCalledSetModified(), INTEROP_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_clearModified", () -> this.wbContainer.browserCalledClearModified(), INTEROP_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_saveOk", () -> this.wbContainer.browserCalledSaveOk(), LIFECYCLE_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_saveFail", x$0 -> this.wbContainer.browserCalledSaveFail(x$0), LIFECYCLE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_save", () -> this.wbContainer.browserCalledSave(), LIFECYCLE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_deactivated", () -> this.wbContainer.browserCalledDeactivated(), LIFECYCLE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_destroying", () -> this.wbContainer.browserCalledDestroying(), LIFECYCLE_LEVEL);
        this.registerRunnable(browser, "niagara_wb_util_destroyed", () -> this.wbContainer.browserCalledDestroyed(), LIFECYCLE_LEVEL);
        this.registerFunction(browser, "niagara_wb_util_syncProperties", x$0 -> this.wbContainer.browserCalledSyncProperties(x$0), INTEROP_LEVEL);
        this.registerSupplier(browser, "niagara_wb_util_getProperties", () -> this.wbContainer.browserCalledGetProperties(), INTEROP_LEVEL);
        this.registerBiConsumer(browser, "niagara_wb_util_propertyChanged", (x$0, x$1) -> this.wbContainer.browserCalledPropertyChanged(x$0, x$1), INTEROP_LEVEL);
        this.registerBiConsumer(browser, "niagara_wb_util_metadataChanged", (x$0, x$1) -> this.wbContainer.browserCalledMetadataChanged(x$0, x$1), INTEROP_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_startDrag", x$0 -> this.wbContainer.browserCalledStartDrag(x$0), NOISE_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_dragCallback", x$0 -> this.wbContainer.browserCalledDragCallback(x$0), NOISE_LEVEL);
        this.registerSupplier(browser, "niagara_wb_util_isCommandBarVisible", () -> this.wbContainer.browserCalledIsCommandBarVisible(), NOISE_LEVEL);
        this.registerBiFunction(browser, "niagara_wb_util_getLexicon", (x$0, x$1) -> this.wbContainer.browserCalledGetLexicon(x$0, x$1), NOISE_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_setServerSessionId", x$0 -> this.wbContainer.browserCalledSetServerSessionId(x$0), INTEROP_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_playSound", x$0 -> this.wbContainer.browserCalledPlaySound(x$0), INTEROP_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_stopSound", x$0 -> this.wbContainer.browserCalledStopSound(x$0), INTEROP_LEVEL);
        this.registerConsumer(browser, "niagara_wb_util_popup", x$0 -> this.wbContainer.browserCalledPopup(x$0), INTEROP_LEVEL);
        if (BOX_OVER_FOX && !Sys.isStation()) {
            this.registerConsumer(browser, "niagara_wb_util_sendBox", x$0 -> this.wbContainer.browserCalledSendBox(x$0), NOISE_LEVEL);
            this.registerSupplier(browser, "niagara_wb_util_getHostOrd", () -> this.wbContainer.browserCalledGetHostOrd(), INTEROP_LEVEL);
            this.registerSupplier(browser, "niagara_wb_util_getSessionOrdInHost", () -> this.wbContainer.browserCalledGetSessionOrdInHost(), INTEROP_LEVEL);
        }
        if (LOG.isLoggable(CONSOLE_LEVEL)) {
            browser.registerConsoleEventHandler(event -> this.withWebWidgetNow(w -> w.log(event.isError() ? Level.SEVERE : CONSOLE_LEVEL, "console: " + event.getMessage())));
        }
    }

    public Env env() {
        return this.env;
    }

    public WbContainer wbContainer() {
        return this.wbContainer;
    }

    public UxWidget uxWidget() {
        return this.uxWidget;
    }

    public WebSocket bajaScriptWebSocket() {
        return this.webSocket;
    }

    public Browser browser() {
        return this.browser;
    }

    private void popup(String json, BWbShell shell) throws Exception {
        BOrd activeOrd = shell.getActiveOrd();
        if (activeOrd == null) {
            return;
        }
        PopupArguments arguments = this.getPopupArguments(json, activeOrd);
        BNiagaraWbDialog dlg = new BNiagaraWbDialog(BWbPopupProfile.TYPE, (BWidget)shell, arguments.getOrd(), arguments.getTitle(), arguments.getPosition(), arguments.getSize(), arguments.isModal());
        dlg.open();
    }

    private PopupArguments getPopupArguments(String json, BOrd activeOrd) throws Exception {
        JSONObject obj = new JSONObject(json);
        String ordEncoding = obj.getString("ord");
        String positionEncoding = obj.getString("position");
        String sizeEncoding = obj.getString("size");
        PopupArguments arguments = new PopupArguments();
        arguments.setTitle(obj.getString("title"));
        arguments.setModal(obj.getBoolean("modal"));
        arguments.setOrd(BOrd.make((BOrd)activeOrd, (String)ordEncoding));
        arguments.setPosition((BPoint)BPoint.DEFAULT.decodeFromString(positionEncoding));
        arguments.setSize((BSize)BSize.DEFAULT.decodeFromString(sizeEncoding));
        return arguments;
    }

    private void registerRunnable(BWebBrowser browser, String name, Runnable runnable, Level logLevel) {
        Runnable toRegister = runnable;
        if (LOG.isLoggable(logLevel)) {
            toRegister = () -> this.withWebWidgetNow(w -> {
                w.log(logLevel, "Browser called " + name);
                runnable.run();
            });
        }
        browser.register(name, toRegister);
    }

    private <T> void registerConsumer(BWebBrowser browser, String name, Consumer<T> consumer, Level logLevel) {
        Consumer<Object> toRegister = consumer;
        if (LOG.isLoggable(logLevel)) {
            toRegister = arg -> this.withWebWidgetNow(w -> {
                w.log(logLevel, "Browser called " + name + " with argument " + arg);
                consumer.accept(arg);
            });
        }
        browser.registerConsumer(name, toRegister);
    }

    private <T, U> void registerBiConsumer(BWebBrowser browser, String name, BiConsumer<T, U> biConsumer, Level logLevel) {
        BiConsumer<Object, Object> toRegister = biConsumer;
        if (LOG.isLoggable(logLevel)) {
            toRegister = (arg1, arg2) -> this.withWebWidgetNow(w -> {
                w.log(logLevel, "Browser called " + name + " with arguments [" + arg1 + ", " + arg2 + ']');
                biConsumer.accept(arg1, arg2);
            });
        }
        browser.registerBiConsumer(name, toRegister);
    }

    private <T, R> void registerFunction(BWebBrowser browser, String name, Function<T, R> function, Level logLevel) {
        Function<Object, Object> toRegister = function;
        if (LOG.isLoggable(logLevel)) {
            toRegister = arg -> this.fromWebWidget(w -> {
                Object result = function.apply(arg);
                w.log(logLevel, "Browser called " + name + " with argument " + arg + ", returning " + result);
                return result;
            }, null);
        }
        browser.registerFunction(name, toRegister);
    }

    private <T, U, R> void registerBiFunction(BWebBrowser browser, String name, BiFunction<T, U, R> biFunction, Level logLevel) {
        BiFunction<Object, Object, Object> toRegister = biFunction;
        if (LOG.isLoggable(logLevel)) {
            toRegister = (arg1, arg2) -> this.fromWebWidget(w -> {
                Object result = biFunction.apply(arg1, arg2);
                w.log(logLevel, "Browser called " + name + " with arguments [" + arg1 + ", " + arg2 + "], returning " + result);
                return result;
            }, null);
        }
        browser.registerBiFunction(name, toRegister);
    }

    private <R> void registerSupplier(BWebBrowser browser, String name, Supplier<R> supplier, Level logLevel) {
        Supplier<Object> toRegister = supplier;
        if (LOG.isLoggable(logLevel)) {
            toRegister = () -> this.fromWebWidget(arg_0 -> WebWidgetInterop.lambda$null$47((Supplier)supplier, logLevel, name, arg_0), null);
        }
        browser.registerSupplier(name, toRegister);
    }

    private void withWebWidgetNow(Consumer<BWebWidget> consumer) {
        BWebWidget w = (BWebWidget)this.webWidgetRef.get();
        if (w != null) {
            consumer.accept(w);
        }
    }

    private void withWebWidgetLater(Consumer<BWebWidget> consumer) {
        BWidget.invokeLater(() -> this.withWebWidgetNow(consumer));
    }

    private <T> T fromWebWidget(Function<BWebWidget, T> function, T def) {
        BWebWidget w = (BWebWidget)this.webWidgetRef.get();
        if (w != null) {
            return function.apply(w);
        }
        return def;
    }

    private static IJs getWbContainer(BWebWidget w) {
        return w.getBrowser().executeScript("window.wbContainer");
    }

    private static IJs getUxWidget(BWebWidget w) {
        return w.getBrowser().executeScript("window.wbWidget");
    }

    private static IJs getBajaScriptWebSocket(BWebWidget w) {
        return w.getBrowser().executeScript("window.wbSocket");
    }

    private static String toJsonStr(Map<String, Object> map) {
        JSONObject obj = new JSONObject();
        map.keySet().iterator().forEachRemaining(name -> obj.put(name, map.get(name)));
        return obj.toString();
    }

    private static void profileLog(BWebWidget w, String msg) {
        PROFILE_LOG.log(PROFILE_LEVEL, WebWidgetInterop.id(w) + ": " + msg);
    }

    private static boolean profileLoggable() {
        return PROFILE_LOG.isLoggable(PROFILE_LEVEL);
    }

    private static String id(BWebWidget w) {
        return Integer.toHexString(System.identityHashCode(w)) + '(' + w.getJs() + ')';
    }

    private static /* synthetic */ Object lambda$null$47(Supplier supplier, Level logLevel, String name, BWebWidget w) {
        Object result = supplier.get();
        w.log(logLevel, "Browser called " + name + ", returning " + result);
        return result;
    }

    public class Browser {
        public String getLocationHref() {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> w.getBrowser().executeScript("window.location.href").toString(), "");
        }

        public void ready() {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                if (LOG.isLoggable(INTEROP_LEVEL)) {
                    w.log(INTEROP_LEVEL, "Browser has loaded document");
                }
                String wbLoaded = "window.wbLoaded();";
                if (BWebWidget.DEBUG_DELAY) {
                    wbLoaded = "setTimeout(wbLoaded, 5000);";
                }
                w.getBrowser().executeScriptAsync("(function () {window.wbHasLoaded = true;if (typeof window.wbLoaded === 'function') {" + wbLoaded + '}' + "}());");
            });
        }
    }

    public class WebSocket {
        public void handleMessage(String msg) {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                IJs wbSocket = WebWidgetInterop.getBajaScriptWebSocket(w);
                if (wbSocket.isObject()) {
                    wbSocket.call("onMessageStr", msg);
                }
            });
        }
    }

    public class UxWidget {
        public IJs findCommand(int cmdId) {
            return (IJs)WebWidgetInterop.this.fromWebWidget(w -> WebWidgetInterop.getUxWidget(w).call("getCommandGroup", new Object[0]).call("findCommand", cmdId), null);
        }

        public void setPropertyValue(String propName, Object propValue, Object options) {
            WebWidgetInterop.this.withWebWidgetNow(w -> WebWidgetInterop.getUxWidget(w).call("properties", new Object[0]).call("setValue", SlotPath.unescape((String)propName), propValue, options));
        }

        public void setPropertyMetadata(String propName, Object metadata, Object options) {
            WebWidgetInterop.this.withWebWidgetNow(w -> WebWidgetInterop.getUxWidget(w).call("properties", new Object[0]).call("setMetadata", SlotPath.unescape((String)propName), metadata, options));
        }
    }

    public class WbContainer {
        public void initialize(JsInfo jsInfo, TypeInfo widgetTypeInfo, JSONObject params) {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                String initCall;
                String script = initCall = "require(['" + jsInfo.getJsId() + "'], function (Widget) {\n  if (Widget.__esModule) { Widget = Widget.default || Widget; }\n  var widget = new Widget(" + '\'' + widgetTypeInfo.getModuleName() + "', " + '\'' + widgetTypeInfo.getTypeName() + "');\n  window.wbContainer.initialize(widget, " + params + ")\n    .catch(function (err) {\n      console.error('wbContainer failed to initialize');\n      console.error(err);\n    });\n});";
                BIWebResource.DependencyGraph deps = jsInfo.resolveDependencies();
                if (!deps.isEmpty()) {
                    script = RequireJsUtil.wrapInBuiltfileRequireScript((String)initCall, (BIWebResource.DependencyGraph)deps);
                }
                if (LOG.isLoggable(LIFECYCLE_LEVEL)) {
                    w.log(LIFECYCLE_LEVEL, "initialize() script:\n" + script);
                }
                w.getBrowser().executeScriptAsync(script);
            });
        }

        public void callDeactivate() {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                try {
                    IJs container = WebWidgetInterop.getWbContainer(w);
                    if (container != null && !container.isNull()) {
                        if (LOG.isLoggable(LIFECYCLE_LEVEL)) {
                            w.log(LIFECYCLE_LEVEL, "Called JS function wbContainer.deactivate()");
                        }
                        container.call("deactivate", new Object[0]);
                    } else {
                        w.onUxWidgetDeactivated();
                    }
                }
                catch (Throwable e) {
                    if (LOG.isLoggable(LIFECYCLE_LEVEL)) {
                        w.log(LIFECYCLE_LEVEL, "Cannot deactivate", e);
                    }
                    w.onUxWidgetDeactivated();
                }
            });
        }

        public void callDragover(double x, double y, String navNodesJson) {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                if (LOG.isLoggable(NOISE_LEVEL)) {
                    w.log(NOISE_LEVEL, "Called JS function wbContainer.dragover(" + x + ", " + y + ", " + navNodesJson + ')');
                }
                WebWidgetInterop.getWbContainer(w).call("dragover", x, y, navNodesJson);
            });
        }

        public void callDrop(double x, double y, String navNodesJson) {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                if (LOG.isLoggable(NOISE_LEVEL)) {
                    w.log(NOISE_LEVEL, "Called JS function wbContainer.drop(" + x + ", " + y + ", " + navNodesJson + ')');
                }
                WebWidgetInterop.getWbContainer(w).call("drop", x, y, navNodesJson);
            });
        }

        public void callLoad(String ordStr) {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                if (LOG.isLoggable(LIFECYCLE_LEVEL)) {
                    w.log(LIFECYCLE_LEVEL, "Called JS function wbContainer.load()");
                }
                WebWidgetInterop.getWbContainer(w).call("load", ordStr);
            });
        }

        public void callSave() {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                try {
                    IJs container = WebWidgetInterop.getWbContainer(w);
                    if (container != null && !container.isNull()) {
                        if (LOG.isLoggable(LIFECYCLE_LEVEL)) {
                            w.log(LIFECYCLE_LEVEL, "Called JS function wbContainer.save()");
                        }
                        container.call("save", new Object[0]);
                    } else {
                        w.onUxWidgetSave();
                    }
                }
                catch (Throwable e) {
                    w.onUxWidgetSaveFail(e.getMessage());
                }
            });
        }

        public void callUpdateProperties(Map<String, Object> newProps) {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                String json = WebWidgetInterop.toJsonStr(newProps);
                if (LOG.isLoggable(INTEROP_LEVEL)) {
                    w.log(INTEROP_LEVEL, "Called JS function wbContainer.updateProperties(" + json + ')');
                }
                WebWidgetInterop.getWbContainer(w).call("updateProperties", json);
            });
        }

        private void browserCalledInitializing() {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                if (WebWidgetInterop.profileLoggable()) {
                    WebWidgetInterop.profileLog(w, "initializing(): -> " + BRelTime.make((long)(Clock.ticks() - WebWidgetInterop.this.startTicks)));
                }
                WebWidgetInterop.this.initTicks = Clock.ticks();
                w.onUxWidgetInitializing();
            });
        }

        private void browserCalledInitialized() {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                WebWidgetInterop.this.loadTicks = Clock.ticks();
                if (WebWidgetInterop.profileLoggable()) {
                    WebWidgetInterop.profileLog(w, "initialized(): -> " + BRelTime.make((long)(Clock.ticks() - WebWidgetInterop.this.initTicks)));
                }
                w.onUxWidgetInitialized();
            });
        }

        private void browserCalledLoaded() {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                if (WebWidgetInterop.profileLoggable()) {
                    WebWidgetInterop.profileLog(w, "loaded(): -> " + BRelTime.make((long)(Clock.ticks() - WebWidgetInterop.this.loadTicks)) + " (" + w.findOrd(w.getCurrentValue()) + ')');
                }
                w.onUxWidgetLoaded();
            });
        }

        private void browserCalledError(Object err) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.onUxWidgetError(err));
        }

        private void browserCalledHyperlink(Object jsOrd) {
            WebWidgetInterop.this.withWebWidgetNow(w -> {
                BWbShell shell = BWbShell.getWbShell(w);
                if (shell != null) {
                    w.getBrowser().fromJsToString(jsOrd).ifPresent(ord -> shell.hyperlink(BOrd.make((String)ord)));
                }
            });
        }

        private void browserCalledBuildCommands(Object data) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.buildCommands(data));
        }

        private void browserCalledUpdateCommand(Object jsCmd) {
            WebWidgetInterop.this.withWebWidgetLater(w -> w.getBrowser().fromJsToString(jsCmd).ifPresent(json -> w.updateCommand(new JSONObject(json))));
        }

        private void browserCalledSetModified() {
            WebWidgetInterop.this.withWebWidgetLater(w -> w.onUxWidgetSetModified());
        }

        private void browserCalledClearModified() {
            WebWidgetInterop.this.withWebWidgetLater(w -> w.clearModified());
        }

        private void browserCalledSaveOk() {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.onUxWidgetSave());
        }

        private void browserCalledSaveFail(String err) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.onUxWidgetSaveFail(err));
        }

        private void browserCalledSave() {
            WebWidgetInterop.this.withWebWidgetLater(w -> {
                BWbShell shell = BrowserUtil.findWbShell((BComplex)w);
                if (shell != null) {
                    shell.getSaveCommand().invoke();
                }
            });
        }

        private void browserCalledDeactivated() {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.onUxWidgetDeactivated());
        }

        private void browserCalledDestroying() {
            WebWidgetInterop.this.destroyTicks = Clock.ticks();
        }

        private void browserCalledDestroyed() {
            if (WebWidgetInterop.profileLoggable()) {
                WebWidgetInterop.this.withWebWidgetNow(w -> WebWidgetInterop.profileLog(w, "destroyed(): -> " + BRelTime.make((long)(Clock.ticks() - WebWidgetInterop.this.destroyTicks))));
            }
        }

        private String browserCalledSyncProperties(Object jsProps) {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> w.syncProperties(jsProps), "");
        }

        private String browserCalledGetProperties() {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> w.getWebProperties(), "");
        }

        private void browserCalledPropertyChanged(String name, Object value) {
            String valueStr = value.toString();
            WebWidgetInterop.this.withWebWidgetLater(w -> WebProperty.setProperty((BWidget)w, (String)name, (String)valueStr));
        }

        private void browserCalledMetadataChanged(String name, Object metaData) {
            WebWidgetInterop.this.withWebWidgetLater(w -> WebProperty.setFacets((BWidget)w, (String)name, (Object)metaData));
        }

        private void browserCalledSendBox(String data) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.sendBox(data));
        }

        private String browserCalledGetHostOrd() {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> w.getHostOrd(), "");
        }

        private String browserCalledGetSessionOrdInHost() {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> w.getSessionOrdInHost(), "");
        }

        private void browserCalledSetServerSessionId(String id) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.setServerSessionId(id));
        }

        private void browserCalledStartDrag(String json) {
            WebWidgetInterop.this.withWebWidgetLater(w -> {
                BObject base = (BObject)w.findSession();
                JSONObject obj = new JSONObject(json);
                double x = obj.getDouble("x");
                double y = obj.getDouble("y");
                int modifiers = obj.getInt("modifiers");
                JSONObject dragData = new JSONObject(JSONUtil.getString((JSONObject)obj, (String)"drag"));
                String mimeType = JSONUtil.getString((JSONObject)dragData, (String)"mime");
                ArrayList<BComponent> compList = new ArrayList<BComponent>();
                if ("niagara/navnodes".equals(mimeType)) {
                    JSONArray array = dragData.getJSONArray("data");
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject navNode = (JSONObject)array.get(i);
                        if (!navNode.has("ord")) continue;
                        BComponent c = (BComponent)BOrd.make((String)JSONUtil.getString((JSONObject)navNode, (String)"ord")).get(base);
                        compList.add(c);
                    }
                }
                if (!compList.isEmpty()) {
                    BComponent[] comps = compList.toArray(EMPTY_COMPONENT_ARRAY);
                    TransferEnvelope envelope = TransferEnvelope.make((Mark)new Mark((BObject[])comps));
                    SimpleDragRenderer dragRenderer = new SimpleDragRenderer(comps);
                    dragRenderer.font = Theme.tree().getFont((BWidget)w);
                    dragRenderer.xCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
                    dragRenderer.yCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
                    BTransferWidget transferWidget = w.getBrowser().getTransferWidget();
                    TransferContext cx = transferWidget.makeTransferContext(envelope);
                    BWidgetShell shell = w.getShell();
                    if (shell != null) {
                        Point pt = new Point(x, y);
                        pt = shell.translateFromChild((BWidget)transferWidget, pt);
                        BMouseEvent event = new BMouseEvent(511, (BWidget)transferWidget, modifiers, pt.x, pt.y, 0, false);
                        transferWidget.startDrag(event, cx, (DragRenderer)dragRenderer);
                    }
                }
            });
        }

        private void browserCalledDragCallback(boolean eventWasProcessed) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.onJsDragEvent(eventWasProcessed));
        }

        private boolean browserCalledIsCommandBarVisible() {
            return (Boolean)WebWidgetInterop.this.fromWebWidget(w -> {
                BWbShell shell = BrowserUtil.findWbShell((BComplex)w);
                return shell != null && shell.getProfile().makeToolBar() == null || !w.isInViewTab();
            }, false);
        }

        private String browserCalledGetLexicon(String moduleName, String lang) {
            try {
                return BLexiconRpc.getLexicon((String)moduleName, (String)lang, (Context)BFacets.DEFAULT).toString();
            }
            catch (Exception e) {
                return "";
            }
        }

        private void browserCalledPlaySound(String sound) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.playSound(sound));
        }

        private void browserCalledStopSound(String sound) {
            WebWidgetInterop.this.withWebWidgetNow(w -> w.stopSound(sound));
        }

        private void browserCalledPopup(String json) {
            WebWidgetInterop.this.withWebWidgetNow(w -> BWebBrowser.post(w.getBrowser(), () -> {
                try {
                    BWbShell shell = BWbShell.getWbShell(w);
                    if (shell == null) {
                        return;
                    }
                    WebWidgetInterop.this.popup(json, shell);
                }
                catch (Exception e) {
                    w.log(INTEROP_LEVEL, "Problem with launching popup", e);
                }
            }));
        }

        public BExporter updateTransformOptions(BExporter exporter) {
            return (BExporter)WebWidgetInterop.this.fromWebWidget(w -> {
                try {
                    IJs container = WebWidgetInterop.getWbContainer(w);
                    if (container == null || container.isNull()) {
                        return null;
                    }
                    IJs result = container.call("updateTransformOptions", BsonEncoderPlugin.marshal((BValue)exporter));
                    IJs resolvedResult = result.resolve(50000L);
                    if (resolvedResult == null || resolvedResult.isNull()) {
                        return null;
                    }
                    String stringResult = resolvedResult.toString();
                    if (stringResult.isEmpty()) {
                        return null;
                    }
                    return (BExporter)BsonDecoderPlugin.unmarshal((String)stringResult, null);
                }
                catch (Exception e) {
                    w.log(INTEROP_LEVEL, "Problem with updating updateTransformOptions", e);
                    return null;
                }
            }, null);
        }
    }

    public class Env {
        private String browserCalledGetBaseOrd() {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> {
                BOrd ord;
                OrdTarget base;
                Binder binder = WbUtil.getBinder((BComplex)w);
                if (binder != null && (base = binder.getBase()) != null && (ord = base.getOrd()) != null) {
                    return ord.toString();
                }
                return null;
            }, null);
        }

        private String browserCalledGetSessionOrd() {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> {
                BISession session = w.getCurrentValueSession();
                if (session != null) {
                    return session.getNavOrd().toString();
                }
                return null;
            }, null);
        }

        private void browserCalledHyperlink(Object jsOrd) {
            WebWidgetInterop.this.withWebWidgetNow(w -> BWebBrowser.post(w.getBrowser(), () -> {
                BWbShell shell = BWbShell.getWbShell(w);
                if (shell == null) {
                    return;
                }
                BOrd activeOrd = shell.getActiveOrd();
                if (activeOrd == null) {
                    return;
                }
                w.getBrowser().fromJsToString(jsOrd).ifPresent(hyperlinkOrd -> {
                    BOrd ord = BOrd.make((BOrd)activeOrd, (String)hyperlinkOrd);
                    BWidget.invokeLater(() -> shell.hyperlink(ord));
                });
            }));
        }

        private String browserCalledListViews(Object jsOrd) {
            return (String)WebWidgetInterop.this.fromWebWidget(w -> w.listViews(jsOrd), "");
        }

        private void browserCalledReload() {
            WebWidgetInterop.this.withWebWidgetLater(w -> {
                BWbShell shell = BWbShell.getWbShell(w);
                if (shell != null) {
                    PxIncludeManager.trimAll();
                    shell.getRefreshCommand().invoke();
                }
            });
        }
    }

    public static class PopupArguments {
        private BOrd ord;
        private BPoint position;
        private BSize size;
        private boolean modal;
        private String title;

        public BOrd getOrd() {
            return this.ord;
        }

        public void setOrd(BOrd ord) {
            this.ord = ord;
        }

        public BPoint getPosition() {
            return this.position;
        }

        public void setPosition(BPoint position) {
            this.position = position;
        }

        public BSize getSize() {
            return this.size;
        }

        public void setSize(BSize size) {
            this.size = size;
        }

        public boolean isModal() {
            return this.modal;
        }

        public void setModal(boolean modal) {
            this.modal = modal;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

