/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.LoginFailureCause;
import com.tridium.jetty.NiagaraHttpSession;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.session.NiagaraSession;
import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.workbench.web.browser.BLoopbackAuthenticationScheme;
import com.tridium.workbench.web.browser.LoopbackCallbackHandler;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUnrestrictedFolder;
import javax.security.auth.callback.CallbackHandler;

final class LoopbackNiagaraSession
implements NiagaraSession {
    private boolean valid;
    private String superId;
    private final String id;
    private final long creationTime = System.currentTimeMillis();
    private static final Object SUPER_SESSION_MONITOR = new Object();
    static final BUser SUPER_ADMIN_USER = new BUser();
    private static LoopbackNiagaraSession loopbackSession;

    private LoopbackNiagaraSession() {
        this.id = SessionManager.generateSessionId(LoopbackNiagaraSession.class, (int)25);
    }

    public Map<String, String> getSessionInfo() {
        return Collections.emptyMap();
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public String getSuperId() {
        return this.superId;
    }

    public void setSuperId(String superId) {
        NiagaraBasicPermission initPermission = new NiagaraBasicPermission("MODIFY_SESSION_IDS");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)initPermission);
        }
        this.superId = superId;
    }

    public void doSetAuthenticated(BUser user) {
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    public void invalidate(LoginFailureCause cause) {
        this.valid = false;
    }

    public String getAuditTarget() {
        return "loopback";
    }

    public boolean isSecure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getLoopbackSuperSessionId() {
        LoopbackNiagaraSession.validateStationVm();
        Object object = SUPER_SESSION_MONITOR;
        synchronized (object) {
            if (loopbackSession == null || !LoopbackNiagaraSession.loopbackSession.valid) {
                loopbackSession = new LoopbackNiagaraSession();
                SessionManager.addSession((NiagaraSession)loopbackSession);
                BLoopbackAuthenticationScheme loopbackScheme = new BLoopbackAuthenticationScheme();
                BAuthenticationService authSrv = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
                authSrv.authenticate((NiagaraSession)loopbackSession, SUPER_ADMIN_USER, (CallbackHandler)new LoopbackCallbackHandler(), (BAuthenticationScheme)loopbackScheme);
            }
            return loopbackSession.getSuperId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getLoopbackHttpSessionId() {
        LoopbackNiagaraSession.validateStationVm();
        String id = "";
        Object object = SUPER_SESSION_MONITOR;
        synchronized (object) {
            NiagaraHttpSession httpSession;
            NiagaraSuperSession superSession;
            if (loopbackSession != null && LoopbackNiagaraSession.loopbackSession.valid && (superSession = SessionManager.getNiagaraSuperSession((NiagaraSession)loopbackSession)) != null && (httpSession = (NiagaraHttpSession)superSession.getSession(NiagaraHttpSession.class)) != null) {
                id = httpSession.getId();
            }
        }
        return id;
    }

    private static void validateStationVm() {
        if (!Sys.isStation()) {
            throw new IllegalStateException("Only a Station VM can loopback");
        }
    }

    static {
        SUPER_ADMIN_USER.setPermissions(BPermissionsMap.SUPER_USER);
        SUPER_ADMIN_USER.setAllowConcurrentSessions(true);
        BUnrestrictedFolder parent = new BUnrestrictedFolder();
        parent.add("admin", (BValue)SUPER_ADMIN_USER);
    }
}

