/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.fox.sys.BFoxScheme;
import com.tridium.fox.sys.BFoxsScheme;
import com.tridium.fox.sys.BFoxwssScheme;
import com.tridium.net.BHttpObject;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.util.CompUtil;
import com.tridium.util.SpyUtil;
import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.web.browser.BWebBrowser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BHtmlFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.spy.BSpy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;
import org.owasp.encoder.Encode;

public final class BrowserUtil {
    private static final List<String> LOCALHOST = Arrays.asList("127.0.0.1", "localhost", "localhost.localdomain", "::1", "localhost6", "localhost6.localdomain6");
    private static Pattern HTTP_PORT_PATTERN = Pattern.compile("/?/?[^/]+:(\\d+)");
    private static final Logger log = Logger.getLogger("webBrowser");
    private static final Lexicon lex = Lexicon.make(BrowserUtil.class);

    private BrowserUtil() {
    }

    public static BWbShell findWbShell(BComplex c) {
        BWbShell shell;
        if (c == null) {
            return null;
        }
        BComplex p = c.getParent();
        if (p == null) {
            return null;
        }
        if (p instanceof BWidget && (shell = BWbShell.getWbShell((BWidget)p)) != null) {
            return shell;
        }
        return BrowserUtil.findWbShell(p.getParent());
    }

    public static String createSpyHtml(BSpy spy, Context cx) throws Exception {
        StringWriter sout = new StringWriter();
        SpyWriter out = new SpyWriter((Writer)sout, spy.getPath(), cx);
        out.w((Object)"<!DOCTYPE html>");
        out.w((Object)"<html><head>");
        out.w((Object)"<link rel='stylesheet' href='module://web/rc/spy/spy.css' type='text/css'/>");
        out.w((Object)"<script>document.addEventListener('submit', function (e) {e.preventDefault();var form = e.target;var action = form.getAttribute('action');var href = action.replace(/^\\/ord\\//, '');var ord = href;var csrfInput = form.querySelector('[name=csrfToken]');if (csrfInput) {var csrfToken = csrfInput.value.replace(/[^\\w]/g, (c) => '$' + c.charCodeAt(0).toString(16));ord = href + '$3ftoken$3d' + csrfToken;}window.niagaraWbHyperlink(ord, '');});</script>");
        out.w((Object)"</head><body><div class='spy-container'>");
        BrowserUtil.writeSpyHeader(spy, out, cx);
        spy.get().write(out);
        out.w((Object)"</div></body></html>");
        return sout.toString();
    }

    private static void writeSpyHeader(BSpy spy, SpyWriter out, Context cx) {
        BObject ord;
        String header = "Local Workbench";
        BObject bObject = ord = cx == null ? null : cx.getFacet("activeOrd");
        if (ord instanceof BString) {
            BOrd activeOrd = BOrd.make((String)ord.toString());
            for (OrdQuery query : activeOrd.parse()) {
                if (query.isHost() || !query.isSession()) continue;
                header = "Remote Station";
                break;
            }
        }
        out.w((Object)"<div class='spy-nav-container'>").w((Object)"<table width='100%' class='spy-nav'><tr><td class='spy-nav-index'>");
        FilePath path = spy.getPath();
        out.a("/", (Object)header);
        String x = "";
        for (int i = 0; i < path.depth(); ++i) {
            x = x + "/" + path.nameAt(i);
            out.w((Object)" | ").a(x, (Object)SpyUtil.getRequestedName((String)path.nameAt(i)));
        }
        out.w((Object)"<td></tr></table></div><hr>");
    }

    public static BHttpObject getOrdFilePathAsHttpObject(FilePath path) throws MalformedURLException {
        if (path.isAuthorityAbsolute() || path.isStationHomeAbsolute() || path.isProtectedStationHomeAbsolute()) {
            return null;
        }
        File file = BFileSystem.INSTANCE.pathToLocalFile(path);
        return new BHttpObject(file.toURI().toURL().toString());
    }

    public static BOrd mergeFilePathFragment(BOrd ord, String fragment) {
        OrdQuery[] queries = ord.parse();
        for (int i = 0; i < queries.length; ++i) {
            String scheme = queries[i].getScheme();
            if (!"file".equals(scheme) && !"module".equals(scheme)) continue;
            queries[i] = ((FilePath)queries[i]).merge(fragment);
            break;
        }
        return BOrd.make((OrdQuery[])queries).relativizeToSession();
    }

    public static String getScheme(BOrd ord) {
        if (ord == null) {
            return null;
        }
        for (OrdQuery query : ord.parse()) {
            if (!BrowserUtil.isScheme(query)) continue;
            return query.getScheme();
        }
        return null;
    }

    public static String getHostname(BOrd ord) {
        if (ord == null) {
            return null;
        }
        for (OrdQuery query : ord.parse()) {
            if (!query.isHost()) continue;
            return "local".equals(query.getScheme()) ? "localhost" : query.getBody();
        }
        return null;
    }

    public static Integer getPort(BOrd ord) {
        if (ord == null) {
            return null;
        }
        for (OrdQuery query : ord.parse()) {
            String body = query.getBody();
            switch (query.getScheme()) {
                case "fox": {
                    return ((BFoxScheme.FoxQuery)query).getPort();
                }
                case "foxs": {
                    return ((BFoxsScheme.FoxQuery)query).getPort();
                }
                case "foxwss": {
                    return ((BFoxwssScheme.FoxwssQuery)query).getPort();
                }
                case "http": {
                    return BrowserUtil.parseHttpPort(body).orElse(80);
                }
                case "https": {
                    return BrowserUtil.parseHttpPort(body).orElse(443);
                }
            }
        }
        return null;
    }

    private static Optional<Integer> parseHttpPort(String body) {
        Matcher m = HTTP_PORT_PATTERN.matcher(body);
        return Optional.ofNullable(m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null);
    }

    public static BOrd getActiveOrd(Context cx) {
        if (cx != null) {
            BObject activeOrd = cx.getFacet("activeOrd");
            if (activeOrd != null) {
                return BOrd.make((String)activeOrd.toString());
            }
            throw new IllegalStateException("No activeOrd available in context");
        }
        throw new IllegalStateException("No context available");
    }

    private static boolean isScheme(OrdQuery query) {
        switch (query.getScheme()) {
            case "fox": 
            case "foxs": 
            case "foxwss": 
            case "http": 
            case "https": 
            case "workbench": {
                return true;
            }
        }
        return false;
    }

    public static boolean confirmBeforeUnload(BWbView view) {
        if (BrowserUtil.hasBeforeUnload(view)) {
            int buttons;
            String msg = lex.getText("WebBrowser.confirmLeave");
            int result = BDialog.confirm((BWidget)view, null, (Object)msg, (int)(buttons = 12));
            return result != 8;
        }
        return true;
    }

    public static boolean hasBeforeUnload(BWbView view) {
        if (view == null) {
            return false;
        }
        for (BWebBrowser browser : (BWebBrowser[])CompUtil.getDescendants((BComponent)view, BWebBrowser.class)) {
            if (!browser.hasBeforeUnload()) continue;
            return true;
        }
        return false;
    }

    public static BHtmlFile makeErrorPage(BString error, String url) {
        String err = error.getString();
        int index = err.indexOf("##");
        String errorMessage = index > -1 ? err.substring(0, index) : lex.getText("browser.error");
        String errorDetails = index > -1 ? err.substring(err.indexOf("##") + 2) : err;
        Properties macros = new Properties();
        macros.put("errorOrd", Encode.forHtml((String)url));
        macros.put("errorMessage", Encode.forHtml((String)errorMessage));
        macros.put("errorDetails", Encode.forHtml((String)errorDetails));
        macros.put("errorTitle", Encode.forHtml((String)lex.getText("unknownHost.loadFail")));
        macros.put("errorHeading", Encode.forHtml((String)lex.getText("unknownHost.displayFail")));
        BIFile in = (BIFile)BOrd.make((String)"module://workbench/com/tridium/workbench/media/error.html").get();
        BMemoryFileStore store = new BMemoryFileStore(null, new FilePath("/temp/error.html"));
        try (InputStream is = in.getInputStream();
             OutputStream os = store.getOutputStream();){
            WbUtil.loadWithMacros(is, os, macros);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Cannot generate error page", e);
        }
        return new BHtmlFile((BIFileStore)store);
    }

    public static String getHostForBrowser(String host) {
        String scopeSpec = IPAddressUtil.numericStringToScopeSpec((String)host);
        if (scopeSpec == null) {
            return host;
        }
        int endOfHost = host.lastIndexOf("%" + scopeSpec);
        return host.substring(0, endOfHost);
    }

    public static String getHostForBrowserURI(String host) {
        if (!IPAddressUtil.isIpv6Address((String)host)) {
            return host;
        }
        String scopeSpec = IPAddressUtil.numericStringToScopeSpec((String)host);
        if (scopeSpec == null) {
            return "[" + host + "]";
        }
        int endOfHost = host.lastIndexOf("%" + scopeSpec);
        return "[" + host.substring(0, endOfHost) + "]";
    }

    public static String getURIForBrowser(String uriString) {
        try {
            URI uri = new URI(uriString);
            String host = uri.getHost();
            int port = uri.getPort();
            if (host == null || !host.startsWith("[") || !host.endsWith("]")) {
                return uriString;
            }
            String hostWithoutBraces = host.substring(1, host.length() - 1);
            String scopeSpec = IPAddressUtil.numericStringToScopeSpec((String)hostWithoutBraces);
            if (scopeSpec == null) {
                return uriString;
            }
            int endOfHost = hostWithoutBraces.lastIndexOf("%" + scopeSpec);
            String newHost = "[" + hostWithoutBraces.substring(0, endOfHost) + "]";
            if (port != -1) {
                newHost = newHost + ":" + port;
            }
            return BrowserUtil.replaceHostInUrl(uriString, newHost);
        }
        catch (URISyntaxException e) {
            log.log(Level.WARNING, "Problem with getURIForBrowser, fall back to URI: " + uriString, log.isLoggable(Level.FINE) ? e : null);
            return uriString;
        }
    }

    public static String getHostForSocketFactory(String host) {
        if (!host.startsWith("[") || !host.endsWith("]")) {
            return host;
        }
        host = host.substring(1, host.length() - 1);
        return IPAddressUtil.expandIPv6NumericString((String)host, (boolean)false);
    }

    private static String replaceHostInUrl(String originalURL, String newHost) throws URISyntaxException {
        URI uri = new URI(originalURL);
        uri = new URI(uri.getScheme(), newHost, uri.getPath(), uri.getQuery(), uri.getFragment());
        return uri.toString();
    }

    public static boolean isLocalHost(String host) {
        return LOCALHOST.contains(host.toLowerCase());
    }
}

