/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.security.UrlWhitelist;
import com.tridium.ui.Binder;
import com.tridium.ui.theme.Theme;
import com.tridium.ux.WbWebWidgetServlet;
import com.tridium.web.BICollectionSupport;
import com.tridium.web.servlets.ViewAllOrdServlet;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserOptions;
import com.tridium.workbench.web.browser.BoxClientUtil;
import com.tridium.workbench.web.browser.BrowserUtil;
import com.tridium.workbench.web.browser.IWbJsCommand;
import com.tridium.workbench.web.browser.LoopbackNiagaraSession;
import com.tridium.workbench.web.browser.OfflineRequest;
import com.tridium.workbench.web.browser.OfflineResponse;
import com.tridium.workbench.web.browser.RemoteDebugCommand;
import com.tridium.workbench.web.browser.WbJsCommand;
import com.tridium.workbench.web.browser.WbJsToggleCommand;
import com.tridium.workbench.web.browser.WebWidgetInterop;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.gx.BSize;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.OrdUtil;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BBinding;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.WebProperty;
import javax.baja.util.Version;
import javax.baja.web.BFormFactorEnum;
import javax.baja.web.BIOffline;
import javax.baja.web.BWebService;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.JsInfo;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.view.BWbView;
import javax.baja.workbench.view.BWbViewBinding;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=0x40000000, override=true), @NiagaraProperty(name="js", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="preferredSize", type="BSize", defaultValue="BSize.make(BWebBrowser.DEFAULT_PREFERRED_WIDTH, BWebBrowser.DEFAULT_PREFERRED_HEIGHT)")})
@NiagaraActions(value={@NiagaraAction(name="browserInitialized"), @NiagaraAction(name="updateUrl", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="updateStatus", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="updateProgress", parameterType="BDouble", defaultValue="BDouble.DEFAULT"), @NiagaraAction(name="progressRunning", parameterType="BBoolean", defaultValue="BBoolean.DEFAULT"), @NiagaraAction(name="handleError", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="targetChanged")})
public final class BWebWidget
extends BWbView
implements BWebBrowser.IWebBrowserDropHandler,
AutoCloseable {
    @Generated
    public static final Property enabled = BWebWidget.newProperty((int)0x40000000, (boolean)true, null);
    @Generated
    public static final Property js = BWebWidget.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property preferredSize = BWebWidget.newProperty((int)0, (BValue)BSize.make((double)640.0, (double)480.0), null);
    @Generated
    public static final Action browserInitialized = BWebWidget.newAction((int)0, null);
    @Generated
    public static final Action updateUrl = BWebWidget.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action updateStatus = BWebWidget.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action updateProgress = BWebWidget.newAction((int)0, (BValue)BDouble.DEFAULT, null);
    @Generated
    public static final Action progressRunning = BWebWidget.newAction((int)0, (BValue)BBoolean.DEFAULT, null);
    @Generated
    public static final Action handleError = BWebWidget.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action targetChanged = BWebWidget.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWebWidget.class);
    private volatile WebWidgetInterop interop;
    private volatile OrdTarget cachedOrdTarget;
    private volatile Optional<CompletableFuture<Void>> loadedFuture = Optional.empty();
    private volatile boolean reset;
    private volatile String ordToLoad = "";
    private volatile String serverSessionId = "";
    private volatile boolean sameRemoteVersion = true;
    private volatile boolean legacyWebProperties;
    private BWebBrowser browser;
    private volatile WebWidgetState state = WebWidgetState.uninitialized;
    private final Map<IWbJsCommand, ?> commands = new WeakHashMap();
    private volatile BMenu menu;
    private volatile BToolBar toolBar;
    private final Object saveMonitor = new Object();
    private volatile boolean saved;
    private String saveErr;
    private final Object deactivateMonitor = new Object();
    private volatile boolean deactivated;
    private final Object dragOverMonitor = new Object();
    private volatile int dragOverRes;
    private static final long waitIncrement = 1000L;
    static final long waitLimit = 50000L;
    private BoxClientUtil.BoxHandler boxHandler;
    private NavListener navListener;
    private static final String JSESSIONID = "JSESSIONID";
    private static final String LAST_SUPER_SESSION_ADD = "lastSuperSessionAdd";
    public static final Logger log = Logger.getLogger("webWidget");
    private BFormFactorEnum formFactor = BFormFactorEnum.max;
    private static final boolean USE_LOCAL_RC = "true".equals(AccessController.doPrivileged(() -> System.getProperty("niagara.useLocalWbRc", "true"))) && AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.module.dev.wb")) == false;
    public static final boolean DEBUG_DELAY = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.webwidget.debug.delay"));
    private volatile Runnable onLoaded;
    private volatile boolean closeOnStop = true;
    private volatile boolean claimed = false;
    private volatile int reuseCount = 0;
    private volatile boolean extraLoadsComplete;
    private volatile boolean offline;
    public static final boolean IS_WEB_LAUNCHER = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.webLauncher"));
    private static final boolean NIAGARA_WEBBROWSER_UPDATABLE = AccessController.doPrivileged(() -> System.getProperty("niagara.webbrowser.updatable", "true")).equals("true");
    private WebBrowserProvider browserProvider = options -> new BWebBrowser(options);

    @Generated
    public BOrd getJs() {
        return (BOrd)this.get(js);
    }

    @Generated
    public void setJs(BOrd v) {
        this.set(js, (BValue)v, null);
    }

    @Generated
    public BSize getPreferredSize() {
        return (BSize)this.get(preferredSize);
    }

    @Generated
    public void setPreferredSize(BSize v) {
        this.set(preferredSize, (BValue)v, null);
    }

    @Generated
    public void browserInitialized() {
        this.invoke(browserInitialized, null, null);
    }

    @Generated
    public void updateUrl(BString parameter) {
        this.invoke(updateUrl, (BValue)parameter, null);
    }

    @Generated
    public void updateStatus(BString parameter) {
        this.invoke(updateStatus, (BValue)parameter, null);
    }

    @Generated
    public void updateProgress(BDouble parameter) {
        this.invoke(updateProgress, (BValue)parameter, null);
    }

    @Generated
    public void progressRunning(BBoolean parameter) {
        this.invoke(progressRunning, (BValue)parameter, null);
    }

    @Generated
    public void handleError(BString parameter) {
        this.invoke(handleError, (BValue)parameter, null);
    }

    @Generated
    public void targetChanged() {
        this.invoke(targetChanged, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWebWidget() {
    }

    public BWebWidget(AgentInfo agentInfo) {
        this.recordAgentId(agentInfo, null);
    }

    public BWebWidget(AgentInfo agentInfo, OrdTarget target) {
        this.recordAgentId(agentInfo, target.getOrd());
    }

    public BWebWidget(AgentInfo agentInfo, BOrd ord) {
        this.recordAgentId(agentInfo, ord);
    }

    public BWebWidget(AgentInfo agentInfo, OrdTarget target, BFormFactorEnum formFactor) {
        this.recordAgentId(agentInfo, target.getOrd());
        this.formFactor = formFactor;
    }

    public void started() throws Exception {
        block26: {
            this.setClaimed(false);
            BOrd startedOrd = null;
            try {
                BOrd ord;
                this.reset = false;
                this.loadedFuture = Optional.of(new CompletableFuture());
                if (this.browser == null) {
                    Map<String, String> options = BBoolean.TRUE.equals((Object)this.get("exporting")) ? Collections.singletonMap("forceStationBrowserInit", Boolean.TRUE.toString()) : Collections.emptyMap();
                    this.browser = this.browserProvider.makeBrowser(options);
                    this.browser.setWhitelist(UrlWhitelist.ALLOW_ALL);
                    this.buildInitialToolbar();
                    if (BBoolean.TRUE.equals((Object)this.get("forceInitialize"))) {
                        this.browser.forceInitialize();
                    }
                    this.browser.setCloseOnStop(this.isCloseOnStop());
                    this.browser.setOnRegisterFunctions(this::onRegisterFunctions);
                    this.browser.setOnLoaded(this::onBrowserLoaded);
                    this.browser.setContextMenuEnabled(false);
                    this.browser.setShowProgressIndicator(true);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.location, (Slot)updateUrl);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.statusMsg, (Slot)updateStatus);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.progressRunning, (Slot)progressRunning);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.progress, (Slot)updateProgress);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.error, (Slot)handleError);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.initialized, (Slot)browserInitialized);
                    for (BBinding binding : this.getBindings()) {
                        this.linkTo((BComponent)binding, (Slot)BBinding.targetChanged, (Slot)targetChanged);
                    }
                    BEdgePane pane = new BEdgePane();
                    pane.setCenter((BWidget)this.browser);
                    this.setContent((BWidget)pane);
                    pane.setSize(this.getWidth(), this.getHeight());
                }
                if ((ord = this.getJs()).isNull() || this.browser.isStub()) {
                    this.loadedFuture.get().complete(null);
                    return;
                }
                BISession session = this.findSession();
                this.interop = WebWidgetInterop.start(this);
                this.browser.setDropHandler(this);
                if (this.browser.isInitialized() && this.hasRequireDefined() && this.canReinitialize()) {
                    this.reinitialize();
                    break block26;
                }
                BFoxSession foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
                ArrayList<String[]> queryList = new ArrayList<String[]>();
                OrdQuery[] queries = ord.parse();
                for (int i = 0; i < queries.length; ++i) {
                    String[] paramNames;
                    if (!(queries[i] instanceof ViewQuery)) continue;
                    ViewQuery viewQuery = (ViewQuery)queries[i];
                    String id = viewQuery.getViewId();
                    if (id == null) {
                        id = "";
                    }
                    try {
                        TypeInfo typeInfo = Sys.getRegistry().getType(id);
                        if (!Sys.isStation() && foxSession == null && typeInfo.is(BIOffline.TYPE)) {
                            this.offline = true;
                        }
                    }
                    catch (TypeNotFoundException typeInfo) {
                        // empty catch block
                    }
                    queries[i] = new ViewQuery("view", id);
                    if (foxSession != null) {
                        this.sameRemoteVersion = WbSys.isRemoteVersionTheSame(foxSession.getConnection().session());
                        Version remoteVersion = foxSession.getConnection().getRemoteVersion();
                        if (remoteVersion.compareTo(FoxSession.VERSION_4_4) < 0) {
                            log.severe("WebWidget attempted to connect to version no longer supported: " + remoteVersion);
                        }
                    }
                    for (String name : paramNames = viewQuery.getParameterNames()) {
                        queryList.add(new String[]{name, viewQuery.getParameter(name)});
                    }
                    break;
                }
                this.boxHandler = BoxClientUtil.makeHandler(session).orElse(null);
                String themeName = Theme.getInstalledThemeName();
                if (themeName != null) {
                    queryList.add(new String[]{"theme", themeName});
                }
                queryList.add(new String[]{"formFactor", this.formFactor.getTag()});
                queryList.add(new String[]{"useLocalWbRc", String.valueOf(this.offline || USE_LOCAL_RC && this.sameRemoteVersion && this.getBrowser().canUseLocalWbResources())});
                queryList.add(new String[]{"attachAfterInit", String.valueOf(!this.isInViewTab() && this.getWbViewBinding() == null)});
                String query = queryList.stream().map(entry -> entry[0] + '=' + entry[1]).collect(Collectors.joining("&"));
                URI uri = BWebWidget.makeUri(this, this.browser, session, "/bajaux/webwidget/" + BOrd.make((OrdQuery[])queries), query);
                if (this.offline) {
                    WbWebWidgetServlet servlet = new WbWebWidgetServlet();
                    OfflineRequest req = new OfflineRequest(uri, Collections.singletonMap("niagara.context", new BasicContext()), this.browser.isJavaFx() ? Collections.singletonMap("User-Agent", "JavaFX") : Collections.emptyMap());
                    final OfflineResponse resp = new OfflineResponse();
                    servlet.service((ServletRequest)req, (ServletResponse)resp);
                    if (resp.getStatus() != 200) {
                        throw new IOException("Could not write Web Widget HTML: " + resp.getErrorMsg());
                    }
                    this.browser.load(new BObject(){

                        public String toString(Context context) {
                            return resp.getContentAsString();
                        }
                    }, this.getCurrentContext());
                } else if (!this.browser.isStub()) {
                    FoxSession sess;
                    if (foxSession != null && (sess = foxSession.getConnection().session()) != null) {
                        this.navListener = new FoxSessionRemoveListener(foxSession, this.browser, uri);
                        BNavRoot.INSTANCE.addNavListener(this.navListener);
                    }
                    startedOrd = BOrd.make((String)uri.toASCIIString());
                    this.browser.load((BObject)startedOrd, this.getCurrentContext());
                } else {
                    this.loadedFuture.get().complete(null);
                }
                if (log.isLoggable(Level.INFO)) {
                    this.log(Level.INFO, "Loading: " + uri.toASCIIString());
                }
            }
            catch (Throwable e) {
                if (log.isLoggable(Level.SEVERE)) {
                    this.log(Level.INFO, "Problem Loading", e);
                }
                String msg = "";
                if (e instanceof LocalizableException) {
                    msg = ((LocalizableException)e).toString(null);
                }
                if (e instanceof LocalizableRuntimeException) {
                    msg = ((LocalizableRuntimeException)e).toString(null);
                }
                this.setContent(WbUtil.makeErrorPane(this, msg, startedOrd, e));
            }
        }
    }

    @Override
    public void computePreferredSize() {
        double w = this.getPreferredSize().width();
        double h = this.getPreferredSize().height();
        this.setPreferredSize(w, h);
    }

    public static URI makeUri(BWidget owner, BWebBrowser browser, BISession session, String ord, String query) throws Exception {
        boolean allowCookieSwap;
        BComponent details = BWebWidget.getHttpConnectionDetails(session);
        BFoxSession foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
        BLocalHost host = BLocalHost.INSTANCE;
        boolean isSecure = true;
        if (foxSession != null) {
            isSecure = foxSession.getUseFoxs() || ((BBoolean)details.get("httpsEnabled")).getBoolean();
            host = foxSession.getHost();
        } else if (Sys.isStation()) {
            isSecure = ((BBoolean)details.get("httpsEnabled")).getBoolean();
        }
        int port = BWebWidget.getPort(details, isSecure);
        URI uri = new URI(isSecure ? "https" : "http", null, browser.toHostAddr((BHost)host), port, ord, query, null);
        boolean bl = allowCookieSwap = !IS_WEB_LAUNCHER || !browser.isJavaFx();
        if (foxSession != null && allowCookieSwap) {
            try {
                AccessController.doPrivileged(() -> {
                    FoxSession sess = foxSession.getConnection().session();
                    if (sess != null) {
                        FoxSession foxSession2 = sess;
                        synchronized (foxSession2) {
                            Optional expectedSessionId = sess.getFromCache("jsession");
                            if (!expectedSessionId.isPresent() || !browser.isCookiePresent(uri, JSESSIONID, (String)expectedSessionId.get(), "/")) {
                                String superSessionId = sess.getRemoteSuperId();
                                Optional optional = sess.getFromCache(LAST_SUPER_SESSION_ADD);
                                String lastId = optional.orElse(null);
                                if (lastId == null || !lastId.equals(superSessionId)) {
                                    browser.addCookie(uri, "super_session_id", superSessionId, "/");
                                    browser.removeCookie(uri, JSESSIONID, "/");
                                    sess.getFromCache(LAST_SUPER_SESSION_ADD, v -> superSessionId);
                                }
                            }
                        }
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else if (Sys.isStation() && !browser.isStub() && BLocalHost.INSTANCE.equals((Object)host)) {
            AccessController.doPrivileged(() -> {
                String id = LoopbackNiagaraSession.getLoopbackHttpSessionId();
                if (id.isEmpty()) {
                    browser.removeCookie(uri, JSESSIONID, "/");
                    browser.addCookie(uri, "super_session_id", LoopbackNiagaraSession.getLoopbackSuperSessionId(), "/");
                } else {
                    String oldId = browser.getCookieValue(uri, JSESSIONID, "/").orElse("");
                    if (!id.equals(oldId)) {
                        browser.removeCookie(uri, JSESSIONID, "/");
                        browser.addCookie(uri, JSESSIONID, id, "/");
                    }
                }
                return null;
            });
        }
        return uri;
    }

    public static BComponent getHttpConnectionDetails(BISession session) {
        BFoxSession foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
        BComponent details = null;
        if (foxSession != null) {
            details = (BComponent)foxSession.getConnection().session().getFromCache("httpDetails", key -> {
                BBrokerChannel channel = (BBrokerChannel)foxSession.getConnection().getChannels().get("station");
                return channel.getHttpConnectionDetails();
            });
        } else if (Sys.isStation()) {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            details = webService.getHttpConnectionDetails(null);
        }
        if (details == null) {
            details = new BComponent();
            details.add("enabled", (BValue)BBoolean.TRUE);
            details.add("httpEnabled", (BValue)BBoolean.FALSE);
            details.add("httpsEnabled", (BValue)BBoolean.TRUE);
            details.add("httpPort", (BValue)BInteger.make((int)80));
            details.add("httpsPort", (BValue)BInteger.make((int)443));
        }
        return details;
    }

    public static int getPort(BComponent details, boolean isSecure) {
        int port = -1;
        BBoolean webServiceEnabledValue = (BBoolean)details.get("enabled");
        BBoolean httpEnabledValue = (BBoolean)details.get("httpEnabled");
        boolean httpsEnabled = ((BBoolean)details.get("httpsEnabled")).getBoolean();
        boolean httpEnabled = httpEnabledValue == null ? !httpsEnabled : httpEnabledValue.getBoolean();
        int httpsPort = ((BInteger)details.get("httpsPort")).getInt();
        int httpPort = ((BInteger)details.get("httpPort")).getInt();
        if (!httpsEnabled && !httpEnabled && httpEnabledValue != null || webServiceEnabledValue != null && !webServiceEnabledValue.getBoolean()) {
            throw new LocalizableRuntimeException("workbench", "httpFox.noWebService.details");
        }
        if (isSecure && !httpsEnabled) {
            throw new LocalizableRuntimeException("workbench", "httpFox.mismatch.details");
        }
        if (!isSecure && !httpEnabled) {
            if (httpEnabledValue == null && httpsEnabled) {
                isSecure = true;
            } else {
                throw new LocalizableRuntimeException("workbench", "httpFox.mismatch.details");
            }
        }
        if (isSecure) {
            if (httpsPort != 443) {
                port = httpsPort;
            }
        } else if (httpPort != 80) {
            port = httpPort;
        }
        return port;
    }

    public String getWidgetTypeSpec() {
        BOrd ord = this.getJs();
        if (ord.isNull()) {
            return "";
        }
        return Arrays.stream(ord.normalize().parse()).filter(q -> q instanceof ViewQuery).map(q -> Objects.toString(((ViewQuery)q).getViewId(), "")).findFirst().orElse("");
    }

    private void reinitialize() {
        OrdTarget target;
        ++this.reuseCount;
        this.extraLoadsComplete = false;
        TypeInfo wTypeInfo = this.getTypeInfoFromJs().orElseThrow(() -> new IllegalStateException("js type info not present"));
        BIJavaScript webWidget = (BIJavaScript)wTypeInfo.getInstance();
        BWbShell shell = BrowserUtil.findWbShell((BComplex)this);
        if (shell != null) {
            target = shell.getActiveOrdTarget();
        } else {
            BWbViewBinding binding = this.getWbViewBinding();
            OrdTarget ordTarget = target = binding != null ? binding.getTarget() : null;
        }
        if (target == null) {
            return;
        }
        BWebBrowser.post(this.browser, () -> {
            JsInfo jsInfo = webWidget.getJsInfo(this.getCurrentContext());
            TypeInfo widgetTypeInfo = webWidget.getType().getTypeInfo();
            JSONObject params = null;
            try {
                params = WbWebWidgetServlet.getParameters((OrdTarget)target);
            }
            catch (IOException e) {
                this.log(Level.WARNING, "Could not decode parameters: " + target.getOrd(), e);
            }
            this.interop.wbContainer().initialize(jsInfo, widgetTypeInfo, params);
            if (this.onLoaded != null) {
                this.onLoaded.run();
            }
        });
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (value == null) {
            return;
        }
        BOrd ord = this.findOrd(value);
        if (ord.isNull()) {
            throw new Exception("Unsupported value for WebWidget: " + value.getType());
        }
        String ordStr = ord.relativizeToSession().toString();
        BWebBrowser.post(this.browser, () -> {
            if (this.state == WebWidgetState.uninitialized) {
                this.ordToLoad = ordStr;
                if (this.reset) {
                    this.reset = false;
                    this.reinitialize();
                }
            } else if (!this.extraLoads()) {
                this.interop.wbContainer().callLoad(ordStr);
            }
        });
    }

    private boolean extraLoads() {
        Optional<TypeInfo> wTypeInfo = this.getTypeInfoFromJs();
        if (wTypeInfo.isPresent() && !wTypeInfo.get().is(BICollectionSupport.TYPE)) {
            return false;
        }
        if (!this.extraLoadsComplete) {
            this.extraLoadsComplete = true;
            List<BWbViewBinding> bindings = this.getViewBindings();
            if (bindings.size() > 1) {
                for (BBinding bBinding : bindings) {
                    this.interop.wbContainer().callLoad(this.getOrdFromBinding(bBinding).toString());
                }
                return true;
            }
        }
        return false;
    }

    public BOrd findOrd(BObject value) {
        BOrd ord = BOrd.NULL;
        if (this.isInViewTab()) {
            BOrd activeOrd;
            BWbShell shell = BWbShell.getWbShell(this);
            if (shell != null && (activeOrd = shell.getActiveOrd()) != null && shell.getActiveView() == this) {
                ord = activeOrd.relativizeToSession();
            }
        } else {
            BWbViewBinding binding = this.getWbViewBinding();
            if (binding != null) {
                ord = this.getOrdFromBinding(binding);
            }
        }
        if (ord.isNull() && value instanceof BINavNode) {
            ord = ((BINavNode)value).getNavOrd().relativizeToSession();
        }
        return ord;
    }

    private BOrd getOrdFromBinding(BBinding binding) {
        OrdTarget baseOrdTarget;
        BOrd base = this.cachedOrdTarget != null ? this.cachedOrdTarget.getOrd() : null;
        Binder binder = WbUtil.getBinder((BComplex)this);
        if (binder != null && (baseOrdTarget = binder.getBase()) != null) {
            base = baseOrdTarget.getOrd();
        }
        return BWebWidget.getOrdFromBinding(binding, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.loadedFuture.isPresent() && this.loadedFuture.get().isDone()) {
            BWebBrowser.post(this.browser, () -> this.interop.wbContainer().callSave());
            Object object = this.saveMonitor;
            synchronized (object) {
                try {
                    long count = 0L;
                    while (!this.saved) {
                        if (count >= 50000L) {
                            break;
                        }
                        BISession sess = this.findSession();
                        if (!this.offline) {
                            if (sess == BLocalHost.INSTANCE) break;
                            if (!sess.isConnected()) {
                                break;
                            }
                        }
                        this.saveMonitor.wait(1000L);
                        count += 1000L;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.saved = false;
                }
            }
            if (this.saveErr != null) {
                throw new CannotSaveException(this.saveErr);
            }
        }
        return super.doSaveValue(value, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUxWidgetSetModified() {
        Object object = this.saveMonitor;
        synchronized (object) {
            this.saveErr = null;
            this.saved = false;
        }
        this.setModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUxWidgetSave() {
        Object object = this.saveMonitor;
        synchronized (object) {
            this.saved = true;
            this.saveErr = null;
            this.saveMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUxWidgetSaveFail(String err) {
        Object object = this.saveMonitor;
        synchronized (object) {
            this.saveErr = err;
            this.saved = true;
            this.saveMonitor.notifyAll();
        }
    }

    public void stopped() throws Exception {
        if (!this.isInViewTab()) {
            this.cleanup();
        }
    }

    @Override
    public void close() {
        if (this.navListener != null) {
            BNavRoot.INSTANCE.removeNavListener(this.navListener);
        }
        if (this.boxHandler != null) {
            this.boxHandler.unregisterUnsolicitedListener(this.serverSessionId);
        }
        if (this.getBrowser() != null) {
            this.getBrowser().close();
        }
        this.cachedOrdTarget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivated() {
        if (this.browser.isStub()) {
            return;
        }
        if (!this.getJs().isNull() && this.loadedFuture.isPresent() && this.loadedFuture.get().isDone()) {
            BWebBrowser.post(this.browser, () -> this.interop.wbContainer().callDeactivate());
            Object object = this.deactivateMonitor;
            synchronized (object) {
                try {
                    long count = 0L;
                    while (!this.deactivated) {
                        if (count >= 50000L) {
                            if (log.isLoggable(Level.FINE)) {
                                this.log(Level.FINE, "Cannot deactivate within wait limit of 50000ms");
                            }
                            break;
                        }
                        BISession sess = this.findSession();
                        if (!this.offline) {
                            if (sess == BLocalHost.INSTANCE) break;
                            if (!sess.isConnected()) {
                                break;
                            }
                        }
                        this.deactivateMonitor.wait(1000L);
                        count += 1000L;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.deactivated = false;
                }
            }
        }
        if (this.loadedFuture.isPresent() && !this.loadedFuture.get().isDone()) {
            this.loadedFuture.get().complete(null);
        }
        this.state = WebWidgetState.uninitialized;
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUxWidgetDeactivated() {
        Object object = this.deactivateMonitor;
        synchronized (object) {
            this.deactivated = true;
            this.deactivateMonitor.notifyAll();
        }
    }

    private void cleanup() {
        if (this.getBrowser().isCloseOnStop()) {
            this.close();
        }
    }

    public void changed(Property prop, Context context) {
        if (prop.equals(preferredSize)) {
            this.computePreferredSize();
        }
        if (this.state == WebWidgetState.initialized && WebProperty.isWebProperty((BComplex)this, (Property)prop)) {
            BWebBrowser.post(this.browser, () -> {
                try {
                    JSONObject encodedProperty = WebProperty.encodeProperty((BWidget)this, (Property)prop);
                    Object propertyValue = encodedProperty.get("value");
                    this.interop.uxWidget().setPropertyValue(prop.getName(), propertyValue, "ext");
                    if (encodedProperty.has("metadata")) {
                        JSONObject propertyMetadata = encodedProperty.getJSONObject("metadata");
                        this.interop.uxWidget().setPropertyMetadata(prop.getName(), propertyMetadata, "ext");
                    }
                }
                catch (IOException ex) {
                    this.log(Level.SEVERE, "Could not set Web Property in JS: " + prop.getName(), ex);
                }
            });
        }
        super.changed(prop, context);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 406) {
            return this.reloadInline((BOrd)a, (AgentInfo)b, (BSpace)c);
        }
        if (x == 407) {
            BExporter exporter = (BExporter)a;
            BWebWidget webWidget = (BWebWidget)c;
            webWidget.updateExporter(exporter);
            return null;
        }
        return super.fw(x, a, b, c, d);
    }

    private void updateExporter(BExporter exporter) {
        block4: {
            try {
                if (this.getBrowser().isJavaFx()) {
                    return;
                }
                BExporter exporterChanges = this.interop().wbContainer().updateTransformOptions(exporter);
                if (exporterChanges != null) {
                    exporter.copyFrom((BComplex)exporterChanges);
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.log(Level.FINE, "Unable to check for updateExporter", e);
            }
        }
    }

    public void setOnLoaded(Runnable onLoaded) {
        this.onLoaded = onLoaded;
    }

    public void setBrowserProvider(WebBrowserProvider browserProvider) {
        this.browserProvider = browserProvider;
    }

    private boolean reloadInline(BOrd ord, AgentInfo agentInfo, BSpace space) {
        Property[] webProps;
        if (!this.canReloadInline(agentInfo, space)) {
            return false;
        }
        this.state = WebWidgetState.uninitialized;
        if (agentInfo != null) {
            this.recordAgentId(agentInfo, ord);
        }
        for (Property prop : webProps = this.getPropertiesArray()) {
            if (!WebProperty.isWebProperty((BComplex)this, (Property)prop) || !prop.isDynamic()) continue;
            this.remove(prop);
        }
        this.reset = true;
        return true;
    }

    private boolean canReloadInline(AgentInfo agentInfo, BSpace space) {
        BISession session;
        if (!NIAGARA_WEBBROWSER_UPDATABLE) {
            return false;
        }
        BISession bISession = session = space != null ? space.getSession() : null;
        if (this.offline && session instanceof BFoxSession) {
            return false;
        }
        BISession oldSession = this.getCurrentValueSession();
        if (session != null && oldSession != null && !session.equals(oldSession) || session == null && oldSession != null || session != null && oldSession == null) {
            return false;
        }
        if (this.isCloseOnStop() || !this.canReinitialize()) {
            return false;
        }
        boolean isAgentIJavaScript = true;
        if (agentInfo != null) {
            isAgentIJavaScript = agentInfo.getInstance() instanceof BIJavaScript;
        }
        return isAgentIJavaScript && this.browser != null && this.browser.isInitialized() && this.hasRequireDefined();
    }

    private boolean canReinitialize() {
        return this.getTypeInfoFromJs().isPresent() && !(this.getContent() instanceof BErrorPanel);
    }

    public BMenu[] getViewMenus() {
        BMenu[] bMenuArray;
        if (this.menu == null) {
            bMenuArray = null;
        } else {
            BMenu[] bMenuArray2 = new BMenu[1];
            bMenuArray = bMenuArray2;
            bMenuArray2[0] = this.menu;
        }
        return bMenuArray;
    }

    public BToolBar getViewToolBar() {
        return this.toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMenu(JSONObject groupData) {
        Map<IWbJsCommand, ?> map = this.commands;
        synchronized (map) {
            this.commands.clear();
        }
        BMenu m = null;
        boolean added = false;
        if (groupData != null) {
            m = new BMenu(JSONUtil.getString((JSONObject)groupData, (String)"displayName"));
            added = this.buildMenu(m, groupData.getJSONArray("kids"));
        }
        if (BWebWidget.isWebDevMode()) {
            if (m == null) {
                m = new BMenu(this.getDisplayName(null));
            }
            m.add("remoteDebugCmd", (Command)new RemoteDebugCommand(this.browser));
            added = true;
        }
        this.menu = m != null && added ? m : null;
    }

    private boolean buildMenu(BMenu menu, JSONArray kids) {
        boolean added = false;
        for (int i = 0; i < kids.length(); ++i) {
            JSONObject obj = kids.getJSONObject(i);
            if (obj.getBoolean("command") && obj.getBoolean("menu")) {
                added = true;
                menu.add("jsCmd?", this.makeCmd(obj));
                continue;
            }
            BMenu newMenu = new BMenu(JSONUtil.getString((JSONObject)obj, (String)"displayName"));
            BSubMenuItem subMenu = new BSubMenuItem((BIMenu)newMenu);
            if (!obj.has("kids") || !this.buildMenu(newMenu, obj.getJSONArray("kids"))) continue;
            added = true;
            menu.add("jsCmdGroup?", (BValue)subMenu);
        }
        return added;
    }

    private void buildInitialToolbar() {
        BToolBar tb = null;
        boolean added = false;
        if (BWebWidget.isWebDevMode()) {
            if (tb == null) {
                tb = new BToolBar();
            }
            tb.add("remoteDebugCmd", (Command)new RemoteDebugCommand(this.browser));
            added = true;
        }
        this.toolBar = tb != null && added ? tb : null;
    }

    private void buildToolbar(JSONObject groupData) {
        BToolBar tb = null;
        boolean added = false;
        if (groupData != null) {
            tb = new BToolBar();
            added = this.buildToolbar(tb, groupData.getJSONArray("kids"));
        }
        if (BWebWidget.isWebDevMode()) {
            if (tb == null) {
                tb = new BToolBar();
            }
            tb.add("remoteDebugCmd", (Command)new RemoteDebugCommand(this.browser));
            added = true;
        }
        this.toolBar = tb != null && added ? tb : null;
    }

    private boolean buildToolbar(BToolBar tb, JSONArray kids) {
        boolean added = false;
        for (int i = 0; i < kids.length(); ++i) {
            JSONObject obj = kids.getJSONObject(i);
            if (obj.getBoolean("command") && obj.getBoolean("toolbar")) {
                added = true;
                tb.add("jsCmd?", this.makeCmd(obj));
                continue;
            }
            if (!obj.has("kids") || !this.buildToolbar(tb, obj.getJSONArray("kids"))) continue;
            added = true;
        }
        return added;
    }

    private static boolean isWebDevMode() {
        return BWidget.getApplication() != null && BWebBrowserOptions.get().getWebDevelopmentTools();
    }

    public void doUpdateUrl(BString url) {
        this.doUpdateStatus(url);
    }

    public void doUpdateStatus(BString msg) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(msg.getString());
        }
    }

    public void doUpdateProgress(BDouble progress) {
        this.doUpdateStatus(BString.make((String)((int)this.browser.getProgress() + "%: " + this.browser.getOrd())));
    }

    public void doProgressRunning(BBoolean running) {
        this.doUpdateStatus(BString.make((String)this.browser.getLocation()));
    }

    public void doHandleError(BString error) {
        BWebBrowser.log.severe(error.toString());
    }

    private void onRegisterFunctions() {
        this.interop.registerFunctions(this.browser);
    }

    private void onBrowserLoaded() {
        BISession session = this.findSession();
        if (session instanceof BFoxSession) {
            URI uri;
            FoxSession sess = ((BFoxSession)session).getConnection().session();
            try {
                uri = new URI(this.interop.browser().getLocationHref());
            }
            catch (URISyntaxException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            AccessController.doPrivileged(() -> {
                this.browser.getCookieValue(uri, JSESSIONID, "/").ifPresent(val -> {
                    String cfr_ignored_0 = (String)sess.getFromCache("jsession", v -> val);
                });
                return null;
            });
        }
        if (this.onLoaded != null) {
            this.onLoaded.run();
        }
        this.interop.browser().ready();
    }

    public void doTargetChanged() {
        if (this.state == WebWidgetState.initialized) {
            BWebBrowser.post(this.browser, () -> {
                BWebWidget widget = this;
                Property[] nprops = widget.getPropertiesArray();
                if (nprops.length == 0) {
                    return;
                }
                HashMap<String, JSONObject> map = null;
                for (Property p : nprops) {
                    if (!WebProperty.isWebProperty((BComplex)widget, (Property)p)) continue;
                    if (map == null) {
                        map = new HashMap<String, JSONObject>();
                    }
                    try {
                        map.put(SlotPath.unescape((String)p.getName()), WebProperty.encodeProperty((BWidget)widget, (Property)p));
                    }
                    catch (IOException ex) {
                        this.log(Level.SEVERE, "Could not set Web Property in JS: " + p.getName(), ex);
                    }
                }
                if (map != null) {
                    this.interop.wbContainer().callUpdateProperties(map);
                }
            });
        }
    }

    public void doBrowserInitialized() {
        String dataUri = String.format("data:,body{ font-size: %spx; }", Theme.label().getTextFont().getSize());
        AccessController.doPrivileged(() -> {
            BWebBrowser.post(this.browser, () -> this.browser.setUserAgentStyleSheetLocation(dataUri));
            return null;
        });
    }

    BISession findSession() {
        BWbViewBinding binding;
        BISession session = this.getCurrentValueSession();
        if (!BWebWidget.isUsableRemoteSession(session) && (binding = this.getWbViewBinding()) != null && binding.getTarget() != null && binding.getTarget().getComponent() != null) {
            session = binding.getTarget().getComponent().getSession();
        }
        if (!BWebWidget.isUsableRemoteSession(session)) {
            session = WbUtil.findSession(this);
        }
        if (!BWebWidget.isUsableRemoteSession(session)) {
            BISession cachedSession;
            BISession bISession = cachedSession = this.cachedOrdTarget != null && this.cachedOrdTarget.getSpace() != null ? this.cachedOrdTarget.getSpace().getSession() : null;
            if (BWebWidget.isUsableRemoteSession(cachedSession)) {
                return cachedSession;
            }
        }
        return session;
    }

    private static boolean isUsableRemoteSession(BISession session) {
        return session != null && !(session instanceof BLocalHost);
    }

    public void setCachedOrdTarget(OrdTarget ordTarget) {
        this.cachedOrdTarget = ordTarget;
    }

    public BWbViewBinding getWbViewBinding() {
        for (BBinding binding : this.getBindings()) {
            if (!(binding instanceof BWbViewBinding) || !binding.isBound()) continue;
            return (BWbViewBinding)binding;
        }
        return null;
    }

    public List<BWbViewBinding> getViewBindings() {
        return Arrays.stream(this.getBindings()).filter(b -> b instanceof BWbViewBinding && b.isBound()).map(b -> (BWbViewBinding)((Object)b)).collect(Collectors.toList());
    }

    WebWidgetInterop interop() {
        return this.interop;
    }

    public BWebBrowser getBrowser() {
        return this.browser;
    }

    public boolean isCloseOnStop() {
        return this.closeOnStop;
    }

    public void setCloseOnStop(boolean closeOnStop) {
        this.closeOnStop = closeOnStop;
        if (this.browser != null) {
            this.browser.setCloseOnStop(closeOnStop);
        }
    }

    public boolean isClaimed() {
        return this.claimed;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    public void executeScript(String script) {
        BWebBrowser.post(this.browser, () -> this.browser.executeScriptAsync(script));
    }

    public boolean hasRequireDefined() {
        try {
            return this.browser != null && this.browser.executeScriptAndWait("typeof window.require === 'function'").toBool();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Unable to check for require", e);
            }
            return false;
        }
    }

    public Optional<CompletableFuture<Void>> getLoadedFuture() {
        return this.loadedFuture;
    }

    void onUxWidgetInitializing() {
        this.state = WebWidgetState.initializing;
        if (!this.ordToLoad.isEmpty()) {
            String containerOrd = this.ordToLoad;
            this.ordToLoad = "";
            BWebBrowser.post(this.browser, () -> {
                if (!this.extraLoads()) {
                    this.interop.wbContainer().callLoad(containerOrd);
                }
            });
        }
    }

    void onUxWidgetInitialized() {
        this.state = WebWidgetState.initialized;
        Optional<CompletableFuture<Void>> future = this.loadedFuture;
        if (future.isPresent() && (this.getCurrentValue() == null || this.getWbViewBinding() == null && !this.isInViewTab())) {
            future.get().complete(null);
        }
    }

    void onUxWidgetLoaded() {
        this.loadedFuture.ifPresent(future -> future.complete(null));
    }

    void onUxWidgetError(Object err) {
        this.log(Level.SEVERE, err.toString());
        this.loadedFuture.ifPresent(future -> future.completeExceptionally(new Exception("Failed to load WebWidget: " + err)));
    }

    void buildCommands(Object data) {
        if (!this.isInViewTab()) {
            return;
        }
        JSONObject obj = this.browser.fromJsToString(data).map(JSONObject::new).orElse(null);
        BWidget.invokeLater(() -> {
            this.buildMenu(obj);
            this.buildToolbar(obj);
            if (this.isInViewTab()) {
                BViewTab vt = (BViewTab)this.getParent();
                vt.updateShell();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCommand(JSONObject jsCmdObj) {
        int id = jsCmdObj.getInt("id");
        Map<IWbJsCommand, ?> map = this.commands;
        synchronized (map) {
            this.commands.keySet().forEach(cmd -> {
                if (cmd != null && cmd.getId() == id) {
                    cmd.sync(jsCmdObj);
                }
            });
        }
    }

    String syncProperties(Object jsProps) {
        Optional<String> propsStr = this.browser.fromJsToString(jsProps);
        if (!propsStr.isPresent()) {
            return "";
        }
        JSONArray props = new JSONArray(propsStr.get());
        ArrayList<WebProperty> webProps = new ArrayList<WebProperty>();
        for (int i = 0; i < props.length(); ++i) {
            JSONObject p = props.getJSONObject(i);
            String typeSpec = p.has("typeSpec") ? JSONUtil.getString((JSONObject)p, (String)"typeSpec") : "";
            WebProperty buxp = new WebProperty(JSONUtil.getString((JSONObject)p, (String)"name"), p.has("hidden") && p.getBoolean("hidden"), p.has("readonly") && p.getBoolean("readonly"), p.has("transient") ? p.getBoolean("transient") : p.has("trans") && p.getBoolean("trans"), "undefined".equals(typeSpec) ? "" : typeSpec, JSONUtil.getString((JSONObject)p, (String)"value"), p.has("metadata") ? p.getJSONObject("metadata") : null);
            webProps.add(buxp);
        }
        Map map = WebProperty.sync((BWidget)this, webProps);
        return map.isEmpty() ? "" : BWebWidget.toJsonStr(map);
    }

    private static String toJsonStr(Map<String, Object> map) {
        JSONObject obj = new JSONObject();
        map.keySet().iterator().forEachRemaining(name -> obj.put(name, map.get(name)));
        return obj.toString();
    }

    String listViews(Object jsOrd) {
        StringWriter writer = new StringWriter();
        try {
            Optional<String> ordOptional = this.browser.fromJsToString(jsOrd);
            if (!ordOptional.isPresent()) {
                return "";
            }
            BOrd ord = BOrd.make((String)ordOptional.get()).relativizeToSession();
            OrdTarget target = ord.resolve(this.getCurrentValue(), this.getCurrentContext());
            BObject base = target.get();
            AgentList list = WbSys.getFilteredViewList(this, base, agent -> true);
            ViewAllOrdServlet.writeViewList((AgentList)list, (BOrd)ord, (Writer)writer, (String)"", (OrdTarget)target, (Context)this.getCurrentContext());
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not provide view list", e);
        }
        return writer.toString();
    }

    String getWebProperties() {
        Map map = Collections.emptyMap();
        try {
            map = WebProperty.getPropertyChanges((BWidget)this);
        }
        catch (IOException ex) {
            this.log(Level.SEVERE, "Could not encode Web Property in JS", ex);
        }
        return !map.isEmpty() ? BWebWidget.toJsonStr(map) : "";
    }

    void sendBox(String data) {
        if (this.boxHandler == null) {
            return;
        }
        this.boxHandler.sendBox(data).handleAsync((resp, err) -> {
            if (resp != null) {
                this.onBoxResponseMessage((String)resp);
            } else if (err != null) {
                this.loadedFuture.ifPresent(future -> {
                    if (!future.isDone()) {
                        future.completeExceptionally((Throwable)err);
                    }
                });
                this.log(Level.SEVERE, "Error sending BOX message over FOX", (Throwable)err);
            }
            return resp;
        }, (Executor)BoxClientUtil.getExecutorService());
    }

    String getHostOrd() {
        if (this.boxHandler == null) {
            return "";
        }
        return this.boxHandler.getHostOrd().encodeToString();
    }

    String getSessionOrdInHost() {
        if (this.boxHandler == null) {
            return "";
        }
        return this.boxHandler.getSessionOrdInHost().encodeToString();
    }

    void setServerSessionId(String id) {
        if (this.boxHandler == null) {
            return;
        }
        this.boxHandler.unregisterUnsolicitedListener(this.serverSessionId);
        this.serverSessionId = id;
        this.boxHandler.registerUnsolicitedListener(this.serverSessionId, this::onBoxResponseMessage);
    }

    void playSound(String sound) {
        if (this.browser != null && this.getParent() != null) {
            this.browser.playSound(BOrd.make((BOrd)BWebWidget.getBaseOrd(this), (String)sound).normalize());
        }
    }

    void stopSound(String sound) {
        if (this.browser != null && this.getParent() != null) {
            this.browser.stopSound(BOrd.make((BOrd)BWebWidget.getBaseOrd(this), (String)sound).normalize());
        }
    }

    private static BOrd getBaseOrd(BWebWidget ww) {
        BOrd base = BOrd.NULL;
        BWbShell shell = BrowserUtil.findWbShell((BComplex)ww);
        if (shell != null) {
            base = shell.getActiveOrd();
        }
        return base;
    }

    void log(Level level, String msg) {
        log.log(level, "WebWidget " + this.id() + ": " + msg);
    }

    void log(Level level, String msg, Throwable th) {
        log.log(level, "WebWidget " + this.id() + ": " + msg, th);
    }

    private String id() {
        return this.getBrowser().getDebugId() + '(' + this.getJs() + ')';
    }

    public int getReuseCount() {
        return this.reuseCount;
    }

    private void onBoxResponseMessage(String boxFrame) {
        BWebBrowser.post(this.browser, () -> this.interop.bajaScriptWebSocket().handleMessage(boxFrame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command makeCmd(JSONObject jsCmd) {
        IWbJsCommand cmd = jsCmd.getBoolean("toggle") ? new WbJsToggleCommand(this, jsCmd) : new WbJsCommand(this, jsCmd);
        Map<IWbJsCommand, ?> map = this.commands;
        synchronized (map) {
            this.commands.put(cmd, null);
        }
        return (Command)cmd;
    }

    boolean isInViewTab() {
        BWidget w = this.getParentWidget();
        return w instanceof BViewTab;
    }

    public static BOrd createJsOrd(AgentInfo agentInfo, BOrd ord) {
        String[] paramNames;
        ViewQuery query;
        StringBuilder out = new StringBuilder();
        out.append("view:").append(agentInfo.getAgentId());
        if (ord != null && (query = OrdUtil.getViewQuery((BOrd)ord)) != null && (paramNames = query.getParameterNames()).length > 0) {
            out.append('?');
            for (int i = 0; i < paramNames.length; ++i) {
                if (i > 0) {
                    out.append(';');
                }
                out.append(paramNames[i]).append('=').append(query.getParameter(paramNames[i]));
            }
        }
        return BOrd.make((String)out.toString());
    }

    private void recordAgentId(AgentInfo agentInfo, BOrd ord) {
        this.setJs(BWebWidget.createJsOrd(agentInfo, ord));
    }

    public Optional<TypeInfo> getTypeInfoFromJs() {
        try {
            String id = this.getWidgetTypeSpec();
            if (id.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Sys.getRegistry().getType(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static BOrd getOrdFromBinding(BBinding binding, BOrd base) {
        BObject obj = binding.get();
        BOrd ord = binding.getOrd();
        if (obj instanceof BINavNode) {
            ord = ((BINavNode)obj).getNavOrd();
        } else if (base != null) {
            ord = BOrd.make((BOrd)base, (BOrd)ord);
        }
        ViewQuery query = binding.getTarget().getViewQuery();
        if (query != null) {
            ord = BOrd.make((BOrd)ord, (OrdQuery)query);
        }
        return ord.normalize().relativizeToSession();
    }

    private boolean isOfflineMode() {
        return this.offline;
    }

    private void fireEvent(String eventName, TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        BObject[] values = mark.getValues();
        double x = cx.getX();
        double y = cx.getY();
        BWebBrowser.post(this.browser, () -> {
            try {
                StringWriter strWtr = new StringWriter();
                JSONWriter out = QuickJSONWriter.make((Appendable)strWtr);
                boolean empty = true;
                out.array();
                for (BObject value : values) {
                    if (!(value instanceof BINavNode)) continue;
                    empty = false;
                    try {
                        BINavNode node = (BINavNode)value;
                        out.object();
                        out.key("ord").value((Object)node.getNavOrd().relativizeToSession());
                        out.key("name").value((Object)node.getNavName());
                        out.key("displayName").value((Object)node.getNavDisplayName(null));
                        out.key("icon").value((Object)node.getNavIcon().encodeToString());
                        out.key("description").value((Object)node.getNavDescription(null));
                        out.key("typeSpec").value((Object)node.getType());
                        out.endObject();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                out.endArray();
                if (!empty) {
                    switch (eventName) {
                        case "dragover": {
                            this.interop.wbContainer().callDragover(x, y, strWtr.toString());
                            break;
                        }
                        case "drop": {
                            this.interop.wbContainer().callDrop(x, y, strWtr.toString());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown event name " + eventName);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.dragOverRes = 0;
                Object object = this.dragOverMonitor;
                synchronized (object) {
                    this.dragOverMonitor.notifyAll();
                }
                this.log(Level.SEVERE, e.getMessage() == null ? "Could not invoke drag and drop event" : e.getMessage(), e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onJsDragEvent(boolean eventWasProcessed) {
        this.dragOverRes = eventWasProcessed ? 0 : 16;
        Object object = this.dragOverMonitor;
        synchronized (object) {
            this.dragOverMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doDragOver(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        BObject[] values = mark.getValues();
        if (values.length == 0) {
            return 0;
        }
        for (BObject value : values) {
            if (value instanceof BINavNode) continue;
            return 0;
        }
        try {
            Object object = this.dragOverMonitor;
            synchronized (object) {
                this.fireEvent("dragover", cx);
                this.dragOverMonitor.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            this.dragOverRes = 0;
        }
        return this.dragOverRes;
    }

    @Override
    public CommandArtifact doDrop(TransferContext cx) {
        this.fireEvent("drop", cx);
        return null;
    }

    @FunctionalInterface
    public static interface WebBrowserProvider {
        public BWebBrowser makeBrowser(Map<String, String> var1);
    }

    private static enum WebWidgetState {
        uninitialized,
        initializing,
        initialized;

    }

    public static final class FoxSessionRemoveListener
    implements NavListener {
        private final WeakReference<BFoxSession> sessRef;
        private final WeakReference<BWebBrowser> browserRef;
        private final URI uri;

        public FoxSessionRemoveListener(BFoxSession sess, BWebBrowser browser, URI uri) {
            this.sessRef = new WeakReference<BFoxSession>(sess);
            this.browserRef = new WeakReference<BWebBrowser>(browser);
            this.uri = uri;
        }

        public void navEvent(NavEvent event) {
            BFoxSession sess = (BFoxSession)this.sessRef.get();
            BWebBrowser browser = (BWebBrowser)((Object)this.browserRef.get());
            if (sess != null && browser != null && event.getId() == 2 && event.getParent() == sess) {
                AccessController.doPrivileged(() -> {
                    try {
                        browser.removeCookie(this.uri, BWebWidget.JSESSIONID, "/");
                        browser.removeCookie(this.uri, "super_session_id", "/");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                });
            }
        }
    }
}

