/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.security.UrlWhitelist;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BrowserUtil;
import com.tridium.workbench.web.browser.IJs;
import com.tridium.workbench.web.browser.interop.ConsoleEventHandler;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIWebBrowserImpl
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BIWebBrowserImpl.class);
    public static final String FORCE_STATION_BROWSER_INIT = "forceStationBrowserInit";

    public boolean preInitialize(Map<String, String> var1);

    public void browserChanged(Property var1, Context var2);

    public void browserReload();

    public void setBounds(double var1, double var3, double var5, double var7);

    public void setDropHandler(BWebBrowser.IWebBrowserDropHandler var1);

    public IJs executeScript(String var1);

    default public IJs executeScriptAndWait(String script) {
        return this.executeScript(script);
    }

    public void executeScriptAsync(String var1);

    public void load(BObject var1, Context var2);

    public void setWhitelist(UrlWhitelist var1);

    public void setOnRegisterFunctions(Runnable var1);

    public void setOnLoaded(Runnable var1);

    public void setUserAgentStyleSheetLocation(String var1);

    public boolean isInitialized();

    public Optional<String> fromJsToString(Object var1);

    public void post(Runnable var1);

    public boolean isCookiePresent(URI var1, String var2, String var3, String var4);

    public Optional<String> getCookieValue(URI var1, String var2, String var3);

    public void removeCookie(URI var1, String var2, String var3);

    public void addCookie(URI var1, String var2, String var3, String var4) throws IOException;

    public void register(String var1, Runnable var2);

    public <T> void registerConsumer(String var1, Consumer<T> var2);

    public <T, U> void registerBiConsumer(String var1, BiConsumer<T, U> var2);

    public <T, R> void registerFunction(String var1, Function<T, R> var2);

    public <T, U, R> void registerBiFunction(String var1, BiFunction<T, U, R> var2);

    public <R> void registerSupplier(String var1, Supplier<R> var2);

    default public void registerConsoleEventHandler(ConsoleEventHandler eventHandler) {
    }

    default public void removeConsoleEventHandler(ConsoleEventHandler eventHandler) {
    }

    default public String getDebugId() {
        return Integer.toHexString(System.identityHashCode(this));
    }

    default public void clearCache() {
    }

    default public void registerObject(Object o) {
    }

    public void close();

    public boolean canUseLocalWbResources();

    public String getScheme();

    public String getHostname();

    public int getPort();

    default public void playSound(BOrd sound) {
    }

    default public void stopSound(BOrd sound) {
    }

    default public String toHostAddr(BHost host) {
        return BIWebBrowserImpl.toDefaultHostAddr(host);
    }

    public static String toDefaultHostAddr(BHost host) {
        return BrowserUtil.getHostForBrowser(host.getHostname());
    }

    public String getFragmentScrollReadyJs();

    public String getDebugUrl();

    default public boolean supportsNativePdfExport() {
        return false;
    }

    default public void exportToNativePdf(PdfOp op) throws Exception {
        throw new UnsupportedOperationException();
    }
}

