/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web;

import com.tridium.ui.theme.Theme;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.Lexicon;

@NiagaraType
public class BUrlTextField
extends BTextField {
    @Generated
    public static final Type TYPE = Sys.loadType(BUrlTextField.class);
    private static final int DEFAULT_VISIBLE_COLUMNS = 20;
    private static final BIcon ICON = BIcon.std((String)"hyperlink.png");
    private static final Lexicon LEXICON = Lexicon.make((String)"workbench");
    private static final Logger LOGGER = Logger.getLogger("workbench");
    private final String url;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUrlTextField() {
        this("", 20);
    }

    public BUrlTextField(String url, int urlVisibleColumn) {
        super(url, urlVisibleColumn, false);
        this.url = url;
        this.setRenderer(new HyperlinkRenderer());
    }

    public void mouseEntered(BMouseEvent event) {
        super.mouseEntered(event);
        this.setMouseCursor(MouseCursor.hand);
    }

    public void mouseExited(BMouseEvent event) {
        super.mouseExited(event);
        this.setMouseCursor(MouseCursor.normal);
    }

    public void mousePressed(BMouseEvent event) {
        super.mousePressed(event);
        if (event.isButton1Down()) {
            BUrlTextField.openURL((BWidget)this, this.url);
        }
    }

    public void keyPressed(BKeyEvent event) {
        super.keyPressed(event);
        if (event.getKeyCode() == 10) {
            BUrlTextField.openURL((BWidget)this, this.url);
        }
    }

    public String getStyleSelector() {
        return "hyperlink";
    }

    private static void openURL(BWidget parent, String url) {
        Desktop platform;
        if (Desktop.isDesktopSupported() && (platform = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                platform.browse(new URI(url));
            }
            catch (URISyntaxException e) {
                String failureText = LEXICON.getText("urlTextField.error.invalidSyntax", new Object[]{e.getInput()});
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.SEVERE, failureText, e);
                } else {
                    LOGGER.log(Level.SEVERE, failureText + ": " + e);
                }
                BDialog.error((BWidget)parent, (Object)failureText);
            }
            catch (IOException e) {
                String failureText = LEXICON.getText("urlTextField.error.defaultBrowserFailed");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.SEVERE, failureText, e);
                } else {
                    LOGGER.log(Level.SEVERE, failureText + ": " + e);
                }
                BDialog.error((BWidget)parent, (Object)failureText);
            }
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    private static class HyperlinkRenderer
    extends TextRenderer {
        private HyperlinkRenderer() {
            super(BFont.make((BFont)Theme.textEditor().getFixedWidthFont(), (int)4));
        }

        public BBrush getForeground(Segment seg) {
            if (!this.getEditor().isEnabled() || !this.getEditor().getParentWidget().isEnabled()) {
                return Theme.textEditor().getDisabledTextBrush((IStylable)this.getEditor());
            }
            return BBrush.makeSolid((BColor)BColor.blue);
        }
    }
}

