/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserView;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.web.BIFormFactorMax;
import javax.baja.web.BIWebOnly;
import javax.baja.web.js.BIJavaScript;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.view.BWbView;

public class WbViewUtil {
    private static final String[] DEV_VIEWS = new String[]{"bql:CollectionView", "bajaui:CollectionView"};
    private static final Map<String, Boolean> devViewsEnabled = new HashMap<String, Boolean>();

    public static AgentList getWorkbenchAgents(BObject object, Context cx) {
        AgentList list = object.getAgents(cx);
        for (String string : DEV_VIEWS) {
            if (devViewsEnabled.get(string).booleanValue()) continue;
            list.remove(string);
        }
        if (BWebBrowser.BROWSING_DISABLED) {
            for (String string : list.list()) {
                if (!string.getAgentType().is(BIJavaScript.TYPE) && !string.getAgentType().is(BWebBrowserView.TYPE)) continue;
                list.toBottom((AgentInfo)string);
            }
        }
        return list;
    }

    public static AgentFilter isWorkbenchViewFilter() {
        return IS_WORKBENCH_VIEW_FILTER_HOLDER.INSTANCE;
    }

    private static boolean isWorkbenchView(TypeInfo type) {
        return type.is(BWbView.TYPE) || type.is(BAbstractPxView.TYPE) || type.is(BIFormFactorMax.TYPE) && !type.is(BIWebOnly.TYPE);
    }

    public static boolean isAcceptableViewForProfile(BWbProfile profile, BObject objectToView, AgentInfo viewAgent) {
        if (!profile.hasView(objectToView, viewAgent)) {
            return false;
        }
        if (viewAgent.getAppName() == null) {
            return true;
        }
        return Arrays.stream(profile.getAppNames()).anyMatch(name -> name.equals(viewAgent.getAppName()));
    }

    static {
        for (String s : DEV_VIEWS) {
            devViewsEnabled.put(s, AccessController.doPrivileged(() -> Boolean.getBoolean("profile.enableDevView." + s)));
        }
    }

    private static interface IS_WORKBENCH_VIEW_FILTER_HOLDER {
        public static final AgentFilter INSTANCE = new AgentFilter(){

            public boolean include(AgentInfo agent) {
                return WbViewUtil.isWorkbenchView(agent.getAgentType());
            }
        };
    }
}

