/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BFindPane;
import com.tridium.ui.Binder;
import com.tridium.util.CompUtil;
import com.tridium.web.WebUtil;
import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.web.browser.BrowserUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.js.BIJavaScript;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.workbench.view.BWbView;

public class WbUtil {
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static Logger log = Logger.getLogger("wb.util");

    public static void loadWithMacros(InputStream in, OutputStream out, Properties macros) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (c != 36) {
                out.write(c);
                continue;
            }
            c = in.read();
            if (c != 40) {
                out.write(c);
                continue;
            }
            StringBuilder s = new StringBuilder();
            while ((c = in.read()) != 41) {
                s.append((char)c);
            }
            String key = s.toString();
            String val = macros.getProperty(key, key);
            for (int i = 0; i < val.length(); ++i) {
                out.write(val.charAt(i));
            }
        }
    }

    public static BColor mixColors(BColor colorA, BColor colorB, float mix) {
        if (mix <= 0.0f) {
            return colorA;
        }
        if (mix >= 1.0f) {
            return colorB;
        }
        int red = (int)((float)colorA.getRed() + (float)(colorB.getRed() - colorA.getRed()) * mix);
        int green = (int)((float)colorA.getGreen() + (float)(colorB.getGreen() - colorA.getGreen()) * mix);
        int blue = (int)((float)colorA.getBlue() + (float)(colorB.getBlue() - colorA.getBlue()) * mix);
        int alpha = (int)((float)colorA.getAlpha() + (float)(colorB.getAlpha() - colorA.getAlpha()) * mix);
        return BColor.make((int)red, (int)green, (int)blue, (int)alpha);
    }

    public static BColor floatToColor(float value, BColor lowColor, BColor midColor, BColor highColor, float min, float max) {
        int blue;
        int green;
        int red;
        float delta = Math.abs(max - min) / 2.0f;
        float mid = min + delta;
        if (value < mid) {
            if (value < min) {
                return lowColor;
            }
            float mRed = (float)(midColor.getRed() - lowColor.getRed()) / delta;
            float bRed = (float)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            float mGreen = (float)(midColor.getGreen() - lowColor.getGreen()) / delta;
            float bGreen = (float)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            float mBlue = (float)(midColor.getBlue() - lowColor.getBlue()) / delta;
            float bBlue = (float)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
        } else {
            if (value > max) {
                return highColor;
            }
            float mRed = (float)(highColor.getRed() - midColor.getRed()) / delta;
            float bRed = (float)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            float mGreen = (float)(highColor.getGreen() - midColor.getGreen()) / delta;
            float bGreen = (float)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            float mBlue = (float)(highColor.getBlue() - midColor.getBlue()) / delta;
            float bBlue = (float)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
        }
        return BColor.make((int)red, (int)green, (int)blue);
    }

    public static boolean isSuperUser(BWidget widget) {
        boolean isSuperUser = true;
        BWbEditor editor = (BWbEditor)WbUtil.findAncenstorViaComponentTree((BComponent)widget, BWbEditor.TYPE);
        if (editor != null) {
            try {
                BUser user;
                Context cx = editor.getCurrentContext();
                if (cx != null && (user = WbUtil.getUserFromContext(editor, cx)) != null) {
                    user.lease();
                    if (!user.getPermissions().isSuperUser()) {
                        isSuperUser = false;
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "error checking privileges", e);
                isSuperUser = false;
            }
        }
        return isSuperUser;
    }

    public static int compositeDeletionWarning(BWidget parentWidget, BComplex[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            int result = WbUtil.compositeDeletionWarning(parentWidget, (BIPropertyContainer)slots[i].getParent().asComponent(), (Slot)slots[i].getPropertyInParent());
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    public static int compositeDeletionWarning(BWidget parentWidget, BIPropertyContainer parent, Slot slot) {
        return WbUtil.compositeDeletionWarning(parentWidget, parent, new Slot[]{slot});
    }

    public static int compositeDeletionWarning(BWidget parentWidget, BIPropertyContainer parent, Slot[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            if ((parent.getFlags(slots[i]) & 0x1000) == 0) continue;
            return BDialog.open((BWidget)parentWidget, (String)lex.getText("compositeDelete.warning.title"), (Object)lex.getText("compositeDelete.warning.message"), (int)3, (BImage)BDialog.WARNING_ICON);
        }
        return -1;
    }

    public static boolean isRemoteModuleAvailable(String moduleName, BISession session) {
        BObject oSession = (BObject)session;
        Version version = (Version)oSession.fw(404, (Object)moduleName, null, null, null);
        if (version == null) {
            try {
                BOrd.make((String)("file:!modules/" + moduleName + ".jar")).resolve(oSession).get();
                return true;
            }
            catch (Exception exception) {}
        } else if (!version.isNull()) {
            return true;
        }
        return false;
    }

    public static BObject findService(BWidget fieldEditor, Type serviceType, BWbShell shell) {
        BServiceContainer serviceContainer;
        if (shell != null) {
            try {
                BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)("service:" + serviceType));
                return ord.get();
            }
            catch (Exception ord) {
                // empty catch block
            }
        }
        if (fieldEditor != null) {
            BObject result = WbUtil.findAncenstorViaWidgetTree(fieldEditor, serviceType);
            if (result != null) {
                return result;
            }
            BComponent firstComponent = (BComponent)WbUtil.findAncenstorViaWidgetTree(fieldEditor, BComponent.TYPE);
            if (firstComponent != null && (result = WbUtil.findAncenstorViaComponentTree(firstComponent, serviceType)) != null) {
                return result;
            }
        }
        if (!serviceType.is(BServiceContainer.TYPE) && (serviceContainer = (BServiceContainer)WbUtil.findService(fieldEditor, BServiceContainer.TYPE, shell)) != null) {
            while (serviceContainer.getParent() instanceof BServiceContainer) {
                serviceContainer = (BServiceContainer)serviceContainer.getParent();
            }
            Object[] services = CompUtil.getDescendants((BComponent)serviceContainer, (Class)serviceType.getTypeClass());
            if (services.length > 0) {
                return (BObject)services[0];
            }
        }
        return null;
    }

    public static BObject findAncenstorViaComponentTree(BComponent c, Type ancestorType) {
        while (c != null) {
            if (c.getType().is(ancestorType)) {
                return c;
            }
            c = (BComponent)c.getParent();
        }
        return null;
    }

    public static BObject findService(BWidget fieldEditor, Type serviceType) {
        if (fieldEditor != null) {
            return WbUtil.findService(fieldEditor, serviceType, BWbShell.getWbShell(fieldEditor));
        }
        return null;
    }

    public static BObject findAncenstorViaWidgetTree(BWidget fieldEditor, Type ancestorType) {
        return WbUtil.findAncenstorViaWidgetTree(fieldEditor, ancestorType, false);
    }

    /*
     * Unable to fully structure code
     */
    public static BObject findAncenstorViaWidgetTree(BWidget fieldEditor, Type ancestorType, boolean requiresSession) {
        if (WbUtil.log.isLoggable(Level.FINE)) {
            WbUtil.log.fine("Looking for:" + ancestorType + " starting with " + fieldEditor.getType());
        }
lbl3:
        // 5 sources

        try {
            for (iterator = fieldEditor; iterator != null; iterator = iterator.getParent()) {
                block23: {
                    if (WbUtil.log.isLoggable(Level.FINE)) {
                        WbUtil.log.fine("ancestor iterator: " + iterator.getType());
                    }
                    if (!(iterator instanceof BWbEditor)) break block23;
                    editor = (BWbEditor)iterator;
                    val = editor.getCurrentValue();
                    if (val != null && val.getType().is(ancestorType) && (!requiresSession || val.asComponent().getSession() != null)) {
                        if (WbUtil.log.isLoggable(Level.FINE)) {
                            WbUtil.log.fine("Found ancestor via BWbEditor widget ancestry:" + ancestorType);
                        }
                        return val;
                    }
                    for (BBinding binding : bindings = editor.getBindings()) {
                        target = null;
                        if (binding.isBound()) {
                            target = binding.getTarget();
                        } else {
                            ord = binding.getOrd();
                            if (!ord.isNull()) {
                                try {
                                    target = ord.resolve((BObject)editor.getWbShell().getActiveOrdTarget().getComponent(), editor.getCurrentContext());
                                }
                                catch (Exception var13_15) {
                                    // empty catch block
                                }
                            }
                        }
                        if (target == null) continue;
                        securityTarget = (BObject)target.getSecurityTarget();
                        if (securityTarget != null && securityTarget.getType().is(ancestorType)) {
                            if (requiresSession && val.asComponent().getSession() == null) continue;
                            if (WbUtil.log.isLoggable(Level.FINE)) {
                                WbUtil.log.fine("Found ancestor via Binding");
                            }
                            return securityTarget;
                        }
                        if (securityTarget == null || !securityTarget.isComplex()) continue;
                        for (comp = securityTarget.asComplex().getParent(); comp != null; comp = comp.getParent()) {
                            if (comp == null || !comp.getType().is(ancestorType) || requiresSession && comp.asComponent().getSession() == null) continue;
                            if (WbUtil.log.isLoggable(Level.FINE)) {
                                WbUtil.log.fine("Found ancestor via Binding parent walk");
                            }
                            return comp;
                        }
                    }
                    ** GOTO lbl3
                }
                if (iterator instanceof BPropertyEntry) {
                    val = ((BPropertyEntry)iterator).getTarget();
                    if (val == null || !val.getType().is(ancestorType) || requiresSession && val.asComponent().getSession() == null) continue;
                    if (WbUtil.log.isLoggable(Level.FINE)) {
                        WbUtil.log.fine("Found ancestor via PropertySheet");
                    }
                    return val;
                }
                if (!(iterator instanceof BMgrEditDialog)) continue;
                dialog = (BMgrEditDialog)iterator;
                manager = dialog.getManager();
                val = manager.getCurrentValue();
                if (val != null && val.getType().is(ancestorType)) {
                    if (requiresSession && val.asComponent().getSession() == null) continue;
                    if (WbUtil.log.isLoggable(Level.FINE)) {
                        WbUtil.log.fine("Found ancestor via BMgrEditDialog");
                    }
                    return val;
                }
                if (val == null || !val.isComplex()) continue;
                for (comp = val.asComplex().getParent(); comp != null; comp = comp.getParent()) {
                    if (comp == null || !comp.getType().is(ancestorType) || requiresSession && comp.asComponent().getSession() == null) continue;
                    if (WbUtil.log.isLoggable(Level.FINE)) {
                        WbUtil.log.fine("Found ancestor via BMgrEditDialog parent walk");
                    }
                    return comp;
                }
                ** GOTO lbl3
            }
        }
        catch (Exception e) {
            WbUtil.log.log(Level.SEVERE, "Problem searching for widget tree based ancestor", e);
        }
        return null;
    }

    public static BUser getUserFromContext(BWidget owner, Context cx) {
        try {
            if (cx == null) {
                return null;
            }
            BUser user = cx.getUser();
            if (user == null && cx.getFacet("username") != null) {
                BUserService userService = (BUserService)WbUtil.findService(owner, BUserService.TYPE);
                if (userService != null) {
                    userService.lease();
                }
                user = userService != null ? userService.getUser(((BString)cx.getFacet("username")).getString()) : null;
            }
            return user;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Cannot find user from context", e);
            }
            return null;
        }
    }

    public static Type getWebProfileFromContext(BWidget owner, Context cx) {
        BUser user = WbUtil.getUserFromContext(owner, cx);
        if (user == null) {
            return null;
        }
        try {
            user.lease();
            BWebProfileConfig config = (BWebProfileConfig)user.getMixIn(BWebProfileConfig.TYPE);
            if (config == null) {
                return null;
            }
            config.lease();
            Type profileType = config.getTypeSpec().getResolvedType();
            return profileType;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Cannot find web profile from context", e);
            }
            return null;
        }
    }

    public static BISession findSession(BWbEditor editor) {
        BISession session = editor.getCurrentValueSession();
        if (session == null) {
            session = WbUtil.findSession((BComplex)editor);
        }
        return session;
    }

    public static BISession findSession(BComplex complex) {
        BLocalHost session = null;
        BWbShell shell = BrowserUtil.findWbShell(complex);
        if (shell != null) {
            for (OrdTarget target = shell.getActiveOrdTarget(); target != null; target = target.getBaseOrdTarget()) {
                BComponent component;
                session = BOrd.toSession((BObject)target.get());
                if (session == null && (component = target.getComponent()) != null) {
                    session = component.getSession();
                }
                if (session == null) continue;
                return session;
            }
        }
        if (session == null) {
            session = BLocalHost.INSTANCE;
        }
        return session;
    }

    public static Binder getBinder(BComplex widget) {
        if (widget == null) {
            return null;
        }
        Binder binder = (Binder)widget.fw(302);
        if (binder != null) {
            return binder;
        }
        return WbUtil.getBinder(widget.getParent());
    }

    public static OrdTarget getBaseOrdTargetForType(OrdTarget target, Type type) {
        while (target != null) {
            if (target.get() != null && target.get().getType().is(type)) {
                return target;
            }
            if (target.getSlotInComponent() instanceof Action && target.getComponent() != null && target.getComponent().getType().is(type)) {
                return target;
            }
            target = target.getBaseOrdTarget();
        }
        return null;
    }

    public static BWidget makeErrorPane(BWidget owner, String msg, BOrd ord, Throwable e) {
        BWbShell shell = null;
        Object errorDisplay = null;
        BWbProfile profile = null;
        if (owner != null && owner.getShell() instanceof BWbShell) {
            shell = (BWbShell)owner.getShell();
        }
        if (shell != null) {
            profile = shell.getProfile();
            if (profile != null) {
                errorDisplay = profile.makeErrorDisplay(shell, msg, ord, e);
            }
            if (errorDisplay == null) {
                errorDisplay = new BErrorPanel(shell, "", msg, ord, e);
            }
            return errorDisplay;
        }
        return new BLabel(msg);
    }

    public static String getBestViewId(BObject object, String viewId, BWidget owner, Context cx, String ... fallbackViewIds) {
        Type viewType;
        AgentList list = null;
        if (owner != null) {
            list = WbSys.getFilteredViewList(owner, object, agent -> true);
        } else {
            BObject profile;
            list = object.getAgents(cx);
            Type type = WbUtil.getWebProfileFromContext(owner, cx);
            if (type != null && (profile = type.getInstance()) instanceof BIWebProfile) {
                WebUtil.ProfileFilter filter = new WebUtil.ProfileFilter((BIWebProfile)profile, object);
                list = list.filter((AgentFilter)filter);
            }
        }
        AgentInfo info = list.get(viewId);
        if (info != null) {
            return info.getAgentId();
        }
        try {
            viewType = BTypeSpec.make((String)viewId).getResolvedType();
        }
        catch (Exception e) {
            log.log(Level.FINE, "Cannot find viewId:" + viewId, e);
            if (fallbackViewIds.length == 0) {
                return "";
            }
            return WbUtil.getBestViewId(object, fallbackViewIds[0], owner, cx, Arrays.copyOfRange(fallbackViewIds, 1, fallbackViewIds.length));
        }
        while (!(!viewType.is(BIJavaScript.TYPE) && !viewType.is(BWbView.TYPE) || viewType.equals(BWbView.TYPE) || viewType.equals(BWbComponentView.TYPE) || viewType.equals(BIJavaScript.TYPE))) {
            info = list.get(viewType.getTypeInfo().toString());
            if (info != null) {
                return info.getAgentId();
            }
            AgentList filteredList = list.filter(AgentFilter.is((Type)viewType));
            if (filteredList.size() > 0) {
                return filteredList.getDefault().getAgentId();
            }
            viewType = viewType.getSuperType();
        }
        if (fallbackViewIds.length == 0) {
            return "";
        }
        return WbUtil.getBestViewId(object, fallbackViewIds[0], owner, cx, Arrays.copyOfRange(fallbackViewIds, 1, fallbackViewIds.length));
    }

    public static BWbProfile getProfileFromWidget(BWidget widget) {
        BWbProfile profile = null;
        BWidgetShell shell = widget.getShell();
        if (shell instanceof BWbShell) {
            profile = ((BWbShell)shell).getProfile();
        }
        if (profile == null) {
            try {
                profile = BWbProfile.make(null, WbMain.defaultProfileType);
            }
            catch (Exception e) {
                profile = (BWbProfile)WbMain.defaultProfileType.getInstance();
            }
        }
        return profile;
    }

    static class BatchReplaceRenderer
    extends TableCellRenderer {
        BatchReplaceRenderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell c) {
            return this.getForeground(c);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell c) {
            return this.getBackground(c);
        }
    }

    static class BatchReplaceController
    extends TableController {
        BatchReplaceController() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    public static class BatchReplace
    extends TableModel
    implements BFindPane.Listener {
        BWidget owner;
        BFindPane find;
        BTable table;
        String[] oldNames;
        String[] newNames;
        String lexOld = UiLexicon.bajaui().getText("old");
        String lexNew = UiLexicon.bajaui().getText("new");

        public BatchReplace(BWidget owner, String[] oldNames) {
            this.owner = owner;
            this.oldNames = oldNames;
            this.newNames = (String[])oldNames.clone();
            this.find = new BFindPane(owner, true, true, (BFindPane.Listener)this);
            this.table = new BTable((TableModel)this, (TableController)new BatchReplaceController());
            this.table.setCellRenderer((TableCellRenderer)new BatchReplaceRenderer());
        }

        public String[] prompt(String title) {
            BEdgePane edge = new BEdgePane();
            edge.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
            edge.setBottom((BWidget)new BBorderPane((BWidget)this.find, 10.0, 0.0, 0.0, 0.0));
            BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)edge));
            pane.setMinSize(400.0, 200.0);
            pane.setMaxSize(500.0, 600.0);
            int r = BDialog.open((BWidget)this.owner, (String)title, (Object)pane, (int)3);
            if (r != 1) {
                return null;
            }
            this.find.save();
            return this.newNames;
        }

        public void findPatternModified(FindPattern pattern, String replace) {
            for (int i = 0; i < this.newNames.length; ++i) {
                this.newNames[i] = pattern.replace(this.oldNames[i], replace);
            }
            this.updateTable();
        }

        public int getRowCount() {
            return this.oldNames.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return col == 0 ? this.lexOld : this.lexNew;
        }

        public Object getValueAt(int row, int col) {
            return col == 0 ? this.oldNames[row] : this.newNames[row];
        }
    }
}

