/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.nre.security.UserLoginEntry;
import com.tridium.nre.security.UserLoginHistory;
import com.tridium.ui.util.LayoutUtil;
import com.tridium.workbench.util.BSessionInfoDialog;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BUserLoginHistoryDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BUserLoginHistoryDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUserLoginHistoryDialog.class);
    private static final Lexicon LEX = Lexicon.make((String)"workbench");
    private static final Lexicon BAJA_LEX = Lexicon.make((String)"baja");
    private static final String MESSAGES_PANE = "messagesPane";
    private static final String PREVIOUS_LOGIN_PANE = "previousLoginPane";
    private static final String PREVIOUS_LOGIN_MESSAGE_PANE = "previousLoginMessage";
    private static final String CONNECTED_AS_PANE = "connectAsPane";
    private static final String MESSAGES_ROW_ICON = "icon";
    private static final String MESSAGES_ROW_CONTENT = "content";
    private static final String NO_LOGIN_HISTORY_MESSAGE = "noLoginHistoryMessage";
    private static final BIcon LOGIN_HISTORY_ICON = BIcon.make((String)BAJA_LEX.getText("session.info.login.history.icon"));
    private UserLoginHistory userLoginHistory;
    protected BButton okButton;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUserLoginHistoryDialog() {
        throw new UnsupportedOperationException();
    }

    public BUserLoginHistoryDialog(BWindow owner) {
        super((BWidget)owner, "", true, (BWidget)new BNullWidget());
    }

    public void show(UserLoginHistory userLoginHistory) {
        if (userLoginHistory != null && userLoginHistory.getUserName() != null) {
            this.showConfig(userLoginHistory);
            this.open();
        }
    }

    private void showConfig(UserLoginHistory userLoginHistory) {
        this.userLoginHistory = userLoginHistory;
        this.setTitle(LEX.getText("userLoginHistoryDialog.title", new Object[]{userLoginHistory.getUserName()}));
        this.setModal(true);
        this.setContent(this.buildContent());
        this.setBoundsCenteredOnOwner();
        this.setDefaultButton(this.okButton);
    }

    private BWidget buildContent() {
        BEdgePane edgePane = new BEdgePane();
        edgePane.setCenter(this.buildBody());
        edgePane.setBottom(this.buildButtons());
        return new BBorderPane((BWidget)edgePane, 7.0, 7.0, 7.0, 7.0);
    }

    private BWidget buildBody() {
        BEdgePane edgePane = new BEdgePane();
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setHalign(BHalign.fill);
        grid.setColumnAlign(BHalign.fill);
        if (this.userLoginHistory.getLoginHistory().isEmpty()) {
            String noLoginHistoryMessage = LEX.getText("userLoginHistoryDialog.noHistory", new Object[]{this.userLoginHistory.getUserName()});
            grid.add(NO_LOGIN_HISTORY_MESSAGE, (BValue)BUserLoginHistoryDialog.wordWrappedLabel(noLoginHistoryMessage, BHalign.center, 400.0));
            edgePane.setCenter((BWidget)grid);
        } else {
            BGridPane messagesPane = new BGridPane(1);
            messagesPane.setHalign(BHalign.fill);
            if (this.userLoginHistory.getPreviousLoginEntry() != null) {
                BGridPane previousLoginPane = new BGridPane(1);
                previousLoginPane.setColumnGap(10.0);
                previousLoginPane.setStretchColumn(0);
                previousLoginPane.setHalign(BHalign.fill);
                previousLoginPane.add(PREVIOUS_LOGIN_MESSAGE_PANE, (BValue)BUserLoginHistoryDialog.wordWrappedLabel(BUserLoginHistoryDialog.getPreviousLoginMessage(this.userLoginHistory), BHalign.left, 400.0));
                messagesPane.add(PREVIOUS_LOGIN_PANE, (BValue)previousLoginPane);
            }
            if (this.getOwner() instanceof BSessionInfoDialog) {
                String connectedAsMessage = BAJA_LEX.getText("session.info.connectedAs", new Object[]{this.userLoginHistory.getUserName()});
                messagesPane.add(CONNECTED_AS_PANE, (BValue)BUserLoginHistoryDialog.wordWrappedLabel(connectedAsMessage, BHalign.left, 400.0));
            }
            if (messagesPane.get(PREVIOUS_LOGIN_PANE) != null || messagesPane.get(CONNECTED_AS_PANE) != null) {
                grid.add(MESSAGES_PANE, (BValue)new BBorderPane(BUserLoginHistoryDialog.buildMessagesRow(BImage.make((BIcon)LOGIN_HISTORY_ICON), (BWidget)messagesPane), 0.0, 0.0, 0.0, 5.0));
            }
            grid.add(null, (BValue)new BSeparator());
            DefaultTableModel tableModel = new DefaultTableModel(new String[]{LEX.getText("userLoginHistoryDialog.history.time"), LEX.getText("userLoginHistoryDialog.history.location"), LEX.getText("userLoginHistoryDialog.history.success"), LEX.getText("userLoginHistoryDialog.history.secure"), LEX.getText("userLoginHistoryDialog.history.client")});
            for (int i = this.userLoginHistory.getLoginHistory().size() - 1; i >= 0; --i) {
                BFacets facets = BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE);
                facets = BFacets.make((BFacets)facets, (String)"showTime", (BIDataValue)BBoolean.TRUE);
                facets = BFacets.make((BFacets)facets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
                facets = BFacets.make((BFacets)facets, (String)"showTimeZone", (BIDataValue)BBoolean.TRUE);
                tableModel.addRow(new Object[]{BAbsTime.make((long)((UserLoginEntry)this.userLoginHistory.getLoginHistory().get(i)).getTimestamp().getTime()).toString((Context)facets), ((UserLoginEntry)this.userLoginHistory.getLoginHistory().get(i)).getLocation(), ((UserLoginEntry)this.userLoginHistory.getLoginHistory().get(i)).getSuccess(), ((UserLoginEntry)this.userLoginHistory.getLoginHistory().get(i)).getSecure(), BUserLoginHistoryDialog.getFriendlyClientName((UserLoginEntry)this.userLoginHistory.getLoginHistory().get(i))});
            }
            BTable historyTable = new BTable((TableModel)tableModel);
            historyTable.setHscrollBarVisible(false);
            historyTable.setVscrollBarVisible(false);
            BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)historyTable);
            constrainedPane.setMinHeight(150.0);
            constrainedPane.setMinWidth(300.0);
            edgePane.setCenter((BWidget)new BScrollPane((BWidget)constrainedPane));
            edgePane.setTop((BWidget)grid);
        }
        return edgePane;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        LayoutUtil.setPreferredSizeForPotentialScrollBars((BWidget)this, (boolean)true, (boolean)false);
        double preferredWidth = this.getPreferredWidth() + 5.0;
        double preferredHeight = this.getPreferredHeight();
        if (this.getPreferredHeight() > 450.0) {
            preferredHeight = 450.0;
        }
        this.setPreferredSize(preferredWidth, preferredHeight);
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(1);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    private static BLabel wordWrappedLabel(String text, BHalign align, double width) {
        BLabel label = new BLabel(text, align);
        label.setWordWrapEnabled(true, width);
        return label;
    }

    private static BWidget buildMessagesRow(BImage icon, BWidget msg) {
        BGridPane row = new BGridPane(2);
        row.setRowGap(10.0);
        row.setColumnGap(10.0);
        row.setColumnAlign(BHalign.fill);
        row.setHalign(BHalign.fill);
        row.setStretchColumn(1);
        row.add(MESSAGES_ROW_ICON, (BValue)new BLabel(icon));
        row.add(MESSAGES_ROW_CONTENT, (BValue)msg);
        return row;
    }

    private static String getPreviousLoginMessage(UserLoginHistory userLoginHistory) {
        UserLoginEntry previousLoginEntry = userLoginHistory.getPreviousLoginEntry();
        if (previousLoginEntry != null) {
            return BAJA_LEX.getText("session.info.previousLogin", new Object[]{BAbsTime.make((long)previousLoginEntry.getTimestamp().getTime()), previousLoginEntry.getLocation(), BUserLoginHistoryDialog.getFriendlyClientName(previousLoginEntry)});
        }
        return null;
    }

    private static String getFriendlyClientName(UserLoginEntry loginHistoryEntry) {
        String friendlyClient = loginHistoryEntry.getFriendlyClient();
        if (friendlyClient == null || friendlyClient.isEmpty() || friendlyClient.equals("UNKNOWN_PRODUCT")) {
            friendlyClient = BAJA_LEX.get("session.info.unknown.client");
        }
        return friendlyClient;
    }
}

