/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.util.BSessionInfo;
import com.tridium.workbench.util.BUserLoginHistoryDialog;
import javax.baja.agent.BIAgent;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"baja:SessionInfo"})})
@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BSessionInfoDialog
extends BDialog
implements BIAgent {
    @Generated
    public static final Action okButtonPressed = BSessionInfoDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSessionInfoDialog.class);
    private static final Lexicon lex = Lexicon.make((String)"workbench");
    protected BButton okButton;
    protected BSessionInfo info;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSessionInfoDialog() {
    }

    public BSessionInfoDialog(BWidget owner) {
        super(owner, "", true, (BWidget)new BNullWidget());
    }

    public void show(BWidget owner, BSessionInfo info) {
        BSessionInfoDialog dialog = new BSessionInfoDialog(owner);
        dialog.show(info);
    }

    public void show(BSessionInfo info) {
        this.info = info;
        this.setTitle(lex.getText("sessionInfoDialog.title", new Object[]{info.getHostname()}));
        this.setModal(true);
        this.setContent(this.buildDialog());
        this.setBoundsCenteredOnOwner();
        this.setResizable(false);
        this.setDefaultButton(this.okButton);
        this.open();
    }

    private BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    private BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 7.0, 7.0, 7.0, 7.0);
    }

    public BWidget buildRow(BImage icon, BWidget msg) {
        BGridPane row = new BGridPane(2);
        row.setRowGap(10.0);
        row.setColumnGap(10.0);
        row.setColumnAlign(BHalign.fill);
        row.setHalign(BHalign.fill);
        row.setStretchColumn(1);
        row.add(null, (BValue)new BLabel(icon));
        row.add(null, (BValue)msg);
        return row;
    }

    public BWidget wordWrappedLabel(String text, BHalign align, double width) {
        BLabel label = new BLabel(text, align);
        label.setWordWrapEnabled(true, width);
        return label;
    }

    protected BWidget buildBody() {
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setHalign(BHalign.fill);
        grid.setColumnAlign(BHalign.fill);
        String userName = this.info.getUsername();
        if (userName != null) {
            grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getConnectedAsIcon()), this.wordWrappedLabel(this.info.getConnectedAsMessage(userName), BHalign.left, 250.0)));
            grid.add(null, (BValue)new BSeparator());
        }
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getHostnameIcon()), this.wordWrappedLabel(this.info.getHostnameMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getIdentityVerifiedIcon()), this.wordWrappedLabel(this.info.getIdentityVerifiedMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getSessionEncryptedIcon()), this.wordWrappedLabel(this.info.getSessionEncryptedMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        if (this.info.isFips()) {
            grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getFipsIcon()), this.wordWrappedLabel(this.info.getFipsMessage(), BHalign.left, 250.0)));
            grid.add(null, (BValue)new BSeparator());
        }
        grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getLastConnectedIcon()), this.wordWrappedLabel(this.info.getLastConnectedMessage(), BHalign.left, 250.0)));
        grid.add(null, (BValue)new BSeparator());
        if (this.info.getUserLoginHistory() != null) {
            BEdgePane edge = new BEdgePane();
            if (userName != null && this.info.getPreviousLoginMessage() != null) {
                edge.setCenter(this.wordWrappedLabel(this.info.getPreviousLoginMessage(), BHalign.left, 300.0));
                BButton link = new BButton((Command)new HistoryCmd());
                link.setButtonStyle(BButtonStyle.hyperlink);
                link.setHalign(BHalign.left);
                edge.setBottom((BWidget)link);
            } else {
                edge.setCenter(this.wordWrappedLabel(this.info.getFirstLoginMessage(), BHalign.left, 300.0));
            }
            grid.add(null, (BValue)this.buildRow(BImage.make((BIcon)this.info.getLoginHistoryIcon()), (BWidget)edge));
            grid.add(null, (BValue)new BSeparator());
        }
        return grid;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(1);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    protected class HistoryCmd
    extends Command {
        public HistoryCmd() {
            super((BWidget)BSessionInfoDialog.this, lex, "sessionInfoDialog.historyCmd");
        }

        public CommandArtifact doInvoke() {
            BUserLoginHistoryDialog userLoginHistoryDialog = new BUserLoginHistoryDialog((BWindow)BSessionInfoDialog.this);
            userLoginHistoryDialog.show(BSessionInfoDialog.this.info.getUserLoginHistory());
            return null;
        }
    }
}

