/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.util.TagUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BRelatePad
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BRelatePad.class);
    private static Context context = new BasicContext();
    private static BImage actionIcon = BImage.make((String)"module://icons/x16/action.png");
    private static BImage topicIcon = BImage.make((String)"module://icons/x16/topic.png");
    private static BImage objectIcon = BImage.make((String)"module://icons/x16/object.png");
    private static final Lexicon lex = Lexicon.make(BRelatePad.class);
    BWidget owner;
    boolean editOnly = false;
    BComponent relationMark;
    private IComponent source;
    private IComponent target;
    private TagDictionaryService service;
    private BWbFieldEditor relationEditor;
    private BRelation relation;
    private String relationId;
    private BDynamicEnum relateIdEnum;
    RelationInfo[] list;
    int results = 1;
    RelationSubscriber subscriber;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean openInDialog(BWidget owner) {
        this.owner = owner;
        String title = UiLexicon.bajaui().getText("relating.title");
        BOptionDialog dlg = new BOptionDialog(owner, title, (BWidget)this, 3, null, null);
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        this.results = dlg.getResult();
        if (this.results == 2) {
            return false;
        }
        try {
            this.relationEditor.saveValue();
            this.relationId = SlotPath.unescape((String)((BEnum)this.relationEditor.getCurrentValue()).getTag());
        }
        catch (Exception e) {
            BDialog.error((BWidget)owner, (Object)("Execption: " + e.getLocalizedMessage()));
            return false;
        }
        return true;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public BRelatePad() {
        throw new IllegalStateException();
    }

    public BRelatePad(BWidget shell, BRelation relation) {
        this.owner = shell;
        this.relation = relation;
        this.editOnly = true;
        this.build();
    }

    public BRelatePad(BComponent[] sources, BComponent[] targets) {
        this.source = sources.length == 1 ? new SingleComponent(sources[0]) : new MultiComponent(sources);
        this.target = targets.length == 1 ? new SingleComponent(targets[0]) : new MultiComponent(targets);
        this.build();
    }

    public void build() {
        this.getRelationInfos();
        this.relateIdEnum = this.initRelationEnum();
        this.relationEditor = new BFrozenEnumFE();
        this.relationEditor.loadValue((BObject)this.relateIdEnum);
        this.setCenter(this.relationEditor);
    }

    private BDynamicEnum initRelationEnum() {
        try {
            BEnumRange idRange = BEnumRange.make((String[])this.getRelationIds());
            return BDynamicEnum.make((int)0, (BEnumRange)idRange);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] getRelationIds() {
        if (this.list == null || this.list.length == 0) {
            return new String[0];
        }
        String[] ids = new String[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            ids[i] = SlotPath.escape((String)this.list[i].getRelationId().getQName());
        }
        return ids;
    }

    private RelationInfo[] getRelationInfos() {
        RelationInfo relInfo;
        Iterator relInfos;
        Array relList;
        if (this.list != null) {
            return this.list;
        }
        Collection dictionaries = null;
        TagDictionaryService tdService = null;
        try {
            tdService = this.getTagDictionaryService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tdService != null) {
            dictionaries = tdService.getTagDictionaries();
            if (dictionaries.size() != 0) {
                relList = new Array(RelationInfo.class);
                for (TagDictionary tagDictionary : tdService.getTagDictionaries()) {
                    relInfos = tagDictionary.getRelations();
                    while (relInfos.hasNext()) {
                        relInfo = (RelationInfo)relInfos.next();
                        relList.add((Object)relInfo);
                    }
                }
            }
        } else {
            dictionaries = TagUtil.makeTagDictionaryService().getTagDictionaries();
        }
        if (dictionaries != null && dictionaries.size() != 0) {
            relList = new Array(RelationInfo.class);
            for (TagDictionary tagDictionary : dictionaries) {
                relInfos = tagDictionary.getRelations();
                while (relInfos.hasNext()) {
                    relInfo = (RelationInfo)relInfos.next();
                    relList.add((Object)relInfo);
                }
            }
        } else {
            throw new RuntimeException(lex.getText("relateCommand.noTagService.error.message"));
        }
        this.list = (RelationInfo[])relList.trim();
        return this.list;
    }

    public TagDictionaryService getTagDictionaryService() {
        if (this.service != null) {
            ((BComponent)this.service).lease(Integer.MAX_VALUE);
            return this.service;
        }
        try {
            BComponent base = null;
            base = this.editOnly ? this.relation.getRelationComponent() : this.target.getComponents()[0];
            this.service = base.getTagDictionaryService();
            ((BComponent)this.service).lease(Integer.MAX_VALUE);
            return this.service;
        }
        catch (UnresolvedException ex) {
            return null;
        }
    }

    private static BImage getIcon(BComponent comp, String slotName) {
        BImage icon;
        BImage bImage;
        Slot slot = comp.getSlot(slotName);
        if (slot.isAction()) {
            bImage = actionIcon;
        }
        if (slot.isTopic()) {
            bImage = topicIcon;
        }
        try {
            BValue val = comp.get((Property)slot);
            icon = BImage.make((BIcon)val.getIcon());
        }
        catch (Exception e) {
            icon = objectIcon;
        }
        return icon;
    }

    private static boolean isValidSlotRow(BComponent comp, String slotName) {
        Slot slot = comp.getSlot(slotName);
        if (Flags.isHidden((BComplex)comp, (Slot)slot)) {
            return false;
        }
        if (slot.isProperty()) {
            BValue v = comp.get(slot.asProperty());
            if (v.isComponent() && !(v instanceof BVector)) {
                return false;
            }
            if (v instanceof BLink) {
                return false;
            }
            return !(v instanceof BWsAnnotation);
        }
        return true;
    }

    private static LinkCheck checkLink(BComponent[] sourceComps, BComponent[] targetComps, String sourceSlotName, String targetSlotName) {
        for (int i = 0; i < targetComps.length; ++i) {
            Slot targetSlot = targetComps[i].getSlot(targetSlotName);
            for (int j = 0; j < sourceComps.length; ++j) {
                Slot sourceSlot = sourceComps[j].getSlot(sourceSlotName);
                LinkCheck chk = targetComps[i].checkLink(sourceComps[j], sourceSlot, targetSlot, context);
                if (!chk.isValid()) {
                    return chk;
                }
                if (j <= 0 || targetSlot.isAction() || targetSlot.isTopic() || !targetSlot.isProperty() || Flags.isFanIn((BComplex)targetComps[i], (Slot)targetSlot)) continue;
                return LinkCheck.makeInvalid((String)lex.getText("linkpad.propNoFanIn"));
            }
        }
        return LinkCheck.makeValid();
    }

    public BComponent[] getSourceArray() {
        return this.source.getComponents();
    }

    public BComponent[] getTargetArray() {
        return this.target.getComponents();
    }

    private static class SlotInfo {
        String slotName;
        boolean isProperty;
        boolean isAction;

        SlotInfo(Slot slot) {
            this.slotName = slot.getName();
            this.isProperty = slot.isProperty();
            this.isAction = slot.isAction();
        }

        boolean isValidMatch(Slot slot) {
            return this.slotName.equals(slot.getName()) && this.isProperty == slot.isProperty() && this.isAction == slot.isAction();
        }
    }

    private static class MultiComponent
    implements IComponent {
        private SlotInfo[] slotInfos;
        private BComponent[] comps;

        MultiComponent(BComponent[] comps) {
            this.comps = comps;
            Array slotInfoArray = new Array(SlotInfo.class);
            for (int i = 0; i < comps.length; ++i) {
                if (i == 0) {
                    Slot[] slots = comps[i].getSlotsArray();
                    for (int j = 0; j < slots.length; ++j) {
                        if (Flags.isHidden((BComplex)comps[i], (Slot)slots[j])) continue;
                        slotInfoArray.add((Object)new SlotInfo(slots[j]));
                    }
                    continue;
                }
                Array a = slotInfoArray.copy();
                for (SlotInfo inf : a) {
                    boolean valid = false;
                    Slot[] slots = comps[i].getSlotsArray();
                    for (int j = 0; j < slots.length; ++j) {
                        if (!inf.isValidMatch(slots[j])) continue;
                        valid = true;
                        break;
                    }
                    if (valid) continue;
                    slotInfoArray.remove((Object)inf);
                }
            }
            this.slotInfos = (SlotInfo[])slotInfoArray.trim();
        }

        @Override
        public String getName() {
            StringBuilder buff = new StringBuilder();
            buff.append(this.comps[0].getName());
            buff.append(" (");
            buff.append(this.comps.length);
            buff.append(")");
            return buff.toString();
        }

        @Override
        public String getDisplayName() {
            StringBuilder buff = new StringBuilder();
            buff.append(this.comps[0].getDisplayName(null));
            buff.append(" (");
            buff.append(this.comps.length);
            buff.append(")...");
            return buff.toString();
        }

        public String getDisplayName(Slot slot) {
            return this.comps[0].getDisplayName(this.comps[0].getSlot(slot.getName()), null);
        }

        @Override
        public LinkCheck checkLink(IComponent source, String sourceSlotName, String targetSlotName) {
            return BRelatePad.checkLink(source.getComponents(), this.comps, sourceSlotName, targetSlotName);
        }

        @Override
        public Slot getDefaultSlot(String slotName) {
            return this.comps[0].getSlot(slotName);
        }

        @Override
        public String getDisplayName(String slotName) {
            Slot slot = this.comps[0].getSlot(slotName);
            return this.comps[0].getDisplayName(slot, null);
        }

        @Override
        public BImage getIcon(String slotName) {
            return BRelatePad.getIcon(this.comps[0], slotName);
        }

        @Override
        public String[] getSlotNamesArray() {
            String[] slotStrs = new String[this.slotInfos.length];
            for (int i = 0; i < this.slotInfos.length; ++i) {
                slotStrs[i] = this.slotInfos[i].slotName;
            }
            return slotStrs;
        }

        @Override
        public boolean isValidSlotRow(String slotName) {
            for (int i = 0; i < this.comps.length; ++i) {
                if (BRelatePad.isValidSlotRow(this.comps[i], slotName)) continue;
                return false;
            }
            return true;
        }

        @Override
        public BComponent[] getComponents() {
            return this.comps;
        }
    }

    private static class SingleComponent
    implements IComponent {
        BComponent comp;

        SingleComponent(BComponent comp) {
            this.comp = comp;
        }

        @Override
        public String getName() {
            return this.comp.getName();
        }

        @Override
        public String getDisplayName() {
            return this.comp.getDisplayName(null);
        }

        @Override
        public String getDisplayName(String slotName) {
            Slot slot = this.comp.getSlot(slotName);
            return this.comp.getDisplayName(slot, null);
        }

        @Override
        public String[] getSlotNamesArray() {
            Slot[] slots = this.comp.getSlotsArray();
            String[] slotNames = new String[slots.length];
            for (int i = 0; i < slotNames.length; ++i) {
                slotNames[i] = slots[i].getName();
            }
            return slotNames;
        }

        @Override
        public LinkCheck checkLink(IComponent source, String sourceSlotName, String targetSlotName) {
            return BRelatePad.checkLink(source.getComponents(), this.getComponents(), sourceSlotName, targetSlotName);
        }

        @Override
        public BComponent[] getComponents() {
            return new BComponent[]{this.comp};
        }

        @Override
        public boolean isValidSlotRow(String slotName) {
            return BRelatePad.isValidSlotRow(this.comp, slotName);
        }

        @Override
        public BImage getIcon(String slotName) {
            return BRelatePad.getIcon(this.comp, slotName);
        }

        @Override
        public Slot getDefaultSlot(String slotName) {
            return this.comp.getSlot(slotName);
        }
    }

    private static interface IComponent {
        public String getName();

        public String getDisplayName();

        public String getDisplayName(String var1);

        public String[] getSlotNamesArray();

        public LinkCheck checkLink(IComponent var1, String var2, String var3);

        public BComponent[] getComponents();

        public boolean isValidSlotRow(String var1);

        public BImage getIcon(String var1);

        public Slot getDefaultSlot(String var1);
    }

    private class RelationSubscriber
    extends Subscriber {
        RelationSubscriber() {
        }

        public void event(BComponentEvent event) {
            switch (event.getId()) {
                case 1: {
                    Slot slot = event.getSlot();
                    BComponent c = event.getSourceComponent();
                    BValue bValue = c.get(slot.asProperty());
                    if (!(bValue instanceof BRelation)) break;
                    ((BRelation)bValue).activateRelation();
                    break;
                }
                case 2: {
                    Slot slot = event.getSlot();
                    BComponent c = event.getSourceComponent();
                    BValue bValue = c.get(slot.asProperty());
                    if (!(bValue instanceof BRelation)) break;
                    System.out.println("relation removed: " + bValue);
                    ((BRelation)bValue).deactivateRelation();
                }
            }
        }
    }
}

