/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.workbench.util.BEditTagDialog;
import com.tridium.workbench.util.BRelateTagsPad;
import com.tridium.workbench.util.TagUtil;
import java.util.Iterator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tag.Tags;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTagDictionary;

@NiagaraType
public class BEditTagManager
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BEditTagManager.class);
    BComponent target;
    BWidget owner;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEditTagManager(BWidget owner, BComponent target) {
        this.owner = owner;
        this.target = target;
        this.doLoadValue((BObject)target, null);
    }

    @Override
    public MgrModel makeModel() {
        return new TagMgrModel(this);
    }

    @Override
    public MgrController makeController() {
        return new TagMgrController(this);
    }

    @Override
    protected MgrTagDictionary makeTagDictionary() {
        MgrTagDictionary mgrTagDictionary = super.makeTagDictionary();
        if (mgrTagDictionary != null) {
            return mgrTagDictionary;
        }
        return new MgrNoServiceTagDictionary(this);
    }

    public boolean isExisting(Object tagInfo) {
        Id tagId = null;
        Tags tags = this.target.tags();
        Tags editDialogImpliedTags = null;
        boolean isEditTagDialog = this.owner.getType().is(BEditTagDialog.TYPE);
        if (!isEditTagDialog) {
            if (tagInfo instanceof TagInfo) {
                tagId = ((TagInfo)tagInfo).getTagId();
                return tags.contains(tagId);
            }
            if (tagInfo instanceof TagGroupInfo) {
                return this.checkTagGroup((TagGroupInfo)tagInfo, tags);
            }
            return false;
        }
        BEditTagDialog editTagDialog = (BEditTagDialog)this.owner;
        tags = editTagDialog.directTags.tags();
        if (editTagDialog.impliedTags != null) {
            editDialogImpliedTags = editTagDialog.impliedTags.tags();
        }
        if (tagInfo instanceof TagInfo) {
            tagId = ((TagInfo)tagInfo).getTagId();
            if (editDialogImpliedTags != null) {
                return tags.contains(tagId) || editDialogImpliedTags.contains(tagId);
            }
            return tags.contains(tagId);
        }
        if (tagInfo instanceof TagGroupInfo) {
            return this.checkTagGroup((TagGroupInfo)tagInfo, editDialogImpliedTags);
        }
        return false;
    }

    private boolean checkTagGroup(TagGroupInfo tagGroup, Tags tags) {
        TagInfo nextTagInfo;
        if (tags == null) {
            return false;
        }
        boolean existInAll = true;
        Iterator tgiTags = tagGroup.getTags();
        while (tgiTags.hasNext() && (existInAll = tags.contains((nextTagInfo = (TagInfo)tgiTags.next()).getTagId()))) {
        }
        return existInAll;
    }

    private class TagMgrController
    extends MgrController {
        public TagMgrController(BAbstractManager manager) {
            super(manager);
        }

        @Override
        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[0];
        }

        @Override
        protected MgrController.IMgrCommand[] makeTagCommands() {
            return new MgrController.IMgrCommand[0];
        }

        @Override
        public void tagSelectionChanged() {
            BTreeTable table = this.getManager().getMgrTagDictionary().getTable();
            TableSelection selection = table.getSelection();
            int[] rows = selection.getRows();
            for (int i = 0; i < rows.length; ++i) {
                Object obj = table.getModel().getSubject(rows[i]);
                if (!(obj instanceof String) && !BEditTagManager.this.isExisting(obj)) continue;
                selection.deselect(rows[i]);
            }
            this.updateCommands();
        }

        @Override
        public void updateCommands() {
        }

        @Override
        public void cellDoubleClicked(BTreeTable table, BMouseEvent event, int row, int col) {
            if (BEditTagManager.this.owner instanceof BEditTagDialog && table.getSelection().isSelected(row)) {
                ((BEditTagDialog)BEditTagManager.this.owner).doAdd();
            }
            if (BEditTagManager.this.owner instanceof BRelateTagsPad) {
                ((BRelateTagsPad)BEditTagManager.this.owner).doAdd();
            }
        }
    }

    private class TagMgrModel
    extends MgrModel {
        public TagMgrModel(BAbstractManager manager) {
            super(manager);
        }

        @Override
        public Type getBaseNewType() {
            return this.getManager().getTarget().getType();
        }
    }

    public class MgrNoServiceTagDictionary
    extends MgrTagDictionary {
        public MgrNoServiceTagDictionary(BAbstractManager manager) {
            super(manager);
        }

        @Override
        public TagDictionaryService getTagDictionaryService() {
            return TagUtil.makeTagDictionaryService();
        }
    }
}

