/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BWbPane;
import com.tridium.workbench.shell.WbCommands;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.BDouble;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.BWbProfile;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class WbState {
    static HashMap<Type, WbState> byProfile = new HashMap();
    static BRectGeom defBounds = BRectGeom.make((double)50.0, (double)50.0, (double)800.0, (double)600.0);
    final Type profile;
    final File file;
    BRectGeom bounds = defBounds;
    boolean maximized = false;
    double hsplitPos = 25.0;
    String sideBarPickle = "";
    boolean showSideBar = true;
    boolean showConsole = false;
    boolean pathBarUsesNavFile = true;

    public static WbState get(BWbProfile profile) {
        Type type = profile.getType();
        WbState state = byProfile.get(type);
        if (state == null) {
            state = new WbState(type);
            if (state.file.exists()) {
                state.loadFromFile();
            } else {
                state.loadFromProfile(profile);
            }
            byProfile.put(type, state);
        }
        return state;
    }

    public static void load(BNiagaraWbFrame shell) {
        WbState state = WbState.get(shell.getProfile());
        state.loadToShell(shell);
    }

    public static void save(BNiagaraWbFrame shell) {
        WbState state = WbState.get(shell.getProfile());
        state.saveFromShell(shell);
        state.saveToFile();
    }

    public WbState(Type profile) {
        this.profile = profile;
        this.file = new File(Sys.getNiagaraUserHome(), "etc" + File.separator + "wb-" + profile.getTypeName() + ".xml");
    }

    public void loadFromProfile(BWbProfile profile) {
        if (profile.hasSideBar()) {
            BSideBarPane sideBar = new BSideBarPane();
            sideBar.initFromProfile(profile);
            this.sideBarPickle = sideBar.pickle();
        }
    }

    public void loadToShell(BNiagaraWbFrame shell) {
        BWbPane pane = shell.pane;
        WbCommands commands = shell.commands;
        if (!this.maximized) {
            shell.frame.setBounds((int)this.bounds.x, (int)this.bounds.y, (int)this.bounds.width, (int)this.bounds.height);
        } else {
            ((AwtUiEnv)AwtUiEnv.get()).setMaximized((Frame)((Object)shell.frame), true);
            IRectGeom bounds = ((AwtUiEnv)AwtUiEnv.get()).getDefaultScreenBounds();
            shell.frame.setBounds((int)(bounds.width() * 0.125), (int)(bounds.height() * 0.125), (int)(bounds.width() * 0.75), (int)(bounds.height() * 0.75));
        }
        pane.setSplitPosition(this.hsplitPos);
        if (pane.sideBar != null) {
            pane.sideBar.unpickle(this.sideBarPickle);
        }
        commands.showSideBar.setSelected(this.showSideBar);
        commands.console.setSelected(this.showConsole);
        commands.pathBarUsesNavFile.setSelected(this.pathBarUsesNavFile);
    }

    public void saveFromShell(BNiagaraWbFrame shell) {
        Rectangle r = shell.getFrameBounds();
        BWbPane pane = shell.pane;
        WbCommands commands = shell.commands;
        this.maximized = ((AwtUiEnv)AwtUiEnv.get()).isMaximized((Frame)((Object)shell.frame));
        this.bounds = BRectGeom.make((double)r.x, (double)r.y, (double)r.width, (double)r.height);
        this.hsplitPos = pane.getSplitPosition();
        this.sideBarPickle = pane.sideBar == null ? "" : pane.sideBar.pickle();
        this.showSideBar = commands.showSideBar.isSelected();
        this.showConsole = commands.console.isSelected();
        this.pathBarUsesNavFile = commands.pathBarUsesNavFile.isSelected();
    }

    public void loadFromFile() {
        try {
            XElem root = XParser.make((File)this.file).parse();
            this.bounds = this.load(root, "bounds", this.bounds);
            this.maximized = this.load(root, "maximized", "false").equals("true");
            this.hsplitPos = this.load(root, "hsplitPos", this.hsplitPos);
            this.sideBarPickle = this.load(root, "sideBarPickle", this.sideBarPickle);
            this.showSideBar = this.load(root, "showSideBar", this.showSideBar);
            this.showConsole = this.load(root, "showConsole", this.showConsole);
            this.pathBarUsesNavFile = this.load(root, "pathBarUsesNavFile", this.pathBarUsesNavFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToFile() {
        AccessController.doPrivileged(new SaveToFilePrivilegedAction());
    }

    String load(XElem root, String name, String def) {
        XElem elem = root.elem(name);
        if (elem == null) {
            return def;
        }
        return elem.get("value", def);
    }

    boolean load(XElem root, String name, boolean def) {
        return this.load(root, name, "" + def).equals("true");
    }

    double load(XElem root, String name, double def) {
        return BDouble.decode((String)this.load(root, name, BDouble.encode((double)def)));
    }

    BRectGeom load(XElem root, String name, BRectGeom def) {
        return BRectGeom.make((String)this.load(root, name, def.encodeToString()));
    }

    void save(XWriter out, String name, Object value) {
        out.w((Object)"  <").w((Object)name).w((Object)" value='").safe(value.toString()).w((Object)"'/>\n");
    }

    private class SaveToFilePrivilegedAction
    implements PrivilegedAction<Void> {
        private SaveToFilePrivilegedAction() {
        }

        @Override
        public Void run() {
            try {
                XWriter out = new XWriter(WbState.this.file);
                out.w((Object)"<WbState version='1.0' timestamp='").safe("" + Clock.time()).w((Object)"'>\n");
                WbState.this.save(out, "profile", WbState.this.profile);
                WbState.this.save(out, "bounds", WbState.this.bounds.encodeToString());
                WbState.this.save(out, "maximized", WbState.this.maximized ? "true" : "false");
                WbState.this.save(out, "hsplitPos", BDouble.encode((double)WbState.this.hsplitPos));
                WbState.this.save(out, "sideBarPickle", WbState.this.sideBarPickle);
                WbState.this.save(out, "showSideBar", "" + WbState.this.showSideBar);
                WbState.this.save(out, "showConsole", "" + WbState.this.showConsole);
                WbState.this.save(out, "pathBarUsesNavFile", "" + WbState.this.pathBarUsesNavFile);
                out.w((Object)"</WbState>\n");
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

