/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.user.BUserChannel;
import com.tridium.ui.Binder;
import com.tridium.util.BISubstitutableOrdScheme;
import com.tridium.util.CompUtil;
import com.tridium.util.SpyUtil;
import com.tridium.workbench.nav.BFileMenuAgent;
import com.tridium.workbench.pathbar.BNavFilePA;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BPasswordResetDialog;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.NoViewRegisteredException;
import com.tridium.workbench.shell.ViewRestrictedException;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserView;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.WebWidgetUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.fox.BFoxProxySession;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.security.BPermissions;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.web.BIFormFactorMax;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BWbView;

public class NHyperlinkInfo
extends HyperlinkInfo {
    static final AgentFilter pathBarAgentFilter = AgentFilter.is((Type)BPathBarAgent.TYPE);
    static Logger log = Logger.getLogger("wb.hyperlink");
    static BPathBarAgent[] noPathBarAgents = new BPathBarAgent[0];
    private static final boolean DISABLE_HYPERLINK_ORD_SUBSTITUTION = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.hyperlink.ord.substitution.disabled"));
    BWbProfile profile;
    BOrd currentOrd;
    boolean appendToHistory;
    BICredentials credentials;
    BNiagaraWbShell shell;
    BViewTab tab;
    WbHistory.Entry historyEntry;
    BImage icon;
    OrdQuery[] queries;
    boolean hasParent;
    OrdTarget target;
    BPermissions permissions;
    AgentList viewAgents;
    AgentInfo agent;
    BWbView view;
    Context context;
    BPathBarAgent[] pathBarAgents;
    String fault;

    public static NHyperlinkInfo make(HyperlinkInfo info) {
        if (info instanceof NHyperlinkInfo) {
            return (NHyperlinkInfo)info;
        }
        return new NHyperlinkInfo(info.getOrd(), info.getMode(), true, null);
    }

    public NHyperlinkInfo(BOrd ord, BHyperlinkMode mode, boolean appendToHistory) {
        this(ord, mode, appendToHistory, null);
    }

    public NHyperlinkInfo(BOrd ord, BHyperlinkMode mode, boolean appendToHistory, BICredentials credentials) {
        super(ord, mode);
        this.appendToHistory = appendToHistory;
        this.credentials = credentials;
        if (log.isLoggable(Level.FINE)) {
            log.fine("--- NHyperlinkInfo(" + ord + ", " + mode + ", " + appendToHistory + ", " + credentials + ") ---");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hyperlink(BViewTab tab) throws Throwable {
        this.tab = tab;
        this.shell = tab.shell;
        this.profile = this.shell.profile;
        try {
            this.currentOrd = tab.ord;
            this.ord = this.normalizeOrd();
            try {
                Optional substitutableOrdScheme;
                this.target = this.resolve();
                if (!DISABLE_HYPERLINK_ORD_SUBSTITUTION && (substitutableOrdScheme = BISubstitutableOrdScheme.findSubstitutableOrdScheme((BOrd)this.ord)).isPresent()) {
                    this.ord = ((BISubstitutableOrdScheme)substitutableOrdScheme.get()).convertToSubstituteOrd(this.ord, this.target, (Context)BISubstitutableOrdScheme.SUBSTITUTE_NAV_ORD_FACET);
                }
            }
            finally {
                this.hasParent = this.hasParent();
                this.historyEntry = this.appendToHistory();
                this.queries = this.parseOrd();
            }
            this.icon = this.getIcon();
            this.permissions = this.getPermissions();
            this.viewAgents = this.getViewAgentsList();
            this.agent = this.getAgent();
            this.view = this.getView();
            this.context = this.getContext();
            this.pathBarAgents = this.makePathBarAgents();
            this.fault = this.getFault();
            this.resetTab();
            this.updateTab();
            this.updateViewTab();
            this.activateView();
            this.loadView();
            this.view = this.profile.customizeView(this.view);
            this.startBinder();
        }
        finally {
            try {
                this.updateTab();
                tab.updateShell();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void resetTab() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("resetTab: " + (Object)((Object)this.tab));
        }
        this.tab.stopView(true);
    }

    private BOrd normalizeOrd() {
        BOrd oldOrd = this.ord;
        BOrd newOrd = this.ord;
        try {
            BOrd n = this.ord;
            if (this.currentOrd != null && !this.ord.toString().contains("/module.palette")) {
                n = BOrd.make((BOrd)this.currentOrd, (BOrd)n);
            }
            newOrd = n.normalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("normalizeOrd: " + oldOrd + " -> " + newOrd);
        }
        return newOrd;
    }

    private boolean hasParent() {
        boolean hasParent = false;
        try {
            hasParent = this.ord.getParent() != null && !this.ord.toString().startsWith("workbench:/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("hasParent: " + hasParent);
        }
        return hasParent;
    }

    private WbHistory.Entry appendToHistory() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("appendToHistory");
        }
        WbHistory.Entry historyEntry = null;
        if (this.appendToHistory) {
            historyEntry = this.tab.history.append(this.ord);
            BNiagaraWbShell.history.recentAdd(historyEntry);
        } else {
            this.tab.history.recentTouch(this.ord);
            BNiagaraWbShell.history.recentTouch(this.ord);
        }
        return historyEntry;
    }

    private OrdQuery[] parseOrd() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parseOrd");
        }
        try {
            return this.ord.parse();
        }
        catch (Exception e) {
            throw new LocalizableException("bajaui", "errorPanel.invalidOrd", (Throwable)e);
        }
    }

    private OrdTarget resolve() throws Exception {
        if (!WbMain.isKioskAccessible(this.ord)) {
            throw new UnresolvedException("Local access denied in kiosk mode");
        }
        OrdTarget target = this.shell.resolve(this.ord, this.credentials);
        if (log.isLoggable(Level.FINE)) {
            log.fine("resolved: " + target.get().toDebugString());
        }
        if (target.get() instanceof BComponent) {
            BComponent comp = (BComponent)target.get();
            comp.lease();
        }
        BFoxSession s = null;
        if (target.get() instanceof BComponent && ((BComponent)target.get()).getSession() instanceof BFoxSession) {
            s = (BFoxSession)((BComponent)target.get()).getSession();
        } else if (target.get() instanceof BFoxSession) {
            s = (BFoxSession)target.get();
        } else {
            try {
                BISession session;
                BSpace space = target.getSpace();
                if (space != null && (session = space.getSession()) instanceof BFoxSession) {
                    s = (BFoxSession)session;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (s != null) {
            BFoxClientConnection c = s.getConnection();
            FoxSession fs = c.session();
            FoxMessage m = fs.getRemoteWelcome();
            BAbsTime exp = BAbsTime.make((long)m.getTime("passwordExpires", BAbsTime.NULL.getMillis()));
            boolean resetPassword = m.getBoolean("forceReset", false);
            Lexicon lex = Lexicon.make((String)"fox");
            if (!resetPassword && !exp.isNull() && fs.promptForPasswordReset) {
                if (m.getBoolean("networkUser", false)) {
                    BDialog.open((BWidget)this.shell, (String)"Password Expiration", (Object)lex.getText("fox.network.user.password.expiring", new Object[]{exp}), (int)1, (BImage)BImage.make((String)"module://icons/x32/keys.png"));
                    fs.promptForPasswordReset = false;
                } else if (!(c.getUseFoxs() || BFoxClientWebsocketBehavior.useWebsocketOnly.equals((Object)c.getFoxOverWebsocket()) || c.getFoxOverWebsocketInUse())) {
                    BDialog.open((BWidget)this.shell, (String)"Password Expiration", (Object)lex.getText("fox.insecure.password.expiring", new Object[]{exp}), (int)1, (BImage)BImage.make((String)"module://icons/x32/keys.png"));
                    fs.promptForPasswordReset = false;
                } else if (BDialog.open((BWidget)this.shell, (String)"Password Expiration", (Object)lex.getText("fox.user.password.expiring", new Object[]{exp}), (int)12, (BImage)BImage.make((String)"module://icons/x32/keys.png")) == 4) {
                    resetPassword = true;
                } else {
                    fs.promptForPasswordReset = false;
                }
            }
            if (m.getBoolean("illegalNetworkUserState", false)) {
                BDialog.open((BWidget)this.shell, (String)"Password Expiration", (Object)lex.getText("fox.illegal.network.user.passwordReset", new Object[]{exp}), (int)1, (BImage)BImage.make((String)"module://icons/x32/keys.png"));
                this.ensureDisconnect(s);
                throw new AuthenticationException("Cannot reset password.");
            }
            if (!c.getUseFoxs() && !BFoxClientWebsocketBehavior.useWebsocketOnly.equals((Object)c.getFoxOverWebsocket()) && !c.getFoxOverWebsocketInUse() && m.getBoolean("noInsecureReset", false)) {
                BDialog.open((BWidget)this.shell, (String)"Password Expiration", (Object)lex.getText("fox.login.passwordReset.secureOnly", new Object[]{exp}), (int)1, (BImage)BImage.make((String)"module://icons/x32/keys.png"));
                this.ensureDisconnect(s);
                throw new AuthenticationException("Cannot reset password.");
            }
            if (resetPassword && fs.promptForPasswordReset) {
                boolean passwordReset = false;
                String errMsg = null;
                int loopCount = 0;
                BPasswordStrength passwordStrength = new BPasswordStrength(m.getInt("minLength", ((BInteger)BPasswordStrength.minimumLength.getDefaultValue()).getInt()), m.getInt("minLowerCase", ((BInteger)BPasswordStrength.minimumLowerCase.getDefaultValue()).getInt()), m.getInt("minUpperCase", ((BInteger)BPasswordStrength.minimumUpperCase.getDefaultValue()).getInt()), m.getInt("minDigits", ((BInteger)BPasswordStrength.minimumDigits.getDefaultValue()).getInt()), m.getInt("minSpecial", ((BInteger)BPasswordStrength.minimumSpecial.getDefaultValue()).getInt()), m.getInt("maxLength", ((BInteger)BPasswordStrength.maximumLength.getDefaultValue()).getInt()));
                while (!passwordReset) {
                    try {
                        ++loopCount;
                        BUserChannel userChannel = ((BFoxConnection)fs.conn()).getChannels().getUserChannel();
                        userChannel.fetchPrefs();
                        BPassword password = BPasswordResetDialog.open((BWidget)this.shell, passwordStrength, errMsg);
                        if (password != null) {
                            userChannel.setAuthenticator((BAbstractAuthenticator)new BPasswordCache(password), true);
                            fs.promptForPasswordReset = false;
                            passwordReset = true;
                            s.disconnect();
                            BUsernameAndPassword credentials = new BUsernameAndPassword(s.getUsername(), password);
                            s.getConnection().setCredentials((BIUserCredentials)credentials);
                            s.getConnection().setAuthenticationClient((AuthenticationClient)s.getConnection());
                            s.connect();
                            continue;
                        }
                        passwordReset = true;
                        throw new AuthenticationException("password not changed as required");
                    }
                    catch (IOException | AuthenticationException e) {
                        this.ensureDisconnect(s);
                        throw e;
                    }
                    catch (Exception e) {
                        errMsg = e.getLocalizedMessage();
                        if (loopCount <= 100) continue;
                        this.ensureDisconnect(s);
                        throw e;
                    }
                }
            }
        }
        return target;
    }

    private void ensureDisconnect(BFoxSession s) {
        block3: {
            try {
                if (s != null) {
                    s.disconnect();
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, "Cannot disconnect", e);
            }
        }
    }

    private BImage getIcon() {
        try {
            BImage icon = BImage.make((BIcon)this.target.get().getIcon());
            if (this.historyEntry != null) {
                this.historyEntry.icon = icon;
            }
            return icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BPermissions getPermissions() throws Exception {
        BPermissions permissions = this.target.getPermissionsForTarget();
        if (log.isLoggable(Level.FINE)) {
            log.fine("getPermissions: " + permissions);
        }
        return permissions;
    }

    private AgentList getViewAgentsList() throws Exception {
        BObject obj = this.target.get();
        AgentList list = WbSys.getFilteredViewList((BWidget)this.shell, obj, BFileMenuAgent.disable ? AgentFilter.has((BPermissions)this.permissions).toPredicate() : agent -> true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("getAgents: " + list);
        }
        if (list.size() == 0) {
            AgentList agents = this.target.get().getAgents().filter(WbSys.getBaseViewsFilter());
            if (agents.size() > 0) {
                throw new ViewRestrictedException(obj.getType());
            }
            throw new NoViewRegisteredException(obj.getType());
        }
        return list;
    }

    private AgentInfo getAgent() throws Exception {
        OrdQuery lastQuery;
        String viewId = null;
        if (this.queries.length > 0 && (lastQuery = this.queries[this.queries.length - 1]) instanceof ViewQuery) {
            viewId = ((ViewQuery)lastQuery).getViewId();
        }
        AgentInfo agent = viewId == null && this.viewAgents.size() > 0 ? this.viewAgents.getDefault() : this.viewAgents.get(viewId);
        if (this.historyEntry != null && viewId != null) {
            this.historyEntry.ordNoView = SpyUtil.stripAuthorization((BOrd)BOrd.make((OrdQuery[])this.queries, (int)0, (int)(this.queries.length - 1)));
            this.historyEntry.viewId = viewId;
        }
        if (agent == null) {
            System.out.println("No views accessible:");
            System.out.println("  ord:         " + this.ord);
            System.out.println("  target.type: " + this.target.get().getType());
            System.out.println("  target:      " + this.target.get());
            if (viewId != null) {
                throw new LocalizableRuntimeException("bajaui", "errorPanel.invalidView", new Object[]{viewId});
            }
            throw new LocalizableRuntimeException("bajaui", "errorPanel.noViews");
        }
        if (!this.permissions.has(agent.getRequiredPermissions())) {
            throw new PermissionException(this.permissions + " < " + agent.getRequiredPermissions());
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("getAgent: " + agent);
        }
        return agent;
    }

    private BWbView getView() throws Exception {
        BObject view = this.agent.getInstance();
        if (log.isLoggable(Level.FINE)) {
            log.fine("getView: " + view.toDebugString());
        }
        if (view instanceof BWbView) {
            return (BWbView)view;
        }
        if (view instanceof BAbstractPxView) {
            return new BWbPxView((BAbstractPxView)view);
        }
        if (view instanceof BIFormFactorMax) {
            return WebWidgetUtil.getCacheableWebWidget(this.tab.getView(), BOrd.toSession((BObject)this.ord.get()), this.target.getOrd(), this.agent, this.target.getSpace());
        }
        throw new LocalizableRuntimeException("bajaui", "errorPanel.notWbView");
    }

    public static void clearCache(BWbView view) {
        if (view instanceof BWebBrowserView) {
            BWebBrowserView browserView = (BWebBrowserView)view;
            browserView.clearCache();
        }
        if (view instanceof BWebWidget) {
            BWebWidget ww = (BWebWidget)view;
            WebWidgetUtil.clearCache(ww);
            BWebBrowser webBrowser = ww.getBrowser();
            if (webBrowser != null) {
                webBrowser.clearCache();
            }
        }
        if (view instanceof BWbPxView) {
            BWbPxView pxView = (BWbPxView)view;
            for (BWebWidget bWebWidget : (BWebWidget[])CompUtil.getDescendants((BComponent)pxView, BWebWidget.class)) {
                WebWidgetUtil.clearCache(bWebWidget);
                BWebBrowser webBrowser = bWebWidget.getBrowser();
                if (webBrowser == null || webBrowser.getParentWidget() != null) continue;
                webBrowser.clearCache();
            }
            for (BWidget bWidget : (BWebBrowser[])CompUtil.getDescendants((BComponent)pxView, BWebBrowser.class)) {
                bWidget.clearCache();
            }
        }
    }

    private Context getContext() throws Exception {
        try {
            BISession session = BOrd.toSession((BObject)this.target.get());
            if (session != null) {
                return session.getSessionContext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private BPathBarAgent[] makePathBarAgents() throws Exception {
        if (this.shell.getProfile().makeLocatorBar() == null) {
            return noPathBarAgents;
        }
        try {
            BPathBarAgent[] navAgents;
            BINavNode nav;
            BObject obj;
            BISession session;
            if (this.shell.commands.pathBarUsesNavFile.isSelected() && (session = BOrd.toSession((BObject)(obj = this.target.get()))) != null && (nav = session.getNavChild("navfile")) != null && (navAgents = BNavFilePA.make((BNavFileSpace)nav, this.target)) != null) {
                return navAgents;
            }
            Array acc = new Array(BPathBarAgent.class);
            for (int i = 0; i < this.queries.length; ++i) {
                BOrd base = i == 0 ? BOrd.NULL : this.ord.getSubOrd(0, i);
                BPathBarAgent agent = this.makePathBarAgent(this.queries[i]);
                if (agent == null) continue;
                if (i == this.queries.length - 1) {
                    agent.setAgentOrd(base, this.queries[i], this.target.get());
                } else {
                    agent.setAgentOrd(base, this.queries[i]);
                }
                for (BPathBarAgent kid : agent.explode()) {
                    acc.add((Object)kid);
                }
            }
            return (BPathBarAgent[])acc.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BPathBarAgent makePathBarAgent(OrdQuery query) {
        BOrdScheme scheme = BOrdScheme.lookup((String)query.getScheme());
        if (scheme.getType().is(BViewScheme.TYPE)) {
            return null;
        }
        AgentList list = scheme.getAgents().filter(pathBarAgentFilter);
        if (list.size() == 0) {
            return null;
        }
        return (BPathBarAgent)list.getDefault().getInstance();
    }

    private String getFault() throws Exception {
        BISession session;
        if (log.isLoggable(Level.FINE)) {
            log.fine("getFault");
        }
        if ((session = BOrd.toSession((BObject)this.target.get())) instanceof BFoxSession) {
            return ((BFoxSession)session).getStationFault();
        }
        return null;
    }

    private void updateTab() throws Exception {
        BISession session;
        if (log.isLoggable(Level.FINE)) {
            log.fine("updateTab");
        }
        OrdTarget lastTarget = this.tab.target;
        this.tab.ord = this.ord;
        this.tab.hasParent = this.hasParent;
        this.tab.target = this.target;
        this.tab.agents = this.viewAgents;
        this.tab.agent = this.agent;
        this.tab.view = this.view;
        this.tab.pathBarAgents = this.pathBarAgents;
        this.tab.fault = this.fault;
        BObject lastObject = lastTarget == null ? null : lastTarget.get();
        BISession lastSession = lastObject == null ? null : BOrd.toSession((BObject)lastObject);
        BObject object = this.target == null ? null : this.target.get();
        BISession bISession = session = object == null ? null : BOrd.toSession((BObject)object);
        if (lastSession != session) {
            if (lastSession instanceof BFoxSession) {
                ((BFoxSession)lastSession).getActivityMonitor().removeNotifyListener((BFoxProxySession.NotifyListener)this.tab);
            }
            if (session instanceof BFoxSession) {
                ((BFoxSession)session).getActivityMonitor().addNotifyListener((BFoxProxySession.NotifyListener)this.tab);
            }
        }
    }

    private void updateViewTab() {
        String tabName = BViewTabbedPane.toTabName(this.ord, this.target);
        if (log.isLoggable(Level.FINE)) {
            log.fine("updateViewTab: " + tabName);
        }
        BImage tabIcon = this.icon;
        BLabel label = this.tab.getLabel();
        if (tabIcon != null) {
            label.setImage(tabIcon);
        }
        label.setText(tabName);
        if (this.view.getParent() == null) {
            this.tab.setContent(this.view);
        }
    }

    private void activateView() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("activateView");
        }
        this.tab.fireActivated();
    }

    private void loadView() throws Throwable {
        if (log.isLoggable(Level.FINE)) {
            log.fine("loadView");
        }
        this.view.fw(403);
        this.view.loadValue(this.target.get(), this.context);
        Throwable e = this.view.getLoadError();
        if (e != null) {
            throw e;
        }
        this.view.prime();
        this.shell.relayout();
        this.view.relayout();
    }

    private void startBinder() throws Throwable {
        Binder binder = (Binder)this.view.fw(302);
        binder.start(this.target, this.context);
    }
}

