/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.sys.Nre;
import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.util.CommandLineArguments;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.WbOptionsManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.naming.BHost;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.options.OptionsManager;

@NiagaraType
public class BWbApplication
extends BNiagaraWidgetApplication {
    @Generated
    public static final Type TYPE = Sys.loadType(BWbApplication.class);
    static boolean needAutoLogoff = true;
    public static LogoffListener logOffListener;
    boolean applet;
    boolean webstart;
    WbOptionsManager optionsManager = new WbOptionsManager(this);
    private static final boolean HEADLESS;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean useAntiAlias() {
        return true;
    }

    public boolean isApplet() {
        return this.applet;
    }

    public boolean isWebStart() {
        return this.webstart;
    }

    public void checkInputActivity(long inactivity) {
        super.checkInputActivity(inactivity);
        BGeneralOptions options = BGeneralOptions.make();
        boolean logoffEnabled = options.getAutoLogoffEnabled();
        long logoffPeriod = options.getAutoLogoffPeriod().getMillis();
        if (logoffEnabled && inactivity > logoffPeriod) {
            if (needAutoLogoff) {
                LOGGER.info("Auto Logoff (" + logoffPeriod / 1000L + "sec)");
                needAutoLogoff = false;
                BWbApplication.autoLogoff();
            }
        } else {
            needAutoLogoff = true;
        }
    }

    public static void autoLogoff() {
        BWidgetShell[] shells;
        BHost[] hosts;
        if (logOffListener != null) {
            logOffListener.logoff();
        }
        for (BHost host : hosts = BHost.getAllHosts()) {
            host.disconnect();
        }
        for (BWidgetShell shell : shells = BWidget.getApplication().getShells()) {
            if (!(shell instanceof BNiagaraWbShell)) continue;
            ((BNiagaraWbShell)shell).autoLogoff();
        }
    }

    public void restart() {
        BWidgetShell[] shells = this.getShells();
        StringBuilder paramStr = new StringBuilder();
        for (BWidgetShell shell : shells) {
            paramStr.append("\"");
            if (shell instanceof BNiagaraWbShell) {
                BViewTab[] tabs = ((BNiagaraWbShell)shell).pane.views.getTabs();
                int selectedIdx = 0;
                for (int i = 0; i < tabs.length; ++i) {
                    if (i > 0) {
                        paramStr.append(';');
                    }
                    paramStr.append(tabs[i].getOrd());
                    if (!tabs[i].isVisible()) continue;
                    selectedIdx = i;
                }
                if (selectedIdx > 0) {
                    paramStr.append(";tab:").append(selectedIdx);
                }
            }
            paramStr.append("\" ");
        }
        this.restart(new String[0], paramStr.toString());
    }

    public void restart(String[] options, String params) {
        if (HEADLESS) {
            throw new UnsupportedOperationException("Display required to launch external application");
        }
        try {
            String[] cmdLineOpts;
            if ((params == null || params.isEmpty()) && Nre.args.parameters.length > 0) {
                params = Nre.args.parameters[0];
            }
            if (params == null) {
                params = "";
            }
            CommandLineArguments opts = new CommandLineArguments(options);
            Array usedOpts = new Array(String.class);
            StringBuilder newOptionsBuilder = new StringBuilder();
            for (String cmdLineOpt : cmdLineOpts = Nre.args.options) {
                String optValue = opts.getOption(cmdLineOpt);
                if (optValue == null) {
                    optValue = Nre.args.getOption(cmdLineOpt);
                } else {
                    usedOpts.add((Object)cmdLineOpt);
                }
                newOptionsBuilder.append(" -").append(cmdLineOpt).append(":").append(optValue);
            }
            for (int i = 0; i < opts.options.length; ++i) {
                if (usedOpts.contains((Object)opts.options[i])) continue;
                newOptionsBuilder.append(" -").append(opts.options[i]).append(":").append(opts.getOption(opts.options[i]));
            }
            String newOptions = newOptionsBuilder.toString().trim();
            params = params.trim();
            ArrayList<String> command = new ArrayList<String>();
            command.add("wb");
            if (!newOptions.isEmpty()) {
                command.addAll(Arrays.asList(newOptions.split(" ")));
            }
            if (!params.isEmpty()) {
                command.addAll(Arrays.asList(params.split(" ")));
            }
            new ProcessBuilder(command.toArray(new String[0])).start();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Exception occurred in WbApplication restart", exception);
        }
        System.exit(0);
    }

    public OptionsManager getOptionsManager() {
        return this.optionsManager;
    }

    static {
        HEADLESS = AccessController.doPrivileged(() -> Boolean.getBoolean("java.awt.headless"));
    }

    public static interface LogoffListener {
        public void logoff();
    }
}

