/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.net.BHttpScheme;
import com.tridium.net.BHttpsScheme;
import com.tridium.web.WebUtil;
import com.tridium.workbench.shell.BNiagaraWbWebShell;
import com.tridium.workbench.shell.RemoteShellContainer;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.workbench.web.BWbWebProfile;

@NiagaraType
public class BNiagaraWbWebStartShell
extends BNiagaraWbWebShell {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraWbWebStartShell.class);
    private BOrd initialPopStateOrd;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BNiagaraWbWebStartShell make(Object panel) throws Exception {
        RemoteShellContainer wrapper = RemoteShellContainer.makeForWebStart(panel);
        Type profileType = BNiagaraWbWebStartShell.getProfileTypeFromParams(wrapper);
        BNiagaraWbWebStartShell.configureThemeFromParams(wrapper);
        return new BNiagaraWbWebStartShell(wrapper, profileType);
    }

    public BNiagaraWbWebStartShell() {
    }

    public BNiagaraWbWebStartShell(RemoteShellContainer container, Type profileType) {
        super(container, profileType);
    }

    @Override
    public void hyperlink(HyperlinkInfo hyperlinkInfo) {
        if (!this.userHasWbWebProfile()) {
            if (this.initialPopStateOrd == null) {
                this.doHyperlink(hyperlinkInfo);
            } else {
                this.shellContainer.showDocument(this.ordToUrl(hyperlinkInfo.getOrd()));
            }
        } else {
            BOrd ord = hyperlinkInfo.getOrd();
            OrdQuery[] query = ord.parse();
            if (query.length > 0) {
                if (BHttpScheme.INSTANCE.getId().equals(query[0].getScheme()) || BHttpsScheme.INSTANCE.getId().equals(query[0].getScheme())) {
                    this.shellContainer.showDocument(this.ordToUrl(hyperlinkInfo.getOrd()));
                } else {
                    BHyperlinkMode mode;
                    boolean hasBrowserQuery = WebUtil.hasWebStartBrowserQuery((OrdQuery[])query);
                    if (!hasBrowserQuery && WebUtil.requiresWebStartBrowserViewQuery((OrdQuery[])query)) {
                        ord = WebUtil.addWebStartBrowserQuery((OrdQuery[])query);
                        hyperlinkInfo = new HyperlinkInfo(ord, hyperlinkInfo.getMode());
                    }
                    if (!(mode = hyperlinkInfo.getMode()).equals((Object)BHyperlinkMode.replace)) {
                        ord = BOrd.make((BOrd)this.getActiveOrd(), (BOrd)hyperlinkInfo.getOrd()).normalize();
                        hyperlinkInfo = new HyperlinkInfo(ord, mode);
                    }
                    super.hyperlink(hyperlinkInfo);
                }
            }
        }
    }

    public void onPopState(String ord) {
        if (!this.userHasWbWebProfile()) {
            return;
        }
        BOrd dest = ord != null && !ord.isEmpty() ? BOrd.make((String)ord) : this.initialPopStateOrd;
        BWidget.invokeLater(() -> {
            this.popstate = true;
            this.hyperlink(dest);
        });
    }

    @Override
    protected void startPopState(BOrd initialOrd) {
        this.initialPopStateOrd = initialOrd;
        if (!this.userHasWbWebProfile()) {
            return;
        }
        try {
            String js = "window.onpopstate = function(event) {\n  var ord = event && event.state && event.state.ord;\n  if (niagaraWebStart_onPopHistoryState) {\n    niagaraWebStart_onPopHistoryState(ord);\n  }\n};";
            this.shellContainer.executeJs(js);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed start pop state js.", e);
        }
    }

    @Override
    protected void stopPopState() {
        this.initialPopStateOrd = null;
    }

    @Override
    protected void pushState(HyperlinkInfo hyperlinkInfo) {
        if (!this.userHasWbWebProfile()) {
            return;
        }
        try {
            if (!this.popstate) {
                BOrd ord = hyperlinkInfo.getOrd();
                String ordString = BNiagaraWbWebStartShell.encodeSingleQuotes(ord.toString());
                String uri = BNiagaraWbWebStartShell.encodeSingleQuotes(this.ordToUrl(ord).toString());
                String js = String.format("history.pushState({ord: '%s'}, '', '%s');niagaraWebStart_onPushHistoryState();", ordString, uri);
                this.shellContainer.executeJs(js);
            }
            this.popstate = false;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to push browser history state", e);
        }
    }

    private static String encodeSingleQuotes(String text) {
        return BNiagaraWbWebStartShell.encodeQuotes(text, "'");
    }

    private static String encodeQuotes(String text, String quoteCharacter) {
        return text.replace(quoteCharacter, "\\" + quoteCharacter);
    }

    private boolean userHasWbWebProfile() {
        String param = this.getShellContainer().getParameter("webstart_user_wb_profile");
        if (param != null) {
            return "true".equals(param);
        }
        return false;
    }

    public boolean hasWebStartAddressBar() {
        if (this.profile instanceof BWbWebProfile) {
            return ((BWbWebProfile)this.profile).hasWebStartAddressBar();
        }
        return true;
    }

    public boolean hasWebStartStatusBar() {
        if (this.profile instanceof BWbWebProfile) {
            return ((BWbWebProfile)this.profile).hasWebStartStatusBar();
        }
        return true;
    }
}

