/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.GenericReportableAuthenticationException;
import com.tridium.authn.LoginFailureCause;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.NiagaraWbShell;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.WbAuthenticationClient;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.file.BTextFileEditor;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BFontSize;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BIRebootable;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbWebStartShell;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BSideBarPane;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.BWbPane;
import com.tridium.workbench.shell.NHyperlinkInfo;
import com.tridium.workbench.shell.WbCommands;
import com.tridium.workbench.shell.WbHistory;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.sidebars.BNavSideBar;
import com.tridium.workbench.web.browser.BrowserUtil;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BITemplate;
import javax.baja.file.BSubSpaceFile;
import javax.baja.fox.BFoxProxySession;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.license.LicenseException;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.security.ChangeUserAuthenticationException;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.sidebar.BIWbSideBar;
import javax.baja.workbench.view.BWbView;
import javax.net.ssl.SSLHandshakeException;

@NiagaraType
public abstract class BNiagaraWbShell
extends BWbShell
implements NiagaraWbShell,
ShellManager.ShellPeerFactory,
NavListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraWbShell.class);
    static Logger log;
    static String statusDefault;
    static BImage errorIcon;
    static WbHistory history;
    public final BWbProfile profile;
    public final WbCommands commands;
    public final BWbPane pane;
    public BFileChooser fileChooser;
    public BDirectoryChooser dirChooser;
    public BBqlQueryBuilder bqlBuilder;
    private Set<BWbShell.ActivityListener> activityListeners = Collections.newSetFromMap(new WeakHashMap());
    public static final int OPTION_CLOSE_CHANGE_USER = 1000;
    public static Lexicon lex;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    BNiagaraWbShell(Type profileType) {
        this.profile = BWbProfile.make(this, profileType);
        this.commands = new WbCommands(this);
        this.pane = new BWbPane(this);
        this.setContent((BWidget)this.pane);
    }

    BNiagaraWbShell(Type profileType, ShellPeer peer) {
        super(peer);
        this.profile = BWbProfile.make(this, profileType);
        this.commands = new WbCommands(this);
        this.pane = new BWbPane(this);
        this.setContent((BWidget)this.pane);
    }

    abstract void doShowStatus(String var1);

    BSideBarPane makeSideBar() {
        return new BSideBarPane();
    }

    @Override
    public Command getRefreshCommand() {
        return this.commands.refresh;
    }

    @Override
    public Command getSaveCommand() {
        return this.commands.save;
    }

    @Override
    public Command getExportCommand() {
        return this.commands.export;
    }

    @Override
    public Command getBackCommand() {
        return this.commands.back;
    }

    @Override
    public Command getForwardCommand() {
        return this.commands.forward;
    }

    @Override
    public Command getLogoffCommand() {
        return this.commands.logoff;
    }

    @Override
    public final BWbProfile getProfile() {
        return this.profile;
    }

    public final void showStatus(String msg) {
        if (msg == null) {
            msg = statusDefault;
        }
        this.doShowStatus(msg);
    }

    @Override
    public final BOrd getActiveOrd() {
        return this.tab().ord;
    }

    @Override
    public final OrdTarget getActiveOrdTarget() {
        return this.tab().target;
    }

    @Override
    public final BWbView getActiveView() {
        return this.tab().view;
    }

    public final String getActiveViewId() {
        return this.tab().agent.getAgentId();
    }

    public void updateCommandStates(BWbView view) {
        this.commands.updateView(view);
    }

    public void exitBusy() {
        super.exitBusy();
        this.commands.updateBogCommands();
    }

    public void debug() {
    }

    @Deprecated
    public final boolean isApplet() {
        return this instanceof BNiagaraWbApplet;
    }

    public final boolean isWebStart() {
        return this instanceof BNiagaraWbWebStartShell;
    }

    public final boolean isAppletOrWebStart() {
        return this.isApplet() || this.isWebStart();
    }

    public final boolean isFrame() {
        return this instanceof BNiagaraWbFrame;
    }

    public void updateTransferWidgetStates() {
        if (this.tab().view != null) {
            this.tab().view.updateTransferWidgetStates();
        }
    }

    public static BWbApplication app() {
        return (BWbApplication)BNiagaraWbShell.getApplication();
    }

    public String getSelectedText() {
        BTextFileEditor editor;
        String text;
        if (this.tab().view instanceof BTextFileEditor && (text = (editor = (BTextFileEditor)this.tab().view).getSelectedText()) != null && (text = text.trim()).length() > 0) {
            return text;
        }
        return null;
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void setModified(BWbPlugin view) {
        if (view == this.tab().view) {
            this.commands.save.setEnabled(true);
        }
    }

    public void clearModified(BWbPlugin view) {
        if (view == this.tab().view) {
            this.commands.save.setEnabled(false);
        }
    }

    public void navEvent(NavEvent event) {
        this.commands.updateBogCommands();
        if (event.getId() == 2 || event.getId() == 5) {
            this.checkTabsForRemoveEvent(event);
        }
    }

    private void checkTabsForRemoveEvent(NavEvent event) {
        BViewTab[] tabs = this.pane.views.getTabs();
        boolean tabRemoved = false;
        for (int i = 0; i < tabs.length; ++i) {
            BISession session;
            BObject object;
            BViewTab tab = tabs[i];
            BOrd activeOrd = tab.ord;
            if (activeOrd == null || tab.getTarget() == null) continue;
            OrdTarget target = tab.getTarget();
            BObject bObject = object = target == null ? null : target.get();
            if (object instanceof BITemplate) continue;
            BISession bISession = session = object == null ? null : BOrd.toSession((BObject)object);
            if (tab.view instanceof BIRebootable && ((BIRebootable)((Object)tab.view)).isRebooting()) continue;
            if (session != null && !session.isConnected()) {
                LoginFailureCause cause = null;
                this.closeSubSpaceFile(object);
                tabRemoved = true;
                tab.stopView(false);
                if (session instanceof BFoxSession) {
                    cause = ((BFoxSession)session).getFailureCause();
                }
                LocalizableException e = new LocalizableException("bajaui", "errorPanel.disconnected");
                if (cause == null) {
                    this.error(tab, activeOrd, (Throwable)e, false);
                    continue;
                }
                String message = cause.getDefaultFailureTitle() + "\n" + cause.getDefaultFailureMessage();
                if (cause.equals((Object)LoginFailureCause.SESSION_TIMEOUT)) {
                    String info = UiLexicon.bajaui().getText("errorPanel.autoLogoffInformation");
                    message = message + "\n" + info;
                }
                this.error(tab, activeOrd, message, (Throwable)e, false);
                continue;
            }
            if (!WbMain.isRemoved(event, activeOrd)) continue;
            this.closeSubSpaceFile(object);
            tabRemoved = true;
            tab.stopView(false);
            this.error(tab, activeOrd, (Throwable)new LocalizableException("bajaui", "errorPanel.targetRemoved"), false);
        }
        if (tabRemoved) {
            this.tab().updateShell();
            this.relayout();
        }
    }

    private void closeSubSpaceFile(BObject target) {
        BSubSpaceFile file = this.getSubSpaceFile(target);
        if (file != null && file.isOpen()) {
            file.close();
        }
    }

    private BSubSpaceFile getSubSpaceFile(BObject target) {
        BSpace node;
        if (target instanceof BSubSpaceFile) {
            return (BSubSpaceFile)target;
        }
        for (node = BOrd.toSpace((BObject)target); node != null && !(node instanceof BSubSpaceFile); node = node.getNavParent()) {
        }
        return (BSubSpaceFile)node;
    }

    void autoLogoff() {
    }

    public final boolean confirmClose() {
        String title = UiLexicon.bajaui().getText("saveBeforeClose");
        int result = BSaveAllDialog.saveTabs(this, title);
        return result != 2;
    }

    public void hyperlink(File file, int line1, int col1, int line2, int col2) {
        BWbView active;
        BOrd fileOrd = BFileSystem.INSTANCE.localFileToOrd(file);
        BViewTab[] tabs = this.pane.views.getTabs();
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i].ord == null || !tabs[i].ord.equals((Object)fileOrd) || this.tab() == tabs[i]) continue;
            this.pane.views.selectLabelPane(tabs[i]);
        }
        if (!this.tab().ord.equals((Object)fileOrd)) {
            this.hyperlink(fileOrd);
        }
        if ((active = this.getActiveView()) instanceof BTextFileEditor) {
            ((BTextFileEditor)active).highlight(line1, col1, line2, col2);
        }
    }

    public void hyperlink(HyperlinkInfo hyperlinkInfo) {
        this.doHyperlink(hyperlinkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doHyperlink(HyperlinkInfo hyperlinkInfo) {
        this.showStatus("");
        NHyperlinkInfo info = NHyperlinkInfo.make(hyperlinkInfo);
        if (info.getMode() == BHyperlinkMode.newShell) {
            WbMain.openFrame((BNiagaraWbFrame)this, info.getOrd(), this.profile.getType());
            return;
        }
        BViewTab tab = this.tab();
        if (info.getMode() == BHyperlinkMode.newTab) {
            tab = this.pane.views.addTab();
        } else if (!this.confirmHyperlink()) {
            return;
        }
        if (!this.profile.canHyperlink(info.getOrd())) {
            this.error(tab, info.getOrd(), (Throwable)new LocalizableException("bajaui", "errorPanel.ordNotAccessible"), true);
            return;
        }
        ShellManager shellManager = (ShellManager)this.widgetSupport(null);
        this.enterBusy();
        try {
            info.hyperlink(tab);
        }
        catch (Throwable e) {
            this.error(tab, info.getOrd(), e, true);
        }
        finally {
            this.exitBusy();
        }
    }

    public final boolean confirmHyperlink() {
        return this.confirmHyperlink(this.tab());
    }

    public final boolean confirmHyperlink(BViewTab tab) {
        if (tab.view != null) {
            if (tab.view.isModified()) {
                int buttons;
                String msg = UiLexicon.bajaui().getText("confirmHyperlink.message", new Object[]{tab.getDisplayName()});
                int result = BDialog.confirm((BWidget)this, null, (Object)msg, (int)(buttons = 14));
                if (result == 2) {
                    return false;
                }
                if (result == 4) {
                    this.save(tab.view);
                    if (tab.view.isModified()) {
                        return false;
                    }
                }
            }
            if (!BrowserUtil.confirmBeforeUnload(tab.view)) {
                return false;
            }
        }
        return true;
    }

    public void syncTree() {
        this.syncTree(false);
    }

    public void syncTree(boolean silence) {
        if (this.getProfile().hasSideBar()) {
            try {
                BIWbSideBar[] bars = this.pane.sideBar.list();
                for (int i = 0; i < bars.length; ++i) {
                    if (!(bars[i] instanceof BNavSideBar)) continue;
                    ((BNavSideBar)bars[i]).syncTree(silence);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initShell() {
        ((ShellManager)this.widgetSupport(null)).activate();
    }

    public void shutdownShell() {
        for (BViewTab tab : this.pane.views.getTabs()) {
            BWbView view = tab.getView();
            if (view != null) {
                NHyperlinkInfo.clearCache(view);
            }
            tab.stopView(true);
        }
        ((ShellManager)this.widgetSupport(null)).deactivate();
    }

    public OrdTarget resolve(BOrd ord, BICredentials credentials) throws Exception {
        return this.resolve(ord, credentials, null);
    }

    /*
     * Unable to fully structure code
     */
    public OrdTarget resolve(BOrd ord, BICredentials credentials, Context context) throws Exception {
        newSession = false;
        authenticationClient = new WbAuthenticationClient((BWidget)this);
        i = 0;
        while (true) {
            try {
                target = ord.resolve((BObject)BLocalHost.INSTANCE, context, (AuthenticationClient)authenticationClient);
                if ((newSession || authenticationClient.isNewSession()) && (profile = this.getProfile()) != null && (openOrd = profile.getOpenOrd(session = BOrd.toSession((BObject)target.get()), ord)) != null && !ord.equals((Object)openOrd)) {
                    ord = openOrd;
                    target = openOrd.resolve((BObject)BLocalHost.INSTANCE, context, (AuthenticationClient)authenticationClient);
                }
                return target;
            }
            catch (CancelledAuthenticationException e) {
                throw e;
            }
            catch (ChangeUserAuthenticationException e) {
                AuthUtil.removeSavedUser(e.getAuthenticationRealm().getAuthenticationRealmName());
            }
            catch (AuthenticationException e) {
                newSession = true;
                realm = e.getAuthenticationRealm();
                loginFailureCause = e.getLoginFailureCause();
                if (loginFailureCause == null) ** GOTO lbl-1000
                switch (2.$SwitchMap$com$tridium$authn$LoginFailureCause[loginFailureCause.ordinal()]) {
                    case 1: {
                        authenticationClient.setException(new AuthenticationException(e.getAuthenticationRealm(), (Throwable)new GenericReportableAuthenticationException(LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED)));
                        AuthUtil.removeSavedUser(e.getAuthenticationRealm().getAuthenticationRealmName());
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (credentials != null && e.getAuthenticationRealm() != null) {
                            realm.setCredentials(credentials);
                            credentials = null;
                            break;
                        }
                        if (i == 0 && WbMain.kioskCredentials != null) {
                            realm.setCredentials(WbMain.kioskCredentials);
                            break;
                        }
                        if (i == 0 && AuthUtil.resolveSSO(e)) break;
                        authenticationClient.setException(e);
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof IncompatibleVersionException) {
                    BDialog.warning((BWidget)this, (String)UiLexicon.bajaui().getText("resolve.cannotHyperlinkN4wbToAXstation.title"), (Object)UiLexicon.bajaui().getText("resolve.cannotHyperlinkN4wbToAXstation.msg", new Object[]{ord}));
                }
                throw e;
            }
            ++i;
        }
    }

    public void userActivity() {
        BISession session;
        OrdTarget target = this.getActiveOrdTarget();
        BObject object = target == null ? null : target.get();
        BISession bISession = session = object == null ? null : BOrd.toSession((BObject)object);
        if (session instanceof BFoxSession) {
            ((BFoxSession)session).userActivity();
        }
        for (BWbShell.ActivityListener listener : this.activityListeners) {
            listener.activity();
        }
    }

    @Override
    public void addActivityListener(BWbShell.ActivityListener listener) {
        this.activityListeners.add(listener);
    }

    @Override
    public void removeActivityListener(BWbShell.ActivityListener listener) {
        this.activityListeners.remove(listener);
    }

    @Override
    public boolean notifyTimeout(BWidget widget, final BISession session) {
        BWidgetShell shell = widget.getShell();
        if (!(shell instanceof BNiagaraWbShell)) {
            for (BWidget parent = widget; parent != null; parent = parent.getParentWidget()) {
                if (!(parent instanceof BViewTab)) continue;
                ((BNiagaraWbShell)shell).pane.views.selectLabelPane((BLabelPane)parent);
                break;
            }
        }
        final BOptionDialog dialog = new BOptionDialog(widget, lex.getText("sessionTimeout.title"), (BWidget)new BLabel(lex.getText("sessionTimeout.message", new Object[]{((BFoxProxySession)session).getStationName()})), 3, BDialog.INFO_ICON, null);
        dialog.setBoundsCenteredOnOwner();
        dialog.getOkButton().setText(lex.getText("sessionTimeout.continue"));
        dialog.getCancelButton().setText(lex.getText("sessionTimeout.logout"));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (!dialog.isShowing()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                while (dialog.isShowing()) {
                    if (session instanceof BFoxSession && !session.isConnected()) {
                        Runnable close = new Runnable(){

                            @Override
                            public void run() {
                                dialog.close();
                            }
                        };
                        BWidget.invokeLater((Runnable)close);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        Thread expirationWarningMonitor = new Thread(runnable);
        expirationWarningMonitor.setName("ExpirationWarningMonitor");
        expirationWarningMonitor.start();
        dialog.open();
        if (dialog.getResult() == 2) {
            session.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BWbView view) {
        this.enterBusy();
        try {
            view.saveValue();
        }
        catch (Throwable e) {
            Throwable cause = e;
            String msg = UiLexicon.bajaui().getText("plugin.save.error");
            boolean suppressStackTrace = false;
            if (e instanceof CannotSaveException) {
                CannotSaveException cse = (CannotSaveException)((Object)e);
                if (cse.isSilent()) {
                    return;
                }
                msg = e.getMessage();
                cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                suppressStackTrace = cse.suppressStackTrace();
            }
            if (!suppressStackTrace) {
                cause.printStackTrace();
            }
            String title = UiLexicon.bajaui().getText("dialog.error");
            BDialog.error((BWidget)this, (String)title, (Object)msg, (Throwable)(suppressStackTrace ? null : e));
            this.repaint();
            return;
        }
        finally {
            this.exitBusy();
        }
        this.commands.updateBogCommands();
        this.commands.save.setEnabled(false);
        this.repaint();
    }

    void error(BViewTab tab, BOrd ord, Throwable e, boolean logIt) {
        String msg = null;
        if (e instanceof UnresolvedException) {
            Throwable cause = ThrowableUtil.getCause((Throwable)e);
            msg = this.exceptionToMessage(cause);
            if (msg == null) {
                msg = this.exceptionToMessage(e);
            }
        } else {
            msg = this.exceptionToMessage(e);
        }
        if (msg == null) {
            msg = UiLexicon.bajaui().getText("errorPanel.cannotHyperlink");
        }
        this.error(tab, ord, msg, e, logIt);
    }

    void error(BViewTab tab, BOrd ord, String msg, Throwable e, boolean logIt) {
        if (logIt) {
            log.log(Level.SEVERE, msg, e);
        }
        this.showStatus(msg);
        String tabName = BViewTabbedPane.toTabName(ord, null);
        BImage tabIcon = errorIcon;
        tab.fault = null;
        tab.setLabel(new BLabel(tabIcon, tabName));
        Object errorDisplay = null;
        BWbProfile profile = this.getProfile();
        if (profile != null) {
            errorDisplay = profile.makeErrorDisplay(this, msg, ord, e);
        }
        if (errorDisplay == null) {
            errorDisplay = new BErrorPanel(this, msg, ord, e);
        }
        tab.setContent((BWidget)errorDisplay);
        tab.relayout();
    }

    private String exceptionToMessage(Throwable e) {
        UiLexicon lex = UiLexicon.bajaui();
        if (e instanceof LocalizableException) {
            return e.getMessage();
        }
        if (e instanceof LocalizableRuntimeException) {
            return e.getMessage();
        }
        if (e instanceof UnresolvedException) {
            return lex.getText("errorPanel.targetNotFound");
        }
        if (e instanceof AuthenticationException) {
            return lex.getText("errorPanel.failedToAuthenticate");
        }
        if (e instanceof PermissionException) {
            return lex.getText("errorPanel.noPermission");
        }
        if (e instanceof LicenseException) {
            return lex.getText("errorPanel.license", new Object[]{e.getMessage()});
        }
        if (e instanceof ConnectException && e.getCause() instanceof SSLHandshakeException) {
            return lex.getText("errorPanel.tlsError", new Object[]{e.getCause().getMessage()});
        }
        if (e instanceof ConnectException) {
            return lex.getText("errorPanel.connect");
        }
        if (e instanceof UnknownHostException) {
            return lex.getText("errorPanel.unknownHost", new Object[]{e.getMessage()});
        }
        if (e instanceof SSLHandshakeException) {
            return lex.getText("errorPanel.tlsError", new Object[]{e.getMessage()});
        }
        return null;
    }

    public BConsole getConsole() {
        return this.pane.console;
    }

    public BConsole openConsole() {
        this.commands.console.setSelected(true);
        this.pane.console.appendBreak();
        this.relayout();
        return this.pane.console;
    }

    public BViewTab tab() {
        return this.pane.views.tab();
    }

    private static BFont incFontSize(BFont f) {
        return BFont.make((String)f.getName(), (double)(f.getSize() + 4.0), (int)f.getStyle());
    }

    public static WbHistory getWbHistory() {
        return history;
    }

    static {
        if (BGeneralOptions.make().getFontSize() == BFontSize.large) {
            PalladiumWidgetTheme.plainText = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.plainText);
            PalladiumWidgetTheme.boldText = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.boldText);
            PalladiumWidgetTheme.largeFont = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.largeFont);
            PalladiumWidgetTheme.largeBoldFont = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.largeBoldFont);
            PalladiumWidgetTheme.fixedWidth = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.fixedWidth);
            PalladiumWidgetTheme.fixedWidthBold = BNiagaraWbShell.incFontSize(PalladiumWidgetTheme.fixedWidthBold);
        }
        log = Logger.getLogger("wb.shell");
        statusDefault = "";
        errorIcon = BImage.make((String)"module://icons/x16/error.png");
        history = new WbHistory();
        lex = Lexicon.make((String)"workbench");
    }

    static class Support {
        BNiagaraWbShell shell;
        BWbProfile profile;

        Support(BNiagaraWbShell shell) {
            this.shell = shell;
            this.profile = shell.profile;
        }
    }
}

