/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.propsheet;

import com.tridium.ui.theme.PropertySheetTreeTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.propsheet.BComplexEntry;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import com.tridium.workbench.transfer.TransferUtil;
import com.tridium.workbench.util.ConfigFlagsCommand;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.nav.menu.BNavMenuAgent;

@NiagaraType
public abstract class BPropertyEntry
extends BTransferWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BPropertyEntry.class);
    static final BFont font = Theme.propertySheetTree().getTextFont();
    static final double textBaseline = font.getHeight() - font.getDescent();
    static final double EXPANDER_DIM = Theme.propertySheetTree().getExpanderHeight();
    static final double ICON_DIM = 16.0;
    static final double EXPANDER_ICON_GAP = 10.0;
    static final double ICON_NAME_GAP = 6.0;
    static final double INDENT = Math.max(Theme.propertySheetTree().getExpanderWidth() + 4.0, 20.0);
    static final BColor hyperlinkColor = BColor.make((int)0x4444BB);
    static final BColor cutColor = BColor.make((int)0x606060);
    static final double MAX_SUMMARY_WIDTH = 250.0;
    static BIcon tagIcon = BIcon.std((String)"badges/tag.png");
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    static BImage defaultTagIcon = BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"object.png"), (BIcon)tagIcon));
    static final String lexUnsubscribed = UiLexicon.make((String)"bajaui").getText("propsheet.unsubscribed");
    BFieldEditorSheet sheet;
    BComplexEntry parentEntry;
    Property property;
    String displayName;
    BObject target;
    boolean isTag;
    BImage icon;
    BImage dirtyIcon;
    BImage cutIcon;
    boolean isExpanded;
    RectGeom expander = new RectGeom(0.0, 0.0, EXPANDER_DIM, EXPANDER_DIM - 2.0);
    RectGeom label = new RectGeom();
    RectGeom content = new RectGeom();
    boolean hyperlinkActive;
    boolean dropActive;
    BMenu popup;
    boolean dirty = false;
    boolean readonly;
    boolean ignoreRelease = false;
    boolean disableHyperlink = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    BPropertyEntry() {
    }

    BPropertyEntry(BFieldEditorSheet sheet, BComplexEntry parent, Property property, BObject target) {
        this.sheet = sheet;
        this.property = property;
        this.parentEntry = parent;
        this.target = target;
        this.isTag = this.parentEntry != null && this.parentEntry.target != null && property != null ? (this.parentEntry.target instanceof BIPropertyContainer ? (((BIPropertyContainer)this.parentEntry.target).getFlags((Slot)property) & 0x4000) != 0 && property.getType().is(BIDataValue.TYPE) : (this.parentEntry.target.asComplex().getFlags((Slot)property) & 0x4000) != 0 && property.getType().is(BIDataValue.TYPE)) : target.getType().is(BIDataValue.TYPE);
        this.readonly = sheet.isReadonly();
        if (parent != null && !(target instanceof BComponent)) {
            if (parent.target instanceof BIPropertyContainer) {
                this.readonly = parent.readonly || (((BIPropertyContainer)parent.target).getFlags((Slot)property) & 1) != 0 || sheet.isReadonly();
            } else {
                boolean bl = this.readonly = parent.readonly || Flags.isReadonly((BComplex)((BComplex)parent.target), (Slot)property) || sheet.isReadonly();
            }
        }
        this.displayName = property != null ? (parent == null ? property.getDefaultDisplayName(null) : (parent.target instanceof BIPropertyContainer ? ((BIPropertyContainer)parent.target).getDisplayName((Slot)property, null) : parent.target.asComplex().getDisplayName((Slot)property, null))) : (target instanceof BIPropertyContainer ? ((BIPropertyContainer)target).getDisplayName(null) : target.asComplex().getDisplayName(null));
        if (this.displayName == null) {
            this.displayName = "";
        }
        this.reloadIcon();
        this.setCopyEnabled(true);
        this.setCutEnabled(true);
        this.setPasteEnabled(true);
        this.setDuplicateEnabled(true);
        this.setDeleteEnabled(true);
        this.setRenameEnabled(true);
    }

    int computeSizes() {
        this.computeLabelSize();
        this.computeContentSize();
        return (int)this.label.width;
    }

    double computeHeight() {
        return Math.max(font.getHeight(), Math.max(16.0, EXPANDER_DIM));
    }

    void computeLabelSize() {
        this.label.width = 22.0 + font.width(this.displayName);
        this.label.height = this.computeHeight();
    }

    void computeContentSize() {
    }

    void positionsComputed() {
    }

    public void paint(Graphics g) {
        PropertySheetTreeTheme theme = Theme.propertySheetTree();
        boolean isRoot = this.isRoot();
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(theme.getControlBackground((IStylable)this));
        g.fillRect(0.0, 0.0, w, h);
        if (isRoot) {
            g.setBrush(theme.getHeaderBackground((IStylable)this));
            g.fillRect(0.0, 0.0, w, this.getDividerY() + 2.0);
        }
        boolean cut = false;
        if (this.target.isComponent()) {
            BComponent comp = this.target.asComponent();
            cut = comp.isPendingMove();
        }
        if (this.dropActive) {
            g.setBrush(theme.getDropOkBackground((IStylable)this));
            g.fillRect(this.label.x, this.label.y, this.label.width, this.label.height);
        }
        double iconY = this.label.y + (this.computeHeight() - 16.0) / 2.0;
        if (this.dirty) {
            g.drawImage(this.dirtyIcon, this.label.x, iconY);
        } else if (cut) {
            if (this.cutIcon == null) {
                this.cutIcon = this.icon.getDisabledImage();
            }
            g.drawImage(this.cutIcon, this.label.x, iconY);
        } else {
            g.drawImage(this.icon, this.label.x, iconY);
        }
        this.paintExpander(g);
        g.setFont(font);
        double nameX = this.label.x + 16.0 + 6.0;
        double nameY = this.label.y + textBaseline;
        if (this.dropActive) {
            g.setBrush(theme.getDropOkForeground((IStylable)this));
        } else if (this.hyperlinkActive) {
            g.setBrush(hyperlinkColor);
        } else if (cut) {
            g.setBrush(cutColor);
        } else {
            g.setBrush(isRoot ? theme.getHeaderColor((IStylable)this) : theme.getTextBrush((IStylable)this));
        }
        g.drawString(this.displayName, nameX, nameY);
        this.paintContent(g);
        this.paintDivider(g);
    }

    void paintExpander(Graphics g) {
        Theme.propertySheetTree().paintExpander(g, (BWidget)this, this.expander.x, this.expander.y, this.isExpandable(), this.isExpanded);
    }

    void paintContent(Graphics g) {
    }

    void paintDivider(Graphics g) {
        g.setBrush(Theme.propertySheetTree().getDividerColor((IStylable)this));
        double divX = this.expander.x;
        double divY = this.getDividerY();
        g.strokeLine(divX, divY, this.getWidth(), divY);
    }

    private double getDividerY() {
        return this.content.y + Math.max(this.label.height, this.content.height) + 1.0;
    }

    void reloadIcon() {
        if (this.target != null) {
            this.icon = this.isTag ? BImage.make((BIcon)BIcon.make((BIcon)this.target.getIcon(), (BIcon)tagIcon)) : BImage.make((BIcon)this.target.getIcon());
        }
        if (this.icon == null) {
            this.icon = this.isTag ? defaultTagIcon : defaultIcon;
        }
    }

    boolean isRoot() {
        BPropertyEntry widget = this;
        while (widget != null) {
            if (!((widget = widget.getParentWidget()) instanceof BPropertyEntry)) continue;
            return false;
        }
        return true;
    }

    public String getStyleSelector() {
        return "tree property-sheet";
    }

    public void disableHyperlink(boolean v) {
        this.disableHyperlink = v;
    }

    boolean isHyperlinkSupported() {
        return false;
    }

    void hyperlink(BMouseEvent event) {
    }

    boolean isExpandable() {
        return true;
    }

    void toggleExpansion() {
        if (!this.isExpandable()) {
            return;
        }
        if (this.isExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    void expand() {
        if (this.isExpanded) {
            return;
        }
        this.isExpanded = true;
        this.doExpand();
        this.relayout();
        this.sheet.relayoutSync();
        RectGeom r = new RectGeom(0.0, 0.0, this.getWidth(), this.getHeight());
        this.scrollToVisible(r);
    }

    void collapse() {
        if (!this.isExpanded) {
            return;
        }
        this.isExpanded = false;
        this.doCollapse();
        this.relayout();
    }

    void doExpand() {
    }

    void doCollapse() {
    }

    public abstract void init();

    public BObject getTarget() {
        return this.target;
    }

    final void update(BObject target) {
        BObject old = this.target;
        if (old.getType() != target.getType() || target.isComponent() && old != target) {
            if (this.parentEntry != null) {
                this.parentEntry.rebuildEntry(this, target);
            }
            return;
        }
        this.doUpdate(target);
    }

    abstract void doUpdate(BObject var1);

    void setDirty() {
        if (this.dirty) {
            return;
        }
        if (this.dirtyIcon == null) {
            try {
                this.dirtyIcon = this.icon.getHighlightedImage();
            }
            catch (Exception e) {
                this.dirtyIcon = this.icon;
                e.printStackTrace();
            }
        }
        this.dirty = true;
        BWidget parent = this.getParentWidget();
        if (parent instanceof BPropertyEntry) {
            ((BPropertyEntry)parent).setDirty();
        }
        this.sheet.setModified();
        this.repaint();
    }

    final void save(Context cx) throws Exception {
        if (!this.dirty) {
            return;
        }
        try {
            this.doSave(cx);
        }
        catch (CannotSaveException e) {
            Object[] args = new Object[]{this.property.getDefaultDisplayName(null)};
            String msg = UiLexicon.bajaui().getText("plugin.saveProp.error", args) + "  " + e.getMessage();
            throw new CannotSaveException(msg, e.suppressStackTrace(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            Object[] args = new Object[]{this.property.getDefaultDisplayName(null)};
            String msg = UiLexicon.bajaui().getText("plugin.saveProp.error", args);
            throw new CannotSaveException(msg, e);
        }
        BPropertyEntry[] kids = this.getChildEntries();
        for (int i = 0; i < kids.length; ++i) {
            kids[i].save(cx);
        }
    }

    void doSave(Context cx) throws Exception {
    }

    void clearDirty() {
        this.dirty = false;
        BPropertyEntry[] kids = this.getChildEntries();
        for (int i = 0; i < kids.length; ++i) {
            kids[i].clearDirty();
        }
    }

    BPropertyEntry[] getChildEntries() {
        return (BPropertyEntry[])this.getChildren(BPropertyEntry.class);
    }

    public boolean isRegisteredForComponentEvents(BComponent c) {
        if (this.sheet.getParentWbComponentView() != null) {
            return this.sheet.getParentWbComponentView().isRegisteredForComponentEvents(c);
        }
        return false;
    }

    public void mouseEntered(BMouseEvent event) {
        this.checkMouseOver(event);
    }

    public void mouseExited(BMouseEvent event) {
        this.checkMouseOver(null);
    }

    public void mouseMoved(BMouseEvent event) {
        this.checkMouseOver(event);
    }

    public void mousePressed(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.checkMouseOver(null);
            this.doPopup(event.getX(), event.getY());
            this.ignoreRelease = true;
        } else if (this.expander.contains(event.getX(), event.getY())) {
            this.toggleExpansion();
        }
    }

    public void mouseReleased(BMouseEvent event) {
        this.setMouseCursor(MouseCursor.normal);
        if (event.isPopupTrigger()) {
            this.checkMouseOver(null);
            this.doPopup(event.getX(), event.getY());
        } else if (!this.ignoreRelease && this.hyperlinkActive) {
            this.hyperlink(event);
        }
        this.ignoreRelease = false;
    }

    void doPopup(double x, double y) {
        BPermissions perm;
        BComponent comp;
        BMenu popup = null;
        if (this.target.isComponent() && this.target.asComponent().isMounted()) {
            comp = this.target.asComponent();
            popup = BNavMenuAgent.makeFor((BObject)comp).makeMenu((BWidget)this, (BObject)comp);
        }
        if (this.parentEntry != null && this.parentEntry.target.isComponent() && this.parentEntry.target.asComponent().isMounted() && (perm = (comp = this.parentEntry.target.asComponent()).getPermissions(null)).has(32)) {
            if (popup == null) {
                popup = new BMenu();
            } else {
                popup.add(null, (BValue)new BSeparator());
            }
            popup.add("configFlags", (Command)new ConfigFlagsCommand((BWidget)this, (BIPropertyContainer)comp, (Slot)this.property));
        }
        if (popup != null) {
            popup.open((BWidget)this, x, y);
        }
    }

    void checkMouseOver(BMouseEvent event) {
        if (this.isHyperlinkSupported()) {
            boolean oldHyperlink = this.hyperlinkActive;
            if (event != null) {
                double x = event.getX();
                double y = event.getY();
                this.hyperlinkActive = this.label.contains(x, y);
            } else {
                this.hyperlinkActive = false;
            }
            if (this.hyperlinkActive != oldHyperlink) {
                MouseCursor cursor = this.hyperlinkActive ? MouseCursor.hand : MouseCursor.normal;
                this.setMouseCursor(cursor);
                this.repaint(this.label.x, this.label.y, this.label.width, this.label.height);
            }
        }
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        return TransferUtil.getTransferData(this.target);
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        return TransferUtil.insert((BWidget)this, cx, this.target, null);
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact doDuplicate() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        Mark mark = new Mark(this.target);
        BComponent parent = (BComponent)this.target.asComponent().getParent();
        if (parent == null) {
            return null;
        }
        return TransferUtil.insert((BWidget)this, 16, mark, (BObject)parent, null, null);
    }

    public CommandArtifact doDelete() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        Mark mark = new Mark(this.target);
        return TransferUtil.delete((BWidget)this, mark);
    }

    public CommandArtifact doRename() throws Exception {
        if (!this.target.isComponent()) {
            return null;
        }
        Mark mark = new Mark(this.target);
        return TransferUtil.rename((BWidget)this, mark);
    }

    public void mouseDragStarted(BMouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        if (!this.target.isComponent()) {
            return;
        }
        if (!this.label.contains(x, y)) {
            return;
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(this.icon, this.displayName);
        dragRenderer.font = font;
        dragRenderer.xCursorOffset = this.label.x - x;
        dragRenderer.yCursorOffset = this.label.y - y;
        this.startDrag(event, TransferEnvelope.make((Mark)new Mark(this.target)), (DragRenderer)dragRenderer);
    }

    public int dragOver(TransferContext cx) {
        if (!this.target.isComponent()) {
            return 0;
        }
        boolean oldDropActive = this.dropActive;
        double x = cx.getX();
        double y = cx.getY();
        this.dropActive = this.contains(x, y);
        if (oldDropActive != this.dropActive) {
            this.repaint();
        }
        if (!this.dropActive) {
            return 0;
        }
        int mask = 48;
        return mask;
    }

    public void dragExit(TransferContext cx) {
        this.dropActive = false;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (!this.dropActive) {
            return null;
        }
        this.dropActive = false;
        this.repaint();
        return TransferUtil.insert((BWidget)this, cx, this.target, null);
    }

    public UndoManager getUndoManager() {
        BWbShell wbShell = BWbShell.getWbShell(this.sheet);
        UndoManager undoManager = wbShell.getUndoManager();
        return undoManager;
    }
}

