/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pdf;

import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import java.util.ArrayList;
import javax.baja.gx.BFont;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BIWbViewExporter;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"workbench:PropertySheet", "webEditors:MultiSheet"})})
public class BPropertySheetToPdf
extends BPdfExporter
implements BIWbViewExporter {
    @Generated
    public static final Type TYPE = Sys.loadType(BPropertySheetToPdf.class);
    private static Lexicon lex = Lexicon.make((String)"pdf");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        BWbView view = (BWbView)op.get();
        BIPropertyContainer c = (BIPropertyContainer)view.getCurrentValue();
        BTable table = new BTable((TableModel)new Model(c, (Context)op));
        BLabel name = new BLabel(c.getDisplayName((Context)op));
        name.setHalign(BHalign.left);
        name.setFont(BFont.make((String)lex.getText("pdf.propertySheetToPdf.font")));
        BLabel type = new BLabel(c.getType().toString());
        type.setHalign(BHalign.left);
        String pathString = null;
        pathString = c instanceof BComponent ? ((BComponent)c).getSlotPath().toString() : "";
        BLabel path = new BLabel(pathString);
        path.setHalign(BHalign.left);
        BPdfFlowPane flow = new BPdfFlowPane();
        flow.add(null, (BValue)name);
        flow.add(null, (BValue)type);
        flow.add(null, (BValue)path);
        flow.add(null, (BValue)new BLabel(""));
        flow.add(null, (BValue)table);
        flow.setupPane();
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument((BWidget)flow, doc, op);
    }

    class Model
    extends TableModel {
        String[] cols = new String[]{"Property", "Value"};
        ArrayList<String> names = new ArrayList();
        ArrayList<String> values = new ArrayList();

        public Model(BIPropertyContainer c, Context cx) {
            SlotCursor cur = c.getProperties();
            while (cur.next()) {
                Property prop = cur.property();
                if ((c.getFlags((Slot)prop) & 4) != 0) continue;
                this.names.add(c.getDisplayName((Slot)prop, cx));
                this.values.add(c.propertyValueToString(prop, cx));
            }
        }

        public int getRowCount() {
            return this.names.size();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int col) {
            return this.cols[col];
        }

        public Object getValueAt(int row, int col) {
            return col == 0 ? this.names.get(row) : this.values.get(row);
        }
    }
}

