/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.file.util.LicenseGenerator;
import com.tridium.workbench.shell.HelpGenerator;
import com.tridium.workbench.shell.WbMain;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.tool.BWbNavNodeTool;

@NiagaraType(ordScheme="workbench")
@NiagaraSingleton
public class BWorkbenchScheme
extends BOrdScheme {
    @Generated
    public static final BWorkbenchScheme INSTANCE = new BWorkbenchScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BWorkbenchScheme.class);
    public static BObject helpAbout;
    public static BObject helpContents;
    public static BObject licenseAgreement;
    public static BObject thirdPartyLicenses;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BWorkbenchScheme() {
        super("workbench");
    }

    public OrdQuery parse(String queryBody) {
        return new WorkbenchPath(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        String path = query.getBody();
        if (path.startsWith("/help")) {
            if ("/help".equals(path)) {
                return new OrdTarget(base, (BObject)BString.DEFAULT);
            }
            if ("/help/about.html".equals(path)) {
                return new OrdTarget(base, HelpAndLicenseHolder.it.helpAbout);
            }
            if ("/help/contents.html".equals(path)) {
                return new OrdTarget(base, HelpAndLicenseHolder.it.helpContents);
            }
        }
        if (path.startsWith("/tools/")) {
            String toolName = path.substring("/tools/".length());
            int slash = toolName.indexOf(47);
            if (slash > 0) {
                toolName = toolName.substring(0, slash);
            }
            return new OrdTarget(base, (BObject)BWbNavNodeTool.make(toolName));
        }
        if (path.startsWith("/licenses/")) {
            if ("/licenses/licenseAgreement.txt".equals(path)) {
                return new OrdTarget(base, HelpAndLicenseHolder.it.licenseAgreement);
            }
            if ("/licenses/readmeLicenses.txt".equals(path)) {
                return new OrdTarget(base, HelpAndLicenseHolder.it.thirdPartyLicenses);
            }
        }
        throw new UnresolvedException(query.toString());
    }

    private static class HelpAndLicense {
        private BObject helpAbout;
        private BObject helpContents;
        private BObject licenseAgreement;
        private BObject thirdPartyLicenses;

        private HelpAndLicense() {
            block2: {
                try {
                    this.helpAbout = HelpGenerator.makeAbout();
                    this.helpContents = HelpGenerator.makeContents();
                    this.licenseAgreement = (BObject)LicenseGenerator.makeLicenseAgreement();
                    this.thirdPartyLicenses = (BObject)LicenseGenerator.makeThirdPartyLicenses();
                }
                catch (Throwable e) {
                    if (WbMain.brandTitle == null) break block2;
                    e.printStackTrace();
                }
            }
        }
    }

    private static interface HelpAndLicenseHolder {
        public static final HelpAndLicense it = new HelpAndLicense();
    }

    static class WorkbenchPath
    extends FilePath {
        WorkbenchPath(String body) {
            super("workbench", body);
        }

        public void normalize(OrdQueryList list, int index) {
            list.trim(index);
        }

        public OrdQuery makePath(String body) {
            return new WorkbenchPath(body);
        }
    }
}

