/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.json.JSONObject;
import com.tridium.nre.security.UserLoginHistory;
import com.tridium.workbench.nav.BComponentMenuAgent;
import com.tridium.workbench.util.BUserLoginHistoryDialog;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType(agent={@AgentOn(types={"baja:User"})})
@NiagaraSingleton
public class BUserMenuAgent
extends BComponentMenuAgent {
    @Generated
    public static final BUserMenuAgent INSTANCE = new BUserMenuAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BUserMenuAgent.class);
    private static final String GET_USER_LOGIN_HISTORY_AGENT_KEY_BASE = "user.loginHistory";
    private static final String GET_USER_LOGIN_HISTORY_COMMAND_NAME = "userLoginHistory";
    private static final String GET_LOGIN_HISTORY_RPC_METHOD_NAME = "getLoginHistory";
    private static final boolean UNFRIENDLY_ARGUMENT_FOR_RPC = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = super.doMakeMenu(owner, target, cx);
        if (target instanceof BUser) {
            BUser selectedUser = (BUser)target;
            BComponentSpace selectedUserComponentSpace = selectedUser.getComponentSpace();
            boolean isTargetInProxySpace = selectedUserComponentSpace != null && selectedUserComponentSpace.isProxyComponentSpace();
            boolean isTargetInUserService = selectedUser.getParent() instanceof BUserService;
            if (isTargetInProxySpace && isTargetInUserService) {
                menu.add(null, (BValue)new BSeparator());
                menu.add(GET_USER_LOGIN_HISTORY_COMMAND_NAME, (Command)new GetUserLoginHistoryCommand(owner, selectedUser, TYPE.getModule(), GET_USER_LOGIN_HISTORY_AGENT_KEY_BASE, cx));
            }
        }
        return menu;
    }

    private static final class GetUserLoginHistoryCommand
    extends Command {
        final BUser user;
        final Context context;

        GetUserLoginHistoryCommand(BWidget owner, BUser user, BModule module, String keyBase, Context context) {
            super(owner, module, keyBase);
            this.user = user;
            this.context = context;
        }

        public CommandArtifact doInvoke() throws Exception {
            FoxRpcUtil.doRpc((BISpaceNode)this.user, (String)BUserMenuAgent.GET_LOGIN_HISTORY_RPC_METHOD_NAME, (Object[])new Object[]{false}).ifPresent(loginHistoryResponse -> {
                UserLoginHistory userLoginHistory;
                if (!loginHistoryResponse.isEmpty()) {
                    List loginEntries = (List)loginHistoryResponse.get("history");
                    int maxLoginHistoryEntryCount = loginEntries == null || loginEntries.size() < 5 ? 5 : loginEntries.size();
                    userLoginHistory = new UserLoginHistory(new JSONObject((Map)loginHistoryResponse), maxLoginHistoryEntryCount);
                } else {
                    JSONObject emptyLoginHistory = new JSONObject();
                    emptyLoginHistory.put("username", (Object)this.user.getUsername());
                    emptyLoginHistory.put("history", Collections.emptyList());
                    userLoginHistory = new UserLoginHistory(emptyLoginHistory, 20);
                }
                BUserLoginHistoryDialog dialog = new BUserLoginHistoryDialog(null);
                dialog.show(userLoginHistory);
            });
            return null;
        }
    }
}

