/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.nav.BSessionAgent;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType(agent={@AgentOn(types={"fox:FoxSession"})})
@NiagaraSingleton
public class BFoxSessionAgent
extends BSessionAgent {
    @Generated
    public static final BFoxSessionAgent INSTANCE = new BFoxSessionAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxSessionAgent.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BFoxSessionAgent() {
    }

    @Override
    public void pickle(BISession session, XElem pickle) {
        BFoxSession s = (BFoxSession)session;
        pickle.addAttr("port", String.valueOf(s.getPort()));
        pickle.addAttr("websocketPort", String.valueOf(s.getRawWebsocketPort()));
        FoxConnectionTypeEnum foxConnectionType = s.getFoxConnectionType();
        pickle.addAttr("foxConnectionType", foxConnectionType.name());
        pickle.addAttr("useFoxs", foxConnectionType == FoxConnectionTypeEnum.FOXS || foxConnectionType == FoxConnectionTypeEnum.FOXS_OR_FOXWSS ? "true" : "false");
        if (s.getStationName() != null) {
            pickle.addAttr("stationName", s.getStationName());
        }
    }

    @Override
    public BISession unpickle(BHost host, XElem pickle) {
        String stationName = pickle.get("stationName", null);
        boolean useFoxs = pickle.getb("useFoxs", false);
        int defaultPort = useFoxs ? 4911 : 1911;
        int port = pickle.geti("port", defaultPort);
        int websocketPort = pickle.geti("websocketPort", -1);
        FoxConnectionTypeEnum defaultConnType = useFoxs ? FoxConnectionTypeEnum.FOXS_OR_FOXWSS : FoxConnectionTypeEnum.FOX_OR_FOXWSS;
        FoxConnectionTypeEnum foxConnectionType = FoxConnectionTypeEnum.valueOf((String)pickle.get("foxConnectionType", defaultConnType.name()));
        return BFoxSession.make((String)stationName, (BHost)host, (int)port, (FoxConnectionTypeEnum)foxConnectionType, (int)websocketPort);
    }
}

