/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.logging;

import com.tridium.logging.BILoggingService;
import com.tridium.logging.LogSettings;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.logging.BAutocompleteTextField;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"baja:ILoggingService"})})
@NiagaraActions(value={@NiagaraAction(name="handleLogLevelChanged", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4), @NiagaraAction(name="handleCategoryModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)})
public class BLoggerConfiguration
extends BWbView {
    @Generated
    public static final Action handleLogLevelChanged = BLoggerConfiguration.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action handleCategoryModified = BLoggerConfiguration.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLoggerConfiguration.class);
    private static final Lexicon lex = Lexicon.make(BLoggerConfiguration.class);
    private static final BIcon AddIcon = BIcon.std((String)"add.png");
    private static final BIcon RemoveIcon = BIcon.std((String)"subtract.png");
    private LogSettings settings;
    private final Map<String, String> logToLevel = new HashMap<String, String>();
    private final Set<String> removedLogs = new HashSet<String>();
    private static final int CategoryTextWidth = 50;
    private static final String RootAlias = "(ROOT)";
    private BGridPane addPane;
    private BAutocompleteTextField addCategory;
    private BListDropDown addLevel;
    private BButton addButton;
    private BGridPane configuredLogs;
    private final TreeSet<String> registered = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private final BList searchResults = new BList();

    @Generated
    public void handleLogLevelChanged(BWidgetEvent parameter) {
        this.invoke(handleLogLevelChanged, (BValue)parameter, null);
    }

    @Generated
    public void handleCategoryModified(BWidgetEvent parameter) {
        this.invoke(handleCategoryModified, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        BILoggingService service = (BILoggingService)value;
        this.settings = new LogSettings(service.readLogSettings());
        this.loadSearch(service);
        BEdgePane content = new BEdgePane();
        BBorderPane adderBorder = new BBorderPane(this.makeCategoryAdder(), new BLabel(this.text("addlog")));
        content.setTop((BWidget)adderBorder);
        BEdgePane ee = new BEdgePane();
        BScrollPane scroll = new BScrollPane(this.makeConfiguredLogs());
        scroll.setBorderPolicy(BScrollBarPolicy.never);
        scroll.setViewportBackground(Theme.widget().getControlBackground());
        BBorderPane border = new BBorderPane((BWidget)scroll, new BLabel(this.text("configuredLogs")));
        ee.setTop((BWidget)border);
        content.setCenter((BWidget)new BBorderPane((BWidget)ee, 10.0, 3.0, 3.0, 3.0));
        this.loadCurrentSettings();
        this.doHandleCategoryModified(null);
        BGridPane buttons = new BGridPane(2);
        buttons.setColumnAlign(BHalign.fill);
        buttons.setUniformColumnWidth(true);
        buttons.add(null, (BValue)new BButton(this.getWbShell().getRefreshCommand()));
        buttons.add(null, (BValue)new BButton(this.getWbShell().getSaveCommand()));
        content.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 5.0, 0.0, 5.0));
        this.setContent((BWidget)content);
        this.addCategory.requestFocus();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BILoggingService service = (BILoggingService)value;
        for (String string : this.removedLogs) {
            if (string.contains(":") || string.contains("=")) {
                this.settings.removeLogSettings(string.replace(":", "\\:").replace("=", "\\="));
                continue;
            }
            this.settings.removeLogSettings(string);
        }
        for (Map.Entry entry : this.logToLevel.entrySet()) {
            if (((String)entry.getKey()).contains(":") || ((String)entry.getKey()).contains("=")) {
                this.settings.setLogLevel(((String)entry.getKey()).replace(":", "\\:").replace("=", "\\="), Level.parse(((String)entry.getValue()).toString()));
                continue;
            }
            this.settings.setLogLevel((String)entry.getKey(), Level.parse(((String)entry.getValue()).toString()));
        }
        service.reload(this.settings.getRawProperties());
        this.removedLogs.clear();
        return value;
    }

    private void loadCurrentSettings() {
        List declared = this.settings.getDeclaredLogs();
        for (String log : declared) {
            Level level = this.settings.getLogLevel(log);
            if (level == null) {
                throw new IllegalStateException(log + " is not configured with a level");
            }
            this.addConfiguredLog(log, level.getName());
        }
    }

    private void addConfiguredLog(String logName, String level) {
        this.configuredLogs.add(this.toLogPropertyName(logName), (BValue)this.makeConfiguredLogSlice(logName, level));
        this.logToLevel.put(logName, level);
        Property[] logs = this.configuredLogs.getDynamicPropertiesArray();
        Arrays.sort(logs, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.configuredLogs.reorder(logs);
    }

    private void removeConfiguredLog(String logName) {
        this.logToLevel.remove(logName);
        this.removedLogs.add(logName);
        this.configuredLogs.remove(this.toLogPropertyName(logName));
    }

    private String toLogPropertyName(String logName) {
        return SlotPath.escape((String)("log_" + logName));
    }

    public void doHandleLogLevelChanged(BWidgetEvent event) {
        BListDropDown level = (BListDropDown)event.getWidget();
        this.logToLevel.put(level.get("logname").toString(), level.getSelectedItem().toString());
        this.setModified();
    }

    public void doHandleCategoryModified(BWidgetEvent event) {
        String name = this.addCategory.getText();
        boolean isValid = !name.endsWith(".") && !this.logToLevel.containsKey(name);
        this.addButton.setEnabled(isValid);
    }

    private BWidget makeCategoryAdder() {
        BLabel label = new BLabel(this.text("logname"));
        label.setFont(Theme.widget().getBoldText());
        label.setHalign(BHalign.left);
        this.addCategory = new BAutocompleteTextField("", 50);
        this.addCategory.setController(new CompletionController());
        this.linkTo((BComponent)this.addCategory, (Slot)BTextField.textModified, (Slot)handleCategoryModified);
        this.addLevel = this.makeLevelDropDown(Level.INFO.getName());
        BGridPane g = new BGridPane(3);
        g.setColumnGap(5.0);
        g.setHalign(BHalign.left);
        g.add(null, (BValue)label);
        g.add(null, (BValue)this.addCategory);
        g.add(null, (BValue)this.addLevel);
        this.addPane = g;
        BEdgePane a = new BEdgePane();
        a.setLeft((BWidget)g);
        this.addButton = this.makeSmallButton(new AddCategory(this), null);
        a.setRight((BWidget)this.addButton);
        BBorderPane top = new BBorderPane((BWidget)a, BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowGap(0.0);
        grid.add(null, (BValue)top);
        return this.makeInset((BWidget)grid);
    }

    private BListDropDown makeLevelDropDown(String select) {
        BListDropDown levels = new BListDropDown();
        levels.getList().addItem((Object)Level.OFF.getName());
        levels.getList().addItem((Object)Level.SEVERE.getName());
        levels.getList().addItem((Object)Level.WARNING.getName());
        levels.getList().addItem((Object)Level.INFO.getName());
        levels.getList().addItem((Object)Level.CONFIG.getName());
        levels.getList().addItem((Object)Level.FINE.getName());
        levels.getList().addItem((Object)Level.FINER.getName());
        levels.getList().addItem((Object)Level.FINEST.getName());
        levels.getList().addItem((Object)Level.ALL.getName());
        for (int i = 0; i < levels.getList().getItemCount(); ++i) {
            if (!levels.getList().getItem(i).equals(select)) continue;
            levels.getList().getSelection().select(i);
            break;
        }
        return levels;
    }

    private BWidget makeConfiguredLogs() {
        this.configuredLogs = new BGridPane(1);
        this.configuredLogs.setStretchColumn(0);
        this.configuredLogs.setColumnAlign(BHalign.fill);
        this.configuredLogs.setRowGap(0.0);
        return this.configuredLogs;
    }

    private BWidget makeConfiguredLogSlice(String category, String select) {
        String logName = category.equals("") ? RootAlias : category;
        BTextField log = new BTextField(logName, 50, false);
        BListDropDown level = this.makeLevelDropDown(select);
        level.add("logname", (BValue)BString.make((String)category));
        this.linkTo((BComponent)level, (Slot)BDropDown.valueModified, (Slot)handleLogLevelChanged);
        BGridPane g = new BGridPane(2);
        g.setColumnGap(5.0);
        g.setHalign(BHalign.left);
        g.add(null, (BValue)log);
        g.add(null, (BValue)level);
        BEdgePane e = new BEdgePane();
        e.setLeft((BWidget)g);
        if (!logName.equals(RootAlias)) {
            e.setRight((BWidget)this.makeSmallButton(new RemoveCategory(this, category), null));
        }
        return new BBorderPane((BWidget)e, BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
    }

    private void loadSearch(BILoggingService service) {
        for (String logName : service.getRegisteredLoggers()) {
            int last = logName.length();
            while (last > 0) {
                this.registered.add(logName.substring(0, last));
                last = logName.lastIndexOf(46, last - 1);
            }
        }
        this.searchResults.setController((ListController)new ResultController());
        this.searchResults.setMultipleSelection(false);
    }

    String text(String s) {
        return lex.getText("loggerConfiguration." + s);
    }

    BButton makeSmallButton(Command command, BColor fill) {
        BButton b = new BButton(command);
        b.setButtonStyle(BButtonStyle.toolBar);
        if (fill != null) {
            b.setBackground(fill.toBrush());
        }
        return b;
    }

    private BWidget makeInset(BWidget content) {
        BBorderPane pane = new BBorderPane(content, BBorder.make((String)"1px solid black"), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        return new BBorderPane((BWidget)pane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    class RemoveCategory
    extends Command {
        final String logName;

        public RemoveCategory(BWidget owner, String logName) {
            super(owner, "", BImage.make((BIcon)RemoveIcon), null, "Remove the category from the log configuration");
            this.logName = logName;
        }

        public CommandArtifact doInvoke() throws Exception {
            BLoggerConfiguration.this.removeConfiguredLog(this.logName);
            BLoggerConfiguration.this.setModified();
            return super.doInvoke();
        }
    }

    class AddCategory
    extends Command {
        public AddCategory(BWidget owner) {
            super(owner, "", BImage.make((BIcon)AddIcon), null, "Add category to log configuration");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BLoggerConfiguration.this.logToLevel.containsKey(BLoggerConfiguration.this.addCategory.getText())) {
                return null;
            }
            BLoggerConfiguration.this.addConfiguredLog(BLoggerConfiguration.this.addCategory.getText(), BLoggerConfiguration.this.addLevel.getSelectedItem().toString());
            BLoggerConfiguration.this.setModified();
            BLoggerConfiguration.this.addCategory.setText("");
            return super.doInvoke();
        }
    }

    class ResultController
    extends ListController {
        ResultController() {
        }

        public void keyPressed(BKeyEvent event) {
            int code = event.getKeyCode();
            if (38 == code) {
                if (this.getSelection().getItem() == 0) {
                    BLoggerConfiguration.this.addCategory.requestFocus();
                }
                super.keyPressed(event);
            } else if (10 == code || 9 == code) {
                this.autoCompleteTextSelect();
                event.consume();
            } else if (27 == code) {
                BLoggerConfiguration.this.addCategory.requestFocus();
                BLoggerConfiguration.this.addCategory.moveCaretPosition(BLoggerConfiguration.this.addCategory.getModel().getEndPosition());
                event.consume();
            } else {
                super.keyPressed(event);
            }
        }

        protected void itemPressed(BMouseEvent event, int index) {
            super.itemPressed(event, index);
            if (event.getClickCount() == 2) {
                this.autoCompleteTextSelect();
                event.consume();
            }
        }

        private void autoCompleteTextSelect() {
            if (UiEnv.get().isPopupOpen((BWidget)BLoggerConfiguration.this.searchResults)) {
                UiEnv.get().closePopup((BWidget)BLoggerConfiguration.this.searchResults);
            }
            BLoggerConfiguration.this.addCategory.setText(BLoggerConfiguration.this.searchResults.getSelectedItem().toString());
            BLoggerConfiguration.this.addCategory.moveCaretPosition(BLoggerConfiguration.this.addCategory.getModel().getEndPosition());
            BLoggerConfiguration.this.addCategory.getSelection().deselect();
            BLoggerConfiguration.this.addCategory.requestFocus();
            ((CompletionController)BLoggerConfiguration.this.addCategory.getController()).updateCandidates();
        }
    }

    class CompletionController
    extends TextController {
        CompletionController() {
        }

        public void focusGained(BFocusEvent event) {
            this.getEditor().setCaretBlinking(true);
        }

        public void focusLost(BFocusEvent event) {
            this.getEditor().setCaretBlinking(false);
        }

        public void keyPressed(BKeyEvent event) {
            int code = event.getKeyCode();
            if (40 == code) {
                if (UiEnv.get().isPopupOpen((BWidget)BLoggerConfiguration.this.searchResults)) {
                    BLoggerConfiguration.this.searchResults.setSelectedIndex(0);
                    BLoggerConfiguration.this.searchResults.requestFocus();
                    event.consume();
                }
            } else if (9 == code) {
                this.doTab();
                event.consume();
            } else if (10 == code) {
                event.consume();
                BLoggerConfiguration.this.addButton.invokeAction();
            } else {
                super.keyPressed(event);
            }
        }

        public void keyTyped(BKeyEvent event) {
            super.keyTyped(event);
            this.updateCandidates();
        }

        void doTab() {
            if (BLoggerConfiguration.this.searchResults.getItemCount() == 0) {
                return;
            }
            BLoggerConfiguration.this.addCategory.setText(BLoggerConfiguration.this.searchResults.getItem(0).toString());
            BLoggerConfiguration.this.addCategory.moveCaretPosition(this.getModel().getEndPosition());
            this.updateCandidates();
        }

        void updateCandidates() {
            boolean isOpen = UiEnv.get().isPopupOpen((BWidget)BLoggerConfiguration.this.searchResults);
            BLoggerConfiguration.this.searchResults.removeAllItems();
            String text = BLoggerConfiguration.this.addCategory.getText();
            if (text.length() > 0) {
                String limit = text.substring(0, text.length() - 1);
                limit = limit + (char)(text.charAt(text.length() - 1) + '\u0001');
                for (String item : BLoggerConfiguration.this.registered.subSet(text, true, limit, false)) {
                    if (item.equals(text)) continue;
                    BLoggerConfiguration.this.searchResults.addItem((Object)item);
                }
            }
            if (BLoggerConfiguration.this.searchResults.getItemCount() == 0) {
                if (isOpen) {
                    UiEnv.get().closePopup((BWidget)BLoggerConfiguration.this.searchResults);
                }
                BLoggerConfiguration.this.searchResults.getSelection().deselectAll();
                return;
            }
            BLoggerConfiguration.this.searchResults.computePreferredSize();
            double x = BLoggerConfiguration.this.addCategory.getX();
            double y = BLoggerConfiguration.this.addCategory.getY() + BLoggerConfiguration.this.addCategory.getHeight();
            if (!isOpen) {
                double fixedHeight = 15.0 * BLoggerConfiguration.this.addCategory.getHeight();
                UiEnv.get().openPopup((BWidget)BLoggerConfiguration.this.searchResults, (BWidget)BLoggerConfiguration.this.addPane, x, y, BLoggerConfiguration.this.addCategory.getWidth(), fixedHeight);
                BLoggerConfiguration.this.addCategory.requestFocus();
            }
        }
    }
}

