/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.job;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.job.JobEvent;
import com.tridium.workbench.job.JobListener;
import com.tridium.workbench.job.JobMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BHost;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;

@NiagaraType
public class BJobMonitorPane
extends BEdgePane
implements JobListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BJobMonitorPane.class);
    static BImage image = BImage.make((String)"module://icons/x16/close.png");
    static BBorder headerBorder = BBorder.make((String)"bottom(solid 1 black)");
    static BInsets headerInsets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
    static BBorder border = BBorder.make((String)"bottom(solid 1 #ccc)");
    static BInsets insets = BInsets.make((double)2.0, (double)5.0, (double)2.0, (double)5.0);
    BGridPane list = new BGridPane(1);
    HashMap<BJob, BJobBar> barByJob = new HashMap();
    BJobService filterService;
    private static final Lexicon LEX = Lexicon.make((String)"workbench");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BJobMonitorPane() {
        this.list.setRowGap(0.0);
        this.list.setStretchColumn(0);
        this.list.setColumnAlign(BHalign.fill);
        this.list.setValign(BValign.top);
        BScrollPane scrollPane = new BScrollPane((BWidget)this.list);
        StyleUtils.addStyleClass((IStylable)scrollPane, (String)"sidebar-body");
        this.setCenter((BWidget)scrollPane);
    }

    public void started() throws Exception {
        super.started();
        JobMonitor.get().addListener(this);
        this.reload();
    }

    public void stopped() throws Exception {
        super.stopped();
        JobMonitor.get().removeListener(this);
    }

    @Override
    public void jobEvent(JobEvent event) {
        if (event.getId() == 5) {
            BJobBar bar = this.barByJob.get(event.getJob());
            if (bar != null) {
                bar.handleComponentEvent(event.getComponentEvent());
            }
        } else {
            this.reload();
        }
    }

    public void reload() {
        this.list.removeAll();
        this.barByJob.clear();
        BJobService[] services = JobMonitor.get().list();
        int n = 0;
        for (int i = 0; i < services.length; ++i) {
            String label;
            BJobService service = services[i];
            BJob[] jobs = services[i].getJobs();
            if (jobs.length == 0 || this.filterService != null && this.filterService != service) continue;
            try {
                BHost host = service.getHost();
                BFoxSession session = (BFoxSession)service.getSession();
                label = session.getStationName() + " on " + host.getNavDisplayName(null);
            }
            catch (Exception e) {
                label = service.getNavOrd().toString();
            }
            BLabel station = new BLabel(label);
            station.setFont(Theme.widget().getBoldText());
            BButton button = new BButton((Command)new CloseAll((BWidget)this, service));
            button.setButtonStyle(BButtonStyle.toolBar);
            BEdgePane top = new BEdgePane();
            top.setLeft((BWidget)station);
            top.setRight((BWidget)button);
            BBorderPane bp = new BBorderPane((BWidget)top, headerBorder, headerInsets);
            bp.setFill(Theme.widget().getControlBackground());
            this.list.add("label" + i, (BValue)bp);
            for (int j = 0; j < jobs.length; ++j) {
                BJob job = jobs[j];
                BJobBar bar = BJobBar.makeFor(job);
                bar.load(job);
                this.barByJob.put(job, bar);
                this.list.add("bar" + n, (BValue)new BBorderPane((BWidget)bar, border, insets));
                ++n;
            }
        }
    }

    class CloseAll
    extends Command {
        BJobService service;

        public CloseAll(BWidget owner, BJobService service) {
            super(owner, "");
            this.service = service;
        }

        public BImage getIcon() {
            return image;
        }

        public CommandArtifact doInvoke() {
            ArrayList<BJob> jobList = new ArrayList<BJob>();
            BJob[] jobs = this.service.getJobs();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < jobs.length; ++i) {
                if (jobs[i].getJobState().isRunning()) continue;
                jobList.add(jobs[i]);
                if (jobs[i].getDisposalAction() == null) continue;
                sb.append(jobs[i].getDisposalAction());
            }
            String disposalActions = sb.toString();
            if (disposalActions.isEmpty() || 4 == this.openDisposeActionDialog(disposalActions)) {
                jobList.forEach(job -> job.dispose());
            }
            return null;
        }

        private int openDisposeActionDialog(String disposalActions) {
            BLabel dlgMessageLabel = new BLabel(LEX.getText("JobServiceManager.disposeCommand.dlgMessage", new Object[]{disposalActions}), BHalign.left);
            BScrollPane pane = new BScrollPane((BWidget)dlgMessageLabel);
            pane.setViewportBackground(Theme.scrollPane().getControlBackground());
            return BDialog.open((BWidget)this.getOwner(), (String)LEX.get("JobServiceManager.disposeCommand.dlgTitle"), (Object)pane, (int)12, (BImage)BDialog.QUESTION_ICON, (String)null);
        }
    }
}

