/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.export.impl.destination.BFileDestinationType;
import com.tridium.export.impl.provider.BExporterTransformer;
import com.tridium.export.ui.impl.destination.BViewInExternalApplicationDestinationType;
import com.tridium.workbench.export.WorkbenchExportContext;
import com.tridium.workbench.export.destination.BViewInWorkbenchDestinationType;
import com.tridium.workbench.export.provider.BWorkbenchTransformOperationProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.export.BIExportDestinationType;
import javax.baja.export.BITransformOperation;
import javax.baja.file.BExporter;
import javax.baja.file.BajaFileUtil;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.function.RunnableCanThrowException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.transform.BITransformer;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraAction(name="exporterModified", flags=4)
public class BExportDialog
extends BEdgePane {
    @Generated
    public static final Action exporterModified = BExportDialog.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExportDialog.class);
    private static final BImage ICON = BImage.make((String)"module://icons/x32/export.png");
    private static final UiLexicon LEX = UiLexicon.bajaui();
    private static final AgentFilter IS_WB_VIEW = AgentFilter.is((TypeInfo)BWbView.TYPE.getTypeInfo());
    private final BWidget owner;
    private final BWbView view;
    private final ExporterCommand actionViewInternal = new ExporterCommand(BViewInWorkbenchDestinationType.INSTANCE);
    private final ExporterCommand actionViewExternal = new ExporterCommand((BIExportDestinationType)BViewInExternalApplicationDestinationType.INSTANCE);
    private final ExporterCommand actionSave = new ExporterCommand((BIExportDestinationType)BFileDestinationType.INSTANCE, LEX.get("exporter.action.save.label")){

        @Override
        protected void doExport() throws IOException {
            if (BExportDialog.this.userWantsToCreateFile()) {
                super.doExport();
            }
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BExportDialog.this.saveOrd.setEditable(this.isSelected());
            BExportDialog.this.saveBrowse.setEnabled(this.isSelected());
        }
    };
    private final BajaFileUtil.BajaFileWriter fileWriter = BajaFileUtil.getDefaultFileWriter();
    private final ToggleCommandGroup<ExporterCommand> actionGroup = new ToggleCommandGroup();
    private final BListDropDown exporterField = new BListDropDown();
    private final Command saveBrowse = new SaveBrowse((BWidget)this);
    private final BTextField saveOrd = new BTextField("", 55, false);
    private final BBorderPane setupPane = new BBorderPane();
    private final List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> transformOps;
    private BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext> selectedTransformOp;
    private BWbEditor setup;
    private static final Object executorMon = new Object();
    private static volatile ExecutorService executorSrv;
    private int lastIndex = -1;

    @Generated
    public void exporterModified() {
        this.invoke(exporterModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static boolean hasExporters(BWbShell shell) {
        WorkbenchExportContext cx;
        BWbView view = shell.getActiveView();
        OrdTarget target = shell.getActiveOrdTarget();
        return BWorkbenchTransformOperationProvider.INSTANCE.getTransformOperations(target, cx = new WorkbenchExportContext(shell.getProfile(), view, (BWidget)shell, null)).size() > 0;
    }

    public static CommandArtifact invoke(BWbShell shell, boolean asPrint) throws Exception {
        BWbView view = shell.getActiveView();
        OrdTarget target = shell.getActiveOrdTarget();
        return new BExportDialog((BWidget)shell, target, view, asPrint).invoke();
    }

    public static CommandArtifact invoke(BWidget owner, BITable<BIObject> table, boolean asPrint) throws Exception {
        OrdTarget target = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)table, (Context)table.getTableFacets());
        return new BExportDialog(owner, target, null, asPrint).invoke();
    }

    public static CommandArtifact invoke(BWidget owner, BOrd exportOrd, boolean asPrint) throws Exception {
        OrdTarget target = exportOrd.resolve();
        return new BExportDialog(owner, target, null, asPrint).invoke();
    }

    private CommandArtifact invoke() throws Exception {
        while (true) {
            int r;
            if ((r = BDialog.open((BWidget)this.owner, (String)LEX.get("export", "Export"), (Object)((Object)this), (int)3)) != 1) {
                return null;
            }
            try {
                this.setup.saveValue();
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.owner, (String)LEX.get("exporter.setup.cannotSave", "Cannot save setup"), (Object)e);
                continue;
            }
            break;
        }
        ((ExporterCommand)this.actionGroup.getSelected()).doExport();
        return null;
    }

    private boolean userWantsToCreateFile() {
        if (this.fileWriter.exists(this.getUserSelectedFileOrd(), null)) {
            return 4 == BDialog.confirm((BWidget)this.owner, (Object)LEX.get("fileChooser.fileExistsPrompt", "File already exists.  Do you want to overwrite?"));
        }
        return true;
    }

    private BOrd getUserSelectedFileOrd() {
        String fileOrd = this.saveOrd.getText();
        String ext = this.getCurrentExporter().getFileExtension();
        if (!fileOrd.endsWith('.' + ext)) {
            fileOrd = fileOrd + '.' + ext;
        }
        return BOrd.make((String)fileOrd);
    }

    private BExportDialog(BWidget owner, OrdTarget target, BWbView view, boolean asPrint) throws LocalizableException {
        this.owner = owner;
        this.view = view;
        this.transformOps = this.findTransformOps(this.getProfile(), target);
        if (this.transformOps.isEmpty()) {
            throw new LocalizableException((Lexicon)LEX, "exporter.noExporters");
        }
        this.setTop((BWidget)new BWizardHeader(ICON, LEX.getText("commands.export.label")));
        BTabbedPane tabs = new BTabbedPane();
        tabs.addPane(LEX.getText("exporter.action"), this.buildAction());
        tabs.addPane(LEX.getText("exporter.setup"), (BWidget)this.setupPane);
        this.setCenter((BWidget)new BBorderPane((BWidget)tabs));
        int index = asPrint ? this.getIndexOfFirstPdfExporter() : 0;
        this.exporterField.getList().setSelectedIndex(index);
        this.doExporterModified();
    }

    private static BExportDialog make(BWidget owner, OrdTarget target, BWbView view, boolean asPrint) throws LocalizableException {
        return new BExportDialog(owner, target, view, asPrint);
    }

    private BExporter getCurrentExporter() {
        return ((BExporterTransformer)this.selectedTransformOp.getTransformer()).getExporter();
    }

    private BWbProfile getProfile() {
        BWbShell shell = this.getWbShell();
        return shell == null ? new BWbProfile() : shell.getProfile();
    }

    private BWbShell getWbShell() {
        return BWbShell.getWbShell(this.owner);
    }

    private BWidget buildAction() {
        BGridPane pane = new BGridPane(1);
        pane.setValign(BValign.top);
        pane.setHalign(BHalign.left);
        pane.add(null, (BValue)this.buildExporterPane());
        this.updateFromSelectedTransformOp();
        pane.add(null, (BValue)new BBorderPane((BWidget)this.buildExportDestinationPane(), 10.0, 0.0, 0.0, 0.0));
        return new BBorderPane((BWidget)pane);
    }

    private BGridPane buildExporterPane() {
        for (BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext> item : this.transformOps) {
            BITransformer transformer = item.getTransformer();
            this.exporterField.getList().addItem(BImage.make((BIcon)transformer.getIcon(null)), (Object)transformer.getDisplayName(null));
        }
        BGridPane exporterPane = new BGridPane(2);
        exporterPane.add(null, (BValue)new BLabel(LEX.getText("exporter.select.exporter")));
        exporterPane.add(null, (BValue)this.exporterField);
        this.linkTo("lk0", (BComponent)this.exporterField, (Slot)BListDropDown.valueModified, (Slot)exporterModified);
        return exporterPane;
    }

    public void doExporterModified() {
        this.updateFromSelectedTransformOp();
    }

    private BGridPane buildExportDestinationPane() {
        BGridPane actionPane = new BGridPane(1);
        WorkbenchExportContext cx = this.makeExportContext();
        ArrayList<ExporterCommand> destinationCmds = new ArrayList<ExporterCommand>();
        this.addDestination(destinationCmds, this.actionSave, cx);
        this.addDestination(destinationCmds, this.actionViewExternal, cx);
        this.addDestination(destinationCmds, this.actionViewInternal, cx);
        this.addDestinationsFromRegistry(destinationCmds, cx);
        Collections.reverse(destinationCmds);
        for (ExporterCommand cmd : destinationCmds) {
            this.actionGroup.add((ToggleCommand)cmd);
            actionPane.add(null, (BValue)new BRadioButton((ToggleCommand)cmd));
        }
        this.actionViewExternal.setSelected(true);
        BEdgePane savePane = new BEdgePane();
        savePane.setRight((BWidget)new BButton(this.saveBrowse));
        actionPane.setColumnAlign(BHalign.fill);
        actionPane.add(null, (BValue)new BBorderPane((BWidget)this.saveOrd, 0.0, 0.0, 0.0, 20.0));
        actionPane.add(null, (BValue)new BBorderPane((BWidget)savePane, 0.0, 0.0, 0.0, 20.0));
        return actionPane;
    }

    private void addDestination(List<ExporterCommand> exporterCommands, ExporterCommand cmd, WorkbenchExportContext cx) {
        if (BIExportDestinationType.isValid((BIExportDestinationType)cmd.destination, (Context)cx) && !exporterCommands.contains((Object)cmd)) {
            exporterCommands.add(cmd);
        }
    }

    private void addDestinationsFromRegistry(List<ExporterCommand> exporterCommands, WorkbenchExportContext cx) {
        for (BIExportDestinationType<? super WorkbenchExportContext> destination : BExportDialog.getDestinationsFromRegistry()) {
            this.addDestination(exporterCommands, new ExporterCommand((BIExportDestinationType)destination), cx);
        }
    }

    private static List<BIExportDestinationType<? super WorkbenchExportContext>> getDestinationsFromRegistry() {
        return Arrays.stream(Sys.getRegistry().getTypes(BIExportDestinationType.TYPE.getTypeInfo())).filter(type -> !type.isAbstract()).map(type -> (BIExportDestinationType)type.getInstance()).collect(Collectors.toList());
    }

    private WorkbenchExportContext makeExportContext() {
        return new WorkbenchExportContext(this.getProfile(), this.view, this.owner, (Context)BFacets.make((String)"fileExtension", (BIDataValue)BString.make((String)this.getCurrentExporter().getFileExtension()), (String)"fileOrd", (BIDataValue)this.getUserSelectedFileOrd()));
    }

    private List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> findTransformOps(BWbProfile profile, OrdTarget target) {
        WorkbenchExportContext cx = new WorkbenchExportContext(profile, this.view, this.owner, null);
        return BWorkbenchTransformOperationProvider.INSTANCE.getTransformOperations(target, cx);
    }

    private int getIndexOfFirstPdfExporter() {
        for (int i = 0; i < this.transformOps.size(); ++i) {
            if (!"application/pdf".equals(this.transformOps.get(i).getTransformer().getMimeType())) continue;
            return i;
        }
        return 0;
    }

    private void updateTransformOp(BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext> item) {
        try {
            this.selectedTransformOp = item;
            AgentList viewAgents = this.getCurrentExporter().getAgents().filter(IS_WB_VIEW);
            this.setup = (BWbEditor)viewAgents.getDefault().getInstance();
            BExporter exporter = this.getCurrentExporter();
            exporter.fw(407, (Object)exporter, this.selectedTransformOp.getTransformedObject(), (Object)this.view, (Object)this);
            this.setup.loadValue((BObject)exporter);
            this.setupPane.setContent((BWidget)this.setup);
            this.actionViewInternal.setEnabled(viewAgents.size() > 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setup = null;
            this.setupPane.setContent((BWidget)new BLabel("ERROR"));
        }
    }

    private void updateFromSelectedTransformOp() {
        int index = this.exporterField.getList().getSelectedIndex();
        if ((index = Math.max(index, 0)) != this.lastIndex) {
            this.lastIndex = index;
            this.updateTransformOp(this.transformOps.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void post(Runnable todo) {
        Object object = executorMon;
        synchronized (object) {
            if (executorSrv == null) {
                executorSrv = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "ExportDialogThread"));
            }
        }
        executorSrv.submit(todo);
    }

    private class SaveBrowse
    extends Command {
        SaveBrowse(BWidget owner) {
            super(owner, (Lexicon)LEX, "exporter.save.browse");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCreateFileOnSave(false);
            chooser.setConfirmOverwrite(false);
            BOrd ord = chooser.show();
            if (ord != null) {
                ord = ord.relativizeToSession();
                BExportDialog.this.saveOrd.setText(ord.toString());
            }
            return null;
        }
    }

    private class ExporterCommand
    extends ToggleCommand {
        private final BIExportDestinationType<? super WorkbenchExportContext> destination;

        private ExporterCommand(BIExportDestinationType<? super WorkbenchExportContext> destination) {
            this(destination, destination.getDisplayName(null));
        }

        private ExporterCommand(BIExportDestinationType<? super WorkbenchExportContext> destination, String label) {
            super((BWidget)BExportDialog.this, label);
            this.destination = destination;
        }

        protected void doExport() throws IOException {
            this.showProgressUntilDone((RunnableCanThrowException<Exception>)((RunnableCanThrowException)() -> this.destination.transform(BExportDialog.this.selectedTransformOp, (Context)BExportDialog.this.makeExportContext())));
        }

        private void showProgressUntilDone(RunnableCanThrowException<Exception> r) {
            BExportDialog.post(() -> BProgressDialog.openIndeterminate((BWidget)BExportDialog.this.owner, (String)LEX.get("pleaseWait", "Please wait"), dlg -> {
                try {
                    r.run();
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
                return null;
            }));
        }

        public boolean equals(Object o) {
            return o instanceof ExporterCommand && ((ExporterCommand)((Object)o)).destination == this.destination;
        }

        public int hashCode() {
            return this.destination.hashCode();
        }
    }
}

