/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"baja:Status"})})
public class BStatusFE
extends BWbFieldEditor
implements Comparator<Item> {
    @Generated
    public static final Type TYPE = Sys.loadType(BStatusFE.class);
    private static final int MIN_VISIBLE_COLUMNS = 20;
    private static final int ALL_STATUSES = 255;
    private static final boolean NOT_EDITABLE = false;
    private List<Item> items;
    private BStatus status = BStatus.ok;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.rebuild();
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        this.status = (BStatus)value;
        this.rebuild();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) {
        int bits = 0;
        for (Item item : this.items) {
            bits = item.save(bits);
        }
        return BStatus.make((int)bits);
    }

    private void rebuild() {
        if (this.isReadonly()) {
            String text = this.status.toString();
            if (this.getContent() instanceof BTextField) {
                BTextField textField = (BTextField)this.getContent();
                textField.setText(text);
            } else {
                int visibleColumns = Math.max(text.length(), 20);
                BTextField textField = new BTextField(text, visibleColumns, false);
                this.setContent((BWidget)textField);
            }
            this.items = null;
            return;
        }
        if (this.items == null) {
            Context context = this.getCurrentContext();
            int statusFilter = context != null ? context.getFacets().geti("filter", 255) : 255;
            int[] ordinals = BStatus.ok.getOrdinals();
            this.items = new ArrayList<Item>(ordinals.length);
            for (int ordinal : ordinals) {
                if ((statusFilter & ordinal) == 0) continue;
                this.items.add(new Item(ordinal));
            }
            this.items.sort(this);
            BGridPane pane = new BGridPane(this.items.size());
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = this.items.get(i);
                pane.add("c" + i, (BValue)item.checkBox);
                this.linkTo("lk" + i, (BComponent)item.checkBox, (Slot)BAbstractButton.actionPerformed, (Slot)setModified);
            }
            this.setContent((BWidget)pane);
        }
        for (Item item : this.items) {
            item.load(this.status.getBits());
        }
    }

    @Override
    public int compare(Item x, Item y) {
        return Integer.compare(x.ordinal, y.ordinal);
    }

    static class Item {
        public final int ordinal;
        public final BCheckBox checkBox;

        public Item(int ordinal) {
            this.ordinal = ordinal;
            this.checkBox = new BCheckBox(BStatus.ok.getDisplayTag(ordinal, null));
        }

        public void load(int bits) {
            this.checkBox.setSelected((bits & this.ordinal) != 0);
        }

        public int save(int bits) {
            return this.checkBox.isSelected() ? bits | this.ordinal : bits & ~this.ordinal;
        }
    }
}

