/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.fieldeditors.BMultiFieldFE;
import java.util.ArrayList;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.workbench.CannotSaveException;

@NiagaraType(agent={@AgentOn(types={"baja:RelTime"})})
public class BRelTimeFE
extends BMultiFieldFE {
    @Generated
    public static final Type TYPE = Sys.loadType(BRelTimeFE.class);
    private final BMultiFieldFE.Field bigHour;
    private final BMultiFieldFE.Field regularHour;
    private final BMultiFieldFE.Field day;
    private final BMultiFieldFE.Field minute;
    private final BMultiFieldFE.Field second;
    private final BMultiFieldFE.Field millisecond;
    private final BMultiFieldFE.Field sign;
    private long min = Long.MIN_VALUE;
    private long max = Long.MAX_VALUE;
    private String range = "";
    public static final String SHOW_DAY = "showDay";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRelTimeFE() {
        this.bigHour = new BMultiFieldFE.BigHourField();
        this.minute = new BMultiFieldFE.MinuteField();
        this.second = new BMultiFieldFE.SecondField();
        this.regularHour = new BMultiFieldFE.Field(){

            @Override
            int length() {
                return 2;
            }

            @Override
            int max() {
                return 23;
            }
        };
        this.millisecond = new BMultiFieldFE.MillisecondField();
        this.day = new BMultiFieldFE.Field(){

            @Override
            int length() {
                return 3;
            }

            @Override
            int max() {
                return 999;
            }
        };
        this.sign = new BMultiFieldFE.Field(){

            @Override
            String string() {
                return this.value == 0 ? "+" : "-";
            }

            @Override
            int length() {
                return 1;
            }

            @Override
            int max() {
                return 1;
            }
        };
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        this.min = Long.MIN_VALUE;
        this.max = Long.MAX_VALUE;
        long t = ((BRelTime)value).getMillis();
        if (cx == null) {
            this.fields = new BMultiFieldFE.Field[]{this.sign, this.bigHour, new BMultiFieldFE.LabelField("h "), this.minute, new BMultiFieldFE.LabelField("m "), this.second, new BMultiFieldFE.LabelField("."), this.millisecond, new BMultiFieldFE.LabelField("s")};
        } else {
            BRelTime maxFacet;
            BRelTime minFacet = (BRelTime)cx.getFacet("min");
            if (minFacet != null) {
                this.min = minFacet.getMillis();
            }
            if ((maxFacet = (BRelTime)cx.getFacet("max")) != null) {
                this.max = maxFacet.getMillis();
            }
            ArrayList<BMultiFieldFE.Field> fieldsList = new ArrayList<BMultiFieldFE.Field>();
            if (this.min < 0L || t < 0L) {
                fieldsList.add(this.sign);
            }
            if (BRelTimeFE.getContextShowDays(cx)) {
                fieldsList.add(this.day);
                fieldsList.add(new BMultiFieldFE.LabelField("d "));
                fieldsList.add(this.regularHour);
            } else {
                fieldsList.add(this.bigHour);
            }
            fieldsList.add(new BMultiFieldFE.LabelField("h "));
            fieldsList.add(this.minute);
            fieldsList.add(new BMultiFieldFE.LabelField("m"));
            if (BRelTimeFE.getBooleanFacetValue(cx, "showSeconds", true)) {
                fieldsList.add(new BMultiFieldFE.LabelField(" "));
                fieldsList.add(this.second);
                if (BRelTimeFE.getBooleanFacetValue(cx, "showMilliseconds", false)) {
                    fieldsList.add(new BMultiFieldFE.LabelField("."));
                    fieldsList.add(this.millisecond);
                }
                fieldsList.add(new BMultiFieldFE.LabelField("s"));
            }
            this.fields = fieldsList.toArray(new BMultiFieldFE.Field[0]);
        }
        if (this.get("range") != null) {
            this.remove("range");
        }
        if (this.min != Long.MIN_VALUE || this.max != Long.MAX_VALUE) {
            this.range = "[";
            this.range = this.range + (this.min == Long.MIN_VALUE ? "-inf" : BRelTime.make((long)this.min).toString());
            this.range = this.range + " - ";
            this.range = this.range + (this.max == Long.MAX_VALUE ? "+inf" : BRelTime.make((long)this.max).toString());
            this.range = this.range + "]";
            this.datePickerButton = new BLabel(this.range);
            this.add("range", (BValue)this.datePickerButton);
        } else {
            this.datePickerButton = null;
        }
        if (t < 0L) {
            this.sign.set(1);
            t = -t;
        } else {
            this.sign.set(0);
        }
        long HOUR = 3600000L;
        long MIN = 60000L;
        long SEC = 1000L;
        long DAY = 86400000L;
        this.day.set((int)(t / 86400000L));
        this.regularHour.set((int)(t % 86400000L / 3600000L));
        this.bigHour.set((int)(t / 3600000L));
        this.minute.set((int)(t % 3600000L / 60000L));
        this.second.set((int)(t % 3600000L % 60000L / 1000L));
        this.millisecond.set((int)(t % 3600000L % 60000L % 1000L));
    }

    private static boolean getBooleanFacetValue(Context cx, String facetName, boolean def) {
        if (cx == null) {
            return def;
        }
        BBoolean value = (BBoolean)cx.getFacet(facetName);
        return value == null ? def : value.getBoolean();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        long t = 0L;
        if (this.fields[0] == this.day || this.fields[1] == this.day) {
            t += (long)this.day.value * 86400000L;
            t += (long)this.regularHour.value * 3600000L;
        } else {
            t += (long)this.bigHour.value * 3600000L;
        }
        t += (long)this.minute.value * 60000L;
        t += (long)this.second.value * 1000L;
        t += (long)this.millisecond.value;
        if (this.sign.value == 1) {
            t = -t;
        }
        if (t < this.min) {
            throw new CannotSaveException(BRelTime.make((long)t) + " < " + BRelTime.make((long)this.min) + " " + this.range);
        }
        if (t > this.max) {
            throw new CannotSaveException(BRelTime.make((long)t) + " > " + BRelTime.make((long)this.max) + " " + this.range);
        }
        return BRelTime.make((long)t);
    }

    public static boolean getContextShowDays(Context cx) {
        return BRelTimeFE.getBooleanFacetValue(cx, SHOW_DAY, false) || BRelTimeFE.getBooleanFacetValue(cx, "showDays", false);
    }
}

