/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BTimeEditors;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bql:DynamicTimeRange"})})
@NiagaraActions(value={@NiagaraAction(name="editTimeRange"), @NiagaraAction(name="updateLayout")})
public class BDynamicTimeRangeFE
extends BWbFieldEditor {
    @Generated
    public static final Action editTimeRange = BDynamicTimeRangeFE.newAction((int)0, null);
    @Generated
    public static final Action updateLayout = BDynamicTimeRangeFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDynamicTimeRangeFE.class);
    private static final String prefTemplate = "WW-WWW-WWWW WW:WWWW to WW-WWW-WWWW WW:WWWW WWWWWWWWWWW";
    private static final Lexicon lex = Lexicon.make((String)"bql");
    private static final double HGAP = 8.0;
    private BListDropDown typeChoice = BDynamicTimeRangeFE.makeTypeChoice();
    private BLabel timeRangeLabel;
    private BButton editButton;
    private BAbsTime startTime;
    private BAbsTime endTime;

    @Generated
    public void editTimeRange() {
        this.invoke(editTimeRange, null, null);
    }

    @Generated
    public void updateLayout() {
        this.invoke(updateLayout, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDynamicTimeRangeFE() {
        this.add("typeChoice", (BValue)this.typeChoice);
        this.timeRangeLabel = new BLabel();
        this.add("rangeLabel", (BValue)this.timeRangeLabel);
        this.add("typeLayout", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)updateLayout));
        this.add("typeMod", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)setModified));
        this.editButton = new BButton(BImage.make((BIcon)BIcon.std((String)"clock.png")));
        this.editButton.setButtonStyle(BButtonStyle.toolBar);
        this.add("editButton", (BValue)this.editButton);
        this.add("editLink", (BValue)new BLink((BComponent)this.editButton, (Slot)BButton.actionPerformed, (Slot)editTimeRange));
    }

    @Override
    public void doLoadValue(BObject value, Context cx) {
        BDynamicTimeRange range = (BDynamicTimeRange)value;
        this.typeChoice.setSelectedItem((Object)range.getRangeType());
        if (range.getRangeType() == BDynamicTimeRangeType.timeRange) {
            this.startTime = range.getFixedStartTime();
            this.endTime = range.getFixedEndTime();
        }
        if (this.startTime == null) {
            this.startTime = BAbsTime.NULL;
        }
        if (this.endTime == null) {
            this.endTime = BAbsTime.NULL;
        }
        this.timeRangeLabel.setText(this.formatTimeRange(range.getFixedStartTime(), range.getFixedEndTime()));
        this.relayout();
    }

    @Override
    public BObject doSaveValue(BObject value, Context cx) throws Exception, CannotSaveException {
        BDynamicTimeRangeType rangeType = (BDynamicTimeRangeType)this.typeChoice.getSelectedItem();
        if (rangeType != BDynamicTimeRangeType.timeRange) {
            return BDynamicTimeRange.make((BDynamicTimeRangeType)rangeType);
        }
        return BDynamicTimeRange.make((BAbsTime)this.startTime, (BAbsTime)this.endTime);
    }

    @Override
    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        this.typeChoice.computePreferredSize();
        this.editButton.computePreferredSize();
        BFont font = Theme.label().getTextFont();
        pw = this.typeChoice.getPreferredWidth();
        pw += 8.0 + font.width(prefTemplate);
        ph = this.typeChoice.getPreferredHeight();
        ph = Math.max(ph, font.getHeight());
        ph = Math.max(ph, this.editButton.getPreferredHeight());
        this.setPreferredSize(pw += 8.0 + this.editButton.getPreferredWidth(), ph);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.typeChoice.computePreferredSize();
        this.timeRangeLabel.computePreferredSize();
        this.editButton.computePreferredSize();
        double x = 0.0;
        this.typeChoice.setBounds(x, (h - this.typeChoice.getPreferredHeight()) / 2.0, this.typeChoice.getPreferredWidth(), this.typeChoice.getPreferredHeight());
        x += this.typeChoice.getPreferredWidth() + 8.0;
        BDynamicTimeRangeType type = (BDynamicTimeRangeType)this.typeChoice.getSelectedItem();
        if (type == BDynamicTimeRangeType.timeRange) {
            this.timeRangeLabel.setBounds(x, (h - this.timeRangeLabel.getPreferredHeight()) / 2.0, this.timeRangeLabel.getPreferredWidth(), this.timeRangeLabel.getPreferredHeight());
            this.editButton.setBounds(x += 8.0 + this.timeRangeLabel.getPreferredWidth(), (h - this.editButton.getPreferredHeight()) / 2.0, this.editButton.getPreferredWidth(), this.editButton.getPreferredHeight());
            x += 8.0 + this.editButton.getPreferredWidth();
        } else {
            this.timeRangeLabel.setBounds(0.0, 0.0, 0.0, 0.0);
            this.editButton.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void doUpdateLayout() {
        this.relayout();
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.typeChoice.setEnabled(!readonly);
        this.editButton.setEnabled(!readonly);
    }

    public void doEditTimeRange() {
        BAbsTime tempStartTime = this.startTime;
        BAbsTime tempEndTime = this.endTime;
        while (true) {
            BTimeEditors eds = new BTimeEditors(tempStartTime, tempEndTime, this.getCurrentContext());
            int rc = BDialog.open((BWidget)this, (String)lex.getText("dynamicTimeRangeFE.editTimeRange"), (Object)((Object)eds), (int)3);
            if (rc == 2) {
                return;
            }
            tempStartTime = eds.getStartTime();
            tempEndTime = eds.getEndTime();
            if (tempStartTime.equals((Object)BAbsTime.NULL) || tempEndTime.equals((Object)BAbsTime.NULL) || tempEndTime.isAfter(tempStartTime)) break;
            BDialog.error((BWidget)this, (Object)lex.getText("dynamicTimeRangeFE.timeSequenceError"));
        }
        this.startTime = tempStartTime;
        this.endTime = tempEndTime;
        this.timeRangeLabel.setText(this.formatTimeRange(this.startTime, this.endTime));
        this.setModified();
    }

    private String formatTimeRange(BAbsTime startTime, BAbsTime endTime) {
        StringBuilder s = new StringBuilder(prefTemplate.length());
        if (startTime == null || startTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.epoch"));
        } else {
            s.append(startTime.toString(this.getCurrentContext()));
        }
        s.append("  ").append(lex.getText("dynamicTimeRangeFE.to")).append("  ");
        if (endTime == null || endTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.now"));
        } else {
            s.append(endTime.toString(this.getCurrentContext()));
        }
        return s.toString();
    }

    public static BListDropDown makeTypeChoice() {
        BListDropDown typeChoice = new BListDropDown();
        BList typeList = typeChoice.getList();
        BEnumRange range = BDynamicTimeRangeType.today.getRange();
        int[] ords = range.getOrdinals();
        for (int i = 0; i < ords.length; ++i) {
            typeList.addItem((Object)range.get(ords[i]));
        }
        typeChoice.setSelectedItem((Object)BDynamicTimeRangeType.today);
        return typeChoice;
    }

    public static void main(String[] args) {
        BEdgePane main = new BEdgePane();
        BDynamicTimeRangeFE ed = new BDynamicTimeRangeFE();
        ed.loadValue((BObject)BDynamicTimeRange.make((BDynamicTimeRangeType)BDynamicTimeRangeType.today));
        main.setTop((BWidget)ed);
        BFrame f = new BFrame();
        f.setContent((BWidget)main);
        f.setScreenBounds(200.0, 10.0, 700.0, 150.0);
        f.open();
    }
}

