/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.console;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsole;
import java.io.File;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;

@NiagaraType
public class BConsoleBuffer
extends BWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BConsoleBuffer.class);
    Point hoverPoint;
    BConsole console;
    Line[] lines;
    BFont font;
    double cellHeight;
    int highlight = -1;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BConsoleBuffer() {
        throw new IllegalStateException();
    }

    public BConsoleBuffer(BConsole console) {
        this.console = console;
        this.font = Theme.textEditor().getFont();
        this.lines = new Line[500];
        this.cellHeight = this.font.getHeight();
    }

    public void append(String text, boolean isBreak) {
        Line line;
        if (isBreak) {
            line = new BreakLine(text);
            this.highlight = -1;
        } else {
            line = this.captureLine(text);
        }
        System.arraycopy(this.lines, 1, this.lines, 0, this.lines.length - 1);
        this.lines[this.lines.length - 1] = line;
        if (this.highlight != -1) {
            --this.highlight;
        }
        this.repaint();
    }

    private Line captureLine(String spec) {
        try {
            int colon4;
            OrdLine line = null;
            line = OrdLine.make(spec);
            if (line != null) {
                return line;
            }
            int colon0 = spec.indexOf(58, 4);
            int colon1 = colon0 < 0 ? -1 : spec.indexOf(58, colon0 + 1);
            int colon2 = colon1 < 0 ? -1 : spec.indexOf(58, colon1 + 1);
            int colon3 = colon2 < 0 ? -1 : spec.indexOf(58, colon2 + 1);
            int n = colon4 = colon3 < 0 ? -1 : spec.indexOf(58, colon3 + 1);
            if (colon4 > 0) {
                try {
                    File file = new File(spec.substring(0, colon0));
                    int line1 = Integer.parseInt(spec.substring(colon0 + 1, colon1));
                    int col1 = Integer.parseInt(spec.substring(colon1 + 1, colon2));
                    int line2 = Integer.parseInt(spec.substring(colon2 + 1, colon3));
                    int col2 = Integer.parseInt(spec.substring(colon3 + 1, colon4));
                    String msg = spec.substring(colon4 + 2);
                    String text = file.getName() + ":" + line1 + ":" + col1 + ": " + msg;
                    return new FileLine(text, file, line1, col1, line2, col2 + 1);
                }
                catch (Exception file) {
                    // empty catch block
                }
            }
            if (colon1 > 0) {
                File file = new File(spec.substring(0, colon0));
                try {
                    int line2 = Integer.parseInt(spec.substring(colon0 + 1, colon1));
                    String msg = spec.substring(colon1 + 2);
                    String text = file.getName() + ":" + line2 + ": " + msg;
                    return new FileLine(text, file, line2, 1, line2, 75);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Line(spec);
    }

    public FileLine getFileLine(int index) {
        return (FileLine)this.lines[index];
    }

    public int topOfLastCommand() {
        for (int i = this.lines.length - 1; i >= 0; --i) {
            if (!(this.lines[i] instanceof BreakLine)) continue;
            return i;
        }
        return -1;
    }

    public int next() {
        int cur = this.highlight;
        if (cur == -1) {
            cur = this.topOfLastCommand();
        }
        if (cur == -1) {
            return -1;
        }
        for (int i = cur + 1; i < this.lines.length; ++i) {
            if (!(this.lines[i] instanceof FileLine)) continue;
            return i;
        }
        return -1;
    }

    public int prev() {
        int cur = this.highlight;
        int top = this.topOfLastCommand();
        if (cur == -1 || top == -1) {
            return -1;
        }
        for (int i = cur - 1; i > top; --i) {
            if (!(this.lines[i] instanceof FileLine)) continue;
            return i;
        }
        return -1;
    }

    public void doLayout(BWidget[] kids) {
        double h = this.getHeight();
        int visibleLines = (int)(h / this.cellHeight);
        BScrollBar bar = this.console.scrollBar;
        bar.setExtent(visibleLines);
        bar.setBlockIncrement(visibleLines);
        if (bar.getPosition() + bar.getExtent() >= this.lines.length) {
            bar.setPosition(bar.getPosition() - bar.getExtent() - 1);
        }
    }

    public int yToLine(double y) {
        int visible;
        double h = this.getHeight();
        if (y < 0.0) {
            return -1;
        }
        if (y > h) {
            return -1;
        }
        int pos = this.console.scrollBar.getPosition();
        int line = pos + (visible = (int)(h / this.cellHeight)) - (int)((h - y) / this.cellHeight);
        if (line < 0) {
            return -1;
        }
        if (line >= this.lines.length) {
            return -1;
        }
        return line;
    }

    public boolean isOffscreen(Line line) {
        double tw = this.font.width(line.text);
        return tw >= this.getWidth();
    }

    public void paint(Graphics g) {
        g.setBrush(Theme.widget().getWindowBackground((IStylable)this));
        g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        g.setFont(this.font);
        g.setBrush(Theme.widget().getWindowForeground((IStylable)this));
        double w = this.getWidth();
        double h = this.getHeight();
        int pos = this.console.scrollBar.getPosition();
        int visible = (int)(h / this.cellHeight);
        double y = h - (double)visible * this.cellHeight;
        for (int i = 0; i <= visible; ++i) {
            int index = i + pos;
            if (index < 0 || index >= this.lines.length) continue;
            Line line = this.lines[index];
            double top = y + (double)(i - 1) * this.cellHeight;
            if (line == null) continue;
            if (index == this.highlight) {
                g.setBrush(BColor.yellow);
                g.fillRect(0.0, top, w, this.cellHeight);
                g.setBrush(Theme.widget().getWindowForeground((IStylable)this));
            }
            if (line.isBreak()) {
                g.setBrush(BColor.make((int)192, (int)192, (int)192));
                g.strokeLine(0.0, top, w, top);
                g.setBrush(Theme.widget().getWindowForeground((IStylable)this));
            }
            g.drawString(line.text, 3.0, y + (double)i * this.cellHeight - 3.0);
        }
    }

    public String getStyleSelector() {
        return "console";
    }

    public void mousePressed(BMouseEvent event) {
        this.console.entry.requestFocus();
    }

    public void mouseReleased(BMouseEvent event) {
        int index = this.yToLine(event.getY());
        if (index != -1 && (this.lines[index] instanceof FileLine || this.lines[index] != null && this.lines[index].isOrd())) {
            this.console.show(index);
        }
    }

    public void mouseMoved(BMouseEvent event) {
        if (this.hoverPoint != null) {
            double dx = (int)Math.abs(this.hoverPoint.x - event.getX());
            double dy = (int)Math.abs(this.hoverPoint.y - event.getY());
            if (dx > 4.0 || dy > 4.0) {
                UiEnv.get().closeBubbleHelp();
                this.resetHover();
                this.hoverPoint = null;
            }
        }
    }

    public void mouseExited(BMouseEvent event) {
        UiEnv.get().closeBubbleHelp();
        this.resetHover();
        this.hoverPoint = null;
    }

    public void mouseHover(BMouseEvent event) {
        Point pt = new Point(event.getX(), event.getY());
        this.hoverPoint = new Point((IPoint)pt);
        int index = this.yToLine(event.getY());
        if (index != -1 && this.lines[index] != null && this.isOffscreen(this.lines[index])) {
            String text = this.lines[index].text;
            pt.y += 18.0;
            UiEnv.get().openBubbleHelp((BWidget)this, pt.x, pt.y, text);
        }
    }

    static class OrdLine
    extends Line {
        BOrd ord;

        protected OrdLine(String text, BOrd ord) {
            super(text);
            this.ord = ord;
        }

        public static OrdLine make(String spec) {
            int barsIndex = spec.indexOf("||");
            StringBuilder friendlySpec = new StringBuilder();
            String msg = "";
            BOrd ord = null;
            if (barsIndex < 0) {
                return null;
            }
            ord = BOrd.make((String)spec.substring(0, barsIndex));
            msg = spec.substring(barsIndex + 2);
            int viewIndex = spec.indexOf("|view:");
            if (viewIndex > 0) {
                friendlySpec.append(spec.substring(0, viewIndex));
            } else {
                friendlySpec.append(ord.toString());
            }
            friendlySpec.append(" -- ").append(msg);
            return new OrdLine(friendlySpec.toString(), ord);
        }

        public BOrd getOrd() {
            return this.ord;
        }

        public HyperlinkInfo getHyperlinkInfo() {
            return new HyperlinkInfo(this.ord);
        }
    }

    static class FileLine
    extends Line {
        public final File file;
        public final int line1;
        public final int col1;
        public final int line2;
        public final int col2;

        public FileLine(String text, File file, int line1, int col1, int line2, int col2) {
            super(text);
            this.file = file;
            this.line1 = line1;
            this.col1 = col1;
            this.line2 = line2;
            this.col2 = col2;
        }
    }

    static class BreakLine
    extends Line {
        public BreakLine(String text) {
            super(text);
        }

        @Override
        public boolean isBreak() {
            return true;
        }
    }

    static class Line {
        public final String text;

        public Line(String text) {
            this.text = text;
        }

        public boolean isBreak() {
            return false;
        }

        public boolean isOrd() {
            return this instanceof OrdLine;
        }
    }
}

