/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.bql.filter.BFacetsFilter;
import com.tridium.sys.Nre;
import com.tridium.workbench.bql.filter.BFilterFE;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIBqlFilter;
import javax.baja.data.DataTypes;
import javax.baja.file.BFileSystem;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFacetsFilterConfig
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BFacetsFilterConfig.class);
    private static Properties predefinedKeys;
    static BModule MODULE;
    static Lexicon lex;
    String[] keys;
    HashMap<String, BFilterFE> editors = new HashMap();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void load(BFacetsFilter facets) {
        this.load(facets, false);
    }

    public void load(BFacetsFilter facets, boolean readonly) {
        BWidget parent;
        this.editors.clear();
        this.removeAll();
        if (facets == null) {
            facets = new BFacetsFilter();
        }
        this.keys = facets.keys();
        BGridPane pane = new BGridPane(2);
        if (this.keys.length > 0) {
            int i;
            BIBqlFilter[] values = new BIBqlFilter[this.keys.length];
            for (i = 0; i < this.keys.length; ++i) {
                values[i] = facets.getValue(this.keys[i]);
            }
            for (i = 0; i < this.keys.length; ++i) {
                String key = this.keys[i];
                BIBqlFilter filter = values[i];
                try {
                    BFilterFE filterEd = BFilterFE.makeFor(filter);
                    filterEd.loadValue((BObject)filter);
                    filterEd.setReadonly(readonly);
                    pane.add(null, (BValue)new BLabel(key));
                    pane.add(null, (BValue)filterEd);
                    this.editors.put(key, filterEd);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        BButton bAdd = new BButton((Command)new Add((BWidget)this));
        BButton bRem = new BButton((Command)new Remove((BWidget)this));
        bAdd.setEnabled(!readonly);
        bRem.setEnabled(!readonly);
        BGridPane actions = new BGridPane(2);
        actions.setHalign(BHalign.left);
        actions.add(null, (BValue)bAdd);
        actions.add(null, (BValue)bRem);
        BEdgePane xpane = new BEdgePane();
        xpane.setTop((BWidget)new BBorderPane((BWidget)actions, 0.0, 0.0, 10.0, 0.0));
        xpane.setCenter((BWidget)pane);
        this.setCenter((BWidget)xpane);
        for (parent = this.getParentWidget(); parent != null && !(parent instanceof BDialog); parent = parent.getParentWidget()) {
        }
        if (parent instanceof BDialog) {
            ((BDialog)parent).setBoundsCenteredOnOwner();
        }
    }

    public BFacetsFilter save() throws Exception {
        BIBqlFilter[] values = new BIBqlFilter[this.keys.length];
        String[] comps = new String[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            BFilterFE editor = this.editors.get(key);
            values[i] = (BIBqlFilter)editor.saveValue();
        }
        return new BFacetsFilter(this.keys, values);
    }

    public static Properties getPredefinedKeys() {
        if (predefinedKeys == null) {
            predefinedKeys = new Properties();
            try {
                File file = new File(Nre.getNiagaraHome(), "defaults" + File.separator + "workbench" + File.separator + "facetKeys.properties");
                BFileSystem.INSTANCE.makeFile(BFileSystem.INSTANCE.localFileToPath(file));
                FileInputStream in = new FileInputStream(file);
                predefinedKeys.load(in);
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return predefinedKeys;
    }

    public static void addPredefinedKeys(BList list) {
        Properties props = BFacetsFilterConfig.getPredefinedKeys();
        Object[] keys = props.keySet().toArray(new String[0]);
        SortUtil.sort((Object[])keys);
        for (int i = 0; i < keys.length; ++i) {
            list.addItem(keys[i]);
        }
    }

    static {
        MODULE = Sys.getModuleForClass(BFacetsFilterConfig.class);
        lex = Lexicon.make((String)"workbench");
    }

    static class FacetKeyModel
    extends TextModel {
        BListDropDown list;

        FacetKeyModel(BListDropDown list) {
            this.list = list;
        }

        public void textModified() {
            super.textModified();
            String sym = BFacetsFilterConfig.getPredefinedKeys().getProperty(this.getText());
            if (sym != null) {
                Type type = DataTypes.getBySymbol((char)sym.charAt(0));
                if (type != null) {
                    this.list.setSelectedItem((Object)type.getTypeName());
                }
                this.list.relayout();
            }
        }
    }

    class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, MODULE, "fieldSheet.facets.remove");
        }

        public CommandArtifact doInvoke() {
            String title = lex.getText("fieldSheet.facets.remove.label");
            BCheckBox[] checks = new BCheckBox[BFacetsFilterConfig.this.keys.length];
            BGridPane list = new BGridPane(1);
            for (int i = 0; i < BFacetsFilterConfig.this.keys.length; ++i) {
                checks[i] = new BCheckBox(BFacetsFilterConfig.this.keys[i]);
                list.add(null, (BValue)checks[i]);
            }
            BEdgePane pane = new BEdgePane();
            pane.setTop((BWidget)new BLabel(lex.getText("fieldSheet.facets.selectToRemove")));
            pane.setCenter((BWidget)list);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)title, (Object)new BBorderPane((BWidget)pane), (int)3)) {
                try {
                    BFacetsFilter facets = BFacetsFilterConfig.this.save();
                    for (int i = 0; i < checks.length; ++i) {
                        if (!checks[i].isSelected()) continue;
                        facets.removeFacetFilter(BFacetsFilterConfig.this.keys[i]);
                    }
                    BFacetsFilterConfig.this.load(facets);
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getOwner(), (String)title, (Object)lex.getText("fieldSheet.facets.notRemoved"), (Throwable)e);
                }
            }
            return null;
        }
    }

    class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, MODULE, "fieldSheet.facets.add");
        }

        public CommandArtifact doInvoke() {
            String title = lex.getText("fieldSheet.facets.add.label");
            Type[] types = DataTypes.getTypes();
            Object[] names = new String[types.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = types[i].getTypeName();
            }
            SortUtil.sort((Object[])names);
            BListDropDown list = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                list.getList().addItem(names[i]);
            }
            list.getList().setSelectedIndex(0);
            BTextDropDown field = new BTextDropDown();
            field.getEditor().setModel((TextModel)new FacetKeyModel(list));
            BFacetsFilterConfig.addPredefinedKeys(field.getList());
            BGridPane pane = new BGridPane(2);
            pane.setColumnAlign(BHalign.fill);
            pane.add(null, (BValue)new BLabel(lex.getText("fieldSheet.facets.key")));
            pane.add(null, (BValue)field);
            pane.add(null, (BValue)new BLabel(lex.getText("fieldSheet.facets.type")));
            pane.add(null, (BValue)list);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)title, (Object)new BBorderPane((BWidget)pane), (int)3)) {
                try {
                    String key = field.getText();
                    String name = (String)list.getSelectedItem();
                    BTypeSpec typeSpec = BTypeSpec.make((String)"baja", (String)name);
                    BObject value = typeSpec.getInstance();
                    for (int i = 0; i < BFacetsFilterConfig.this.keys.length; ++i) {
                        if (!BFacetsFilterConfig.this.keys[i].equals(key)) continue;
                        BDialog.error((BWidget)this.getOwner(), (String)title, (Object)lex.getText("fieldSheet.facets.duplicateKeys"));
                        return null;
                    }
                    AgentList agents = value.getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE));
                    if (agents.size() != 0) {
                        BIBqlFilter filter = (BIBqlFilter)agents.getDefault().getInstance();
                        filter.init(value);
                        BFacetsFilter facets = BFacetsFilterConfig.this.save();
                        facets.addFacetFilter(key, filter);
                        BFacetsFilterConfig.this.load(facets);
                    }
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getOwner(), (String)title, (Object)lex.getText("fieldSheet.facets.notAdded"), (Throwable)e);
                }
            }
            return null;
        }
    }
}

