/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.shell.BGeneralOptions;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.util.Lexicon;
import javax.baja.workbench.authn.BCredInputPane;

@NiagaraType
@NiagaraAction(name="changeUser", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")
public class BWbLoginUsernamePasswordPane
extends BCredInputPane {
    @Generated
    public static final Action changeUser = BWbLoginUsernamePasswordPane.newAction((int)0, (BValue)new BMouseEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWbLoginUsernamePasswordPane.class);
    private BTextField usernameFE = new BTextField();
    private BHyperlinkLabel changeUserHyperlink = new BHyperlinkLabel();
    private BPasswordFE passwordFE = new BPasswordFE();
    private BCheckBox saveCredBox;
    boolean newUser;

    @Generated
    public void changeUser(BMouseEvent parameter) {
        this.invoke(changeUser, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWbLoginUsernamePasswordPane(BUsernameAndPassword credentials, AuthenticationRealm realm, String realmPrefix) {
        this.newUser = credentials.isNewUser();
        UiLexicon lex = UiLexicon.bajaui();
        BGridPane credPane = new BGridPane(2);
        credPane.setHalign(BHalign.left);
        credPane.setColumnGap(20.0);
        credPane.add(null, (BValue)new BLabel(lex.getText("auth.username")));
        credPane.add(null, (BValue)this.usernameFE);
        this.usernameFE.setText(credentials.getUsername());
        this.usernameFE.setEnabled(false);
        credPane.add(null, (BValue)new BLabel());
        credPane.add(null, (BValue)this.changeUserHyperlink);
        this.initChangeUserHyperlink();
        credPane.add(null, (BValue)new BLabel(lex.getText("auth.password")));
        credPane.add(null, (BValue)this.passwordFE);
        this.passwordFE.loadValue((BObject)credentials.getPassword());
        this.add(null, (BValue)credPane);
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        this.saveCredBox = new BCheckBox(lex.getText("auth.saveCredentials"), allowCaching && AuthUtil.hasSavedCredentials(realmPrefix + realm.getAuthenticationRealmName()));
        this.saveCredBox.setEnabled(allowCaching);
        this.add(null, (BValue)this.saveCredBox);
    }

    private void initChangeUserHyperlink() {
        Lexicon lex = Lexicon.make(((Object)((Object)this)).getClass());
        BFont font = this.changeUserHyperlink.getFont();
        font = font.isNull() ? BFont.make((BFont)Theme.label().getTextFont((IStylable)this.changeUserHyperlink), (int)4) : BFont.make((BFont)font, (int)4);
        this.changeUserHyperlink.setForeground(BBrush.makeSolid((BColor)BColor.blue));
        this.changeUserHyperlink.setFont(font);
        this.changeUserHyperlink.setText(lex.getText("auth.changeUser"));
        this.changeUserHyperlink.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)3.0));
        this.linkTo((BComponent)this.changeUserHyperlink, (Slot)BWidget.mouseEvent, (Slot)changeUser);
    }

    public void doChangeUser(BMouseEvent event) {
        if (event.getId() == 502) {
            BWbLoginUsernamePasswordPane parent = this;
            while (!((parent = parent.getParentWidget()) instanceof BOptionDialog) && !(parent instanceof BWizard) && parent != null) {
            }
            if (parent instanceof BOptionDialog) {
                ((BOptionDialog)parent).close(1000);
            } else if (parent instanceof BWizard) {
                ((BWizard)parent).getModel().back();
            }
        }
    }

    @Override
    protected BICredentials doGetCredentials() throws Exception {
        String username = this.usernameFE.getText();
        BPassword password = (BPassword)this.passwordFE.saveValue();
        return new BUsernameAndPassword(username, password);
    }

    @Override
    protected void doCleanCredentials() {
        this.usernameFE.setText("");
        this.passwordFE.loadValue((BObject)BPassword.make((String)""));
        this.usernameFE = null;
        this.passwordFE = null;
    }

    @Override
    public boolean shouldSaveCredentials() {
        return this.saveCredBox.isSelected();
    }

    @Override
    public boolean shouldDeleteCredentials() {
        return !this.saveCredBox.isSelected();
    }
}

