/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.platOnyxx;

import com.lynxspring.platOnyxx.BOnyxxPlatformService;
import com.lynxspring.platOnyxx.OnyxxCommandOutputSpy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class OnyxxIfconfigOutputSpy
extends OnyxxCommandOutputSpy {
    private final String[] ethInterfaceArray = new String[]{"can0", "eth0", "eth1", "br0", "lo", "usb2"};
    private final String errorLineSuffix = "Device not found";

    public OnyxxIfconfigOutputSpy(BOnyxxPlatformService platOnyxx) {
        super(platOnyxx);
        this.command = "ifconfig";
        this.commandArguments = "";
        this.commandOutputFile = "ifconfigspyoutput.txt";
    }

    @Override
    public String getCommandOutput() throws Exception {
        this.generateIfconfigOutput();
        if (this.commandOutputFile == null) {
            throw new IOException("Output File Missing.");
        }
        String combinedPath = "/home/niagara/shared/" + this.commandOutputFile;
        File currentFile = new File(combinedPath);
        BufferedReader fileReader = new BufferedReader(new FileReader(currentFile));
        String currentLine = fileReader.readLine();
        StringBuffer fileContents = new StringBuffer();
        while (currentLine != null) {
            if (!currentLine.contains("Device not found")) {
                fileContents.append(currentLine + "\n");
            } else {
                currentLine = fileReader.readLine();
            }
            currentLine = fileReader.readLine();
        }
        fileReader.close();
        return fileContents.toString();
    }

    private void generateIfconfigOutput() throws Exception {
        for (String ethInterface : this.ethInterfaceArray) {
            this.platOnyxx.doFwSndCmd("/bin/bash -c '" + this.command + " " + ethInterface + " &>> " + "/home/niagara/shared/" + this.commandOutputFile + "'");
            this.platOnyxx.doFwSndCmd("/bin/bash -c 'echo \"\" &>> /home/niagara/shared/" + this.commandOutputFile + "'");
        }
    }
}

