/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.serial.command;

import com.tridium.sms.BSmsMessage;
import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.util.ParseReadMsgs;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.sys.BRelTime;

public final class SmsReadMessagesCommand
extends SmsCommand {
    private BSmsMessage[] smsMessages = new BSmsMessage[0];

    public SmsReadMessagesCommand(SmsCommand.ICommsImplementer comms) {
        super(comms);
    }

    @Override
    public boolean doRun() {
        boolean success;
        block4: {
            success = false;
            try {
                String rawMsgStr = this.comms.write("AT+CMGL=\"REC UNREAD\"\r", "OK\r\n", BRelTime.make((long)20000L));
                this.smsMessages = ParseReadMsgs.parse(rawMsgStr);
                if (this.smsMessages != null && SmsToolkit.log.isLoggable(Level.FINE)) {
                    for (int i = 0; i < this.smsMessages.length; ++i) {
                        SmsToolkit.log.fine("*** Read SMS Message ***");
                        SmsToolkit.log.fine("Sms Message Id: " + this.smsMessages[i].getId());
                        SmsToolkit.log.fine("Sms Message Phone Number: " + this.smsMessages[i].getPhoneNumbers());
                        SmsToolkit.log.fine("Sms Message Message: " + this.smsMessages[i].getMessage());
                    }
                }
                success = true;
            }
            catch (Exception e) {
                if (!SmsToolkit.log.isLoggable(Level.FINE)) break block4;
                SmsToolkit.log.log(Level.FINE, "SMSReadMessagesCommand.execute(CommsManager): Failed to read messags from GSM device", e);
            }
        }
        return success;
    }

    public BSmsMessage[] getMessages() {
        return this.smsMessages;
    }

    public String toString() {
        return SmsToolkit.getText("smsCommand.readMessages");
    }
}

