/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.alarm;

import com.tridium.alarm.user.BIUserAlarmRecipient;
import com.tridium.sms.BSms;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="BStatusBoolean", defaultValue="new BStatusBoolean(true)", flags=8), @NiagaraProperty(name="phoneNumbers", type="BStatusString", defaultValue="new BStatusString()", flags=8, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"sms:PhoneNumbersFE\"))")}), @NiagaraProperty(name="body", type="BFormat", defaultValue="makeDefaultMsgFormat()", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.make(true))")})})
public final class BSmsRecipient
extends BAlarmRecipient
implements BIUserAlarmRecipient {
    @Generated
    public static final Property enabled = BSmsRecipient.newProperty((int)8, (BValue)new BStatusBoolean(true), null);
    @Generated
    public static final Property phoneNumbers = BSmsRecipient.newProperty((int)8, (BValue)new BStatusString(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sms:PhoneNumbersFE")));
    @Generated
    public static final Property body = BSmsRecipient.newProperty((int)0, (BValue)BSmsRecipient.makeDefaultMsgFormat(), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Type TYPE = Sys.loadType(BSmsRecipient.class);
    private static final BIcon icon = BIcon.make((String)"module://sms/res/smsRecipient.png");

    @Generated
    public BStatusBoolean getEnabled() {
        return (BStatusBoolean)this.get(enabled);
    }

    @Generated
    public void setEnabled(BStatusBoolean v) {
        this.set(enabled, (BValue)v, null);
    }

    @Generated
    public BStatusString getPhoneNumbers() {
        return (BStatusString)this.get(phoneNumbers);
    }

    @Generated
    public void setPhoneNumbers(BStatusString v) {
        this.set(phoneNumbers, (BValue)v, null);
    }

    @Generated
    public BFormat getBody() {
        return (BFormat)this.get(body);
    }

    @Generated
    public void setBody(BFormat v) {
        this.set(body, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    private static BFormat makeDefaultMsgFormat() {
        StringBuilder buf = new StringBuilder();
        buf.append("Source:      %alarmData.sourceName%\n");
        buf.append("Text:        %alarmData.msgText%");
        return BFormat.make((String)buf.toString());
    }

    public void handleAlarm(BAlarmRecord alarm) {
        this.sendAlarm(this.getPhoneNumbers().getValue(), alarm);
    }

    private void sendAlarm(String phoneNumbers, BAlarmRecord record) {
        if (this.getEnabled().getValue()) {
            if (SmsToolkit.log.isLoggable(Level.FINE)) {
                SmsToolkit.log.fine("BSmsRecipient.sendAlarm");
            }
            String message = BIUserAlarmRecipient.formatAlarmDataValues((BFormat)this.getBody(), (BAlarmRecord)record, null);
            BSms.sendSMSMessage(phoneNumbers, message);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public void handleAlarmForUser(BUser user, BAlarmRecord alarmRecord) {
        if (this.accept(alarmRecord)) {
            this.sendAlarm(user.getCellPhoneNumber(), alarmRecord);
        }
    }
}

