/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.util;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.job.BNrioLearnDevicesJob;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.PingResponse;

public class DualModuleUtils
implements NrioMessageConst {
    protected static final int SEND_PING_OK = 0;
    protected static final int SEND_PING_NOT_RUNNING = 1;
    protected static final int SEND_PING_DOWNLOADING = 2;
    protected static final int SEND_PING_FAULT = 3;
    protected static final int SEND_PING_ERROR = 4;

    public static int sendPing(BNrioDevice device) {
        if (!device.isRunning()) {
            return 1;
        }
        BNrioNetwork network = (BNrioNetwork)device.getNetwork();
        if (network.isDownLoadInProcess()) {
            return 2;
        }
        if (device.isFault()) {
            return 3;
        }
        PingMessage req = new PingMessage(device.getAddress(), device.getUid().copyBytes(), device.getDeviceType());
        PingResponse rsp = (PingResponse)network.sendNrioMessage(req);
        int status = rsp.getStatus();
        if (status == 255) {
            return 2;
        }
        if (status != 0 && device.incrementPingFailCount()) {
            device.pingFail("PingMessage error: " + status);
            return 4;
        }
        return 0;
    }

    public static boolean processPostPing(BNrioDevice device, boolean needsInitialized) {
        if (needsInitialized) {
            int status = device.sendWriteConfig();
            if (status == 0) {
                device.doEnablePolling();
                device.firstPing = false;
                device.pingOk();
                device.readBuildInfo();
                device.initLastWrite();
                if (device instanceof BNrio16Module) {
                    ((BNrio16Module)device).postWriteOutputDefaults();
                    ((BNrio16Module)device).writeIo();
                }
                return true;
            }
            if (device.incrementPingFailCount()) {
                device.pingFail("WriteConfig error: " + status);
            }
            return false;
        }
        device.doEnablePolling();
        String installedVersion = device.getInstalledVersion();
        if (installedVersion.length() == 0 || installedVersion.startsWith("up", 0)) {
            device.readBuildInfo();
        }
        device.pingOk();
        return true;
    }

    public static boolean addressDualModule(BNrioNetwork nrioNet, BNrioLearnDevicesJob job, int moduleType, byte[] uid, int setAddress) {
        int otherAddr = nrioNet.getIo34OtherAddr(moduleType, uid);
        if (otherAddr < 0) {
            if (job != null) {
                job.getDiscoveryLog().message("waiting for partner module to be addressed");
            }
            return true;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String priVersion = "";
        String secVersion = "";
        int priAddr = -1;
        int secAddr = -1;
        if (moduleType == 11) {
            priAddr = setAddress;
            secAddr = otherAddr;
        } else {
            priAddr = otherAddr;
            secAddr = setAddress;
        }
        priVersion = nrioNet.readBuildInfo(priAddr);
        secVersion = nrioNet.readBuildInfo(secAddr);
        String version = priVersion + ";" + secVersion;
        if (priVersion.length() != 0 && secVersion.length() != 0) {
            job.addLearnedDevice(priAddr, BNrioDeviceTypeEnum.makeFromRaw(11), uid, version, "", secAddr);
        } else {
            nrioNet.clearAddressUsedV2(priAddr);
            nrioNet.clearAddressUsedV2(secAddr);
            nrioNet.sendReset(priAddr);
            nrioNet.sendReset(secAddr);
        }
        return false;
    }

    public static int[] bytesToValues(int index, byte[] bytes) {
        int[] values = new int[4];
        for (int i = 0; i < 4; ++i) {
            values[i] = 0;
            if (i % 2 == 0) {
                values[i] = bytes[index++] << 4;
                int n = i;
                values[n] = values[n] | bytes[index] >> 4 & 0xF;
            } else {
                values[i] = (bytes[index++] & 0xF) << 8;
                int n = i;
                values[n] = values[n] | bytes[index++] & 0xFF;
            }
            values[i] = values[i] & 0xFFF;
        }
        return values;
    }

    public static float[] bytesToValues(NrioInputStream in) {
        float[] values = new float[4];
        int dualbyte = 0;
        for (int i = 0; i < 4; ++i) {
            int value = 0;
            if (i % 2 == 0) {
                value = in.read() << 4;
                dualbyte = in.read();
                value |= dualbyte >> 4 & 0xF;
            } else {
                value = dualbyte << 8 & 0xF00;
                value |= in.read() & 0xFF;
            }
            values[i] = 10.0f * (float)(value &= 0xFFF) / 4096.0f;
        }
        return values;
    }
}

