/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.components.BIOutputDefaultValues;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioOutputStream;
import com.tridium.nrio.messages.NrioReceivedMessage;

public class WriteOutputConfigMessage
extends NrioMessage
implements NrioMessageConst {
    protected int commLossTime;
    protected int powerupTime;
    protected BIOutputDefaultValues defValueComp;
    protected boolean isPrimary = false;

    public WriteOutputConfigMessage() {
    }

    public WriteOutputConfigMessage(int address, int powerupTime, int commLossTime, BIOutputDefaultValues defValueComp, boolean isPrimary) {
        this.address = address;
        this.type = 21;
        this.status = 0;
        this.commLossTime = defValueComp.getEnableCommLossDefaults() ? commLossTime : 0;
        this.powerupTime = defValueComp.getEnableStartupDefaults() ? powerupTime : 0;
        this.defValueComp = defValueComp;
        this.isPrimary = isPrimary;
    }

    @Override
    public byte[] getByteArray() {
        NrioOutputStream packet = new NrioOutputStream();
        packet.writeIntRev(this.powerupTime);
        packet.writeIntRev(this.commLossTime);
        try {
            packet.write(this.defValueComp.toMessageBytes(this.isPrimary));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.data = packet.toByteArray();
        return super.getByteArray();
    }

    @Override
    public Message toResponse(ReceivedMessage resp) {
        NrioReceivedMessage accessResp = (NrioReceivedMessage)resp;
        NrioMessage respMessage = new NrioMessage();
        respMessage.readResponse(accessResp);
        return respMessage;
    }
}

