/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioOutputStream;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.PingResponse;
import java.io.OutputStream;

public class PingMessage
extends NrioMessage
implements NrioMessageConst {
    protected byte[] uid = new byte[6];
    protected int moduleType;

    public PingMessage() {
    }

    public PingMessage(int address, byte[] uid, int deviceType) {
        this.address = address;
        this.type = 3;
        this.status = 0;
        this.uid = uid;
        this.moduleType = deviceType;
    }

    public PingMessage(int address, byte[] uid, BNrioDeviceTypeEnum deviceType) {
        this.address = address;
        this.type = 3;
        this.status = 0;
        this.uid = uid;
        this.moduleType = deviceType.getRawInt();
    }

    public byte[] getUid() {
        return this.uid;
    }

    public int getModuleType() {
        return this.moduleType;
    }

    public void setUid(byte[] uid) {
        this.uid = uid;
    }

    public void setModuleType(int moduleType) {
        this.moduleType = moduleType;
    }

    @Override
    public void write(OutputStream out) {
        try {
            byte[] ba = this.getByteArray();
            out.write(ba);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public byte[] getByteArray() {
        NrioOutputStream packet = new NrioOutputStream();
        try {
            packet.write(this.uid, 0, 6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        packet.write(this.moduleType);
        this.data = packet.toByteArray();
        return super.getByteArray();
    }

    @Override
    public Message toResponse(ReceivedMessage resp) {
        NrioReceivedMessage accessResp = (NrioReceivedMessage)resp;
        PingResponse respMessage = new PingResponse();
        respMessage.readResponse(accessResp);
        return respMessage;
    }
}

