/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.job;

import com.tridium.nrio.BM2mIoNetwork;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.job.BNrioLearnDevicesJob;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.UnconfiguredModuleReply;
import java.util.Vector;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BBlob;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BM2mLearnDeviceJob
extends BNrioLearnDevicesJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BM2mLearnDeviceJob.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BM2mLearnDeviceJob() {
    }

    public BM2mLearnDeviceJob(BM2mIoNetwork net) {
        super(net);
    }

    @Override
    public void run(Context cx) throws Exception {
        this.logMessage("starting");
        try {
            NrioMessage message = new NrioMessage();
            UnconfiguredModuleReply ucmr = new UnconfiguredModuleReply();
            this.nrioNet.initLogicalAddressMap();
            Vector<Object> unconfigDevices = new Vector();
            boolean done = false;
            boolean firstRun = true;
            int exceptionCount = 0;
            while (firstRun || unconfigDevices.size() > 0 && !done && this.isAlive()) {
                firstRun = false;
                try {
                    this.getDiscoveryLog().trace("*** nrioNet.discover() called *****");
                    unconfigDevices = this.nrioNet.discover();
                    exceptionCount = 0;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.getDiscoveryLog().trace("*** unconfigDevices.size() = " + unconfigDevices.size());
                    for (int i = 0; i < unconfigDevices.size(); ++i) {
                        byte[] data = (byte[])unconfigDevices.elementAt(i);
                        this.getDiscoveryLog().trace("NrioDiscovery byte[] = " + ByteArrayUtil.toHexString((byte[])data));
                        NrioReceivedMessage receivedMessage = new NrioReceivedMessage(data, data.length, null);
                        NrioInputStream inStream = message.readResponse(receivedMessage);
                        ucmr.readData(inStream);
                        BNrio16Module localIo = ((BM2mIoNetwork)this.nrioNet).getLocalIoModule();
                        int setAddress = 1;
                        if (localIo == null) {
                            if (this.setAddressAndPing(setAddress, ucmr.getUid(), ucmr.getModuleType()) != 0) {
                                this.nrioNet.clearAddressUsed(setAddress);
                                continue;
                            }
                            String version = this.nrioNet.readBuildInfo(setAddress);
                            this.addLearnedDevice(setAddress, BNrioDeviceTypeEnum.makeFromRaw(ucmr.getModuleType()), ucmr.getUid(), version, "", -1);
                            continue;
                        }
                        this.getDiscoveryLog().trace(" ******  discovered device allready in station ******");
                        localIo.setAddress(1);
                        localIo.setUid(BBlob.make((byte[])ucmr.getUid()));
                        if (ucmr == null) {
                            this.getDiscoveryLog().message("ucmr is NULL");
                        } else if (ucmr.getUid() == null) {
                            this.getDiscoveryLog().message("ucmr.getUid() is NULL");
                        }
                        this.getDiscoveryLog().message("ucmr.getModuleType() = " + ucmr.getModuleType());
                        if (this.setAddressAndPing(setAddress, ucmr.getUid(), ucmr.getModuleType()) == 0) {
                            if (localIo.sendWriteConfig() == 0) {
                                this.nrioNet.enablePolling(setAddress);
                            } else {
                                this.getDiscoveryLog().trace("write config was not Ok");
                            }
                            localIo.readBuildInfo();
                            continue;
                        }
                        this.getDiscoveryLog().trace("Set logical address and Ping was not Ok");
                        this.addLearnedDevice(setAddress, BNrioDeviceTypeEnum.makeFromRaw(ucmr.getModuleType()), ucmr.getUid(), localIo.getInstalledVersion(), localIo.getDisplayName(null), -1);
                    }
                }
                catch (Exception e) {
                    this.getDiscoveryLog().trace("*** caught Exception: " + e + " count = " + ++exceptionCount);
                    e.printStackTrace();
                    if (exceptionCount > 10) {
                        done = true;
                    } else {
                        firstRun = true;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {}
                }
            }
            this.addExistingDevices();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BNrioLearnDeviceEntry[] learnEntries = (BNrioLearnDeviceEntry[])this.getLearnedDevices().getChildren(BNrioLearnDeviceEntry.class);
        for (int i = 0; i < learnEntries.length; ++i) {
            if (!learnEntries[i].getUsedBy().equals("")) continue;
            this.nrioNet.sendReset(learnEntries[i].getAddress());
        }
        this.progress(100);
    }
}

