/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.install.BDependency;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModuleStatus;
import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.util.CommandLineArguments;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BJaceJarCommand
extends BAbstractPlatformCommand {
    @Generated
    public static final BJaceJarCommand INSTANCE = new BJaceJarCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BJaceJarCommand.class);
    private static final Logger log = Logger.getLogger("jacejar");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BJaceJarCommand() {
    }

    public String getCommandName() {
        return "jacejar";
    }

    public String getCommandDescription() {
        return "create Niagara module files that can be run on embedded hosts";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BJaceJarCommand.println((String)"", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"usage:", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  plat jacejar <flags> [modulename]", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"parameters:", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  modulename               name of a Niagara module for which a Jace-ready", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"                             file is to be created (UI entries are stripped)", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"required flags:", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  -dest:<destPath>         path of a local directory where the new file(s)", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"                             are to be created.   If \"\\\" char is used,", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"                             it must be escaped, e.g. -d:d:\\\\niagara\\\\forjace", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BJaceJarCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        String destDirName = args.getOption("dest");
        if (destDirName == null) {
            this.usage();
            return 2;
        }
        if (args.parameters.length == 0) {
            log.severe("no modules specified");
            this.usage();
            return 2;
        }
        BModuleContent moduleContent = BModuleContent.make((String)args.getOption("moduleContent", "runtime"));
        int retCode = 0;
        File destDir = new File(destDirName);
        for (int i = 0; i < args.parameters.length; ++i) {
            BModuleInstallable inst = (BModuleInstallable)LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)args.parameters[i]), null);
            if (inst != null && inst.getModulePart().getStatus() == BModuleStatus.ok) {
                ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(new File(destDir, args.parameters[i] + ".jar").toPath(), new OpenOption[0]));
                inst.getModulePart().writePackageArchive(moduleContent, true, out);
                out.closeEntry();
                out.flush();
                out.close();
                log.info("created module archive for " + args.parameters[i]);
                continue;
            }
            log.severe(args.parameters[i] + " is not a valid module JAR");
            retCode = 3;
        }
        return retCode;
    }
}

