/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import com.tridium.util.CommandLineArguments;
import javax.baja.naming.BHost;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BIpConfigCommand
extends BDaemonSessionCommand {
    @Generated
    public static final BIpConfigCommand INSTANCE = new BIpConfigCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BIpConfigCommand.class);
    private static final int LABEL_WIDTH = 32;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BIpConfigCommand() {
    }

    public String getCommandName() {
        return "ipconfig";
    }

    public String getCommandDescription() {
        return "display the TCP/IP configuration for a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BIpConfigCommand.println((String)"", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"usage:", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  plat ipconfig <flags>", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"required flags:", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -h:<hostord>             ORD for the remote host", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -usr:<userName>          user name for the host's platform daemon", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -pwd:<password>          password for the host's platform daemon", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -secure                  if given, the connection will be encrypted with TLS", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BIpConfigCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        BTcpIpHostSettings hostSettings = new BTcpIpHostSettings();
        TcpUtil.loadFromSession((BTcpIpHostSettings)hostSettings, (BDaemonSession)session);
        if (session.getHostProperties().supportsServlet("dhcpd")) {
            BDhcpdHostSettings dhcpdHostSettings = new BDhcpdHostSettings();
            DhcpdUtil.loadFromSession((BDhcpdHostSettings)dhcpdHostSettings, (BDaemonSession)session);
            DhcpdUtil.loadDhcpdConfFile((BDhcpdHostSettings)dhcpdHostSettings, (BDaemonSession)session);
            DhcpdUtil.setReadOnly((BDhcpdHostSettings)dhcpdHostSettings, (boolean)true);
            DhcpdUtil.copyDhcpdSlotToAdapters((BDhcpdHostSettings)dhcpdHostSettings, (BTcpIpHostSettings)hostSettings);
        }
        if (session.getHostProperties().supportsServlet("linkcfg")) {
            BLinkCfgHostSettings linkCfgHostSettings = new BLinkCfgHostSettings();
            LinkCfgUtil.loadFromSession((BLinkCfgHostSettings)linkCfgHostSettings, (BDaemonSession)session);
            LinkCfgUtil.loadLinkCfgFile((BLinkCfgHostSettings)linkCfgHostSettings, (BDaemonSession)session);
            LinkCfgUtil.setReadOnly((BLinkCfgHostSettings)linkCfgHostSettings, (boolean)true);
            LinkCfgUtil.copyLinkCfgSlotToHost((BLinkCfgHostSettings)linkCfgHostSettings, (BTcpIpHostSettings)hostSettings);
        }
        this.printHostSettings(session.getHost(), hostSettings);
        return 0;
    }

    private void printHostSettings(BHost host, BTcpIpHostSettings hostSettings) {
        BLinkCfgHostSettings linkCfgHostSettings;
        System.out.println("\nTCP/IP summary for " + host + ":");
        System.out.println();
        this.printLabel("Host name");
        System.out.println(hostSettings.getHostName());
        boolean ipv6Supported = false;
        SlotCursor c = hostSettings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            if (!adapter.getIsIpv6Supported()) continue;
            ipv6Supported = true;
            break;
        }
        if (!hostSettings.getUsesAdapterLevelSettings()) {
            this.printLabel("Domain");
            System.out.println(hostSettings.getDomain());
            System.out.println();
            this.printLabel("IPv4 default gateway");
            System.out.println(hostSettings.getDefaultGateway());
            this.printLabel("IPv4 DNS hosts");
            c = hostSettings.getDnsHosts().loadSlots().getProperties();
            while (c.next()) {
                System.out.print(c.get().toString());
                System.out.print(" ");
            }
            System.out.println();
            if (ipv6Supported) {
                System.out.println();
                this.printLabel("Niagara Uses IPv6");
                System.out.println(hostSettings.getNiagaraUsesIpv6());
                System.out.println();
                this.printLabel("IPv6 default gateway");
                System.out.println(hostSettings.getIpv6DefaultGateway());
                this.printLabel("IPv6 DNS hosts");
                c = hostSettings.getIpv6DnsHosts().loadSlots().getProperties();
                while (c.next()) {
                    System.out.print(c.get().toString());
                    System.out.print(" ");
                }
                System.out.println();
            }
        }
        if ((linkCfgHostSettings = (BLinkCfgHostSettings)hostSettings.get("linkModeSettings")) != null) {
            boolean showLinkReview = true;
            if (linkCfgHostSettings.getLinkModesSupported().getPropertyCount() == 1 && linkCfgHostSettings.getLinkModeSettings().getLinkMode().getOrdinal() == 0) {
                showLinkReview = false;
            }
            if (showLinkReview) {
                BDaisyChainSettings daisyChainSettings;
                System.out.println();
                this.printLabel("Active Link Mode");
                System.out.println(linkCfgHostSettings.getLinkModeSettings().getLinkMode().getDisplayTag(null));
                if (linkCfgHostSettings.getLinkModeSettings() instanceof BDaisyChainSettings && (daisyChainSettings = (BDaisyChainSettings)linkCfgHostSettings.getLinkModeSettings()).getIsStpSupported()) {
                    this.printLabel("Spanning Tree Enabled");
                    System.out.println(daisyChainSettings.getIsStpEnabled());
                    if (daisyChainSettings.getIsStpEnabled()) {
                        this.printLabel("Bridge Priority");
                        System.out.println(daisyChainSettings.getBridgePriority().getDisplayTag(null));
                        this.printLabel("Port Priority 1");
                        System.out.println(daisyChainSettings.getPortPriority1().getDisplayTag(null));
                        this.printLabel("Port Priority 2");
                        System.out.println(daisyChainSettings.getPortPriority2().getDisplayTag(null));
                        this.printLabel("Hello Time");
                        System.out.println(daisyChainSettings.getHelloTime());
                        this.printLabel("Forward Delay Time");
                        System.out.println(daisyChainSettings.getForwardDelayTime());
                        this.printLabel("Maximum Aging Time");
                        System.out.println(daisyChainSettings.getMaxAgingTime());
                    }
                }
            }
        }
        SlotCursor c2 = hostSettings.getAdapters().loadSlots().getProperties();
        while (c2.next()) {
            this.printAdapterSettings((BTcpIpAdapterSettings)c2.get());
        }
    }

    private void printLabel(String text) {
        System.out.print(TextUtil.padRight((String)(text + ":"), (int)32));
    }

    private void printAdapterSettings(BTcpIpAdapterSettings adapter) {
        BDhcpdAdapterSettings dhcpdAdapterSettings;
        SlotCursor c;
        System.out.print("\nAdapter " + adapter.getAdapterId());
        if (!adapter.getDescription().trim().isEmpty()) {
            System.out.println(" (" + adapter.getDescription() + ")");
        } else {
            System.out.println();
        }
        this.printLabel("  MAC Address");
        System.out.println(adapter.getMediaAccessControlAddress());
        this.printLabel("  Adapter Enabled");
        System.out.println(adapter.getIsAdapterEnabled());
        System.out.println();
        if (adapter.getUsesAdapterLevelSettings()) {
            this.printLabel("  Domain");
            System.out.println(adapter.getDomain());
        }
        this.printLabel("  IPv4 address");
        System.out.println(adapter.getIpAddress());
        this.printLabel("  IPv4 subnet mask");
        System.out.println(adapter.getSubnetMask());
        if (adapter.getUsesAdapterLevelSettings()) {
            this.printLabel("  IPv4 default gateway");
            System.out.println(adapter.getDefaultGateway());
            this.printLabel("  IPv4 DNS hosts");
            c = adapter.getDnsHosts().loadSlots().getProperties();
            while (c.next()) {
                System.out.print(c.get().toString());
                System.out.print(" ");
            }
            System.out.println();
        }
        if (adapter.getCanUseDhcp()) {
            this.printLabel("  IPv4 DHCP");
            if (adapter.getIsDhcpEnabled()) {
                BIpConfigCommand.println((String)"enabled", (Object[])new Object[0]);
                this.printLabel("    DHCP host");
                System.out.println(adapter.getDhcpHost());
                this.printLabel("    DHCP lease granted");
                System.out.println(adapter.getDhcpLeaseGranted());
                this.printLabel("    DHCP lease expires");
                System.out.println(adapter.getDhcpLeaseExpires());
            } else {
                BIpConfigCommand.println((String)"disabled", (Object[])new Object[0]);
            }
        }
        System.out.println();
        this.printLabel("  IPv6 supported");
        System.out.println(adapter.getIsIpv6Supported());
        if (adapter.getIsIpv6Supported()) {
            this.printLabel("  IPv6 enabled");
            System.out.println(adapter.getIsIpv6Enabled());
            if (adapter.getIsIpv6Enabled()) {
                this.printLabel("  IPv6 address");
                System.out.println(adapter.getIpv6Address());
                this.printLabel("  IPv6 subnet prefix length");
                System.out.println(adapter.getIpv6SubnetPrefixLength());
                if (adapter.getCanUseIpv6Dhcp()) {
                    this.printLabel("  IPv6 Auto-configuration");
                    if (adapter.getIsIpv6DhcpEnabled()) {
                        BIpConfigCommand.println((String)"enabled", (Object[])new Object[0]);
                        if (!adapter.getIpv6DhcpHost().trim().equalsIgnoreCase("n/a") && !adapter.getIpv6DhcpHost().trim().equalsIgnoreCase("")) {
                            this.printLabel("    DHCPv6 host");
                            System.out.println(adapter.getIpv6DhcpHost());
                            this.printLabel("    DHCPv6 lease granted");
                            System.out.println(adapter.getIpv6DhcpLeaseGranted());
                            this.printLabel("    DHCPv6 lease expires");
                            System.out.println(adapter.getIpv6DhcpLeaseExpires());
                        }
                    } else {
                        BIpConfigCommand.println((String)"disabled", (Object[])new Object[0]);
                    }
                }
                if (adapter.getUsesAdapterLevelSettings()) {
                    this.printLabel("  IPv6 default gateway");
                    System.out.println(adapter.getIpv6DefaultGateway());
                    this.printLabel("  IPv6 DNS hosts");
                    c = adapter.getIpv6DnsHosts().loadSlots().getProperties();
                    while (c.next()) {
                        System.out.print(c.get().toString());
                        System.out.print(" ");
                    }
                    System.out.println();
                }
            }
        }
        if ((dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.get("dhcpdAdapterSettings")) != null) {
            System.out.println();
            this.printLabel("  DHCPDv4 Enabled");
            System.out.println(dhcpdAdapterSettings.getIsDhcpdIpv4Enabled());
            if (dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) {
                this.printLabel("  Default Lease Time");
                System.out.println(dhcpdAdapterSettings.getDefaultLeaseTime());
                this.printLabel("  Max Lease Time");
                System.out.println(dhcpdAdapterSettings.getMaxLeaseTime());
                this.printLabel("  Subnet");
                System.out.println(dhcpdAdapterSettings.getSubnet());
                this.printLabel("  Netmask");
                System.out.println(dhcpdAdapterSettings.getSubnetMask());
                this.printLabel("  Client Range Low");
                System.out.println(dhcpdAdapterSettings.getStartClientAddress());
                this.printLabel("  Max Number of Clients");
                System.out.println(dhcpdAdapterSettings.getRange());
            }
        }
    }
}

