/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon;

import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetAppListMessage;
import com.tridium.platform.daemon.message.GetStationListMessage;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.platform.BStationStatus;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SessionSurrogates {
    private final BDaemonSession session;
    public static Logger log = Logger.getLogger("platDaemon");

    public SessionSurrogates(BDaemonSession session) {
        this.session = session;
    }

    protected BDaemonSession getDaemonSession() {
        return this.session;
    }

    public BVector getVector(boolean load) throws ConnectException, AuthenticationException {
        BVector result = (BVector)this.getDaemonSession().getHostProperties().get("apps");
        boolean isNew = false;
        if (result == null) {
            result = new BVector();
            isNew = true;
            this.getDaemonSession().getHostProperties().add("apps", (BValue)result);
        }
        if (load || isNew) {
            try {
                InputStream stream;
                HashSet<String> appPropNames = null;
                if (this.getDaemonSession().getHostProperties().supportsServlet("applist")) {
                    stream = this.getDaemonSession().getInputStream((DaemonMessage)new GetAppListMessage());
                    if (stream != null) {
                        appPropNames = new HashSet<String>();
                        XElem mainElem = XParser.make((InputStream)stream).parse();
                        XElem[] appTypeElems = mainElem.elems("app");
                        for (int ixAppType = 0; ixAppType < appTypeElems.length; ++ixAppType) {
                            XElem appTypeElem = appTypeElems[ixAppType];
                            String appTypeName = appTypeElem.get("type");
                            XElem[] appElems = appTypeElem.elems(appTypeName);
                            for (int ixApp = 0; ixApp < appElems.length; ++ixApp) {
                                Type appType = BAppSurrogate.getAppType((String)appTypeName);
                                if (appType == null) continue;
                                String appPropName = SessionSurrogates.getPropertyName(appType, appElems[ixApp].get("name"));
                                appPropNames.add(appPropName);
                                BAppSurrogate proxy = (BAppSurrogate)result.get(appPropName);
                                if (proxy == null) {
                                    proxy = BAppSurrogate.make((XElem)appElems[ixApp], (BDaemonSession)this.getDaemonSession());
                                    result.add(appPropName, (BValue)proxy);
                                    continue;
                                }
                                proxy.updateFields(appElems[ixApp]);
                            }
                        }
                    }
                } else {
                    stream = this.getDaemonSession().getInputStream((DaemonMessage)new GetStationListMessage());
                    if (stream != null) {
                        XElem mainElem = XParser.make((InputStream)stream).parse();
                        XElem[] appElems = mainElem.elems("station");
                        appPropNames = new HashSet();
                        for (int ixApp = 0; ixApp < appElems.length; ++ixApp) {
                            String appPropName = SessionSurrogates.getPropertyName(BStationSurrogate.TYPE, appElems[ixApp].get("name"));
                            appPropNames.add(appPropName);
                            BAppSurrogate proxy = (BAppSurrogate)result.get(appPropName);
                            if (proxy == null) {
                                proxy = BAppSurrogate.make((XElem)appElems[ixApp], (BDaemonSession)this.getDaemonSession());
                                result.add(appPropName, (BValue)proxy);
                                continue;
                            }
                            proxy.updateFields(appElems[ixApp]);
                        }
                    }
                }
                if (appPropNames != null && !isNew) {
                    Property[] props = result.getPropertiesArray();
                    for (int i = 0; i < props.length; ++i) {
                        if (appPropNames.contains(props[i].getName())) continue;
                        result.remove(props[i].getName());
                    }
                }
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (AuthenticationException ae) {
                throw ae;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error processing app list", e);
                return result;
            }
        }
        return result;
    }

    public void reset() throws ConnectException, AuthenticationException {
        this.getVector(false).removeAll();
    }

    public boolean areAppsRunning() throws ConnectException, AuthenticationException {
        BAppSurrogate[] apps = this.getAll();
        for (int i = 0; i < apps.length; ++i) {
            BStationStatus status = apps[i].getAppStatus();
            if (status != BStationStatus.starting && status != BStationStatus.running && status != BStationStatus.stopping) continue;
            return true;
        }
        return false;
    }

    public BAppSurrogate[] getAll() throws ConnectException, AuthenticationException {
        return (BAppSurrogate[])this.getVector(true).getChildren(BAppSurrogate.class);
    }

    public BAppSurrogate get(Type appType, String name, boolean forceLoad) throws ConnectException, AuthenticationException {
        BVector vect = this.getVector(forceLoad);
        return vect == null ? null : (BAppSurrogate)vect.get(SessionSurrogates.getPropertyName(appType, name));
    }

    private static String getPropertyName(Type appType, String appName) {
        return appType.toString().replace(':', '_') + '_' + SlotPath.escape((String)appName);
    }

    public BDaemonSurrogate getDaemonSurrogate(boolean load) throws ConnectException, AuthenticationException {
        BDaemonSurrogate result = (BDaemonSurrogate)this.getDaemonSession().getHostProperties().get("daemonSurrogate");
        boolean isNew = false;
        if (result == null) {
            result = new BDaemonSurrogate(this.getDaemonSession());
            isNew = true;
            this.getDaemonSession().getHostProperties().add("daemonSurrogate", (BValue)result);
        }
        if (load || isNew) {
            try {
                result.poll();
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (AuthenticationException ae) {
                throw ae;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error processing daemon surrogate", e);
            }
        }
        return result;
    }
}

