/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.data;

import com.tridium.data.BDataTable;
import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.fox.sys.data.BFoxQueryHandler;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.fox.sys.data.BIPreQueryValidator;
import com.tridium.fox.sys.data.EntityExportConsumer;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.data.BIDataValue;
import javax.baja.entityIo.json.JsonEntityDecoder;
import javax.baja.entityIo.json.JsonEntityEncoder;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.query.BQueryResult;
import javax.baja.query.BQueryScheme;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.util.BasicEntity;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;

@NiagaraType
public class BDataChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BDataChannel.class);
    static final Logger logger = Logger.getLogger("fox.data");
    private static final Version VER_4_4 = new Version("4.4");
    private static final Version VER_4_14 = new Version("4.14");
    private static final String RESOLVE_COMMAND = "resolve";
    private static final String RESOLVE_REQ_ORD = "ord";
    private static final String RESOLVE_RESP_EXCEPTION = "exception";
    private static final String RESOLVE_RESP_RESOLVED = "resolved";
    private static final String RESOLVE_RESP_TARGET_TYPE = "targetType";
    private static final String RESOLVE_TARGET_TYPE_TABLE = "table";
    private static final String RESOLVE_TARGET_TYPE_VALUE = "value";
    private static final String RESOLVE_VALUE_TYPE = "valueType";
    private static final String RESOLVE_ENTITIES_COMMAND = "resolveEntities";
    private static final String RESOLVE_ENTITIES_REQ_ORDS = "queryOrds";
    private static final String RESOLVE_ENTITIES_REQ_OFFSET = "offset";
    private static final String RESOLVE_ENTITIES_REQ_LIMIT = "limit";
    private static final String RESOLVE_ENTITIES_REQ_PRE_VALIDATOR = "preQueryValidator";
    private static final String RESOLVE_ENTITIES_REQ_POST_FILTER = "postQueryFilter";
    private static final BFacets lightweightQueryResultsFacets = BFacets.make((String)"lightweightSystemDbQueryResults", (boolean)true);
    private static final int MAX_QUERY_PARAMETER_SIZE = 10;
    private static final String ENTITY_COLUMN = "entity";
    private static final String EXPORT_ENTITIES_COMMAND = "exportEntities";
    private static final String CAN_EXPORT_ENTITIES_COMMAND = "canExportEntities";
    private static final String EXPORT_ENTITIES_ORDS = "entityConsumerOrds";
    private static final String EXPORT_ENTITIES_ACCEPTS_EXPORT = "acceptsExport";
    private static final String ENTITY_VERSION = "eVer";
    private static final int ENTITY_ENCODING_VERSION = 1;
    private static final String SHOULD_ENCODE_TAGS = "shouldEncodeTags";
    private static final String SHOULD_ENCODE_RELATIONS = "shouldEncodeRelations";
    private static final Entity EMPTY_ENTITY = new BasicEntity();
    private static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private static final JsonEntityDecoder ENTITY_DECODER = new JsonEntityDecoder(EMPTY_INPUT_STREAM);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDataChannel() {
        super("data");
    }

    @Override
    public void checkProcessCircuit(FoxCircuit circuit) throws Throwable {
    }

    @Override
    public FoxResponse process(FoxRequest req) throws Exception {
        String command = req.command;
        if (CAN_EXPORT_ENTITIES_COMMAND.equals(command)) {
            return this.canExportEntities(req);
        }
        throw new InvalidCommandException(command);
    }

    @Override
    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (RESOLVE_COMMAND.equals(command)) {
            this.resolve(circuit);
            return;
        }
        if (RESOLVE_ENTITIES_COMMAND.equals(command)) {
            this.resolveEntities(circuit);
            return;
        }
        if (EXPORT_ENTITIES_COMMAND.equals(command)) {
            this.exportEntities(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    @Override
    public Map<String, Integer> getCircuitCommandThreadPriorities() {
        HashMap<String, Integer> cmdToThreadPriorityMap = new HashMap<String, Integer>();
        cmdToThreadPriorityMap.put(RESOLVE_ENTITIES_COMMAND, Nre.getEngineManager().getPriority() - 1);
        return cmdToThreadPriorityMap;
    }

    @Override
    protected boolean allowRoutingCircuitToReachableStation(FoxCircuit circuit) {
        return RESOLVE_ENTITIES_COMMAND.equals(circuit.command) || RESOLVE_COMMAND.equals(circuit.command);
    }

    @Override
    protected Version getMinReachableStationVersionForCircuit(FoxCircuit circuit) {
        if (RESOLVE_ENTITIES_COMMAND.equals(circuit.command)) {
            return VER_4_4;
        }
        return super.getMinReachableStationVersionForCircuit(circuit);
    }

    @Override
    protected Version getMinVersionAlongRouteForCircuit(FoxCircuit circuit) {
        if (RESOLVE_COMMAND.equals(circuit.command)) {
            return VER_4_14;
        }
        return super.getMinVersionAlongRouteForCircuit(circuit);
    }

    public BObject resolve(BOrd ord, String ... reachableStations) throws Exception {
        FoxMessage metadata = null;
        if (reachableStations != null && reachableStations.length != 0) {
            metadata = BDataChannel.makeFoxMessageWithReachableStationRoute(this, null, VER_4_14, reachableStations);
        }
        FoxMessage req = new FoxMessage();
        req.add(RESOLVE_REQ_ORD, ord.toString());
        FoxCircuit circuit = this.openCircuit(RESOLVE_COMMAND, metadata);
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString(RESOLVE_RESP_EXCEPTION, null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        if (!resp.getBoolean(RESOLVE_RESP_RESOLVED, false)) {
            throw new UnresolvedException(ord.toString());
        }
        String targetType = resp.getString(RESOLVE_RESP_TARGET_TYPE);
        if (RESOLVE_TARGET_TYPE_TABLE.equals(targetType)) {
            BIDataTable result = DataTableDecoder.decode((DataInput)new DataInputStream(circuit.getInputStream()));
            circuit.close();
            return (BObject)result;
        }
        if (RESOLVE_TARGET_TYPE_VALUE.equals(targetType)) {
            String typeStr = resp.getString(RESOLVE_VALUE_TYPE);
            Type valType = BTypeSpec.make((String)typeStr).getResolvedType();
            BObject decoder = valType.getInstance();
            BObject result = ((BIDataValue)decoder).decode((DataInput)new DataInputStream(circuit.getInputStream()));
            circuit.close();
            return result;
        }
        throw new UnresolvedException("Unsupported result type (" + targetType + ") for " + ord);
    }

    public void resolve(FoxCircuit circuit) throws Exception {
        BObject result;
        FoxMessage req = circuit.readMessage();
        String ordText = req.getString(RESOLVE_REQ_ORD, null);
        if (ordText == null) {
            circuit.writeMessage(BDataChannel.unresolved());
            circuit.flush();
            return;
        }
        BObject o = null;
        try {
            BOrd ord = BOrd.make((String)("local:|" + ordText));
            o = ord.resolve(null, this.getSessionContext()).get();
        }
        catch (UnresolvedException e) {
            logger.log(Level.WARNING, "Could not resolve ord " + ordText, e);
            circuit.writeMessage(BDataChannel.unresolved());
            circuit.flush();
            return;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error encountered resolving ord " + ordText, e);
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage(e));
            circuit.flush();
            return;
        }
        FoxMessage resp = new FoxMessage();
        resp.add(RESOLVE_RESP_RESOLVED, true);
        if (o instanceof BITable) {
            resp.add(RESOLVE_RESP_TARGET_TYPE, RESOLVE_TARGET_TYPE_TABLE);
            BITable table = (BITable)o;
            result = (BObject)BToDataTable.toDataTable((BITable)table);
        } else {
            resp.add(RESOLVE_RESP_TARGET_TYPE, RESOLVE_TARGET_TYPE_VALUE);
            result = (BObject)o.toDataValue();
            resp.add(RESOLVE_VALUE_TYPE, result.getType().getTypeSpec().toString());
        }
        circuit.writeMessage(resp);
        circuit.flush();
        DataOutputStream out = new DataOutputStream(circuit.getOutputStream());
        if (result instanceof BIDataTable) {
            DataTableEncoder.encode((BIDataTable)((BIDataTable)result), (DataOutput)out, (Context)this.getSessionContext());
        } else {
            ((BIDataValue)result).encode((DataOutput)out);
        }
        out.flush();
        out.close();
    }

    private static FoxMessage unresolved() {
        FoxMessage m = new FoxMessage();
        m.add(RESOLVE_RESP_RESOLVED, false);
        return m;
    }

    public Stream<Entity> resolveEntities(BOrdList queryOrds, int offset, int limit, BIPreQueryValidator[] preQueryValidators, BIPostQueryFilter[] postQueryFilters) throws Exception {
        return this.doClientResolveEntities(queryOrds, offset, limit, preQueryValidators, postQueryFilters, JsonEntityEncoder.ENCODE_TAGS_AND_RELATIONS, BDataChannel::decodeEntitiesToStream, new String[0]);
    }

    public Stream<Entity> resolveEntities(BOrdList queryOrds, int offset, int limit, JsonEntityEncoder.Options encodingOptions, BIPreQueryValidator[] preQueryValidators, BIPostQueryFilter[] postQueryFilters) throws Exception {
        return this.doClientResolveEntities(queryOrds, offset, limit, preQueryValidators, postQueryFilters, encodingOptions, BDataChannel::decodeEntitiesToStream, new String[0]);
    }

    public Stream<Entity> resolveReachableStationEntities(BOrdList queryOrds, int offset, int limit, JsonEntityEncoder.Options encodingOptions, BIPreQueryValidator[] preQueryValidators, BIPostQueryFilter[] postQueryFilters, String ... targetStationRoute) throws Exception {
        return this.doClientResolveEntities(queryOrds, offset, limit, preQueryValidators, postQueryFilters, encodingOptions, BDataChannel::decodeEntitiesToStream, targetStationRoute);
    }

    public List<Entity> resolveEntitiesToList(BOrdList queryOrds, int offset, int limit, BIPreQueryValidator[] preQueryValidators, BIPostQueryFilter[] postQueryFilters) throws Exception {
        return this.doClientResolveEntities(queryOrds, offset, limit, preQueryValidators, postQueryFilters, JsonEntityEncoder.ENCODE_TAGS_AND_RELATIONS, BDataChannel::decodeEntitiesToList, new String[0]);
    }

    public List<Entity> resolveEntitiesToList(BOrdList queryOrds, int offset, int limit, JsonEntityEncoder.Options encodingOptions, BIPreQueryValidator[] preQueryValidators, BIPostQueryFilter[] postQueryFilters) throws Exception {
        return this.doClientResolveEntities(queryOrds, offset, limit, preQueryValidators, postQueryFilters, encodingOptions, BDataChannel::decodeEntitiesToList, new String[0]);
    }

    public List<Entity> resolveReachableStationEntitiesToList(BOrdList queryOrds, int offset, int limit, JsonEntityEncoder.Options encodingOptions, BIPreQueryValidator[] preQueryValidators, BIPostQueryFilter[] postQueryFilters, String ... targetStationRoute) throws Exception {
        return this.doClientResolveEntities(queryOrds, offset, limit, preQueryValidators, postQueryFilters, encodingOptions, BDataChannel::decodeEntitiesToList, targetStationRoute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> E doClientResolveEntities(BOrdList queryOrds, int offset, int limit, BIPreQueryValidator[] preQueryValidators, BIPostQueryFilter[] postQueryFilters, JsonEntityEncoder.Options encodingOptions, BiFunction<Integer, FoxCircuit, E> decodingFunction, String ... targetStationRoute) throws Exception {
        BDataChannel.verifyRemoteVersion(this, VER_4_4);
        FoxMessage req = new FoxMessage();
        req.add(RESOLVE_ENTITIES_REQ_ORDS, queryOrds.encodeToString());
        req.add(RESOLVE_ENTITIES_REQ_OFFSET, offset);
        req.add(RESOLVE_ENTITIES_REQ_LIMIT, limit);
        req.add(ENTITY_VERSION, 1);
        if (encodingOptions == null) {
            encodingOptions = JsonEntityEncoder.ENCODE_TAGS_AND_RELATIONS;
        }
        req.add(SHOULD_ENCODE_TAGS, encodingOptions.shouldEncodeTags());
        req.add(SHOULD_ENCODE_RELATIONS, encodingOptions.shouldEncodeRelations());
        if (preQueryValidators != null) {
            if (preQueryValidators.length > 10) {
                throw new IllegalArgumentException("preQueryValidators argument size exceeds max (" + preQueryValidators.length + '>' + 10 + ')');
            }
            for (BIPreQueryValidator validator : preQueryValidators) {
                if (!validator.getType().is(BValue.TYPE)) {
                    throw new IllegalArgumentException("PreQueryValidator is not a BValue: " + validator);
                }
                req.add(RESOLVE_ENTITIES_REQ_PRE_VALIDATOR, ValueDocEncoder.marshal((BValue)((BValue)validator.as(BValue.class))));
            }
        }
        if (postQueryFilters != null) {
            if (postQueryFilters.length > 10) {
                throw new IllegalArgumentException("postQueryFilters argument size exceeds max (" + postQueryFilters.length + '>' + 10 + ')');
            }
            for (BIPostQueryFilter filter : postQueryFilters) {
                if (!filter.getType().is(BValue.TYPE)) {
                    throw new IllegalArgumentException("PostQueryFilter is not a BValue: " + filter);
                }
                req.add(RESOLVE_ENTITIES_REQ_POST_FILTER, ValueDocEncoder.marshal((BValue)((BValue)filter.as(BValue.class))));
            }
        }
        FoxMessage metadata = BDataChannel.makeFoxMessageWithReachableStationRoute(this, null, null, targetStationRoute);
        try (FoxCircuit circuit = this.openCircuit(RESOLVE_ENTITIES_COMMAND, metadata);){
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString(RESOLVE_RESP_EXCEPTION, null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            if (!resp.getBoolean(RESOLVE_RESP_RESOLVED, false)) {
                throw new UnresolvedException(queryOrds.toString());
            }
            E e = decodingFunction.apply(resp.getInt(ENTITY_VERSION, -1), circuit);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveEntities(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        BOrdList queryOrds = (BOrdList)BOrdList.DEFAULT.decodeFromString(req.getString(RESOLVE_ENTITIES_REQ_ORDS));
        int offset = req.getInt(RESOLVE_ENTITIES_REQ_OFFSET, -1);
        int limit = req.getInt(RESOLVE_ENTITIES_REQ_LIMIT, -1);
        int encodingVersion = req.getInt(ENTITY_VERSION, -1);
        boolean shouldEncodeTags = req.getBoolean(SHOULD_ENCODE_TAGS, true);
        boolean shouldEncodeRelations = req.getBoolean(SHOULD_ENCODE_RELATIONS, true);
        try (Stream<Object> mergedEntityStream = null;){
            String[] encodedValidators = req.listStrings(RESOLVE_ENTITIES_REQ_PRE_VALIDATOR);
            if (encodedValidators.length > 10) {
                throw new IllegalArgumentException("preQueryValidators argument size exceeds max (" + encodedValidators.length + '>' + 10 + ')');
            }
            ArrayList<BIPreQueryValidator> preQueryValidators = new ArrayList<BIPreQueryValidator>();
            for (String encodedValidator : encodedValidators) {
                preQueryValidators.add((BIPreQueryValidator)ValueDocDecoder.unmarshal((String)encodedValidator));
            }
            String[] encodedFilters = req.listStrings(RESOLVE_ENTITIES_REQ_POST_FILTER);
            if (encodedFilters.length > 10) {
                throw new IllegalArgumentException("postQueryFilters argument size exceeds max (" + encodedFilters.length + '>' + 10);
            }
            ArrayList<BIPostQueryFilter> postQueryFilters = new ArrayList<BIPostQueryFilter>();
            for (String encodedFilter : encodedFilters) {
                postQueryFilters.add((BIPostQueryFilter)ValueDocDecoder.unmarshal((String)encodedFilter));
            }
            BIQueryHandler.validateQueryOrds((BOrdList)queryOrds);
            NiagaraStation station = this.getConnection().getConnectionTarget(NiagaraStation.class).orElse(null);
            for (BIPreQueryValidator validator : preQueryValidators) {
                validator.validateRemoteQuery(station, queryOrds, offset, limit, this.getSessionContext());
            }
            for (BOrd queryOrd : queryOrds) {
                BOrd ord = BOrd.make((BOrd)BOrd.make((String)"local:"), (BOrd)queryOrd);
                OrdTarget ordTarget = ord.resolve(null, (Context)new BasicContext(this.getSessionContext(), lightweightQueryResultsFacets));
                BObject queryResult = ordTarget.get();
                Stream<Entity> entityStream = null;
                if (queryResult.getType().is(BQueryResult.TYPE)) {
                    entityStream = ((BQueryResult)queryResult).stream();
                } else if (queryResult.getType().is(BITable.TYPE)) {
                    BITable table = (BITable)queryResult;
                    entityStream = table.cursor().stream(true).filter(obj -> obj instanceof Entity).map(obj -> (Entity)obj);
                } else if (queryResult instanceof Entity) {
                    entityStream = Stream.of((Entity)queryResult);
                }
                if (entityStream == null) continue;
                if (mergedEntityStream == null) {
                    mergedEntityStream = entityStream;
                    continue;
                }
                mergedEntityStream = Stream.concat(mergedEntityStream, entityStream);
            }
            if (mergedEntityStream != null) {
                mergedEntityStream = mergedEntityStream.distinct();
                for (BIPostQueryFilter queryFilter : postQueryFilters) {
                    mergedEntityStream = queryFilter.postQueryFilter(mergedEntityStream, this.getSessionContext());
                }
            } else {
                mergedEntityStream = Stream.empty();
            }
            long skip = Math.max(offset, 0);
            long max = limit <= 0 ? Long.MAX_VALUE : (long)limit;
            mergedEntityStream = mergedEntityStream.skip(skip).limit(max);
            BDataChannel.encodeEntities(encodingVersion, circuit, mergedEntityStream, true, new JsonEntityEncoder.Options(shouldEncodeTags, shouldEncodeRelations), this.getSessionContext());
        }
    }

    public boolean canExportEntities(BOrdList entityExportConsumerOrds) throws Exception {
        BDataChannel.verifyRemoteVersion(this, VER_4_4);
        FoxRequest req = this.makeRequest(CAN_EXPORT_ENTITIES_COMMAND);
        req.add(EXPORT_ENTITIES_ORDS, entityExportConsumerOrds.encodeToString());
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean(EXPORT_ENTITIES_ACCEPTS_EXPORT);
    }

    private FoxResponse canExportEntities(FoxRequest req) throws Exception {
        BOrdList entityExportConsumerOrds = (BOrdList)BOrdList.DEFAULT.decodeFromString(req.getString(EXPORT_ENTITIES_ORDS));
        FoxResponse resp = new FoxResponse(req);
        resp.add(EXPORT_ENTITIES_ACCEPTS_EXPORT, !this.getEnabledEntityExportConsumers(entityExportConsumerOrds).isEmpty());
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportEntities(BOrdList entityExportConsumerOrds, Stream<Entity> entityStream, Context cx, BIPostQueryFilter ... postQueryFilters) throws Exception {
        try (Stream<Entity> filteredStream = entityStream;){
            BDataChannel.verifyRemoteVersion(this, VER_4_4);
            FoxMessage req = new FoxMessage();
            req.add(EXPORT_ENTITIES_ORDS, entityExportConsumerOrds.encodeToString());
            req.add(ENTITY_VERSION, 1);
            FoxCircuit circuit = this.openCircuit(EXPORT_ENTITIES_COMMAND);
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (!resp.getBoolean(EXPORT_ENTITIES_ACCEPTS_EXPORT)) {
                throw new LocalizableRuntimeException("niagaraDriver", "niagaraSystemIndex.exportDisabled");
            }
            if (postQueryFilters != null) {
                for (BIPostQueryFilter queryFilter : postQueryFilters) {
                    filteredStream = queryFilter.postQueryFilter(filteredStream, cx);
                }
            }
            BDataChannel.encodeEntities(resp.getInt(ENTITY_VERSION, -1), circuit, filteredStream, false, JsonEntityEncoder.ENCODE_TAGS_AND_RELATIONS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntities(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        BOrdList entityExportConsumerOrds = (BOrdList)BOrdList.DEFAULT.decodeFromString(req.getString(EXPORT_ENTITIES_ORDS));
        int encodingVersion = req.getInt(ENTITY_VERSION, -1);
        List<EntityExportConsumer> consumers = this.getEnabledEntityExportConsumers(entityExportConsumerOrds);
        FoxMessage resp = new FoxMessage();
        resp.add(EXPORT_ENTITIES_ACCEPTS_EXPORT, !consumers.isEmpty());
        resp.add(ENTITY_VERSION, encodingVersion);
        circuit.writeMessage(resp);
        circuit.flush();
        if (!consumers.isEmpty()) {
            List<Entity> entities;
            try {
                entities = BDataChannel.decodeEntitiesToList(encodingVersion, circuit);
            }
            finally {
                circuit.close();
            }
            for (EntityExportConsumer consumer : consumers) {
                consumer.consumeEntitiesFromRemoteExport(entities, this.getSessionContext());
            }
        } else {
            circuit.close();
        }
    }

    private List<EntityExportConsumer> getEnabledEntityExportConsumers(BOrdList entityExportConsumerOrds) {
        if (entityExportConsumerOrds.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<EntityExportConsumer> consumers = new ArrayList<EntityExportConsumer>();
        NiagaraStation station = this.getConnection().getConnectionTarget(NiagaraStation.class).orElse(null);
        BObject base = station instanceof BObject ? (BObject)station : null;
        for (BOrd ord : entityExportConsumerOrds) {
            EntityExportConsumer consumer;
            try {
                consumer = (EntityExportConsumer)ord.get(base, this.getSessionContext());
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("fox", "fox.data.unresolvedEntityConsumer", new Object[]{ord.toString()}, (Throwable)e);
            }
            if (!consumer.canAcceptEntitiesFromRemoteExport(this.getSessionContext())) continue;
            consumers.add(consumer);
        }
        return consumers;
    }

    private static void addRowToDataTable(Entity entity, JsonEntityEncoder.Options encodingOptions, BDataTable dataTable) {
        dataTable.startRow();
        try {
            dataTable.set(JsonEntityEncoder.encodeToString((Entity)entity, (JsonEntityEncoder.Options)encodingOptions), BFacets.NULL);
        }
        catch (Exception ex) {
            Optional optional = entity.getOrdToEntity();
            Object displayObj = optional.isPresent() ? optional.get() : entity;
            throw new BajaRuntimeException("Failed to encode Entity: " + displayObj, (Throwable)ex);
        }
        dataTable.endRow();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void encodeEntities(int encodingVersion, FoxCircuit circuit, Stream<Entity> entities, boolean confirm, JsonEntityEncoder.Options encodingOptions, Context cx) throws Exception {
        if (encodingVersion == 1) {
            if (confirm) {
                FoxMessage resp = new FoxMessage();
                resp.add(RESOLVE_RESP_RESOLVED, true);
                resp.add(ENTITY_VERSION, 1);
                circuit.writeMessage(resp);
                circuit.flush();
            }
            try (JsonEntityEncoder encoder = new JsonEntityEncoder(circuit.getOutputStream(), encodingOptions);){
                AtomicInteger count = new AtomicInteger();
                entities.forEachOrdered(e -> {
                    try {
                        encoder.encode(e, Integer.toString(count.getAndIncrement()));
                    }
                    catch (Exception ex) {
                        Optional optional = e.getOrdToEntity();
                        Object displayObj = optional.isPresent() ? optional.get() : e;
                        throw new BajaRuntimeException("Failed to encode Entity: " + displayObj, (Throwable)ex);
                    }
                });
                if (count.get() != 0) return;
                encoder.encode(EMPTY_ENTITY, Integer.toString(count.getAndIncrement()));
                return;
            }
        }
        BDataTable result = new BDataTable();
        result.addColumn(ENTITY_COLUMN, BString.TYPE, 0, BFacets.NULL);
        result.startRows();
        entities.forEachOrdered(e -> BDataChannel.addRowToDataTable(e, encodingOptions, result));
        result.endRows();
        if (confirm) {
            FoxMessage resp = new FoxMessage();
            resp.add(RESOLVE_RESP_RESOLVED, true);
            circuit.writeMessage(resp);
            circuit.flush();
        }
        try (DataOutputStream out = new DataOutputStream(circuit.getOutputStream());){
            DataTableEncoder.encode((BIDataTable)result, (DataOutput)out, (Context)cx);
            out.flush();
            return;
        }
    }

    private static Stream<Entity> decodeEntitiesToStream(int encodingVersion, FoxCircuit circuit) {
        if (encodingVersion == 1) {
            return BDataChannel.decodeEntitiesVersion1(circuit).stream();
        }
        return BDataChannel.decodeEntitiesVersion0(circuit);
    }

    private static List<Entity> decodeEntitiesToList(int encodingVersion, FoxCircuit circuit) {
        if (encodingVersion == 1) {
            return BDataChannel.decodeEntitiesVersion1(circuit);
        }
        return BDataChannel.decodeEntitiesVersion0(circuit).collect(Collectors.toList());
    }

    private static Stream<Entity> decodeEntitiesVersion0(FoxCircuit circuit) {
        BIDataTable result;
        try {
            result = DataTableDecoder.decode((DataInput)new DataInputStream(circuit.getInputStream()));
        }
        catch (IOException ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        finally {
            circuit.close();
        }
        Column col = result.getColumns().get(ENTITY_COLUMN);
        try (TableCursor cursor = result.cursor();){
            Stream<Entity> stream = cursor.stream().map(row -> {
                try {
                    return JsonEntityDecoder.decodeFromString((String)row.cell(col).toString());
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            });
            return stream;
        }
    }

    private static List<Entity> decodeEntitiesVersion1(FoxCircuit circuit) {
        Entity e;
        List<Object> list = new ArrayList<Entity>();
        try (InputStreamReader reader = new InputStreamReader(circuit.getInputStream());){
            JSONObject root = new JSONObject(new JSONTokener((Reader)reader));
            int count = 0;
            String key = Integer.toString(count);
            while (root.has(key)) {
                list.add(ENTITY_DECODER.decodeEntity(root.getJSONObject(key)));
                key = Integer.toString(++count);
            }
        }
        catch (IOException ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        if (list.size() == 1 && !(e = (Entity)list.get(0)).getOrdToEntity().isPresent() && e.tags().isEmpty() && e.relations().isEmpty()) {
            list = Collections.emptyList();
        }
        circuit.close();
        return list;
    }

    static {
        BQueryScheme.registerPriorityQueryHandler((BIQueryHandler)BFoxQueryHandler.INSTANCE, (int)0);
    }
}

