/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.sys.FoxHttpsSocket;
import java.util.HashSet;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public final class FoxwssHttpSessionListener
implements HttpSessionListener {
    private static final IHttpSessionDestroyListener[] EMPTY_LISTENER_ARRAY = new IHttpSessionDestroyListener[0];
    private static final HashSet<IHttpSessionDestroyListener> listeners = new HashSet();

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        for (IHttpSessionDestroyListener l : FoxwssHttpSessionListener.getListeners()) {
            try {
                l.onHttpSessionDestroyed(httpSession);
            }
            catch (Exception e) {
                FoxHttpsSocket.LOG.log(Level.WARNING, "Unexpected exception calling onHttpSessionDestroyed", FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? e : null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addDestroyListener(IHttpSessionDestroyListener l) {
        HashSet<IHttpSessionDestroyListener> hashSet = listeners;
        synchronized (hashSet) {
            listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDestroyListener(IHttpSessionDestroyListener l) {
        HashSet<IHttpSessionDestroyListener> hashSet = listeners;
        synchronized (hashSet) {
            listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpSessionDestroyListener[] getListeners() {
        HashSet<IHttpSessionDestroyListener> hashSet = listeners;
        synchronized (hashSet) {
            return listeners.toArray(EMPTY_LISTENER_ARRAY);
        }
    }

    static interface IHttpSessionDestroyListener {
        public void onHttpSessionDestroyed(HttpSession var1);
    }
}

