/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxWebSocketAcceptor;
import java.security.AccessController;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.baja.web.servlets.UnauthenticatedWebSocketServlet;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public final class FoxWebSocketServlet
extends UnauthenticatedWebSocketServlet {
    private static final long IDLE_TIMEOUT = AccessController.doPrivileged(() -> Long.getLong("foxwss.idleTimeout", 60000L));
    private static final int MAX_TEXT_MESSAGE_BUFFER_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("foxwss.maxTextMessageBufferSize", 65536));
    private static final int MAX_TEXT_MESSAGE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("foxwss.maxTextMessageSize", 262144));
    private static final int MAX_BINARY_MESSAGE_BUFFER_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("foxwss.maxBinaryMessageBufferSize", 65536));
    private static final int MAX_BINARY_MESSAGE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("foxwss.maxBinaryMessageSize", 131072));

    public void configure(WebSocketServletFactory factory) {
        WebSocketPolicy policy = factory.getPolicy();
        policy.setIdleTimeout(IDLE_TIMEOUT);
        policy.setMaxTextMessageBufferSize(MAX_TEXT_MESSAGE_BUFFER_SIZE);
        policy.setMaxTextMessageSize(MAX_TEXT_MESSAGE_SIZE);
        policy.setMaxBinaryMessageBufferSize(MAX_BINARY_MESSAGE_BUFFER_SIZE);
        policy.setMaxBinaryMessageSize(MAX_BINARY_MESSAGE_SIZE);
        factory.setCreator((WebSocketCreator)new FoxWebSocketCreator());
    }

    private static class FoxWebSocketCreator
    implements WebSocketCreator {
        private FoxWebSocketCreator() {
        }

        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            if (!req.isSecure()) {
                return null;
            }
            try {
                BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
                if (!foxService.isRunning() || !foxService.getFoxOverWebsocketEnabled()) {
                    return null;
                }
                BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
                if (!webService.isRunning() || !webService.getHttpsEnabled()) {
                    return null;
                }
                BFoxWebSocketAcceptor foxWebSocketAcceptor = foxService.getFoxWebsocketAcceptor();
                if (foxWebSocketAcceptor.isRunning()) {
                    return new BFoxWebSocketAcceptor.FoxWebSocket(req.getSession());
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }
}

