/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.FoxHttpsSocket;
import com.tridium.nre.io.TimeoutInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.baja.nre.util.ByteArrayUtil;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class FoxWebSocketAdapter
extends WebSocketAdapter {
    static final long INPUT_STREAM_READ_TIMEOUT = AccessController.doPrivileged(() -> Long.getLong("foxwss.inputstream.readtimeout", 30000L));
    private static final int STREAM_BUFFER_SIZE = 8192;
    final BFoxClientConnection foxClientConnection;
    final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private BufferedOutputStream bpout;
    private PipedInputStream pin;
    private InputStream inputStream;
    private OutputStream outputStream;

    public FoxWebSocketAdapter() {
        this.foxClientConnection = null;
    }

    public FoxWebSocketAdapter(BFoxClientConnection foxClientConnection) {
        this.foxClientConnection = foxClientConnection;
    }

    public void onWebSocketConnect(Session session) {
        String src;
        if (FoxHttpsSocket.LOG.isLoggable(Level.FINE)) {
            String src2 = this.foxClientConnection == null ? "Server" : (this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client");
            String sessionInfo = session != null ? session.hashCode() + ", local: " + session.getLocalAddress() + ", remote: " + session.getRemoteAddress() : "";
            FoxHttpsSocket.LOG.fine(src2 + " FoxwssAdapter.onConnect: " + sessionInfo);
        }
        try {
            if (this.foxClientConnection != null) {
                this.foxClientConnection.sslHandshakeComplete = true;
            }
            super.onWebSocketConnect(session);
            try {
                PipedOutputStream pout = new PipedOutputStream();
                this.pin = new PipedInputStream(pout, 8192);
                this.bpout = new BufferedOutputStream(pout, 8192);
            }
            catch (IOException ioe) {
                src = this.foxClientConnection != null ? (FoxHttpsSocket.LOG.isLoggable(Level.FINE) && this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client") : "Server";
                FoxHttpsSocket.LOG.log(Level.WARNING, src + " FoxwssAdapter.onConnect: error streaming buffered contents to socket", FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? ioe : null);
                this.cleanup(1011, "Failed to create streams");
            }
        }
        catch (Throwable t) {
            src = this.foxClientConnection != null ? (FoxHttpsSocket.LOG.isLoggable(Level.FINE) && this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client") : "Server";
            FoxHttpsSocket.LOG.log(Level.WARNING, src + " FoxwssAdapter.onConnect: encountered unhandled error", FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? t : null);
            this.cleanup(1011, "Unhandled error");
            throw t;
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        if (FoxHttpsSocket.LOG.isLoggable(Level.FINE)) {
            String src = this.foxClientConnection == null ? "Server" : (this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client");
            Session session = this.getSession();
            String sessionInfo = session != null ? session.hashCode() + ", local: " + session.getLocalAddress() + ", remote: " + session.getRemoteAddress() : "";
            FoxHttpsSocket.LOG.fine(src + " FoxwssAdapter.onClose(" + statusCode + ", " + reason + "): " + sessionInfo);
        }
        if (this.foxClientConnection == null || statusCode != 1013 || !"Fox Authentication Exception".equalsIgnoreCase(reason)) {
            this.cleanup(statusCode, reason);
        }
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        if (FoxHttpsSocket.LOG.isLoggable(Level.FINEST)) {
            try {
                String src = this.foxClientConnection == null ? "Server" : (this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client");
                Session session = this.getSession();
                String sessionInfo = session != null ? session.hashCode() + ", local: " + session.getLocalAddress() + ", remote: " + session.getRemoteAddress() : "";
                FoxHttpsSocket.LOG.log(Level.FINEST, src + " FoxWssAdapter.onBinary(" + sessionInfo + "): " + ByteArrayUtil.toHexString((byte[])payload, (int)offset, (int)len));
            }
            catch (Exception src) {
                // empty catch block
            }
        }
        try {
            this.bpout.write(payload, offset, len);
            this.bpout.flush();
        }
        catch (Exception e) {
            String src = this.foxClientConnection != null ? (FoxHttpsSocket.LOG.isLoggable(Level.FINE) && this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client") : "Server";
            FoxHttpsSocket.LOG.log(Level.WARNING, src + " FoxwssAdapter.onBinary: error streaming message", FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? e : null);
            this.cleanup(1011, "Failed to write message");
        }
        super.onWebSocketBinary(payload, offset, len);
    }

    public void onWebSocketText(String message) {
        if (FoxHttpsSocket.LOG.isLoggable(Level.FINEST)) {
            try {
                String src = this.foxClientConnection == null ? "Server" : (this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client");
                Session session = this.getSession();
                String sessionInfo = session != null ? session.hashCode() + ", local: " + session.getLocalAddress() + ", remote: " + session.getRemoteAddress() : "";
                FoxHttpsSocket.LOG.log(Level.FINEST, src + " FoxWssAdapter.onText(" + sessionInfo + "): " + message);
            }
            catch (Exception src) {
                // empty catch block
            }
        }
        try {
            this.bpout.write(message.getBytes(StandardCharsets.UTF_8));
            this.bpout.flush();
        }
        catch (Exception e) {
            String src = this.foxClientConnection != null ? (FoxHttpsSocket.LOG.isLoggable(Level.FINE) && this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client") : "Server";
            FoxHttpsSocket.LOG.log(Level.WARNING, src + " FoxwssAdapter.onText: error streaming message", FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? e : null);
            this.cleanup(1011, "Failed to write message");
        }
        super.onWebSocketText(message);
    }

    public void onWebSocketError(Throwable cause) {
        if (!this.closed.get() && !this.closing.get()) {
            Level logLevel;
            Level level = logLevel = this.foxClientConnection != null ? Level.WARNING : Level.FINE;
            if (FoxHttpsSocket.LOG.isLoggable(logLevel)) {
                String src = this.foxClientConnection == null ? "Server" : (this.foxClientConnection.isRunning() ? this.foxClientConnection.toDisplayPathString(null) : "Client");
                Session session = this.getSession();
                String sessionInfo = session != null ? session.hashCode() + ", local: " + session.getLocalAddress() + ", remote: " + session.getRemoteAddress() : "";
                FoxHttpsSocket.LOG.log(logLevel, src + " FoxwssAdapter.onError: " + sessionInfo, FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? cause : null);
            }
            this.cleanup(1011, "Closed from onWebSocketError");
        }
        super.onWebSocketError(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream(WebSocketClient client) {
        FoxWebSocketAdapter foxWebSocketAdapter = this;
        synchronized (foxWebSocketAdapter) {
            if (this.inputStream == null) {
                this.inputStream = new TimeoutInputStream(client, (InputStream)this.pin, INPUT_STREAM_READ_TIMEOUT, FoxHttpsSocket.LOG, true, (ThreadFactory)new FoxwssThreadFactory("FoxwssTimeoutInputStream-"));
            }
        }
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream getOutputStream() {
        FoxWebSocketAdapter foxWebSocketAdapter = this;
        synchronized (foxWebSocketAdapter) {
            if (this.outputStream == null) {
                this.outputStream = new WebSocketOutputStream(this);
            }
        }
        return this.outputStream;
    }

    void cleanup(int closeSessionReason, String closeSessionMessage) {
        Session session;
        if (this.closed.get() || !this.closing.compareAndSet(false, true)) {
            return;
        }
        if (this.bpout != null && this.pin != null) {
            Thread cleanupThread = new Thread("FoxWebSocketAdapterSessionCleanup"){

                @Override
                public void run() {
                    if (FoxWebSocketAdapter.this.inputStream != null) {
                        try {
                            FoxWebSocketAdapter.this.inputStream.close();
                        }
                        catch (Throwable t) {
                            FoxHttpsSocket.LOG.log(Level.FINE, "Unexpected exception closing adapter input stream", t);
                        }
                    }
                    if (FoxWebSocketAdapter.this.bpout != null) {
                        try {
                            FoxWebSocketAdapter.this.bpout.close();
                        }
                        catch (Throwable t) {
                            FoxHttpsSocket.LOG.log(Level.FINE, "Unexpected exception closing adapter buffered output stream", t);
                        }
                    }
                    if (FoxWebSocketAdapter.this.pin != null) {
                        try {
                            FoxWebSocketAdapter.this.pin.close();
                        }
                        catch (Throwable t) {
                            FoxHttpsSocket.LOG.log(Level.FINE, "Unexpected exception closing adapter piped input stream", t);
                        }
                    }
                    if (FoxWebSocketAdapter.this.outputStream != null) {
                        try {
                            FoxWebSocketAdapter.this.outputStream.close();
                        }
                        catch (Throwable t) {
                            FoxHttpsSocket.LOG.log(Level.FINE, "Unexpected exception closing adapter output stream", t);
                        }
                    }
                }
            };
            cleanupThread.start();
            try {
                cleanupThread.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((session = this.getSession()) != null && session.isOpen()) {
            session.close(closeSessionReason, closeSessionMessage);
        }
        this.bpout = null;
        this.pin = null;
        this.closed.set(true);
        this.closing.set(false);
    }

    static final class FoxwssThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicLong threadNumber = new AtomicLong(1L);
        private final String namePrefix;

        public FoxwssThreadFactory(String threadNamePrefix) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = threadNamePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class WebSocketOutputStream
    extends OutputStream {
        private static final int MAX_BINARY_MESSAGE_SIZE = 65536;
        private static final int MAX_BINARY_MESSAGE_BUFFER_SIZE = 32768;
        private static final int COMMON_BYTE_BUFFER_SIZE = 8192;
        private final ByteBuffer commonByteBuffer = ByteBuffer.allocate(8192);
        private final WebSocketAdapter adapter;

        public WebSocketOutputStream(WebSocketAdapter adapter) {
            WebSocketPolicy policy;
            Session session;
            this.adapter = adapter;
            if (adapter != null && (session = adapter.getSession()) != null && (policy = session.getPolicy()) != null) {
                policy.setMaxBinaryMessageSize(65536);
                policy.setMaxBinaryMessageBufferSize(32768);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.adapter.isConnected()) {
                if (len > 65536) {
                    int size = len;
                    int offset = off;
                    while (size > 0) {
                        int partialSize = Math.min(size, 65536);
                        this.adapter.getRemote().sendBytes(ByteBuffer.wrap(b, offset, partialSize));
                        size -= partialSize;
                        offset += partialSize;
                    }
                } else if (len > 8192) {
                    this.adapter.getRemote().sendBytes(ByteBuffer.wrap(b, off, len));
                } else {
                    this.commonByteBuffer.clear();
                    this.commonByteBuffer.put(b, off, len);
                    this.commonByteBuffer.flip();
                    this.adapter.getRemote().sendBytes(this.commonByteBuffer);
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.adapter.isConnected()) {
                this.commonByteBuffer.clear();
                this.commonByteBuffer.putInt(b);
                this.commonByteBuffer.flip();
                this.adapter.getRemote().sendBytes(this.commonByteBuffer);
            }
        }
    }
}

