/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.sys.BFoxWebSocketAcceptor;
import com.tridium.fox.sys.FoxWebSocketAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.WebSocketSession;

public final class FoxHttpsSocket
extends Socket {
    static final Logger LOG = Logger.getLogger("fox.websocket");
    static final String SERVER_FOX_AUTH_EXCEPTION = "Fox Authentication Exception";
    private final InetAddress inetAddress;
    private final SocketImpl socketImpl;
    private boolean connected = true;

    public static FoxHttpsSocket makeServerSocket(BFoxWebSocketAcceptor.FoxWebSocket foxWebSocket, InetAddress inetAddress) throws SocketException {
        return new FoxHttpsSocket(new FoxServerWebSocketImpl(foxWebSocket, inetAddress), inetAddress);
    }

    public static FoxHttpsSocket makeClientSocket(WebSocketClient client, FoxWebSocketAdapter adapter, InetAddress inetAddress) throws SocketException {
        return new FoxHttpsSocket(new FoxClientWebSocketImpl(client, adapter, inetAddress), inetAddress);
    }

    private FoxHttpsSocket(SocketImpl socketImpl, InetAddress inetAddress) throws SocketException {
        super(socketImpl);
        this.socketImpl = socketImpl;
        this.inetAddress = inetAddress;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.connected) {
            this.connected = false;
            if (this.socketImpl instanceof FoxServerWebSocketImpl) {
                ((FoxServerWebSocketImpl)this.socketImpl).close();
            }
            if (this.socketImpl instanceof FoxClientWebSocketImpl) {
                ((FoxClientWebSocketImpl)this.socketImpl).close();
            }
            super.close();
        }
    }

    public synchronized void closeByServerFoxAuthException() throws IOException {
        if (this.connected) {
            this.connected = false;
            if (this.socketImpl instanceof FoxServerWebSocketImpl) {
                ((FoxServerWebSocketImpl)this.socketImpl).closeByServerFoxAuthException();
            }
            if (this.socketImpl instanceof FoxClientWebSocketImpl) {
                ((FoxClientWebSocketImpl)this.socketImpl).close();
            }
            super.close();
        }
    }

    public synchronized SSLSession getSSLSession() {
        try {
            WebSocketSession webSocketSession = this.socketImpl instanceof FoxClientWebSocketImpl ? (WebSocketSession)((FoxClientWebSocketImpl)this.socketImpl).adapter.getSession() : (WebSocketSession)((FoxServerWebSocketImpl)((FoxServerWebSocketImpl)this.socketImpl)).foxWebSocket.session;
            return ((SslConnection.DecryptedEndPoint)((Connection)webSocketSession.getConnection()).getEndPoint()).getSslConnection().getSSLEngine().getSession();
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Unexpected exception retrieving SSLSession", t);
            return null;
        }
    }

    private static class FoxServerWebSocketImpl
    extends SocketImpl {
        private final BFoxWebSocketAcceptor.FoxWebSocket foxWebSocket;
        private final InetAddress inetAddress;

        private FoxServerWebSocketImpl(BFoxWebSocketAcceptor.FoxWebSocket foxWebSocket, InetAddress inetAddress) {
            this.foxWebSocket = foxWebSocket;
            this.inetAddress = inetAddress;
        }

        @Override
        protected void create(boolean stream) throws IOException {
        }

        @Override
        protected InetAddress getInetAddress() {
            return this.inetAddress;
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            throw new UnsupportedOperationException("connect not supported on FoxServerWebSocketImpl");
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            throw new UnsupportedOperationException("connect not supported on FoxServerWebSocketImpl");
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            throw new UnsupportedOperationException("connect not supported on FoxServerWebSocketImpl");
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            throw new UnsupportedOperationException("bind not supported on FoxServerWebSocketImpl");
        }

        @Override
        protected void listen(int backlog) throws IOException {
            throw new UnsupportedOperationException("listen not supported on FoxServerWebSocketImpl");
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
            throw new UnsupportedOperationException("accept not supported on FoxServerWebSocketImpl");
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return this.foxWebSocket.getInputStream();
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            return this.foxWebSocket.getOutputStream();
        }

        @Override
        protected int available() throws IOException {
            return this.getInputStream().available();
        }

        @Override
        protected void close() throws IOException {
            try {
                this.foxWebSocket.close();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Unexpected exception closing FoxWebSocket on socket close", e);
            }
        }

        void closeByServerFoxAuthException() {
            try {
                this.foxWebSocket.close(1013, FoxHttpsSocket.SERVER_FOX_AUTH_EXCEPTION, null);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Unexpected exception closing FoxWebSocket on special socket close", e);
            }
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
            throw new UnsupportedOperationException("sendUrgentData not supported on FoxServerWebSocketImpl");
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            return null;
        }
    }

    private static class FoxClientWebSocketImpl
    extends SocketImpl {
        private final WebSocketClient client;
        private final FoxWebSocketAdapter adapter;
        private final InetAddress inetAddress;
        private InputStream inputStream;
        private OutputStream outputStream;

        private FoxClientWebSocketImpl(WebSocketClient client, FoxWebSocketAdapter adapter, InetAddress inetAddress) {
            this.client = client;
            this.adapter = adapter;
            this.inetAddress = inetAddress;
        }

        @Override
        protected InetAddress getInetAddress() {
            return this.inetAddress;
        }

        @Override
        protected void create(boolean stream) throws IOException {
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            throw new UnsupportedOperationException("connect not supported on FoxClientWebSocketImpl");
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            throw new UnsupportedOperationException("connect not supported on FoxClientWebSocketImpl");
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            throw new UnsupportedOperationException("connect not supported on FoxClientWebSocketImpl");
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            throw new UnsupportedOperationException("bind not supported on FoxClientWebSocketImpl");
        }

        @Override
        protected void listen(int backlog) throws IOException {
            throw new UnsupportedOperationException("listen not supported on FoxClientWebSocketImpl");
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
            throw new UnsupportedOperationException("accept not supported on FoxClientWebSocketImpl");
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.adapter.getInputStream(this.client);
            }
            return this.inputStream;
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = this.adapter.getOutputStream();
            }
            return this.outputStream;
        }

        @Override
        protected int available() throws IOException {
            return this.getInputStream().available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void close() throws IOException {
            block15: {
                try {
                    if (LOG.isLoggable(Level.FINE) && !this.adapter.closed.get()) {
                        String src = this.adapter.foxClientConnection == null ? "Server" : (this.adapter.foxClientConnection.isRunning() ? this.adapter.foxClientConnection.toDisplayPathString(null) : "Client");
                        Session session = this.adapter.getSession();
                        String sessionInfo = session != null ? session.hashCode() + ", local: " + session.getLocalAddress() + ", remote: " + session.getRemoteAddress() : "";
                        LOG.fine(src + " Socket Close: " + sessionInfo);
                    }
                    this.adapter.cleanup(1011, "Socket closed");
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "Unexpected exception closing FoxWebSocketAdapter on socket close", e);
                }
                AccessController.doPrivileged(() -> {
                    try {
                        this.client.stop();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.FINE, "Unexpected exception stopping WebSocketClient on socket close", t);
                    }
                    return null;
                });
                try {
                    if (this.inputStream == null) break block15;
                    try {
                        this.inputStream.close();
                    }
                    finally {
                        this.inputStream = null;
                    }
                }
                finally {
                    if (this.outputStream != null) {
                        try {
                            this.outputStream.close();
                        }
                        finally {
                            this.outputStream = null;
                        }
                    }
                }
            }
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
            throw new UnsupportedOperationException("sendUrgentData not supported on FoxClientWebSocketImpl");
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            return null;
        }
    }
}

