/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.session.ServerException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.fox.sys.broker.BFoxComponentSpace;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.space.BIGatewaySpace;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.util.NiagaraRpcUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BScopedFileSpace;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.net.NotConnectedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;

@NiagaraType
public class BSysChannel
extends BFoxChannel
implements NavListener,
Station.RemoteListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BSysChannel.class);
    static byte[] noPayload = new byte[0];
    private Type[] stationMixIns = new Type[0];
    private static final Logger niagaraRpcLog = Logger.getLogger("niagaraRpc");
    private static final String javaVmName = AccessController.doPrivileged(() -> System.getProperty("java.vm.name"));
    private static final String javaVmVersion = AccessController.doPrivileged(() -> System.getProperty("java.vm.version"));
    private static final String osArch = AccessController.doPrivileged(() -> System.getProperty("os.arch"));
    private static final String osName = AccessController.doPrivileged(() -> System.getProperty("os.name"));
    private static final String osVersion = AccessController.doPrivileged(() -> System.getProperty("os.version"));
    public static final Version VER_4_14 = new Version("4.14");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSysChannel() {
        super("sys");
    }

    @Override
    protected boolean allowRoutingRequestToReachableStation(FoxRequest req) {
        return "stationCall".equals(req.command);
    }

    @Override
    protected Version getMinVersionAlongRouteForRequest(FoxRequest req) {
        return VER_4_14;
    }

    @Override
    public void checkProcess(FoxRequest req) throws Throwable {
    }

    @Override
    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "navEvent") {
            return this.navEvent(request);
        }
        if (command == "summary") {
            return this.summary(request);
        }
        if (command == "stationCall") {
            return this.stationCall(request);
        }
        if (command == "stationEvent") {
            return this.stationEvent(request);
        }
        if (command == "listLocalSpaces") {
            return this.listLocalSpaces(request);
        }
        if (command == "makeBrokerChannel") {
            return this.makeBrokerChannel(request);
        }
        if (command == "subNavEvents") {
            return this.subscribeNavEvents(request);
        }
        if (command == "unsubNavEvents") {
            return this.unsubscribeNavEvents(request);
        }
        if (command == "niagaraRpc") {
            return this.niagaraRpc(request);
        }
        throw new InvalidCommandException(command);
    }

    @Override
    public void sessionClosed(Throwable cause) throws Exception {
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
        Station.removeRemoteListener((Station.RemoteListener)this);
    }

    public String[][] summary() throws Exception {
        FoxRequest req = this.makeRequest("summary");
        if (this.isTraceOn()) {
            this.trace("c:summary");
        }
        FoxResponse resp = this.sendSync(req);
        String[][] pairs = new String[resp.count][];
        for (int i = 0; i < resp.count; ++i) {
            FoxString msg = (FoxString)resp.tuples[i];
            pairs[i] = new String[]{msg.name, msg.value};
        }
        return pairs;
    }

    public FoxResponse summary(FoxRequest req) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listLocalSpaces");
        }
        Context cx = this.getSessionContext();
        FoxResponse resp = new FoxResponse(req);
        resp.add("stationName", "" + Sys.getStation().getStationName());
        resp.add("host", "" + Sys.getLocalHost(null));
        resp.add("hostModel", "" + Nre.getHostModel());
        resp.add("hostModelVersion", "" + Nre.getHostModelVersion());
        resp.add("product", "" + Nre.getHostProduct());
        resp.add("hostId", "" + Nre.getHostId());
        resp.add("niagaraVersion", "" + Sys.getBajaVersion());
        resp.add("javaVersion", "" + javaVmName + " " + javaVmVersion);
        resp.add("osVersion", "" + osArch + " " + osName + " " + osVersion);
        resp.add("locale", "" + Locale.getDefault());
        resp.add("currentTime", "" + BAbsTime.make().toString(cx));
        return resp;
    }

    public byte[] stationCall(String id, byte[] payload, String ... reachableStations) throws Exception {
        if (payload == null) {
            payload = noPayload;
        }
        FoxRequest req = this.makeRequest("stationCall");
        req.add("id", id);
        req.add("payload", payload);
        if (this.isTraceOn()) {
            this.trace("c:stationCall " + id);
        }
        if (reachableStations == null || reachableStations.length != 0) {
            req = (FoxRequest)BSysChannel.makeFoxMessageWithReachableStationRoute(this, req, VER_4_14, reachableStations);
        }
        FoxResponse resp = this.sendSync(req);
        return resp.getBlob("payload");
    }

    public FoxResponse stationCall(FoxRequest req) throws Exception {
        Station.Message msg;
        String id = req.getString("id");
        byte[] payload = req.getBlob("payload");
        if (this.isTraceOn()) {
            this.trace("s:stationCall " + id);
        }
        if ((msg = Station.remoteCall((Station.Message)new Station.Message(id, payload))) != null) {
            payload = msg.payload;
        }
        if (payload == null) {
            payload = noPayload;
        }
        FoxResponse resp = new FoxResponse(req);
        resp.add("payload", payload);
        return resp;
    }

    public void stationEvent(Station.Message event) throws Exception {
        FoxRequest req = this.makeRequest("stationEvent");
        req.add("id", event.id);
        req.add("payload", event.payload);
        if (this.isTraceOn()) {
            this.trace("c:stationEvent " + event.id);
        }
        this.sendAsync(req);
    }

    public FoxResponse stationEvent(FoxRequest req) throws Exception {
        String id = req.getString("id");
        byte[] payload = req.getBlob("payload");
        if (this.isTraceOn()) {
            this.trace("s:stationEvent " + id);
        }
        if (id.equals("stationFault")) {
            String text = null;
            if (payload.length > 0) {
                text = Lexicon.make((String)"baja").getText(new String(payload));
            }
            this.getFoxSession().stationFault = text;
        } else if (id.equals("mixIns")) {
            this.stationMixIns = Station.decodeMixIns((byte[])payload);
        }
        return null;
    }

    public Type[] getStationMixIns() {
        return (Type[])this.stationMixIns.clone();
    }

    public HashMap<String, String> listLocalSpaces() throws Exception {
        FoxRequest req = this.makeRequest("listLocalSpaces");
        if (this.isTraceOn()) {
            this.trace("c:listLocalSpaces");
        }
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] msgs = resp.list("space");
        String[] schemes = new String[msgs.length];
        HashMap<String, String> schemeIds = new HashMap<String, String>();
        for (int i = 0; i < msgs.length; ++i) {
            FoxMessage msg = (FoxMessage)msgs[i];
            String schemeId = msg.getString("schemeId");
            schemeIds.put(schemeId, schemeId);
        }
        return schemeIds;
    }

    public FoxResponse listLocalSpaces(FoxRequest req) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listLocalSpaces");
        }
        FoxResponse resp = new FoxResponse(req);
        BINavNode[] roots = BLocalHost.INSTANCE.getNavChildren();
        for (int i = 0; i < roots.length; ++i) {
            BINavNode root = roots[i];
            if (!(root instanceof BSpace)) continue;
            BSpace space = (BSpace)root;
            if (space instanceof BIProtected) {
                BIProtected protectedSpace = (BIProtected)space;
                if (protectedSpace == BFileSystem.INSTANCE) {
                    protectedSpace = BScopedFileSpace.STATION_HOME;
                }
                if (!this.getPermissionsFor(protectedSpace).hasOperatorRead()) {
                    if (!space.getNavName().equals("station")) continue;
                    Object[] lexiconArgs = new String[]{this.getConnection() instanceof BFoxServerConnection ? this.getServerConnection().getUser().getUsername() : this.getClientConnection().getCredentials().getUsername()};
                    throw new LocalizableRuntimeException("fox", "error.NoPermissionForStation", lexiconArgs);
                }
            }
            FoxMessage msg = new FoxMessage("space");
            msg.add("schemeId", space.getNavName());
            msg.add("type", space.getType().toString());
            resp.add(msg);
        }
        return resp;
    }

    public BBrokerChannel makeBrokerChannel(BFoxComponentSpace space) throws Exception {
        FoxRequest req = this.makeRequest("makeBrokerChannel");
        req.add("ord", "" + space.getOrdInSession());
        if (this.isTraceOn()) {
            this.trace("c:makebrokerChannel");
        }
        FoxResponse resp = this.sendSync(req);
        String channelName = resp.getString("channelName");
        BFoxChannelRegistry registry = this.getConnection().getChannels();
        BBrokerChannel channel = (BBrokerChannel)registry.get(channelName, BBrokerChannel.TYPE);
        channel.initClient(space);
        return channel;
    }

    public FoxResponse makeBrokerChannel(FoxRequest req) throws Exception {
        String channelName;
        BOrd ord = BOrd.make((String)req.getString("ord"));
        BComponentSpace space = (BComponentSpace)ord.get();
        if (space instanceof BVirtualComponentSpace) {
            BVirtualGateway gateway = ((BVirtualComponentSpace)space).getVirtualGateway();
            channelName = "virt_" + gateway.getHandle();
        } else {
            channelName = space instanceof BIGatewaySpace ? "gw_" + ((BIGatewaySpace)space).getGateway().getHandle() : space.getNavName();
        }
        BFoxChannelRegistry registry = this.getConnection().getChannels();
        BBrokerChannel channel = (BBrokerChannel)registry.get(channelName, BBrokerChannel.TYPE);
        channel.initServer(space);
        if (this.isTraceOn()) {
            this.trace("s:makebrokerChannel " + ord + " -> " + channelName);
        }
        FoxResponse resp = new FoxResponse(req);
        resp.add("channelName", channelName);
        return resp;
    }

    public void subscribeNavEvents() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:subNavEvents");
        }
        this.sendAsync(this.makeRequest("subNavEvents"));
    }

    private FoxResponse subscribeNavEvents(FoxRequest req) {
        if (this.isTraceOn()) {
            this.trace("s:subNavEvents");
        }
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        Station.addRemoteListener((Station.RemoteListener)this);
        Station.broadcastStationFault();
        Station.broadcastStationMixIns();
        return null;
    }

    public void unsubscribeNavEvents() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:unsubNavEvents");
        }
        try {
            this.sendAsync(this.makeRequest("unsubNavEvents"));
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    private FoxResponse unsubscribeNavEvents(FoxRequest req) {
        if (this.isTraceOn()) {
            this.trace("s:unsubNavEvents");
        }
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
        Station.removeRemoteListener((Station.RemoteListener)this);
        return null;
    }

    public void navEvent(NavEvent event) {
        block16: {
            try {
                String ord;
                if (this.isTraceOn()) {
                    this.trace("c:navEvent " + event);
                }
                if (!(ord = event.getParentOrd().toString()).startsWith("local:")) {
                    return;
                }
                if (ord.startsWith("local:|fox:") || ord.startsWith("local:|foxs:") || ord.startsWith("local:|foxwss:")) {
                    return;
                }
                if (event.getParent() instanceof BComponent) {
                    return;
                }
                int pipe = ord.indexOf(124);
                if (pipe < 0) {
                    return;
                }
                String relOrd = ord.substring(pipe + 1);
                FoxRequest req = this.makeRequest("navEvent");
                req.add("ord", relOrd);
                switch (event.getId()) {
                    case 1: {
                        req.add("id", "a");
                        req.add("n", event.getNewChildName());
                        break;
                    }
                    case 2: {
                        req.add("id", "v");
                        req.add("o", event.getOldChildName());
                        break;
                    }
                    case 3: {
                        req.add("id", "r");
                        req.add("o", event.getOldChildName());
                        req.add("n", event.getNewChildName());
                        break;
                    }
                    case 4: {
                        StringBuilder o = new StringBuilder();
                        String[] names = event.getNewOrder();
                        for (int i = 0; i < names.length; ++i) {
                            o.append(names[i]).append('|');
                        }
                        req.add("id", "o");
                        req.add("o", o.toString());
                        break;
                    }
                    case 5: {
                        req.add("id", "p");
                        req.add("o", event.getOldChildName());
                        break;
                    }
                    case 6: {
                        req.add("id", "c");
                        req.add("o", event.getOldChildName());
                        req.add("n", event.getNewChildName());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(event.toString());
                    }
                }
                this.sendAsync(req);
            }
            catch (Exception e) {
                if (!this.getConnection().isConnected()) break block16;
                e.printStackTrace();
            }
        }
    }

    private FoxResponse navEvent(FoxRequest req) throws Exception {
        String relOrd = req.getString("ord");
        BOrd parentOrd = BOrd.make((BOrd)this.getFoxSession().getAbsoluteOrd(), (String)relOrd);
        String id = req.getString("id");
        if (this.isTraceOn()) {
            this.trace("s:navEvent " + SecurityUtil.calculateSessionIdHash((String)id) + " " + parentOrd);
        }
        NavEvent event = null;
        if (id.equals("a")) {
            String newName = req.getString("n");
            event = NavEvent.makeAdded((BOrd)parentOrd, (String)newName, null);
        } else if (id.equals("v")) {
            String oldName = req.getString("o");
            event = NavEvent.makeRemoved((BOrd)parentOrd, (String)oldName, null);
        } else if (id.equals("r")) {
            String oldName = req.getString("o");
            String newName = req.getString("n");
            event = NavEvent.makeRenamed((BOrd)parentOrd, (String)oldName, (String)newName, null);
        } else if (id.equals("o")) {
            String order = req.getString("o");
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(order, "|");
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
            String[] newOrder = v.toArray(new String[0]);
            event = NavEvent.makeReordered((BOrd)parentOrd, (String[])newOrder, null);
        } else if (id.equals("p")) {
            String oldName = req.getString("o");
            event = NavEvent.makeReplaced((BOrd)parentOrd, (String)oldName, null);
        } else if (id.equals("c")) {
            String oldMask = req.getString("o");
            String newMask = req.getString("n");
            event = NavEvent.makeRecategorized((BOrd)parentOrd, (String)oldMask, (String)newMask, null);
        } else {
            System.out.println("ERROR: Unknown event type: " + id);
            Thread.dumpStack();
        }
        if (event != null) {
            BNavRoot.INSTANCE.fireNavEvent(event);
        }
        return null;
    }

    public <R> Optional<R> niagaraRpc(BOrd ord, String methodName, Object ... args) throws Exception {
        FoxResponse resp;
        String respJson;
        JSONObject respObj;
        JSONArray argsArray;
        Version remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        if (remoteVersion.compareTo(FoxSession.VERSION_4_1) < 0) {
            throw new UnsupportedOperationException("RPC requires Niagara 4.1 or later");
        }
        BObject target = ord.get();
        boolean isLegacyRpc = NiagaraRpcUtil.isWhitelistedLegacyRpc((BTypeSpec)target.getType().getTypeSpec(), (String)methodName);
        if (isLegacyRpc) {
            argsArray = NiagaraRpcUtil.encodeLegacyArgs((Object[])args);
        } else {
            argsArray = new JSONArray();
            for (Object o : args) {
                argsArray.put(NiagaraRpcUtil.convertFromCollection((Object)o));
            }
        }
        FoxRequest req = this.makeRequest("niagaraRpc");
        req.add("ord", ord.relativizeToSession().toString());
        req.add("methodName", methodName);
        req.add("args", argsArray.toString());
        req.add("legacyRpc", isLegacyRpc);
        if (this.isTraceOn()) {
            this.trace("c:niagaraRpc " + ord + " -> " + methodName);
        }
        if ((respObj = new JSONObject(respJson = (resp = this.sendSync(req)).getString("response"))).has("exception")) {
            throw new ServerException("Cannot invoke RPC", NiagaraRpcServerException.make(respObj.getJSONObject("exception")));
        }
        if (respObj.has("value")) {
            Object value = respObj.get("value");
            return Optional.ofNullable(isLegacyRpc ? ValueDocDecoder.unmarshal((String)((String)value)) : NiagaraRpcUtil.convertToCollection((Object)value));
        }
        return Optional.empty();
    }

    private FoxResponse niagaraRpc(FoxRequest req) throws Exception {
        BOrd ord = BOrd.make((String)req.getString("ord"));
        String methodName = req.getString("methodName");
        JSONArray args = new JSONArray(req.getString("args"));
        boolean isLegacyRpc = req.getBoolean("legacyRpc", false);
        if (this.isTraceOn()) {
            this.trace("s:niagaraRpc " + ord + " -> " + methodName);
        }
        JSONObject respObj = new JSONObject();
        BFoxServerConnection connection = this.getServerConnection();
        if (connection == null) {
            throw new IllegalStateException("Cannot find Server Connection");
        }
        try {
            String remoteAddr = Objects.toString(connection.session().getRemoteHost(), "");
            Optional retVal = NiagaraRpcUtil.rpc((TransportType)TransportType.fox, (boolean)connection.session().isSecure(), (String)remoteAddr, (BOrd)ord, (String)methodName, (JSONArray)args, (Context)this.getSessionContext());
            if (retVal.isPresent()) {
                Object value = retVal.get();
                if (isLegacyRpc) {
                    value = ValueDocEncoder.marshal((BValue)NiagaraRpcUtil.wrapLegacyRpcResult(value));
                }
                respObj.put("value", value);
            }
        }
        catch (Exception err) {
            if (niagaraRpcLog.isLoggable(Level.FINE)) {
                niagaraRpcLog.log(Level.FINE, "Cannot invoke Server side Fox Niagara RPC", err);
            }
            if (err instanceof SecurityException || err.getCause() instanceof SecurityException) {
                Exception genEx = new Exception(Lexicon.make((String)"baja").getText("niagaraRpc.securityMessage"));
                respObj.put("exception", (Object)NiagaraRpcServerException.encodeStackTrace(genEx));
            }
            respObj.put("exception", (Object)NiagaraRpcServerException.encodeStackTrace(err));
        }
        FoxResponse resp = new FoxResponse(req);
        resp.add("response", respObj.toString());
        return resp;
    }

    public static final class NiagaraRpcServerException
    extends RuntimeException {
        private NiagaraRpcServerException(String message) {
            super("Error from Server-side: " + message, null, false, true);
        }

        private static NiagaraRpcServerException make(JSONObject obj) {
            String message = JSONUtil.getString((JSONObject)obj, (String)"m");
            List list = JSONUtil.toUnmodifiableList((JSONArray)obj.getJSONArray("st"));
            StackTraceElement[] elements = (StackTraceElement[])list.stream().map(element -> new StackTraceElement(JSONUtil.getString((JSONObject)element, (String)"cn"), JSONUtil.getString((JSONObject)element, (String)"mn"), element.has("fn") ? JSONUtil.getString((JSONObject)element, (String)"fn") : null, element.getInt("ln"))).toArray(StackTraceElement[]::new);
            NiagaraRpcServerException err = new NiagaraRpcServerException(message);
            err.setStackTrace(elements);
            return err;
        }

        private static JSONObject encodeStackTrace(Exception exception) {
            JSONObject resp = new JSONObject();
            resp.put("m", (Object)Objects.toString(exception.getMessage(), "unknown"));
            JSONArray array = new JSONArray();
            Arrays.stream(exception.getStackTrace()).map(element -> {
                JSONObject traceObj = new JSONObject();
                traceObj.put("cn", (Object)element.getClassName());
                traceObj.put("mn", (Object)element.getMethodName());
                if (element.getFileName() != null) {
                    traceObj.put("fn", (Object)element.getFileName());
                }
                traceObj.put("ln", element.getLineNumber());
                return traceObj;
            }).forEach(arg_0 -> ((JSONArray)array).put(arg_0));
            resp.put("st", (Object)array);
            return resp;
        }
    }
}

