/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.IFoxOptions;
import com.tridium.fox.sys.LocalizableServerException;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.naming.BHost;
import javax.baja.naming.BStationSessionScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="foxwss")
@NiagaraSingleton
public class BFoxwssScheme
extends BStationSessionScheme {
    @Generated
    public static final BFoxwssScheme INSTANCE = new BFoxwssScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxwssScheme.class);
    public static final int DEFAULT_PORT = 443;
    public static final String SCHEME_NAME = "foxwss";
    public static final String DISABLE_FOXWSS_FALLTHROUGH_FACET_KEY = "disableFoxwssFallthrough";
    public static final String PREFERRED_FOXWSS_PORT_FACET_KEY = "preferredFoxwssPort";
    public static final String FOXWSS_PORT_CONTEXT_FACET_KEY = "foxwssPort";
    private static final ThreadLocal<Integer> FOXWSS_PORT_THREAD_LOCAL = new ThreadLocal();

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BFoxwssScheme() {
        super(SCHEME_NAME);
    }

    public OrdQuery parse(String queryBody) {
        return new FoxwssQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        return this.resolve(base, query, null);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, AuthenticationClient client) throws SyntaxException, UnresolvedException {
        BHost host = null;
        BObject obj = base.get();
        host = obj instanceof BHost ? (BHost)obj : ((BComponent)obj).getHost();
        FoxwssQuery foxQuery = (FoxwssQuery)query;
        int port = foxQuery.port;
        BFoxSession session = BFoxSession.make(null, host, port, FoxConnectionTypeEnum.FOXWSS, port);
        session.getConnection().setAuthenticationClient(client);
        try {
            session = BFoxSession.connect(session);
            return new OrdTarget(base, (BObject)session);
        }
        catch (LocalizableServerException e) {
            if ("fox".equals(e.getLexiconModule()) && "error.NoPermissionForStation".equals(e.getLexiconKey())) {
                session.disconnect();
            }
            throw e;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnresolvedException(query.toString(), e);
        }
    }

    public int getDefaultPort() {
        return 443;
    }

    public static int getPreferredFoxwssPort() {
        int port = -1;
        if (Sys.isStation()) {
            port = Sys.getStation().getSysInfo().geti(PREFERRED_FOXWSS_PORT_FACET_KEY, 443);
        } else if (FoxOptionsHolder.FOX_OPTIONS != null) {
            port = FoxOptionsHolder.FOX_OPTIONS.loadPreferredFoxOverWebsocketPort();
        }
        if (port <= 0) {
            return 443;
        }
        return port;
    }

    public static boolean getAttemptFoxOverWebsocketIfFoxOrFoxsFails() {
        if (Sys.isStation()) {
            return !Sys.getStation().getSysInfo().getb(DISABLE_FOXWSS_FALLTHROUGH_FACET_KEY, false);
        }
        if (FoxOptionsHolder.FOX_OPTIONS != null) {
            return FoxOptionsHolder.FOX_OPTIONS.loadFoxOverWebsocketIfFoxOrFoxsFails();
        }
        return true;
    }

    public static Context addFoxwssPortToContext(Context context, int foxwssPort) {
        return new BasicContext(context, BFacets.make((String)FOXWSS_PORT_CONTEXT_FACET_KEY, (int)foxwssPort));
    }

    public static int getFoxwssPortFromContext(Context context) {
        BObject foxwssPortFacet;
        if (context != null && (foxwssPortFacet = context.getFacet(FOXWSS_PORT_CONTEXT_FACET_KEY)) instanceof BInteger) {
            return ((BInteger)foxwssPortFacet).getInt();
        }
        Integer threadLocalFoxwssPort = FOXWSS_PORT_THREAD_LOCAL.get();
        if (threadLocalFoxwssPort != null && threadLocalFoxwssPort > 0) {
            return threadLocalFoxwssPort;
        }
        return -1;
    }

    public static void setFoxwssPortThreadLocal(Integer foxwssPort) {
        FOXWSS_PORT_THREAD_LOCAL.set(foxwssPort);
    }

    private static final class FoxOptionsHolder {
        static final IFoxOptions FOX_OPTIONS;

        private FoxOptionsHolder() {
        }

        static {
            IFoxOptions foxOptions;
            try {
                foxOptions = (IFoxOptions)Sys.getType((String)"bajaui:FoxOptions").getInstance();
            }
            catch (Exception e) {
                foxOptions = null;
            }
            FOX_OPTIONS = foxOptions;
        }
    }

    public static class FoxwssQuery
    implements OrdQuery {
        int port;

        FoxwssQuery(String body) {
            body = body.trim();
            if (body.isEmpty()) {
                this.port = 443;
            } else {
                this.port = Integer.parseInt(body);
                if (this.port <= 0) {
                    this.port = BFoxwssScheme.getPreferredFoxwssPort();
                }
            }
        }

        FoxwssQuery(int port) {
            this.port = port <= 0 ? BFoxwssScheme.getPreferredFoxwssPort() : port;
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return true;
        }

        public void normalize(OrdQueryList list, int index) {
            list.shiftToHost(index);
        }

        public String getScheme() {
            return BFoxwssScheme.SCHEME_NAME;
        }

        public String getBody() {
            StringBuilder sb = new StringBuilder();
            if (this.port != 443) {
                sb.append(this.port);
            }
            return sb.toString();
        }

        public String toString() {
            return "foxwss:" + this.getBody();
        }

        public int getPort() {
            return this.port;
        }
    }
}

